/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.consistency.impl;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.provisioning.api.ChangeNotificationDispatcher;
import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.provisioning.consistency.api.ErrorHandler;
import com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException;
import com.evolveum.midpoint.provisioning.util.ShadowCacheUtil;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.DeltaConvertor;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceObjectShadowUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.FailedOperationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import com.evolveum.prism.xml.ns._public.types_2.ObjectDeltaType;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class ObjectNotFoundHandler
extends ErrorHandler {
    @Autowired
    @Qualifier(value="cacheRepositoryService")
    private RepositoryService cacheRepositoryService;
    @Autowired
    private ChangeNotificationDispatcher changeNotificationDispatcher;
    @Autowired(required=true)
    private ProvisioningService provisioningService;
    private String oid = null;

    public RepositoryService getCacheRepositoryService() {
        return this.cacheRepositoryService;
    }

    public void setCacheRepositoryService(RepositoryService repositoryService) {
        this.cacheRepositoryService = repositoryService;
    }

    @Override
    public void handleError(ResourceObjectShadowType shadow, Exception ex) throws SchemaException, GenericFrameworkException, CommunicationException, ObjectNotFoundException, ObjectAlreadyExistsException, ConfigurationException, SecurityViolationException {
        OperationResult parentResult;
        if (shadow.getFailedOperationType() == FailedOperationTypeType.DELETE) {
            parentResult = OperationResult.createOperationResult((OperationResultType)shadow.getResult());
            if (shadow instanceof AccountShadowType) {
                this.cacheRepositoryService.deleteObject(AccountShadowType.class, shadow.getOid(), parentResult);
            }
        }
        if (shadow.getFailedOperationType() == FailedOperationTypeType.MODIFY) {
            parentResult = OperationResult.createOperationResult((OperationResultType)shadow.getResult());
            OperationResult handleErrorResult = parentResult.createSubresult(String.valueOf(ObjectNotFoundHandler.class.getName()) + ".handleError[MODIFY]");
            ResourceObjectShadowChangeDescription change = new ResourceObjectShadowChangeDescription();
            if (shadow instanceof AccountShadowType) {
                ObjectDelta objectDelta = new ObjectDelta(AccountShadowType.class, ChangeType.DELETE);
                objectDelta.setOid(shadow.getOid());
                change.setObjectDelta(objectDelta);
                change.setResource(shadow.getResource().asPrismObject());
                AccountShadowType account = (AccountShadowType)shadow;
                account.setActivation(ShadowCacheUtil.completeActivation((ResourceObjectShadowType)account, account.getResource(), parentResult));
                change.setOldShadow(account.asPrismObject());
            }
            change.setSourceChannel(QNameUtil.qNameToUri((QName)SchemaConstants.CHANGE_CHANNEL_DISCOVERY));
            this.changeNotificationDispatcher.notifyChange(change, null, handleErrorResult);
            String oidVal = null;
            this.foundReturnedValue(handleErrorResult, oidVal);
            if (this.oid != null) {
                ObjectDeltaType shadowModifications = shadow.getObjectChange();
                Collection modifications = DeltaConvertor.toModifications((Collection)shadowModifications.getModification(), (PrismObjectDefinition)shadow.asPrismObject().getDefinition());
                try {
                    this.provisioningService.modifyObject(AccountShadowType.class, this.oid, modifications, null, parentResult);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    parentResult.recordWarning("Modifications were not applied, because shadow was previously deleted. Repository state were refreshed.");
                }
            }
            try {
                this.cacheRepositoryService.deleteObject(AccountShadowType.class, shadow.getOid(), parentResult);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                parentResult.recordWarning("Modifications were not applied, because shadow was previously deleted. Repository state were refreshed.");
            }
        }
    }

    private void foundReturnedValue(OperationResult handleErrorResult, String oidVal) {
        if (oidVal != null) {
            this.oid = oidVal;
            return;
        }
        List subresults = handleErrorResult.getSubresults();
        for (OperationResult subresult : subresults) {
            String oidValue = (String)subresult.getReturn("createdAccountOid");
            this.foundReturnedValue(subresult, oidValue);
        }
    }

    private QueryType createQueryByIcfName(ResourceObjectShadowType shadow) throws SchemaException {
        Document doc = DOMUtil.getDocument();
        XPathHolder holder = ObjectTypeUtil.createXPathHolder((QName)SchemaConstants.I_ATTRIBUTES);
        PrismProperty nameProperty = shadow.getAttributes().asPrismContainerValue().findProperty(new QName("http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/resource-schema-2", "name"));
        Element nameFilter = QueryUtil.createEqualFilter((Document)doc, (XPathHolder)holder, (QName)nameProperty.getName(), (String)((String)nameProperty.getValue().getValue()));
        Element resourceFilter = QueryUtil.createEqualRefFilter((Document)doc, null, (QName)ResourceObjectShadowType.F_RESOURCE_REF, (String)shadow.getResourceRef().getOid());
        Element objectClassFilter = QueryUtil.createEqualFilter((Document)doc, null, (QName)ResourceObjectShadowType.F_OBJECT_CLASS, (QName)ResourceObjectShadowUtil.getObjectClassDefinition((ResourceObjectShadowType)shadow).getComplexTypeDefinition().getTypeName());
        Element filter = QueryUtil.createAndFilter((Document)doc, (Element[])new Element[]{nameFilter, resourceFilter, objectClassFilter});
        return QueryUtil.createQuery((Element)filter);
    }
}

