/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import org.identityconnectors.framework.common.serializer.BinaryObjectDeserializer;
import org.identityconnectors.framework.common.serializer.BinaryObjectSerializer;
import org.identityconnectors.framework.common.serializer.ObjectSerializerFactory;
import org.identityconnectors.framework.common.serializer.XmlObjectResultsHandler;
import org.identityconnectors.framework.common.serializer.XmlObjectSerializer;
import org.xml.sax.InputSource;

public final class SerializerUtil {
    private SerializerUtil() {
    }

    public static byte[] serializeBinaryObject(Object object) {
        ObjectSerializerFactory fact = ObjectSerializerFactory.getInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryObjectSerializer ser = fact.newBinarySerializer(baos);
        ser.writeObject(object);
        ser.close();
        return baos.toByteArray();
    }

    public static Object deserializeBinaryObject(byte[] bytes) {
        ObjectSerializerFactory fact = ObjectSerializerFactory.getInstance();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        BinaryObjectDeserializer des = fact.newBinaryDeserializer(in);
        return des.readObject();
    }

    public static String serializeXmlObject(Object object, boolean includeHeader) {
        ObjectSerializerFactory fact = ObjectSerializerFactory.getInstance();
        StringWriter w = new StringWriter();
        XmlObjectSerializer ser = fact.newXmlSerializer(w, includeHeader, false);
        ser.writeObject(object);
        ser.close(true);
        return w.toString();
    }

    public static Object deserializeXmlObject(String str, boolean validate) {
        ObjectSerializerFactory fact = ObjectSerializerFactory.getInstance();
        InputSource source = new InputSource(new StringReader(str));
        final ArrayList rv = new ArrayList();
        fact.deserializeXmlStream(source, new XmlObjectResultsHandler(){

            public boolean handle(Object o) {
                rv.add(o);
                return false;
            }
        }, validate);
        if (rv.size() > 0) {
            return rv.get(0);
        }
        return null;
    }

    public static Object cloneObject(Object object) {
        byte[] bytes = SerializerUtil.serializeBinaryObject(object);
        return SerializerUtil.deserializeBinaryObject(bytes);
    }
}

