/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectClassInfoBuilder {
    private boolean _isContainer;
    private String _type = ObjectClass.ACCOUNT_NAME;
    private Map<String, AttributeInfo> _info = new HashMap<String, AttributeInfo>();

    public ObjectClassInfoBuilder setType(String type) {
        this._type = type;
        return this;
    }

    public ObjectClassInfoBuilder addAttributeInfo(AttributeInfo info) {
        if (this._info.containsKey(info.getName())) {
            String MSG = "AttributeInfo of name '%s' already exists!";
            throw new IllegalArgumentException(String.format("AttributeInfo of name '%s' already exists!", info.getName()));
        }
        this._info.put(info.getName(), info);
        return this;
    }

    public ObjectClassInfoBuilder addAllAttributeInfo(Collection<AttributeInfo> c) {
        for (AttributeInfo info : c) {
            this.addAttributeInfo(info);
        }
        return this;
    }

    public void setContainer(boolean container) {
        this._isContainer = container;
    }

    public ObjectClassInfo build() {
        if (!this._info.containsKey(Name.NAME)) {
            this._info.put(Name.NAME, Name.INFO);
        }
        return new ObjectClassInfo(this._type, CollectionUtil.newSet(this._info.values()), this._isContainer);
    }
}

