/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectorObject {
    final ObjectClass _objectClass;
    final Map<String, Attribute> attrs;

    public ConnectorObject(ObjectClass objectClass, Set<? extends Attribute> set) {
        if (objectClass == null) {
            throw new IllegalArgumentException("ObjectClass may not be null");
        }
        if (set == null || set.size() == 0) {
            String MSG = "The set can not be null or empty.";
            throw new IllegalArgumentException("The set can not be null or empty.");
        }
        this._objectClass = objectClass;
        this.attrs = AttributeUtil.toMap(set);
        if (!this.attrs.containsKey(Uid.NAME)) {
            String MSG = "The Attribute set must contain a 'Uid'.";
            throw new IllegalArgumentException("The Attribute set must contain a 'Uid'.");
        }
        if (!this.attrs.containsKey(Name.NAME)) {
            String MSG = "The Attribute set must contain a 'Name'.";
            throw new IllegalArgumentException("The Attribute set must contain a 'Name'.");
        }
    }

    public Set<Attribute> getAttributes() {
        return CollectionUtil.newReadOnlySet(this.attrs.values());
    }

    public Attribute getAttributeByName(String name) {
        return this.attrs.get(name);
    }

    public Uid getUid() {
        return (Uid)this.attrs.get(Uid.NAME);
    }

    public Name getName() {
        return (Name)this.attrs.get(Name.NAME);
    }

    public ObjectClass getObjectClass() {
        return this._objectClass;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectorObject) {
            ConnectorObject other = (ConnectorObject)obj;
            if (!this._objectClass.equals(other.getObjectClass())) {
                return false;
            }
            return CollectionUtil.equals(this.getAttributes(), other.getAttributes());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.getAttributes()).hashCode();
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Uid", this.getUid());
        map.put("ObjectClass", this.getObjectClass());
        map.put("Name", this.getName());
        map.put("Attributes", this.getAttributes());
        return ((Object)map).toString();
    }
}

