/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.logging;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.identityconnectors.common.StringPrintWriter;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.logging.LogSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StdOutLogger
implements LogSpi {
    private static final String PATTERN = "Thread Id: {0}\tTime: {1}\tClass: {2}\tMethod: {3}\tLevel: {4}\tMessage: {5}";
    private static final ThreadLocal<MessageFormat> _messageFormatHandler = new ThreadLocal<MessageFormat>(){

        @Override
        protected MessageFormat initialValue() {
            return new MessageFormat(StdOutLogger.PATTERN);
        }
    };
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final ThreadLocal<DateFormat> _dateFormatHandler = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(StdOutLogger.DATE_PATTERN);
        }
    };

    StdOutLogger() {
    }

    @Override
    public void log(Class<?> clazz, String methodName, Log.Level level, String message, Throwable ex) {
        Object[] args = new Object[]{Thread.currentThread().getId(), _dateFormatHandler.get().format(new Date()), clazz.getName(), methodName, level, message};
        PrintStream out = Log.Level.ERROR.equals((Object)level) ? System.err : System.out;
        String msg = _messageFormatHandler.get().format(args);
        out.println(msg);
        if (ex != null) {
            StringPrintWriter wrt = new StringPrintWriter();
            ex.printStackTrace(wrt);
            out.print(wrt.getString());
        }
    }

    @Override
    public boolean isLoggable(Class<?> clazz, Log.Level level) {
        return true;
    }
}

