/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.javax.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeELResolver
extends ELResolver {
    private final List<ELResolver> resolvers = new ArrayList<ELResolver>();

    public void add(ELResolver elResolver) {
        if (elResolver == null) {
            throw new NullPointerException("resolver must not be null");
        }
        this.resolvers.add(elResolver);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        Class<Object> result = null;
        for (ELResolver resolver : this.resolvers) {
            Class<?> type = resolver.getCommonPropertyType(context, base);
            if (type == null) continue;
            if (result == null || type.isAssignableFrom(result)) {
                result = type;
                continue;
            }
            if (result.isAssignableFrom(type)) continue;
            result = Object.class;
        }
        return result;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(final ELContext context, final Object base) {
        return new Iterator<FeatureDescriptor>(){
            Iterator<FeatureDescriptor> empty = Collections.emptyList().iterator();
            Iterator<ELResolver> resolvers = CompositeELResolver.access$000(CompositeELResolver.this).iterator();
            Iterator<FeatureDescriptor> features = this.empty;

            Iterator<FeatureDescriptor> features() {
                while (!this.features.hasNext() && this.resolvers.hasNext()) {
                    this.features = this.resolvers.next().getFeatureDescriptors(context, base);
                    if (this.features != null) continue;
                    this.features = this.empty;
                }
                return this.features;
            }

            @Override
            public boolean hasNext() {
                return this.features().hasNext();
            }

            @Override
            public FeatureDescriptor next() {
                return this.features().next();
            }

            @Override
            public void remove() {
                this.features().remove();
            }
        };
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        for (ELResolver resolver : this.resolvers) {
            Class<?> type = resolver.getType(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return type;
        }
        return null;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        for (ELResolver resolver : this.resolvers) {
            Object value = resolver.getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return value;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        for (ELResolver resolver : this.resolvers) {
            boolean readOnly = resolver.isReadOnly(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return readOnly;
        }
        return false;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        context.setPropertyResolved(false);
        for (ELResolver resolver : this.resolvers) {
            resolver.setValue(context, base, property, value);
            if (!context.isPropertyResolved()) continue;
            return;
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        context.setPropertyResolved(false);
        for (ELResolver resolver : this.resolvers) {
            Object result = resolver.invoke(context, base, method, paramTypes, params);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        return null;
    }

    static /* synthetic */ List access$000(CompositeELResolver x0) {
        return x0.resolvers;
    }
}

