/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.form;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.form.AbstractFormType;
import org.activiti.engine.impl.form.DateFormType;
import org.activiti.engine.impl.form.EnumFormType;
import org.activiti.engine.impl.util.xml.Element;

public class FormTypes {
    protected Map<String, AbstractFormType> formTypes = new HashMap<String, AbstractFormType>();

    public void addFormType(AbstractFormType formType) {
        this.formTypes.put(formType.getName(), formType);
    }

    public AbstractFormType parseFormPropertyType(Element formPropertyElement, BpmnParse bpmnParse) {
        AbstractFormType formType = null;
        String typeText = formPropertyElement.attribute("type");
        String datePatternText = formPropertyElement.attribute("datePattern");
        if ("date".equals(typeText) && datePatternText != null) {
            formType = new DateFormType(datePatternText);
        } else if ("enum".equals(typeText)) {
            HashMap<String, String> values = new HashMap<String, String>();
            for (Element valueElement : formPropertyElement.elementsNS("http://activiti.org/bpmn", "value")) {
                String valueId = valueElement.attribute("id");
                String valueName = valueElement.attribute("name");
                values.put(valueId, valueName);
            }
            formType = new EnumFormType(values);
        } else if (typeText != null && (formType = this.formTypes.get(typeText)) == null) {
            bpmnParse.addError("unknown type '" + typeText + "'", formPropertyElement);
        }
        return formType;
    }
}

