/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.form;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.form.AbstractFormType;

public class DateFormType
extends AbstractFormType {
    protected String datePattern;
    protected Format dateFormat;

    public DateFormType(String datePattern) {
        this.datePattern = datePattern;
        this.dateFormat = new SimpleDateFormat(datePattern);
    }

    public String getName() {
        return "date";
    }

    public Object getInformation(String key) {
        if ("datePattern".equals(key)) {
            return this.datePattern;
        }
        return null;
    }

    public Object convertFormValueToModelValue(String propertyValue) {
        if (propertyValue == null || "".equals(propertyValue)) {
            return null;
        }
        try {
            return this.dateFormat.parseObject(propertyValue);
        }
        catch (ParseException e) {
            throw new ActivitiException("invalid date value " + propertyValue);
        }
    }

    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue == null) {
            return null;
        }
        return this.dateFormat.format(modelValue);
    }
}

