/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ExpressionGetInvocation;
import org.activiti.engine.impl.delegate.ExpressionSetInvocation;
import org.activiti.engine.impl.el.Expression;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ELException;
import org.activiti.engine.impl.javax.el.MethodNotFoundException;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.impl.javax.el.ValueExpression;

public class JuelExpression
implements Expression {
    protected String expressionText;
    protected ValueExpression valueExpression;
    protected ExpressionManager expressionManager;

    public JuelExpression(ValueExpression valueExpression, ExpressionManager expressionManager, String expressionText) {
        this.valueExpression = valueExpression;
        this.expressionManager = expressionManager;
        this.expressionText = expressionText;
    }

    public Object getValue(VariableScope variableScope) {
        ELContext elContext = this.expressionManager.getElContext(variableScope);
        try {
            ExpressionGetInvocation invocation = new ExpressionGetInvocation(this.valueExpression, elContext);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
            return invocation.getInvocationResult();
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ActivitiException("Unknown property used in expression", pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new ActivitiException("Unknown method used in expression", mnfe);
        }
        catch (ELException ele) {
            throw new ActivitiException("Error while evalutaing expression", ele);
        }
        catch (Exception e) {
            throw new ActivitiException("Error while evalutaing expression", e);
        }
    }

    public void setValue(Object value, VariableScope variableScope) {
        ELContext elContext = this.expressionManager.getElContext(variableScope);
        try {
            ExpressionSetInvocation invocation = new ExpressionSetInvocation(this.valueExpression, elContext, value);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
        }
        catch (Exception e) {
            throw new ActivitiException("Error while evalutaing expression", e);
        }
    }

    public String toString() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return super.toString();
    }

    public String getExpressionText() {
        return this.expressionText;
    }
}

