/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.runtime.ProcessInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartProcessInstanceCmd<T>
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected Map<String, Object> variables;
    protected String businessKey;

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables) {
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.variables = variables;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = null;
        if (this.processDefinitionId != null) {
            processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiException("No process definition found for id = '" + this.processDefinitionId + "'");
            }
        } else if (this.processDefinitionKey != null) {
            processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(this.processDefinitionKey);
            if (processDefinition == null) {
                throw new ActivitiException("No process definition found for key '" + this.processDefinitionKey + "'");
            }
        } else {
            throw new ActivitiException("processDefinitionKey and processDefinitionId are null");
        }
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.businessKey);
        if (this.variables != null) {
            processInstance.setVariables(this.variables);
        }
        processInstance.start();
        return processInstance;
    }
}

