/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartProcessInstanceByMessageCmd
implements Command<ProcessInstance> {
    protected final String messageName;
    protected final String businessKey;
    protected final Map<String, Object> processVariables;

    public StartProcessInstanceByMessageCmd(String messageName, String businessKey, Map<String, Object> processVariables) {
        this.messageName = messageName;
        this.businessKey = businessKey;
        this.processVariables = processVariables;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        if (this.messageName == null) {
            throw new ActivitiException("Cannot start process instance by message: message name is null");
        }
        MessageEventSubscriptionEntity messageEventSubscription = commandContext.getEventSubscriptionManager().findMessageStartEventSubscriptionByName(this.messageName);
        if (messageEventSubscription == null) {
            throw new ActivitiException("Cannot start process instance by message: no subscription to message with name '" + this.messageName + "' found.");
        }
        String processDefinitionId = messageEventSubscription.getConfiguration();
        if (processDefinitionId == null) {
            throw new ActivitiException("Cannot start process instance by message: subscription to message with name '" + this.messageName + "' is not a message start event.");
        }
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiException("No process definition found for id '" + processDefinitionId + "'");
        }
        ActivityImpl startActivity = processDefinition.findActivity(messageEventSubscription.getActivityId());
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.businessKey, startActivity);
        if (this.processVariables != null) {
            processInstance.setVariables(this.processVariables);
        }
        processInstance.start();
        return processInstance;
    }
}

