/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String signalName;
    protected Object signalData;
    protected final Map<String, Object> processVariables;

    public SignalCmd(String executionId, String signalName, Object signalData, Map<String, Object> processVariables) {
        this.executionId = executionId;
        this.signalName = signalName;
        this.signalData = signalData;
        this.processVariables = processVariables;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiException("executionId is null");
        }
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new ActivitiException("execution " + this.executionId + " doesn't exist");
        }
        if (this.processVariables != null) {
            execution.setVariables(this.processVariables);
        }
        execution.signal(this.signalName, this.signalData);
        return null;
    }
}

