/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.DecrementJobRetriesListener;
import org.activiti.engine.impl.jobexecutor.JobExecutorContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteJobsCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ExecuteJobsCmd.class.getName());
    protected String jobId;

    public ExecuteJobsCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        JobEntity job;
        if (this.jobId == null) {
            throw new ActivitiException("jobId is null");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing job " + this.jobId);
        }
        if ((job = commandContext.getJobManager().findJobById(this.jobId)) == null) {
            throw new ActivitiException("No job found with id '" + this.jobId + "'");
        }
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        if (jobExecutorContext != null) {
            jobExecutorContext.setCurrentJob(job);
        }
        try {
            job.execute(commandContext);
        }
        catch (RuntimeException exception) {
            CommandExecutor commandExecutor = Context.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew();
            commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, new DecrementJobRetriesListener(commandExecutor, this.jobId, exception));
            throw exception;
        }
        finally {
            if (jobExecutorContext != null) {
                jobExecutorContext.setCurrentJob(null);
            }
        }
        return null;
    }
}

