/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteHistoricProcessInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;

    public DeleteHistoricProcessInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new ActivitiException("processInstanceId is null");
        }
        HistoricProcessInstanceEntity instance = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstance(this.processInstanceId);
        if (instance == null) {
            throw new ActivitiException("No historic process instance found with id: " + this.processInstanceId);
        }
        if (instance.getEndTime() == null) {
            throw new ActivitiException("Process instance is still running, cannot delete historic process instance: " + this.processInstanceId);
        }
        commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceById(this.processInstanceId);
        return null;
    }
}

