/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import java.util.List;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.PvmScope;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public class ErrorPropagation {
    private static final Logger LOG = Logger.getLogger(ErrorPropagation.class.getName());

    public static void propagateError(BpmnError error, ActivityExecution execution) throws Exception {
        ErrorPropagation.propagateError(error.getErrorCode(), execution);
    }

    public static void propagateError(String errorCode, ActivityExecution execution) throws Exception {
        String eventHandlerId = ErrorPropagation.findLocalErrorEventHandler(execution, errorCode);
        if (eventHandlerId != null) {
            ErrorPropagation.executeCatch(eventHandlerId, execution);
        } else {
            ActivityExecution superExecution = ErrorPropagation.getSuperExecution(execution);
            if (superExecution != null) {
                ErrorPropagation.executeCatchInSuperProcess(errorCode, superExecution);
            } else {
                LOG.info(execution.getActivity().getId() + " throws error event with errorCode '" + errorCode + "', but no catching boundary event was defined. " + "Execution will simply be ended (none end event semantics).");
                execution.end();
            }
        }
    }

    private static String findLocalErrorEventHandler(ActivityExecution execution, String errorCode) {
        PvmScope scope = execution.getActivity();
        while (scope != null) {
            List definitions = (List)scope.getProperty("errorEventDefinitions");
            if (definitions != null) {
                for (ErrorEventDefinition errorEventDefinition : definitions) {
                    if (!errorEventDefinition.catches(errorCode)) continue;
                    return scope.findActivity(errorEventDefinition.getHandlerActivityId()).getId();
                }
            }
            if (scope instanceof PvmActivity) {
                scope = scope.getParent();
                continue;
            }
            scope = null;
        }
        return null;
    }

    private static void executeCatchInSuperProcess(String errorCode, ActivityExecution superExecution) {
        String errorHandlerId = ErrorPropagation.findLocalErrorEventHandler(superExecution, errorCode);
        if (errorHandlerId != null) {
            ErrorPropagation.executeCatch(errorHandlerId, superExecution);
        } else {
            ActivityExecution superSuperExecution = ErrorPropagation.getSuperExecution(superExecution);
            if (superSuperExecution != null) {
                ErrorPropagation.executeCatchInSuperProcess(errorCode, superSuperExecution);
            } else {
                throw new BpmnError(errorCode, "No catching boundary event found for error with errorCode '" + errorCode + "', neither in same process nor in parent process");
            }
        }
    }

    private static ActivityExecution getSuperExecution(ActivityExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        return executionEntity.getProcessInstance().getSuperExecution();
    }

    private static void executeCatch(String errorHandlerId, ActivityExecution execution) {
        ActivityImpl catchingScopeActivity;
        ProcessDefinitionImpl processDefinition = ((ExecutionEntity)execution).getProcessDefinition();
        ActivityImpl errorHandler = processDefinition.findActivity(errorHandlerId);
        if (errorHandler == null) {
            throw new ActivitiException(errorHandlerId + " not found in process definition");
        }
        boolean matchingParentFound = false;
        ActivityExecution leavingExecution = execution;
        ActivityImpl currentActivity = (ActivityImpl)execution.getActivity();
        ScopeImpl catchingScope = errorHandler.getParent();
        if (catchingScope instanceof ActivityImpl && !(catchingScopeActivity = (ActivityImpl)catchingScope).isScope()) {
            catchingScope = catchingScopeActivity.getParent();
        }
        if (catchingScope instanceof PvmProcessDefinition) {
            ErrorPropagation.executeEventHandler(errorHandler, ((ExecutionEntity)execution).getProcessInstance());
        } else {
            if (currentActivity.getId().equals(catchingScope.getId())) {
                matchingParentFound = true;
            } else {
                currentActivity = (ActivityImpl)currentActivity.getParent();
                while (!matchingParentFound && leavingExecution != null && currentActivity != null) {
                    if (!leavingExecution.isConcurrent() && currentActivity.getId().equals(catchingScope.getId())) {
                        matchingParentFound = true;
                        continue;
                    }
                    if (leavingExecution.isConcurrent()) {
                        leavingExecution = leavingExecution.getParent();
                        continue;
                    }
                    currentActivity = currentActivity.getParentActivity();
                    leavingExecution = leavingExecution.getParent();
                }
                while (leavingExecution != null && leavingExecution.getParent() != null && leavingExecution.getParent().getActivity() != null && leavingExecution.getParent().getActivity().getId().equals(catchingScope.getId())) {
                    leavingExecution = leavingExecution.getParent();
                }
            }
            if (matchingParentFound && leavingExecution != null) {
                ErrorPropagation.executeEventHandler(errorHandler, leavingExecution);
            } else {
                throw new ActivitiException("No matching parent execution for activity " + errorHandlerId + " found");
            }
        }
    }

    private static void executeEventHandler(ActivityImpl borderEventActivity, ActivityExecution leavingExecution) {
        if (borderEventActivity.getActivityBehavior() instanceof EventSubProcessStartEventActivityBehavior) {
            InterpretableExecution execution = (InterpretableExecution)leavingExecution;
            execution.setActivity(borderEventActivity.getParentActivity());
            execution.performOperation(AtomicOperation.ACTIVITY_START);
        } else {
            leavingExecution.executeActivity(borderEventActivity);
        }
    }
}

