/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.Map;
import java.util.logging.Logger;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.SchemaOperationProcessEngineClose;
import org.activiti.engine.impl.SchemaOperationsProcessEngineBuild;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.TransactionContextFactory;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.DbSqlSessionFactory;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.engine.impl.jobexecutor.JobExecutor;

public class ProcessEngineImpl
implements ProcessEngine {
    private static Logger log = Logger.getLogger(ProcessEngineImpl.class.getName());
    protected String name;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected HistoryService historicDataService;
    protected IdentityService identityService;
    protected TaskService taskService;
    protected FormService formService;
    protected ManagementService managementService;
    protected String databaseSchemaUpdate;
    protected JobExecutor jobExecutor;
    protected CommandExecutor commandExecutor;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected ExpressionManager expressionManager;
    protected int historyLevel;
    protected TransactionContextFactory transactionContextFactory;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.name = processEngineConfiguration.getProcessEngineName();
        this.repositoryService = processEngineConfiguration.getRepositoryService();
        this.runtimeService = processEngineConfiguration.getRuntimeService();
        this.historicDataService = processEngineConfiguration.getHistoryService();
        this.identityService = processEngineConfiguration.getIdentityService();
        this.taskService = processEngineConfiguration.getTaskService();
        this.formService = processEngineConfiguration.getFormService();
        this.managementService = processEngineConfiguration.getManagementService();
        this.databaseSchemaUpdate = processEngineConfiguration.getDatabaseSchemaUpdate();
        this.jobExecutor = processEngineConfiguration.getJobExecutor();
        this.commandExecutor = processEngineConfiguration.getCommandExecutorTxRequired();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.historyLevel = processEngineConfiguration.getHistoryLevel();
        this.transactionContextFactory = processEngineConfiguration.getTransactionContextFactory();
        this.commandExecutor.execute(new SchemaOperationsProcessEngineBuild());
        if (this.name == null) {
            log.info("default activiti ProcessEngine created");
        } else {
            log.info("ProcessEngine " + this.name + " created");
        }
        ProcessEngines.registerProcessEngine(this);
        if (this.jobExecutor != null && this.jobExecutor.isAutoActivate()) {
            this.jobExecutor.start();
        }
    }

    public void close() {
        ProcessEngines.unregister(this);
        if (this.jobExecutor != null && this.jobExecutor.isActive()) {
            this.jobExecutor.shutdown();
        }
        this.commandExecutor.execute(new SchemaOperationProcessEngineClose());
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return (DbSqlSessionFactory)this.sessionFactories.get(DbSqlSession.class);
    }

    public String getName() {
        return this.name;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public HistoryService getHistoryService() {
        return this.historicDataService;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }
}

