/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.util;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.xml.GlobalDynamicNamespacePrefixMapper;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.schema.holder.XPathSegment;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.JAXBUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.XmlSchemaType;
import com.evolveum.prism.xml.ns._public.types_2.ItemDeltaType;
import com.evolveum.prism.xml.ns._public.types_2.ModificationTypeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObjectTypeUtil {
    public static List<String> extractOids(List<? extends ObjectType> objects, List<? extends ObjectReferenceType> refs) {
        ArrayList<String> oids = new ArrayList<String>();
        if (objects != null) {
            for (ObjectType objectType : objects) {
                oids.add(objectType.getOid());
            }
        }
        if (refs != null) {
            for (ObjectReferenceType objectReferenceType : refs) {
                oids.add(objectReferenceType.getOid());
            }
        }
        return oids;
    }

    public static ObjectReferenceType findRef(String oid, List<ObjectReferenceType> refs) {
        for (ObjectReferenceType ref : refs) {
            if (!ref.getOid().equals(oid)) continue;
            return ref;
        }
        return null;
    }

    @Deprecated
    public static ItemDeltaType createPropertyModificationType(ModificationTypeType changeType, XPathHolder xpathType, Object element) {
        ItemDeltaType change = new ItemDeltaType();
        change.setValue(new ItemDeltaType.Value());
        change.setModificationType(changeType);
        if (xpathType == null) {
            xpathType = new XPathHolder();
        }
        change.setPath(xpathType.toElement("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "path"));
        change.getValue().getAny().add(element);
        return change;
    }

    @Deprecated
    public static ItemDeltaType createPropertyModificationType(ModificationTypeType changeType, XPathHolder xpath, QName propertyName, Object value) {
        ArrayList<Object> values = new ArrayList<Object>(1);
        values.add(value);
        return ObjectTypeUtil.createPropertyModificationType(changeType, xpath, propertyName, values);
    }

    @Deprecated
    public static ItemDeltaType createPropertyModificationType(ModificationTypeType changeType, XPathHolder xpath, PrismProperty property) {
        return ObjectTypeUtil.createPropertyModificationType(changeType, xpath, property.getName(), property.getValues());
    }

    @Deprecated
    public static ItemDeltaType createPropertyModificationType(ModificationTypeType changeType, XPathHolder xpath, QName propertyName, Collection<Object> values) {
        ItemDeltaType propertyChange = new ItemDeltaType();
        propertyChange.setModificationType(changeType);
        Document doc = DOMUtil.getDocument();
        if (xpath == null) {
            xpath = new XPathHolder();
        }
        if (propertyName.getPrefix() == null) {
            String prefix = GlobalDynamicNamespacePrefixMapper.getPreferredPrefix((String)propertyName.getNamespaceURI());
            propertyName = new QName(propertyName.getNamespaceURI(), propertyName.getLocalPart(), prefix);
        }
        propertyChange.setPath(xpath.toElement("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "path", doc));
        ItemDeltaType.Value jaxbValue = new ItemDeltaType.Value();
        if (values != null) {
            for (Object value : values) {
                if (value == null) continue;
                if (XmlTypeConverter.canConvert(value.getClass())) {
                    try {
                        Object e = XmlTypeConverter.toXsdElement((Object)value, (QName)propertyName, (Document)doc);
                        jaxbValue.getAny().add(e);
                        continue;
                    }
                    catch (SchemaException ex) {
                        throw new SystemException("Unexpected JAXB problem while converting " + propertyName + " : " + ex.getMessage(), (Throwable)ex);
                    }
                }
                if (value instanceof Element) {
                    jaxbValue.getAny().add((Element)value);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported value type " + value.getClass().getName());
            }
        }
        propertyChange.setValue(jaxbValue);
        return propertyChange;
    }

    @Deprecated
    public static ObjectModificationType createModificationReplaceProperty(String oid, QName propertyName, Object propertyValue) {
        return ObjectTypeUtil.createModificationReplaceProperty(oid, null, propertyName, propertyValue);
    }

    @Deprecated
    public static ObjectModificationType createModificationReplaceProperty(String oid, XPathHolder xpath, QName propertyName, Object propertyValue) {
        ObjectModificationType modification = new ObjectModificationType();
        modification.setOid(oid);
        List<ItemDeltaType> propertyModifications = modification.getModification();
        ItemDeltaType propertyModification = ObjectTypeUtil.createPropertyModificationType(ModificationTypeType.REPLACE, xpath, propertyName, propertyValue);
        propertyModifications.add(propertyModification);
        return modification;
    }

    public static String toShortString(ObjectType object) {
        if (object == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ObjectTypeUtil.getShortTypeName(object));
        builder.append(": ");
        builder.append(object.getName());
        builder.append("(OID:");
        builder.append(object.getOid());
        builder.append(")");
        return builder.toString();
    }

    public static String toShortString(AssignmentType assignment) {
        if (assignment == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("Assignment(");
        if (assignment.getAccountConstruction() != null) {
            sb.append("account");
        }
        if (assignment.getTarget() != null) {
            sb.append(ObjectTypeUtil.toShortString(assignment.getTarget()));
        }
        if (assignment.getTargetRef() != null) {
            sb.append(ObjectTypeUtil.toShortString(assignment.getTargetRef()));
        }
        sb.append(")");
        return sb.toString();
    }

    public static String dump(ObjectType object) {
        if (object == null) {
            return "null";
        }
        return object.asPrismObject().dump();
    }

    public static Object toShortString(ObjectReferenceType objectRef) {
        if (objectRef == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("objectRef oid=").append(objectRef.getOid());
        if (objectRef.getType() != null) {
            sb.append(" type=").append(SchemaDebugUtil.prettyPrint(objectRef.getType()));
        }
        return sb.toString();
    }

    public static String getShortTypeName(ObjectType object) {
        return ObjectTypeUtil.getShortTypeName(object.getClass());
    }

    public static String getShortTypeName(Class<? extends ObjectType> type) {
        ObjectTypes objectTypeType = ObjectTypes.getObjectType(type);
        if (objectTypeType != null) {
            return objectTypeType.getQName().getLocalPart();
        }
        return type.getSimpleName();
    }

    public static ObjectReferenceType createObjectRef(ObjectType objectType) {
        return ObjectTypeUtil.createObjectRef(objectType.asPrismObject());
    }

    public static <T extends ObjectType> ObjectReferenceType createObjectRef(PrismObject<T> object) {
        if (object == null) {
            return null;
        }
        ObjectReferenceType ref = new ObjectReferenceType();
        ref.setOid(object.getOid());
        PrismObjectDefinition definition = object.getDefinition();
        if (definition != null) {
            ref.setType(definition.getTypeName());
        }
        return ref;
    }

    public static ObjectReferenceType createObjectRef(String oid, ObjectTypes type) {
        Validate.notEmpty((String)oid, (String)"Oid must not be null or empty.");
        Validate.notNull((Object)((Object)type), (String)"Object type must not be null.");
        ObjectReferenceType reference = new ObjectReferenceType();
        reference.setType(type.getTypeQName());
        reference.setOid(oid);
        return reference;
    }

    public static Element findXsdElement(XmlSchemaType xmlSchemaType) {
        if (xmlSchemaType == null) {
            return null;
        }
        PrismContainerValue xmlSchemaContainerValue = xmlSchemaType.asPrismContainerValue();
        return ObjectTypeUtil.findXsdElement((PrismContainerValue<XmlSchemaType>)xmlSchemaContainerValue);
    }

    public static Element findXsdElement(PrismContainer<XmlSchemaType> xmlSchemaContainer) {
        return ObjectTypeUtil.findXsdElement((PrismContainerValue<XmlSchemaType>)xmlSchemaContainer.getValue());
    }

    public static Element findXsdElement(PrismContainerValue<XmlSchemaType> xmlSchemaContainerValue) {
        PrismProperty definitionProperty = xmlSchemaContainerValue.findProperty(XmlSchemaType.F_DEFINITION);
        if (definitionProperty == null) {
            return null;
        }
        Element definitionElement = (Element)definitionProperty.getValue().getValue();
        if (definitionElement == null) {
            return null;
        }
        List schemaElements = DOMUtil.listChildElements((Node)definitionElement);
        for (Element e : schemaElements) {
            if (!QNameUtil.compareQName((QName)DOMUtil.XSD_SCHEMA_ELEMENT, (Node)e)) continue;
            DOMUtil.fixNamespaceDeclarations((Element)e);
            return e;
        }
        return null;
    }

    public static void setXsdSchemaDefinition(PrismProperty<Element> definitionProperty, Element xsdElement) {
        Document document = xsdElement.getOwnerDocument();
        Element definitionElement = document.createElementNS(XmlSchemaType.F_DEFINITION.getNamespaceURI(), XmlSchemaType.F_DEFINITION.getLocalPart());
        definitionElement.appendChild(xsdElement);
        definitionProperty.setRealValue((Object)definitionElement);
    }

    public static XPathHolder createXPathHolder(QName property) {
        XPathSegment xpathSegment = new XPathSegment(property);
        ArrayList<XPathSegment> segmentlist = new ArrayList<XPathSegment>(1);
        segmentlist.add(xpathSegment);
        XPathHolder xpath = new XPathHolder(segmentlist);
        return xpath;
    }

    public static boolean isModificationOf(ItemDeltaType modification, QName elementName) {
        return ObjectTypeUtil.isModificationOf(modification, elementName, null);
    }

    public static boolean isModificationOf(ItemDeltaType modification, QName elementName, XPathHolder path) {
        if (path == null && XPathHolder.isDefault(modification.getPath())) {
            return elementName.equals(ObjectTypeUtil.getElementName(modification));
        }
        if (path == null) {
            return false;
        }
        XPathHolder modPath = new XPathHolder(modification.getPath());
        if (path.equals(modPath)) {
            return elementName.equals(ObjectTypeUtil.getElementName(modification));
        }
        return false;
    }

    public static QName getElementName(ItemDeltaType propertyModification) {
        if (propertyModification.getValue() == null) {
            throw new IllegalArgumentException("Modification without value element");
        }
        if (propertyModification.getValue().getAny() == null || propertyModification.getValue().getAny().isEmpty()) {
            throw new IllegalArgumentException("Modification with empty value element");
        }
        return JAXBUtil.getElementQName(propertyModification.getValue().getAny().get(0));
    }

    public static boolean isEmpty(ObjectModificationType objectModification) {
        return objectModification.getModification() == null || objectModification.getModification().isEmpty();
    }

    public static void assertConcreteType(Class<? extends Objectable> type) {
        if (type.equals(ObjectType.class)) {
            throw new IllegalArgumentException("The type " + type.getName() + " is abstract");
        }
    }
}

