/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.result;

import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.schema.result.VariousValues;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.CommonException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.EntryType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.LocalizedMessageType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ParamsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UnknownJavaObjectType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OperationResult
implements Serializable,
Dumpable {
    private static final long serialVersionUID = -2467406395542291044L;
    private static final String INDENT_STRING = "    ";
    public static final String CONTEXT_IMPLEMENTATION_CLASS = "implementationClass";
    public static final String CONTEXT_PROGRESS = "progress";
    public static final String CONTEXT_OID = "oid";
    public static final String CONTEXT_OBJECT = "object";
    public static final String CONTEXT_ITEM = "item";
    public static final String CONTEXT_TASK = "task";
    public static final String PARAM_OID = "oid";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_TASK = "task";
    public static final String PARAM_OBJECT = "object";
    public static final String RETURN_COUNT = "count";
    private static long TOKEN_COUNT = 1000000000000000000L;
    private String operation;
    private OperationResultStatus status;
    private Map<String, Object> params;
    private Map<String, Object> context;
    private Map<String, Object> returns;
    private long token;
    private String messageCode;
    private String message;
    private String localizationMessage;
    private List<Object> localizationArguments;
    private Throwable cause;
    private int count = 1;
    private List<OperationResult> subresults;
    private List<String> details;
    private boolean summarizeErrors;
    private boolean summarizePartialErrors;
    private boolean summarizeSuccesses;
    private static final Trace LOGGER = TraceManager.getTrace(OperationResult.class);

    public OperationResult(String operation) {
        this(operation, null, OperationResultStatus.UNKNOWN, 0L, null, null, null, null, null);
    }

    public OperationResult(String operation, String messageCode, String message) {
        this(operation, null, OperationResultStatus.SUCCESS, 0L, messageCode, message, null, null, null);
    }

    public OperationResult(String operation, long token, String messageCode, String message) {
        this(operation, null, OperationResultStatus.SUCCESS, token, messageCode, message, null, null, null);
    }

    public OperationResult(String operation, OperationResultStatus status, String message) {
        this(operation, null, status, 0L, null, message, null, null, null);
    }

    public OperationResult(String operation, OperationResultStatus status, String messageCode, String message) {
        this(operation, null, status, 0L, messageCode, message, null, null, null);
    }

    public OperationResult(String operation, OperationResultStatus status, long token, String messageCode, String message) {
        this(operation, null, status, token, messageCode, message, null, null, null);
    }

    public OperationResult(String operation, OperationResultStatus status, long token, String messageCode, String message, Throwable cause) {
        this(operation, null, status, token, messageCode, message, null, cause, null);
    }

    public OperationResult(String operation, Map<String, Object> params, OperationResultStatus status, long token, String messageCode, String message) {
        this(operation, params, status, token, messageCode, message, null, null, null);
    }

    public OperationResult(String operation, Map<String, Object> params, OperationResultStatus status, long token, String messageCode, String message, List<OperationResult> subresults) {
        this(operation, params, status, token, messageCode, message, null, null, subresults);
    }

    public OperationResult(String operation, Map<String, Object> params, OperationResultStatus status, long token, String messageCode, String message, String localizationMessage, Throwable cause, List<OperationResult> subresults) {
        this(operation, params, status, token, messageCode, message, localizationMessage, null, cause, subresults);
    }

    public OperationResult(String operation, Map<String, Object> params, OperationResultStatus status, long token, String messageCode, String message, String localizationMessage, List<Object> localizationArguments, Throwable cause, List<OperationResult> subresults) {
        if (StringUtils.isEmpty((String)operation)) {
            throw new IllegalArgumentException("Operation argument must not be null or empty.");
        }
        if (status == null) {
            throw new IllegalArgumentException("Operation status must not be null.");
        }
        this.operation = operation;
        this.params = params;
        this.status = status;
        this.token = token;
        this.messageCode = messageCode;
        this.message = message;
        this.localizationMessage = localizationMessage;
        this.localizationArguments = localizationArguments;
        this.cause = cause;
        this.subresults = subresults;
        this.details = new ArrayList<String>();
    }

    public OperationResult createSubresult(String operation) {
        OperationResult subresult = new OperationResult(operation);
        this.addSubresult(subresult);
        return subresult;
    }

    public String getOperation() {
        return this.operation;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public boolean isSummarizeErrors() {
        return this.summarizeErrors;
    }

    public void setSummarizeErrors(boolean summarizeErrors) {
        this.summarizeErrors = summarizeErrors;
    }

    public boolean isSummarizePartialErrors() {
        return this.summarizePartialErrors;
    }

    public void setSummarizePartialErrors(boolean summarizePartialErrors) {
        this.summarizePartialErrors = summarizePartialErrors;
    }

    public boolean isSummarizeSuccesses() {
        return this.summarizeSuccesses;
    }

    public void setSummarizeSuccesses(boolean summarizeSuccesses) {
        this.summarizeSuccesses = summarizeSuccesses;
    }

    public List<OperationResult> getSubresults() {
        if (this.subresults == null) {
            this.subresults = new ArrayList<OperationResult>();
        }
        return this.subresults;
    }

    public OperationResult getLastSubresult() {
        if (this.subresults == null || this.subresults.isEmpty()) {
            return null;
        }
        return this.subresults.get(this.subresults.size() - 1);
    }

    public OperationResultStatus getLastSubresultStatus() {
        OperationResult last = this.getLastSubresult();
        return last != null ? last.getStatus() : null;
    }

    public void addSubresult(OperationResult subresult) {
        this.getSubresults().add(subresult);
    }

    public OperationResultStatus getStatus() {
        return this.status;
    }

    public boolean isSuccess() {
        return this.status == OperationResultStatus.SUCCESS;
    }

    public boolean isWarning() {
        return this.status == OperationResultStatus.WARNING;
    }

    public boolean isAcceptable() {
        return this.status != OperationResultStatus.FATAL_ERROR;
    }

    public boolean isUnknown() {
        return this.status == OperationResultStatus.UNKNOWN;
    }

    public boolean isError() {
        return this.status == OperationResultStatus.FATAL_ERROR || this.status == OperationResultStatus.PARTIAL_ERROR;
    }

    public boolean isPartialError() {
        return this.status == OperationResultStatus.PARTIAL_ERROR;
    }

    public void computeStatus(String errorMessage) {
        this.computeStatus(errorMessage, errorMessage);
    }

    public void computeStatus(String errorMessage, String warnMessage) {
        Validate.notEmpty((String)errorMessage, (String)"Error message must not be null.");
        boolean noMessage = StringUtils.isEmpty((String)this.message);
        this.computeStatus();
        switch (this.status) {
            case PARTIAL_ERROR: 
            case FATAL_ERROR: {
                if (!noMessage) break;
                this.message = errorMessage;
                break;
            }
            case UNKNOWN: 
            case WARNING: 
            case NOT_APPLICABLE: {
                if (!noMessage) break;
                this.message = StringUtils.isNotEmpty((String)warnMessage) ? warnMessage : errorMessage;
            }
        }
    }

    public void computeStatus() {
        if (this.getSubresults().isEmpty()) {
            if (this.status == OperationResultStatus.UNKNOWN) {
                this.status = OperationResultStatus.SUCCESS;
            }
            return;
        }
        OperationResultStatus newStatus = OperationResultStatus.UNKNOWN;
        boolean allSuccess = true;
        boolean allNotApplicable = true;
        for (OperationResult sub : this.getSubresults()) {
            if (sub.getStatus() != OperationResultStatus.NOT_APPLICABLE) {
                allNotApplicable = false;
            }
            if (sub.getStatus() == OperationResultStatus.FATAL_ERROR) {
                this.status = OperationResultStatus.FATAL_ERROR;
                if (this.message == null) {
                    this.message = sub.getMessage();
                }
                return;
            }
            if (sub.getStatus() == OperationResultStatus.IN_PROGRESS) {
                this.status = OperationResultStatus.IN_PROGRESS;
                if (this.message == null) {
                    this.message = sub.getMessage();
                }
                return;
            }
            if (sub.getStatus() != OperationResultStatus.SUCCESS && sub.getStatus() != OperationResultStatus.NOT_APPLICABLE) {
                allSuccess = false;
            }
            if (sub.getStatus() == OperationResultStatus.PARTIAL_ERROR) {
                newStatus = OperationResultStatus.PARTIAL_ERROR;
                if (this.message == null) {
                    this.message = sub.getMessage();
                }
            }
            if (newStatus == OperationResultStatus.PARTIAL_ERROR || sub.getStatus() != OperationResultStatus.WARNING) continue;
            newStatus = OperationResultStatus.WARNING;
            if (this.message != null) continue;
            this.message = sub.getMessage();
        }
        if (allNotApplicable && !this.getSubresults().isEmpty()) {
            this.status = OperationResultStatus.NOT_APPLICABLE;
        }
        this.status = allSuccess && !this.getSubresults().isEmpty() ? OperationResultStatus.SUCCESS : newStatus;
    }

    public void recomputeStatus() {
        if (this.subresults != null && !this.subresults.isEmpty()) {
            this.computeStatus();
        }
    }

    public void recomputeStatus(String message) {
        if (this.subresults != null && !this.subresults.isEmpty()) {
            this.computeStatus(message);
        }
    }

    public void recomputeStatus(String errorMessage, String warningMessage) {
        if (this.subresults != null && !this.subresults.isEmpty()) {
            this.computeStatus(errorMessage, warningMessage);
        }
    }

    public void recordSuccessIfUnknown() {
        if (this.isUnknown()) {
            this.recordSuccess();
        }
    }

    public Map<String, Object> getParams() {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        return this.params;
    }

    public void addParam(String paramName, Object paramValue) {
        this.getParams().put(paramName, paramValue);
    }

    public void addParams(String[] names, Object ... objects) {
        if (names.length != objects.length) {
            throw new IllegalArgumentException("Bad result parameters size, names '" + names.length + "', objects '" + objects.length + "'.");
        }
        int i = 0;
        while (i < names.length) {
            this.addParam(names[i], objects[i]);
            ++i;
        }
    }

    public Map<String, Object> getContext() {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        return this.context;
    }

    public <T> T getContext(Class<T> type, String contextName) {
        return (T)this.getContext().get(contextName);
    }

    public void addContext(String contextName, Object value) {
        this.getContext().put(contextName, value);
    }

    public Map<String, Object> getReturns() {
        if (this.returns == null) {
            this.returns = new HashMap<String, Object>();
        }
        return this.returns;
    }

    public void addReturn(String returnName, Object value) {
        this.getReturns().put(returnName, value);
    }

    public Object getReturn(String returnName) {
        return this.getReturns().get(returnName);
    }

    public long getToken() {
        if (this.token == 0L) {
            this.token = TOKEN_COUNT++;
        }
        return this.token;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocalizationMessage() {
        return this.localizationMessage;
    }

    public List<Object> getLocalizationArguments() {
        return this.localizationArguments;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void recordSuccess() {
        this.status = OperationResultStatus.SUCCESS;
    }

    public void recordFatalError(Throwable cause) {
        this.recordStatus(OperationResultStatus.FATAL_ERROR, cause.getMessage(), cause);
    }

    public void recordPartialError(Throwable cause) {
        this.recordStatus(OperationResultStatus.PARTIAL_ERROR, cause.getMessage(), cause);
    }

    public void recordWarning(Throwable cause) {
        this.recordStatus(OperationResultStatus.WARNING, cause.getMessage(), cause);
    }

    public void recordStatus(OperationResultStatus status, Throwable cause) {
        this.status = status;
        this.cause = cause;
        this.message = cause.getMessage();
    }

    public void recordFatalError(String message, Throwable cause) {
        this.recordStatus(OperationResultStatus.FATAL_ERROR, message, cause);
    }

    public void recordPartialError(String message, Throwable cause) {
        this.recordStatus(OperationResultStatus.PARTIAL_ERROR, message, cause);
    }

    public void recordWarning(String message, Throwable cause) {
        this.recordStatus(OperationResultStatus.WARNING, message, cause);
    }

    public void recordStatus(OperationResultStatus status, String message, Throwable cause) {
        this.status = status;
        this.message = message;
        this.cause = cause;
    }

    public void recordFatalError(String message) {
        this.recordStatus(OperationResultStatus.FATAL_ERROR, message);
    }

    public void recordPartialError(String message) {
        this.recordStatus(OperationResultStatus.PARTIAL_ERROR, message);
    }

    public void recordWarning(String message) {
        this.recordStatus(OperationResultStatus.WARNING, message);
    }

    public void record(CommonException exception) {
        this.recordFatalError(exception.getOperationResultMessage(), (Throwable)exception);
    }

    public void recordStatus(OperationResultStatus status, String message) {
        this.status = status;
        this.message = message;
    }

    public boolean hasUnknownStatus() {
        if (this.status == OperationResultStatus.UNKNOWN) {
            return true;
        }
        for (OperationResult subresult : this.getSubresults()) {
            if (!subresult.hasUnknownStatus()) continue;
            return true;
        }
        return false;
    }

    public void appendDetail(String detailLine) {
        this.details.add(detailLine);
    }

    public List<String> getDetail() {
        return this.details;
    }

    public String toString() {
        return "R(" + this.operation + " " + (Object)((Object)this.status) + " " + this.message + ")";
    }

    public String dump() {
        return this.dump(true);
    }

    public String dump(boolean withStack) {
        StringBuilder sb = new StringBuilder();
        this.dumpIndent(sb, 0, withStack);
        return sb.toString();
    }

    private void dumpIndent(StringBuilder sb, int indent, boolean printStackTrace) {
        int i;
        int i2 = 0;
        while (i2 < indent) {
            sb.append(INDENT_STRING);
            ++i2;
        }
        sb.append("*op* ");
        sb.append(this.operation);
        sb.append(", st: ");
        sb.append((Object)this.status);
        sb.append(", msg: ");
        sb.append(this.message);
        if (this.count > 1) {
            sb.append(" x");
            sb.append(this.count);
        }
        sb.append("\n");
        if (this.cause != null) {
            i2 = 0;
            while (i2 < indent + 2) {
                sb.append(INDENT_STRING);
                ++i2;
            }
            sb.append("[cause]");
            sb.append(this.cause.getClass().getSimpleName());
            sb.append(":");
            sb.append(this.cause.getMessage());
            sb.append("\n");
            if (printStackTrace) {
                OperationResult.dumpStackTrace(sb, this.cause.getStackTrace(), indent + 4);
                this.dumpInnerCauses(sb, this.cause.getCause(), indent + 3);
            }
        }
        for (Map.Entry<String, Object> entry : this.getParams().entrySet()) {
            i = 0;
            while (i < indent + 2) {
                sb.append(INDENT_STRING);
                ++i;
            }
            sb.append("[p]");
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(this.dumpEntry(entry.getValue()));
            sb.append("\n");
        }
        for (Map.Entry<String, Object> entry : this.getContext().entrySet()) {
            i = 0;
            while (i < indent + 2) {
                sb.append(INDENT_STRING);
                ++i;
            }
            sb.append("[c]");
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(this.dumpEntry(entry.getValue()));
            sb.append("\n");
        }
        for (Map.Entry<String, Object> entry : this.getReturns().entrySet()) {
            i = 0;
            while (i < indent + 2) {
                sb.append(INDENT_STRING);
                ++i;
            }
            sb.append("[r]");
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(this.dumpEntry(entry.getValue()));
            sb.append("\n");
        }
        for (String line : this.details) {
            i = 0;
            while (i < indent + 2) {
                sb.append(INDENT_STRING);
                ++i;
            }
            sb.append("[d]");
            sb.append(line);
            sb.append("\n");
        }
        for (OperationResult sub : this.getSubresults()) {
            sub.dumpIndent(sb, indent + 1, printStackTrace);
        }
    }

    private String dumpEntry(Object value) {
        Element element;
        if (value instanceof Element && SchemaConstants.C_VALUE.equals(DOMUtil.getQName((Node)(element = (Element)value)))) {
            try {
                String cvalue = null;
                cvalue = value == null ? "null" : (value instanceof Element ? SchemaDebugUtil.prettyPrint(XmlTypeConverter.toJavaValue((Element)((Element)value))) : SchemaDebugUtil.prettyPrint(value));
                return cvalue;
            }
            catch (Exception exception) {
                return "value: " + element.getTextContent();
            }
        }
        return SchemaDebugUtil.prettyPrint(value);
    }

    private void dumpInnerCauses(StringBuilder sb, Throwable innerCause, int indent) {
        if (innerCause == null) {
            return;
        }
        int i = 0;
        while (i < indent) {
            sb.append(INDENT_STRING);
            ++i;
        }
        sb.append("Caused by ");
        sb.append(innerCause.getClass().getName());
        sb.append(": ");
        sb.append(innerCause.getMessage());
        sb.append("\n");
        OperationResult.dumpStackTrace(sb, innerCause.getStackTrace(), indent + 1);
        this.dumpInnerCauses(sb, innerCause.getCause(), indent);
    }

    private static void dumpStackTrace(StringBuilder sb, StackTraceElement[] stackTrace, int indent) {
        int i = 0;
        while (i < stackTrace.length) {
            int j = 0;
            while (j < indent) {
                sb.append(INDENT_STRING);
                ++j;
            }
            StackTraceElement element = stackTrace[i];
            sb.append(element.toString());
            sb.append("\n");
            ++i;
        }
    }

    public static OperationResult createOperationResult(OperationResultType result) {
        LocalizedMessageType message;
        Validate.notNull((Object)result, (String)"Result type must not be null.");
        HashMap<String, Object> params = null;
        if (result.getParams() != null) {
            params = new HashMap<String, Object>();
            for (EntryType entry : result.getParams().getEntry()) {
                params.put(entry.getKey(), entry.getAny());
            }
        }
        ArrayList<OperationResult> subresults = null;
        if (!result.getPartialResults().isEmpty()) {
            subresults = new ArrayList<OperationResult>();
            for (OperationResultType subResult : result.getPartialResults()) {
                subresults.add(OperationResult.createOperationResult(subResult));
            }
        }
        String localizedMessage = (message = result.getLocalizedMessage()) == null ? null : message.getKey();
        List<Object> localizedArguments = message == null ? null : message.getArgument();
        return new OperationResult(result.getOperation(), params, OperationResultStatus.parseStatusType(result.getStatus()), result.getToken(), result.getMessageCode(), result.getMessage(), localizedMessage, localizedArguments, null, subresults);
    }

    public OperationResultType createOperationResultType() {
        return this.createOperationResultType(this);
    }

    private OperationResultType createOperationResultType(OperationResult opResult) {
        Set<Map.Entry<String, Object>> params;
        OperationResultType result = new OperationResultType();
        result.setToken(opResult.getToken());
        result.setStatus(OperationResultStatus.createStatusType(opResult.getStatus()));
        result.setOperation(opResult.getOperation());
        result.setMessage(opResult.getMessage());
        result.setMessageCode(opResult.getMessageCode());
        if (opResult.getCause() != null || !opResult.details.isEmpty()) {
            StringBuilder detailsb = new StringBuilder();
            if (opResult.details.isEmpty()) {
                for (String line : opResult.details) {
                    detailsb.append(line);
                    detailsb.append("\n");
                }
            }
            if (opResult.getCause() != null) {
                Throwable ex = opResult.getCause();
                detailsb.append(ex.getClass().getName());
                detailsb.append(": ");
                detailsb.append(ex.getMessage());
                detailsb.append("\n");
                StackTraceElement[] stackTrace = ex.getStackTrace();
                int i = 0;
                while (i < stackTrace.length) {
                    detailsb.append(stackTrace[i].toString());
                    detailsb.append("\n");
                    ++i;
                }
            }
            result.setDetails(this.details.toString());
        }
        if (StringUtils.isNotEmpty((String)opResult.getLocalizationMessage())) {
            LocalizedMessageType message = new LocalizedMessageType();
            message.setKey(opResult.getLocalizationMessage());
            if (opResult.getLocalizationArguments() != null) {
                message.getArgument().addAll(opResult.getLocalizationArguments());
            }
            result.setLocalizedMessage(message);
        }
        if (!(params = opResult.getParams().entrySet()).isEmpty()) {
            ParamsType paramsType = new ParamsType();
            result.setParams(paramsType);
            for (Map.Entry<String, Object> entry : params) {
                paramsType.getEntry().add(this.createEntryElement(entry.getKey(), entry.getValue()));
            }
        }
        for (OperationResult subResult : opResult.getSubresults()) {
            result.getPartialResults().add(opResult.createOperationResultType(subResult));
        }
        return result;
    }

    private EntryType createEntryElement(String key, Object value) {
        EntryType entryType = new EntryType();
        entryType.setKey(key);
        if (value != null) {
            Document doc = DOMUtil.getDocument();
            if (value instanceof ObjectType && ((ObjectType)value).getOid() != null) {
                this.setObjectReferenceEntry(entryType, (ObjectType)value);
            } else if (value instanceof String || value instanceof Integer || value instanceof Long) {
                entryType.setAny(new JAXBElement(SchemaConstants.C_VALUE, Object.class, value));
            } else if (XmlTypeConverter.canConvert(value.getClass())) {
                try {
                    entryType.setAny(XmlTypeConverter.toXsdElement((Object)value, (QName)SchemaConstants.C_VALUE, (Document)doc, (boolean)true));
                }
                catch (SchemaException e) {
                    LOGGER.error("Cannot convert value {} to XML: {}", value, (Object)e.getMessage());
                    this.setUnknownJavaObjectEntry(entryType, value);
                }
            } else if (value instanceof Element || value instanceof JAXBElement) {
                entryType.setAny(value);
            } else if ("com.evolveum.midpoint.xml.ns._public.common.common_2".equals(value.getClass().getPackage().getName())) {
                JAXBElement o = new JAXBElement(SchemaConstants.C_VALUE, Object.class, value);
                entryType.setAny(o);
            } else {
                this.setUnknownJavaObjectEntry(entryType, value);
            }
        }
        return entryType;
    }

    private void setObjectReferenceEntry(EntryType entryType, ObjectType objectType) {
        ObjectReferenceType objRefType = new ObjectReferenceType();
        objRefType.setOid(objectType.getOid());
        ObjectTypes type = ObjectTypes.getObjectType(objectType.getClass());
        if (type != null) {
            objRefType.setType(type.getTypeQName());
        }
        JAXBElement element = new JAXBElement(SchemaConstants.C_OBJECT_REF, ObjectReferenceType.class, (Object)objRefType);
        entryType.setAny(element);
    }

    private void setUnknownJavaObjectEntry(EntryType entryType, Object value) {
        UnknownJavaObjectType ujo = new UnknownJavaObjectType();
        ujo.setClazz(value.getClass().getName());
        ujo.setToString(value.toString());
        entryType.setAny(new ObjectFactory().createUnknownJavaObject(ujo));
    }

    public void summarize() {
        Iterator<OperationResult> iterator = this.getSubresults().iterator();
        while (iterator.hasNext()) {
            OperationResult similar;
            OperationResult subresult = iterator.next();
            if (!(subresult.getCount() <= 1 && (subresult.isError() && this.summarizeErrors || subresult.isPartialError() && this.summarizePartialErrors || subresult.isSuccess() && this.summarizeSuccesses) && (similar = this.findSimilarSubresult(subresult)) != null)) continue;
            this.merge(similar, subresult);
            iterator.remove();
        }
    }

    private void merge(OperationResult target, OperationResult source) {
        this.mergeMap(target.getParams(), source.getParams());
        this.mergeMap(target.getContext(), source.getContext());
        this.mergeMap(target.getReturns(), source.getReturns());
        target.incrementCount();
    }

    private void mergeMap(Map<String, Object> targetMap, Map<String, Object> sourceMap) {
        for (Map.Entry<String, Object> targetEntry : targetMap.entrySet()) {
            Object sourceValue;
            String targetKey = targetEntry.getKey();
            Object targetValue = targetEntry.getValue();
            if (targetValue != null && targetValue instanceof VariousValues || MiscUtil.equals((Object)targetValue, (Object)(sourceValue = sourceMap.get(targetKey)))) continue;
            targetEntry.setValue(new VariousValues());
        }
        for (Map.Entry<String, Object> sourceEntry : sourceMap.entrySet()) {
            String sourceKey = sourceEntry.getKey();
            if (targetMap.containsKey(sourceKey)) continue;
            targetMap.put(sourceKey, new VariousValues());
        }
    }

    private OperationResult findSimilarSubresult(OperationResult subresult) {
        OperationResult similar = null;
        for (OperationResult sub : this.getSubresults()) {
            if (sub == subresult || sub.status != subresult.status || !MiscUtil.equals((Object)sub.message, (Object)subresult.message) || similar != null && similar.count >= sub.count) continue;
            similar = sub;
        }
        return similar;
    }
}

