/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.processor;

import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainer;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainerDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class ObjectClassComplexTypeDefinition
extends ComplexTypeDefinition {
    private Set<ResourceAttributeDefinition> identifiers;
    private Set<ResourceAttributeDefinition> secondaryIdentifiers;
    private ResourceAttributeDefinition descriptionAttribute;
    private ResourceAttributeDefinition displayNameAttribute;
    private ResourceAttributeDefinition namingAttribute;
    private boolean defaultAccountType = false;
    private boolean accountType = false;
    private String accountTypeName;
    private String nativeObjectClass;

    public ObjectClassComplexTypeDefinition(QName defaultName, QName typeName, PrismContext prismContext) {
        super(defaultName, typeName, prismContext);
    }

    public Collection<? extends ResourceAttributeDefinition> getAttributeDefinitions() {
        HashSet<ResourceAttributeDefinition> attrs = new HashSet<ResourceAttributeDefinition>();
        for (ItemDefinition def : this.getDefinitions()) {
            if (!(def instanceof ResourceAttributeDefinition)) continue;
            attrs.add((ResourceAttributeDefinition)def);
        }
        return attrs;
    }

    public Collection<ResourceAttributeDefinition> getIdentifiers() {
        if (this.identifiers == null) {
            this.identifiers = new HashSet<ResourceAttributeDefinition>();
        }
        return this.identifiers;
    }

    public boolean isIdentifier(QName attrName) {
        for (ResourceAttributeDefinition idDef : this.getIdentifiers()) {
            if (!idDef.getName().equals(attrName)) continue;
            return true;
        }
        return false;
    }

    public Set<ResourceAttributeDefinition> getSecondaryIdentifiers() {
        if (this.secondaryIdentifiers == null) {
            this.secondaryIdentifiers = new HashSet<ResourceAttributeDefinition>();
        }
        return this.secondaryIdentifiers;
    }

    public boolean isSecondaryIdentifier(QName attrName) {
        for (ResourceAttributeDefinition idDef : this.getSecondaryIdentifiers()) {
            if (!idDef.getName().equals(attrName)) continue;
            return true;
        }
        return false;
    }

    public ResourceAttributeDefinition getDescriptionAttribute() {
        return this.descriptionAttribute;
    }

    public void setDescriptionAttribute(ResourceAttributeDefinition descriptionAttribute) {
        this.descriptionAttribute = descriptionAttribute;
    }

    public ResourceAttributeDefinition getNamingAttribute() {
        return this.namingAttribute;
    }

    public void setNamingAttribute(ResourceAttributeDefinition namingAttribute) {
        this.namingAttribute = namingAttribute;
    }

    public void setNamingAttribute(QName namingAttribute) {
        this.setNamingAttribute(this.findAttributeDefinition(namingAttribute));
    }

    public String getNativeObjectClass() {
        return this.nativeObjectClass;
    }

    public void setNativeObjectClass(String nativeObjectClass) {
        this.nativeObjectClass = nativeObjectClass;
    }

    public boolean isAccountType() {
        return this.accountType;
    }

    public void setAccountType(boolean accountType) {
        this.accountType = accountType;
        if (!accountType) {
            this.defaultAccountType = false;
        }
    }

    public boolean isDefaultAccountType() {
        return this.defaultAccountType;
    }

    public void setDefaultAccountType(boolean defaultAccountType) {
        this.defaultAccountType = defaultAccountType;
        if (defaultAccountType && !this.accountType) {
            throw new IllegalStateException("Can't be default account type, flat account type (boolean) not set.");
        }
    }

    public String getAccountTypeName() {
        return this.accountTypeName;
    }

    public void setAccountTypeName(String accountTypeName) {
        this.accountTypeName = accountTypeName;
    }

    public ResourceAttributeDefinition getDisplayNameAttribute() {
        return this.displayNameAttribute;
    }

    public void setDisplayNameAttribute(ResourceAttributeDefinition displayName) {
        this.displayNameAttribute = displayName;
    }

    public void setDisplayNameAttribute(QName displayName) {
        this.setDisplayNameAttribute(this.findAttributeDefinition(displayName));
    }

    public ResourceAttributeDefinition findAttributeDefinition(QName name) {
        return (ResourceAttributeDefinition)this.findItemDefinition(name, ResourceAttributeDefinition.class);
    }

    public ResourceAttributeDefinition findAttributeDefinition(String name) {
        QName qname = new QName(this.getTypeName().getNamespaceURI(), name);
        return this.findAttributeDefinition(qname);
    }

    public ResourceAttributeDefinition createAttributeDefinition(QName name, QName typeName) {
        ResourceAttributeDefinition propDef = new ResourceAttributeDefinition(name, name, typeName, this.prismContext);
        this.getDefinitions().add(propDef);
        return propDef;
    }

    public ResourceAttributeDefinition createAttributeDefinition(String localName, QName typeName) {
        QName name = new QName(this.getSchemaNamespace(), localName);
        return this.createAttributeDefinition(name, typeName);
    }

    public ResourceAttributeDefinition createAttributeDefinition(String localName, String localTypeName) {
        QName name = new QName(this.getSchemaNamespace(), localName);
        QName typeName = new QName(this.getSchemaNamespace(), localTypeName);
        return this.createAttributeDefinition(name, typeName);
    }

    public ResourceAttributeContainerDefinition toResourceAttributeContainerDefinition(QName elementName) {
        return new ResourceAttributeContainerDefinition(elementName, this, this.getPrismContext());
    }

    public ResourceAttributeContainer instantiate(QName elementName) {
        ResourceAttributeContainerDefinition racDef = this.toResourceAttributeContainerDefinition(elementName);
        ResourceAttributeContainer rac = new ResourceAttributeContainer(elementName, racDef, this.getPrismContext());
        return rac;
    }

    public ObjectClassComplexTypeDefinition clone() {
        ObjectClassComplexTypeDefinition clone = new ObjectClassComplexTypeDefinition(this.getDefaultName(), this.getTypeName(), this.prismContext);
        this.copyDefinitionData(clone);
        return clone;
    }

    protected void copyDefinitionData(ObjectClassComplexTypeDefinition clone) {
        super.copyDefinitionData((ComplexTypeDefinition)clone);
        clone.accountType = this.accountType;
        clone.accountTypeName = this.accountTypeName;
        clone.defaultAccountType = this.defaultAccountType;
        clone.descriptionAttribute = this.descriptionAttribute;
        clone.displayNameAttribute = this.displayNameAttribute;
        clone.identifiers = this.identifiers;
        clone.namingAttribute = this.namingAttribute;
        clone.nativeObjectClass = this.nativeObjectClass;
        clone.secondaryIdentifiers = this.secondaryIdentifiers;
    }

    protected String getDebugDumpClassName() {
        return "OCD";
    }
}

