/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.processor;

import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.schema.SchemaDefinitionFactory;
import com.evolveum.midpoint.prism.schema.SchemaProcessorUtil;
import com.evolveum.midpoint.prism.schema.SchemaToDomProcessor;
import com.evolveum.midpoint.schema.constants.MidPointConstants;
import com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainerDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSParticle;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MidPointSchemaDefinitionFactory
extends SchemaDefinitionFactory {
    public ComplexTypeDefinition createComplexTypeDefinition(XSComplexType complexType, PrismContext prismContext, XSAnnotation annotation) throws SchemaException {
        if (this.isResourceObject(annotation)) {
            return this.createObjectClassDefinition(complexType, prismContext, annotation);
        }
        return super.createComplexTypeDefinition(complexType, prismContext, annotation);
    }

    private ComplexTypeDefinition createObjectClassDefinition(XSComplexType complexType, PrismContext prismContext, XSAnnotation annotation) {
        QName typeName = new QName(complexType.getTargetNamespace(), complexType.getName());
        ObjectClassComplexTypeDefinition ocDef = new ObjectClassComplexTypeDefinition(null, typeName, prismContext);
        Element nativeAttrElement = SchemaProcessorUtil.getAnnotationElement((XSAnnotation)annotation, (QName)MidPointConstants.RA_NATIVE_OBJECT_CLASS);
        String nativeObjectClass = nativeAttrElement == null ? null : nativeAttrElement.getTextContent();
        ocDef.setNativeObjectClass(nativeObjectClass);
        if (this.isAccountObject(annotation)) {
            Element accountType;
            Element defaultAccount;
            String defaultValue;
            ocDef.setAccountType(true);
            Element account = SchemaProcessorUtil.getAnnotationElement((XSAnnotation)annotation, (QName)MidPointConstants.RA_ACCOUNT);
            if (account != null && (defaultValue = account.getAttribute("default")) != null) {
                ocDef.setDefaultAccountType(Boolean.parseBoolean(defaultValue));
            }
            if ((defaultAccount = SchemaProcessorUtil.getAnnotationElement((XSAnnotation)annotation, (QName)MidPointConstants.RA_DEFAULT)) != null) {
                ocDef.setDefaultAccountType(true);
            }
            if ((accountType = SchemaProcessorUtil.getAnnotationElement((XSAnnotation)annotation, (QName)MidPointConstants.RA_ACCOUNT_TYPE)) != null) {
                ocDef.setAccountTypeName(accountType.getTextContent());
            }
        }
        return ocDef;
    }

    public void finishComplexTypeDefinition(ComplexTypeDefinition complexTypeDefinition, XSComplexType complexType, PrismContext prismContext, XSAnnotation annotation) throws SchemaException {
        super.finishComplexTypeDefinition(complexTypeDefinition, complexType, prismContext, annotation);
        if (complexTypeDefinition instanceof ObjectClassComplexTypeDefinition) {
            this.finishObjectClassDefinition((ObjectClassComplexTypeDefinition)complexTypeDefinition, complexType, prismContext, annotation);
        }
    }

    private void finishObjectClassDefinition(ObjectClassComplexTypeDefinition ocDef, XSComplexType complexType, PrismContext prismContext, XSAnnotation annotation) throws SchemaException {
        ResourceAttributeDefinition attrDefinition = this.getAnnotationReference(annotation, MidPointConstants.RA_DISPLAY_NAME_ATTRIBUTE, ocDef);
        if (attrDefinition != null) {
            ocDef.setDisplayNameAttribute(attrDefinition);
        }
        if ((attrDefinition = this.getAnnotationReference(annotation, MidPointConstants.RA_NAMING_ATTRIBUTE, ocDef)) != null) {
            ocDef.setNamingAttribute(attrDefinition);
        }
        if ((attrDefinition = this.getAnnotationReference(annotation, MidPointConstants.RA_DESCRIPTION_ATTRIBUTE, ocDef)) != null) {
            ocDef.setDescriptionAttribute(attrDefinition);
        }
        if ((attrDefinition = this.getAnnotationReference(annotation, MidPointConstants.RA_IDENTIFIER, ocDef)) != null) {
            ocDef.getIdentifiers().add(attrDefinition);
        }
        if ((attrDefinition = this.getAnnotationReference(annotation, MidPointConstants.RA_SECONDARY_IDENTIFIER, ocDef)) != null) {
            ocDef.getSecondaryIdentifiers().add(attrDefinition);
        }
    }

    public void addExtraComplexTypeAnnotations(ComplexTypeDefinition definition, Element appinfo, SchemaToDomProcessor schemaToDomProcessor) {
        super.addExtraComplexTypeAnnotations(definition, appinfo, schemaToDomProcessor);
        if (definition instanceof ObjectClassComplexTypeDefinition) {
            this.addExtraObjectClassAnnotations((ObjectClassComplexTypeDefinition)definition, appinfo, schemaToDomProcessor);
        }
    }

    private void addExtraObjectClassAnnotations(ObjectClassComplexTypeDefinition definition, Element appinfo, SchemaToDomProcessor processor) {
        processor.addAnnotation(MidPointConstants.RA_RESOURCE_OBJECT, appinfo);
        for (ResourceAttributeDefinition identifier : definition.getIdentifiers()) {
            processor.addRefAnnotation(MidPointConstants.RA_IDENTIFIER, identifier.getName(), appinfo);
        }
        for (ResourceAttributeDefinition identifier : definition.getSecondaryIdentifiers()) {
            processor.addRefAnnotation(MidPointConstants.RA_SECONDARY_IDENTIFIER, identifier.getName(), appinfo);
        }
        if (definition.getDisplayNameAttribute() != null) {
            processor.addRefAnnotation(MidPointConstants.RA_DISPLAY_NAME_ATTRIBUTE, definition.getDisplayNameAttribute().getName(), appinfo);
        }
        if (definition.getDescriptionAttribute() != null) {
            processor.addRefAnnotation(MidPointConstants.RA_DESCRIPTION_ATTRIBUTE, definition.getDescriptionAttribute().getName(), appinfo);
        }
        if (definition.getNamingAttribute() != null) {
            processor.addRefAnnotation(MidPointConstants.RA_NAMING_ATTRIBUTE, definition.getNamingAttribute().getName(), appinfo);
        }
        if (!StringUtils.isEmpty((String)definition.getNativeObjectClass())) {
            processor.addAnnotation(MidPointConstants.RA_NATIVE_OBJECT_CLASS, definition.getNativeObjectClass(), appinfo);
        }
        if (definition.isAccountType()) {
            processor.addAnnotation(MidPointConstants.RA_ACCOUNT, appinfo);
            if (definition.isDefaultAccountType()) {
                processor.addAnnotation(MidPointConstants.RA_DEFAULT, appinfo);
            }
            if (definition.getAccountTypeName() != null) {
                processor.addAnnotation(MidPointConstants.RA_ACCOUNT_TYPE, definition.getAccountTypeName(), appinfo);
            }
        }
    }

    public PrismContainerDefinition createExtraDefinitionFromComplexType(XSComplexType complexType, ComplexTypeDefinition complexTypeDefinition, PrismContext prismContext, XSAnnotation annotation) throws SchemaException {
        return super.createExtraDefinitionFromComplexType(complexType, complexTypeDefinition, prismContext, annotation);
    }

    private PrismContainerDefinition createResourceAttributeContainerDefinition(XSComplexType complexType, ObjectClassComplexTypeDefinition complexTypeDefinition, PrismContext prismContext, XSAnnotation annotation) {
        ResourceAttributeContainerDefinition attrContDef = new ResourceAttributeContainerDefinition(null, complexTypeDefinition, prismContext);
        return attrContDef;
    }

    public PrismPropertyDefinition createPropertyDefinition(QName elementName, QName typeName, ComplexTypeDefinition complexTypeDefinition, PrismContext prismContext, XSAnnotation annotation, XSParticle elementParticle) throws SchemaException {
        if (complexTypeDefinition != null && complexTypeDefinition instanceof ObjectClassComplexTypeDefinition) {
            return this.createResourceAttributeDefinition(elementName, typeName, prismContext, annotation);
        }
        return super.createPropertyDefinition(elementName, typeName, complexTypeDefinition, prismContext, annotation, elementParticle);
    }

    private PrismPropertyDefinition createResourceAttributeDefinition(QName elementName, QName typeName, PrismContext prismContext, XSAnnotation annotation) {
        String nativeAttributeName;
        ResourceAttributeDefinition attrDef = new ResourceAttributeDefinition(elementName, elementName, typeName, prismContext);
        Element nativeAttrElement = SchemaProcessorUtil.getAnnotationElement((XSAnnotation)annotation, (QName)MidPointConstants.RA_NATIVE_ATTRIBUTE_NAME);
        String string = nativeAttributeName = nativeAttrElement == null ? null : nativeAttrElement.getTextContent();
        if (!StringUtils.isEmpty((String)nativeAttributeName)) {
            attrDef.setNativeAttributeName(nativeAttributeName);
        }
        return attrDef;
    }

    private boolean isResourceObject(XSAnnotation annotation) {
        if (SchemaProcessorUtil.getAnnotationElement((XSAnnotation)annotation, (QName)MidPointConstants.RA_RESOURCE_OBJECT) != null) {
            return true;
        }
        return SchemaProcessorUtil.getAnnotationElement((XSAnnotation)annotation, (QName)MidPointConstants.RA_ACCOUNT) != null;
    }

    private boolean isAccountObject(XSAnnotation annotation) {
        if (annotation == null || annotation.getAnnotation() == null) {
            return false;
        }
        Element accountType = SchemaProcessorUtil.getAnnotationElement((XSAnnotation)annotation, (QName)MidPointConstants.RA_ACCOUNT);
        return accountType != null;
    }

    private ResourceAttributeDefinition getAnnotationReference(XSAnnotation annotation, QName qname, ObjectClassComplexTypeDefinition objectClass) throws SchemaException {
        Element element = SchemaProcessorUtil.getAnnotationElement((XSAnnotation)annotation, (QName)qname);
        if (element != null) {
            String reference = element.getTextContent();
            if (reference == null || reference.isEmpty()) {
                reference = element.getAttribute("ref");
            }
            if (reference != null && !reference.isEmpty()) {
                QName referenceItemName = DOMUtil.resolveQName((Node)element, (String)reference);
                PrismPropertyDefinition definition = objectClass.findPropertyDefinition(referenceItemName);
                if (definition == null) {
                    throw new SchemaException("The annotation " + qname + " in " + (Object)((Object)objectClass) + " is pointing to " + referenceItemName + " which does not exist");
                }
                if (definition instanceof ResourceAttributeDefinition) {
                    return (ResourceAttributeDefinition)definition;
                }
                throw new SchemaException("The annotation " + qname + " in " + (Object)((Object)objectClass) + " is pointing to " + referenceItemName + " which is not an attribute, it is " + definition);
            }
        }
        return null;
    }
}

