/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.constants;

import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import javax.xml.namespace.QName;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;

public abstract class SchemaConstants {
    private static final Trace LOGGER = TraceManager.getTrace(SchemaConstants.class);
    private static final CatalogResolver catalogResolver;
    private static boolean resolverInitialized;
    public static final String NS_QUERY = "http://prism.evolveum.com/xml/ns/public/query-2";
    public static final String NS_TYPES = "http://prism.evolveum.com/xml/ns/public/types-2";
    public static final String NS_MIDPOINT_PUBLIC_PREFIX = "http://midpoint.evolveum.com/xml/ns/public/";
    public static final String NS_C = "http://midpoint.evolveum.com/xml/ns/public/common/common-2";
    public static final String NS_C_PREFIX = "c";
    public static final String NS_CAPABILITIES = "http://midpoint.evolveum.com/xml/ns/public/resource/capabilities-2";
    public static final String NS_FILTER = "http://midpoint.evolveum.com/xml/ns/public/common/value-filter-1.xsd";
    public static final QName LOGGING;
    public static final QName C_NAME;
    public static final QName C_GENERIC_OBJECT;
    public static final QName C_ACCESS;
    public static final QName C_RAC_REF;
    public static final QName C_FILTER_TYPE_URI;
    public static final QName C_OBJECTS;
    public static final QName C_OBJECT;
    public static final QName C_OBJECT_TYPE;
    public static final QName C_OBJECT_REF;
    public static final QName C_VALUE;
    public static final QName ACTIVATION;
    public static final QName C_PATH;
    public static final QName C_OID_ATTRIBUTE;
    public static final QName I_OBJECTS;
    public static final QName C_EXTENSION;
    public static final QName C_TASK_TYPE;
    public static final QName C_TASK;
    public static final QName C_TASK_EXECUTION_STATUS;
    public static final QName C_TASK_EXECLUSIVITY_STATUS;
    public static final QName C_TASK_DESCRIPTION;
    public static final QName C_TASK_LAST_RUN_START_TIMESTAMP;
    public static final QName C_TASK_LAST_RUN_FINISH_TIMESTAMP;
    public static final QName C_TASK_NEXT_RUN_START_TIME;
    public static final QName C_TASK_RESULT;
    public static final QName C_TASK_PROGRESS;
    public static final QName I_RESOURCE;
    public static final QName C_RESOURCE_CONFIGURATION;
    public static final QName I_RESOURCE_STATE;
    public static final QName C_RESULT;
    public static final QName I_TYPE;
    public static final QName I_SCHEMA_HANDLING;
    public static final QName I_USER_TYPE;
    public static final QName I_USER;
    public static final QName C_ASSIGNMENT;
    public static final QName I_USER_TEMPLATE_TYPE;
    public static final QName I_GENERIC_OBJECT_TYPE;
    public static final QName I_GENERIC_OBJECT;
    public static final QName I_USER_TEMPLATE;
    public static final QName I_ACCOUNT_TYPE;
    public static final QName I_ACCOUNT_SHADOW_TYPE;
    public static final QName I_RESOURCE_TYPE;
    public static final QName I_CONNECTOR_TYPE;
    public static final QName I_CONNECTOR;
    public static final QName I_CONNECTOR_HOST_TYPE;
    public static final QName I_CONNECTOR_HOST;
    public static final QName C_CONNECTOR_FRAMEWORK;
    public static final QName C_CONNECTOR_CONNECTOR_TYPE;
    public static final QName I_SCHEMA;
    public static final QName I_ACCOUNT;
    public static final QName I_RESOURCE_OBJECT_SHADOW;
    public static final QName I_RESOURCE_OBJECT_SHADOW_TYPE;
    public static final QName I_OBJECT_CLASS;
    public static final QName I_OBJECT;
    public static final QName I_ACCOUNT_REF;
    public static final QName I_RESOURCE_REF;
    public static final QName I_ATTRIBUTES;
    public static final QName I_PROPERTY_CONTAINER_REFERENCE_PATH;
    public static final QName I_FILTER_TYPE;
    public static final QName I_RESOURCE_STATE_TYPE;
    public static final QName I_VALUE_ASSIGNMENT_SOURCE;
    public static final QName I_VALUE_ASSIGNMENT_TARGET;
    public static final QName I_VALUE_ASSIGNMENT_FILTER;
    public static final QName I_SYNCHRONIZATION_TYPE;
    public static final QName I_SYNCHRONIZATION;
    public static final QName I_SCRIPTS_TYPE;
    public static final QName I_SCRIPTS;
    public static final QName I_CREDENTIALS_TYPE;
    public static final QName I_CREDENTIALS;
    public static final QName I_PASSWORD;
    public static final QName C_ACTIVATION;
    public static final QName C_ACTIVATION_ENABLED;
    public static final QName C_OBJECT_MODIFICATION;
    public static final QName C_FAILED_OPERATION_TYPE;
    public static final QName T_POLY_STRING_TYPE;
    public static final QName X_ANNOTATION;
    public static final QName X_APPINFO;
    public static final QName X_SCHEMA;
    public static final QName X_DOCUMENTATION;
    public static final QName I_SYSTEM_CONFIGURATION_TYPE;
    public static final QName I_SYSTEM_CONFIGURATION;
    public static final QName I_PASSWORD_POLICY_TYPE;
    public static final QName I_PASSWORD_POLICY;
    public static final QName C_SYSTEM_CONFIGURATION_GLOBAL_ACCOUNT_SYNCHRONIZATION_SETTINGS;
    public static final PropertyPath PATH_PASSWORD;
    public static final PropertyPath PATH_PASSWORD_VALUE;
    public static final PropertyPath PATH_ACTIVATION;
    public static final PropertyPath PATH_ACTIVATION_ENABLE;
    public static final PropertyPath PATH_ATTRIBUTES;
    public static final PropertyPath PATH_EXTENSION;
    public static final QName ROLE;
    public static final QName ROLE_TYPE;
    public static final QName R_PROTECTED_STRING_TYPE;
    public static final QName R_PROTECTED_STRING;
    public static final QName R_PROTECTED_BYTE_ARRAY_TYPE;
    public static final String CONNECTOR_SCHEMA_CONFIGURATION_ELEMENT_LOCAL_NAME = "configuration";
    public static final String NS_ICF_SCHEMA = "http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/resource-schema-2";
    public static final String NS_ICF_CONFIGURATION = "http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/connector-schema-2";
    public static final String NS_PROVISIONING = "http://midpoint.evolveum.com/xml/ns/public/provisioning";
    public static final String NS_PROVISIONING_LIVE_SYNC = "http://midpoint.evolveum.com/xml/ns/public/provisioning/liveSync-1.xsd";
    public static final QName SYNC_TOKEN;
    public static final String NS_CHANNEL = "http://midpoint.evolveum.com/xml/ns/public/provisioning/channels-1";
    public static final QName CHANGE_CHANNEL_SYNC;
    public static final QName CHANGE_CHANNEL_RECON;
    public static final QName CHANGE_CHANNEL_DISCOVERY;
    public static final QName CHANGE_CHANNEL_IMPORT;
    public static final String NS_SITUATION = "http://midpoint.evolveum.com/xml/ns/public/model/situation-1.xsd";
    public static final String[] JAXB_PACKAGES;

    static {
        resolverInitialized = false;
        LOGGING = new QName(NS_C, "logging");
        C_NAME = new QName(NS_C, "name");
        C_GENERIC_OBJECT = new QName(NS_C, "genericObject");
        C_ACCESS = new QName(NS_C, "access");
        C_RAC_REF = new QName(NS_C, "ResourceAccessConfigurationReferenceType");
        C_FILTER_TYPE_URI = new QName(NS_QUERY, "uri");
        C_OBJECTS = new QName(NS_C, "objects");
        C_OBJECT = new QName(NS_C, "object");
        C_OBJECT_TYPE = new QName(NS_C, "ObjectType");
        C_OBJECT_REF = new QName(NS_C, "objectRef");
        C_VALUE = new QName(NS_C, "value");
        ACTIVATION = new QName(NS_C, "activation");
        C_PATH = new QName(NS_C, "path");
        C_OID_ATTRIBUTE = new QName(NS_C, "oid");
        I_OBJECTS = new QName(NS_C, "objects");
        C_EXTENSION = new QName(NS_C, "extension");
        C_TASK_TYPE = new QName(NS_C, "TaskType");
        C_TASK = new QName(NS_C, "task");
        C_TASK_EXECUTION_STATUS = new QName(NS_C, "executionStatus");
        C_TASK_EXECLUSIVITY_STATUS = new QName(NS_C, "exclusivityStatus");
        C_TASK_DESCRIPTION = new QName(NS_C, "description");
        C_TASK_LAST_RUN_START_TIMESTAMP = new QName(NS_C, "lastRunStartTimestamp");
        C_TASK_LAST_RUN_FINISH_TIMESTAMP = new QName(NS_C, "lastRunFinishTimestamp");
        C_TASK_NEXT_RUN_START_TIME = new QName(NS_C, "nextRunStartTime");
        C_TASK_RESULT = new QName(NS_C, "result");
        C_TASK_PROGRESS = new QName(NS_C, "progress");
        I_RESOURCE = new QName(NS_C, "resource");
        C_RESOURCE_CONFIGURATION = new QName(NS_C, CONNECTOR_SCHEMA_CONFIGURATION_ELEMENT_LOCAL_NAME);
        I_RESOURCE_STATE = new QName(NS_C, "resourceState");
        C_RESULT = new QName(NS_C, "result");
        I_TYPE = new QName(NS_C, "type");
        I_SCHEMA_HANDLING = new QName(NS_C, "schemaHandling");
        I_USER_TYPE = new QName(NS_C, "UserType");
        I_USER = new QName(NS_C, "user");
        C_ASSIGNMENT = new QName(NS_C, "assignment");
        I_USER_TEMPLATE_TYPE = new QName(NS_C, "UserTemplateType");
        I_GENERIC_OBJECT_TYPE = new QName(NS_C, "GenericObjectType");
        I_GENERIC_OBJECT = new QName(NS_C, "genericObject");
        I_USER_TEMPLATE = new QName(NS_C, "userTemplate");
        I_ACCOUNT_TYPE = new QName(NS_C, "AccountType");
        I_ACCOUNT_SHADOW_TYPE = new QName(NS_C, "AccountShadowType");
        I_RESOURCE_TYPE = new QName(NS_C, "ResourceType");
        I_CONNECTOR_TYPE = new QName(NS_C, "ConnectorType");
        I_CONNECTOR = new QName(NS_C, "connector");
        I_CONNECTOR_HOST_TYPE = new QName(NS_C, "ConnectorHostType");
        I_CONNECTOR_HOST = new QName(NS_C, "connectorHost");
        C_CONNECTOR_FRAMEWORK = new QName(NS_C, "framework");
        C_CONNECTOR_CONNECTOR_TYPE = new QName(NS_C, "connectorType");
        I_SCHEMA = new QName(NS_C, "schema");
        I_ACCOUNT = new QName(NS_C, "account");
        I_RESOURCE_OBJECT_SHADOW = new QName(NS_C, "resourceObjectShadow");
        I_RESOURCE_OBJECT_SHADOW_TYPE = new QName(NS_C, "ResourceObjectShadowType");
        I_OBJECT_CLASS = new QName(NS_C, "objectClass");
        I_OBJECT = new QName(NS_C, "object");
        I_ACCOUNT_REF = new QName(NS_C, "accountRef");
        I_RESOURCE_REF = new QName(NS_C, "resourceRef");
        I_ATTRIBUTES = new QName(NS_C, "attributes");
        I_PROPERTY_CONTAINER_REFERENCE_PATH = new QName(NS_C, "path");
        I_FILTER_TYPE = new QName(NS_C, "FilterType");
        I_RESOURCE_STATE_TYPE = new QName(NS_C, "ResourceStateType");
        I_VALUE_ASSIGNMENT_SOURCE = new QName(NS_C, "source");
        I_VALUE_ASSIGNMENT_TARGET = new QName(NS_C, "target");
        I_VALUE_ASSIGNMENT_FILTER = new QName(NS_C, "valueFilter");
        I_SYNCHRONIZATION_TYPE = new QName(NS_C, "SynchronizationType");
        I_SYNCHRONIZATION = new QName(NS_C, "synchronization");
        I_SCRIPTS_TYPE = new QName(NS_C, "ScriptsType");
        I_SCRIPTS = new QName(NS_C, "scripts");
        I_CREDENTIALS_TYPE = new QName(NS_C, "CredentialsType");
        I_CREDENTIALS = new QName(NS_C, "credentials");
        I_PASSWORD = new QName(NS_C, "password");
        C_ACTIVATION = new QName(NS_C, "activation");
        C_ACTIVATION_ENABLED = new QName(NS_C, "enabled");
        C_OBJECT_MODIFICATION = new QName(NS_C, "objectModification");
        C_FAILED_OPERATION_TYPE = new QName(NS_C, "failedOperationType");
        T_POLY_STRING_TYPE = new QName(NS_TYPES, "PolyStringType");
        X_ANNOTATION = new QName("http://www.w3.org/2001/XMLSchema", "annotation");
        X_APPINFO = new QName("http://www.w3.org/2001/XMLSchema", "appinfo");
        X_SCHEMA = new QName("http://www.w3.org/2001/XMLSchema", "schema");
        X_DOCUMENTATION = new QName("http://www.w3.org/2001/XMLSchema", "documentation");
        I_SYSTEM_CONFIGURATION_TYPE = new QName(NS_C, "SystemConfigurationType");
        I_SYSTEM_CONFIGURATION = new QName(NS_C, "systemConfiguration");
        I_PASSWORD_POLICY_TYPE = new QName(NS_C, "PasswordPolicyType");
        I_PASSWORD_POLICY = new QName(NS_C, "passwordPolicy");
        C_SYSTEM_CONFIGURATION_GLOBAL_ACCOUNT_SYNCHRONIZATION_SETTINGS = new QName(NS_C, "globalAccountSynchronizationSettings");
        PATH_PASSWORD = new PropertyPath(new QName[]{I_CREDENTIALS, I_PASSWORD});
        PATH_PASSWORD_VALUE = new PropertyPath(new QName[]{I_CREDENTIALS, I_PASSWORD, new QName(NS_C, "protectedString")});
        PATH_ACTIVATION = new PropertyPath(new QName[]{C_ACTIVATION});
        PATH_ACTIVATION_ENABLE = new PropertyPath(new QName[]{C_ACTIVATION, C_ACTIVATION_ENABLED});
        PATH_ATTRIBUTES = new PropertyPath(new QName[]{I_ATTRIBUTES});
        PATH_EXTENSION = new PropertyPath(new QName[]{C_EXTENSION});
        ROLE = new QName(NS_C, "role");
        ROLE_TYPE = new QName(NS_C, "RoleType");
        R_PROTECTED_STRING_TYPE = new QName(NS_C, "ProtectedStringType");
        R_PROTECTED_STRING = new QName(NS_C, "protectedString");
        R_PROTECTED_BYTE_ARRAY_TYPE = new QName(NS_C, "ProtectedByteArrayType");
        SYNC_TOKEN = new QName(NS_PROVISIONING_LIVE_SYNC, "token");
        CHANGE_CHANNEL_SYNC = new QName(NS_CHANNEL, "synchronization");
        CHANGE_CHANNEL_RECON = new QName(NS_CHANNEL, "reconciliation");
        CHANGE_CHANNEL_DISCOVERY = new QName(NS_CHANNEL, "discovery");
        CHANGE_CHANNEL_IMPORT = new QName(NS_CHANNEL, "import");
        JAXB_PACKAGES = new String[]{"com.evolveum.midpoint.xml.ns._public.common.common_2", "com.evolveum.midpoint.xml.ns._public.resource.resource_schema_1", "com.evolveum.midpoint.xml.ns._public.resource.capabilities_2", "com.evolveum.midpoint.xml.ns._public.communication.workflow_1"};
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setUseStaticCatalog(true);
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setVerbosity(1);
        catalogManager.setPreferPublic(true);
        catalogResolver = new CatalogResolver(catalogManager);
        Catalog resolver = catalogResolver.getCatalog();
        SchemaConstants.initResolver(resolver);
    }

    public static CatalogResolver getEntityResolver() {
        if (!resolverInitialized) {
            SchemaConstants.initResolver(catalogResolver.getCatalog());
        }
        return catalogResolver;
    }

    private static void initResolver(Catalog resolver) {
        try {
            Enumeration<URL> catalogs = Thread.currentThread().getContextClassLoader().getResources("META-INF/catalog.xml");
            while (catalogs.hasMoreElements()) {
                URL catalogURL = catalogs.nextElement();
                resolver.parseCatalog(catalogURL);
            }
            resolverInitialized = true;
        }
        catch (IOException ex) {
            resolverInitialized = false;
            LOGGER.error("Unknown error occured: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

