/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync.action;

import com.evolveum.midpoint.audit.api.AuditEventRecord;
import com.evolveum.midpoint.audit.api.AuditEventStage;
import com.evolveum.midpoint.audit.api.AuditEventType;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.sync.Action;
import com.evolveum.midpoint.model.sync.SynchronizationException;
import com.evolveum.midpoint.model.sync.action.BaseAction;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class SynchronizeAction
extends BaseAction {
    private static final Trace LOGGER = TraceManager.getTrace(SynchronizeAction.class);
    private final String actionName;

    public SynchronizeAction() {
        this(Action.ACTION_SYNCHRONIZE);
    }

    public SynchronizeAction(String actionName) {
        Validate.notEmpty((String)actionName, (String)"Action name must not be null or empty.");
        this.actionName = actionName;
    }

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescription change, SynchronizationSituationType situation, AuditEventRecord auditRecord, Task task, OperationResult result) throws SynchronizationException {
        super.executeChanges(userOid, change, situation, auditRecord, task, result);
        Class<? extends ResourceObjectShadowType> clazz = this.getClassFromChange(change);
        if (!AccountShadowType.class.isAssignableFrom(clazz)) {
            throw new SynchronizationException("Couldn't synchronize shadow of type '" + clazz + "', only '" + AccountShadowType.class.getName() + "' is supported.");
        }
        OperationResult subResult = result.createSubresult(this.actionName);
        if (StringUtils.isEmpty((String)userOid)) {
            String message = "Can't synchronize, user oid is empty or null.";
            subResult.computeStatus(message);
            throw new SynchronizationException(message);
        }
        UserType userType = this.getUser(userOid, subResult);
        if (userType == null) {
            String message = "Can't find user with oid '" + userOid + "'.";
            subResult.computeStatus(message);
            throw new SynchronizationException(message);
        }
        SyncContext context = null;
        try {
            context = this.createSyncContext(userType, (ResourceType)change.getResource().asObjectable());
            AccountSyncContext accountContext = this.createAccountSyncContext(context, change, null, null);
            if (accountContext == null) {
                LOGGER.warn("Couldn't create account sync context, skipping action for this change.");
                String string = userOid;
                return string;
            }
        }
        catch (Exception ex) {
            throw new SynchronizationException("Couldn't update account sync context in modify user action.", ex);
        }
        finally {
            subResult.recomputeStatus("Couldn't update account sync context in modify user action.");
        }
        try {
            this.synchronizeUser(context, subResult);
            this.executeChanges(context, subResult);
        }
        finally {
            subResult.recomputeStatus();
            result.recomputeStatus();
            auditRecord.clearTimestamp();
            auditRecord.setEventType(AuditEventType.MODIFY_OBJECT);
            auditRecord.setEventStage(AuditEventStage.EXECUTION);
            auditRecord.setResult(result);
            auditRecord.clearDeltas();
            auditRecord.addDeltas(context.getAllChanges());
            this.getAuditService().audit(auditRecord, task);
        }
        return userOid;
    }

    private Class<? extends ResourceObjectShadowType> getClassFromChange(ResourceObjectShadowChangeDescription change) {
        if (change.getObjectDelta() != null) {
            return change.getObjectDelta().getObjectTypeClass();
        }
        if (change.getCurrentShadow() != null) {
            return change.getCurrentShadow().getCompileTimeClass();
        }
        return change.getOldShadow().getCompileTimeClass();
    }

    private SyncContext createSyncContext(UserType user, ResourceType resource) throws SchemaException {
        LOGGER.debug("Creating sync context.");
        this.getPrismContext().getSchemaRegistry().findObjectDefinitionByType(SchemaConstants.I_USER_TYPE);
        SyncContext context = new SyncContext(this.getPrismContext());
        PrismObject oldUser = user.asPrismObject();
        context.setUserOld((PrismObject<UserType>)oldUser);
        context.rememberResource(resource);
        return context;
    }
}

