/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync.action;

import com.evolveum.midpoint.audit.api.AuditEventRecord;
import com.evolveum.midpoint.audit.api.AuditEventStage;
import com.evolveum.midpoint.audit.api.AuditEventType;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.sync.Action;
import com.evolveum.midpoint.model.sync.SynchronizationException;
import com.evolveum.midpoint.model.sync.action.BaseAction;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserTemplateType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class AddUserAction
extends BaseAction {
    private static final Trace LOGGER = TraceManager.getTrace(AddUserAction.class);

    /*
     * Unable to fully structure code
     */
    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescription change, SynchronizationSituationType situation, AuditEventRecord auditRecord, Task task, OperationResult result) throws SynchronizationException {
        block12: {
            super.executeChanges(userOid, change, situation, auditRecord, task, result);
            subResult = result.createSubresult(Action.ACTION_ADD_USER);
            context = new SyncContext(this.getPrismContext());
            try {
                user = this.getUser(userOid, subResult);
                if (user != null) ** GOTO lbl26
                context.setUserTemplate(this.getUserTemplate(subResult));
                if (context.getUserTemplate() != null) {
                    AddUserAction.LOGGER.debug("Using user template {}", (Object)context.getUserTemplate().getName());
                } else {
                    AddUserAction.LOGGER.debug("User template not defined.");
                }
                accountContext = this.createAccountSyncContext(context, change, PolicyDecision.KEEP, null);
                if (accountContext == null) {
                    AddUserAction.LOGGER.warn("Couldn't create account sync context, skipping action for this change.");
                    var15_13 = userOid;
                    return var15_13;
                }
                try {
                    userDefinition = this.getPrismContext().getSchemaRegistry().findObjectDefinitionByType(SchemaConstants.I_USER_TYPE);
                    oldUser = userDefinition.instantiate(SchemaConstants.I_USER_TYPE);
                    delta = new ObjectDelta(UserType.class, ChangeType.ADD);
                    delta.setObjectToAdd(oldUser);
                    context.setUserSecondaryDelta((ObjectDelta<UserType>)delta);
                    context.rememberResource((ResourceType)change.getResource().asObjectable());
                    break block12;
lbl26:
                    // 1 sources

                    AddUserAction.LOGGER.debug("User with oid {} already exists, skipping create.", new Object[]{user.getOid()});
                }
                catch (Exception ex) {
                    shadowAfterChange = this.getAccountShadowFromChange(change);
                    LoggingUtils.logException((Trace)AddUserAction.LOGGER, (String)"Couldn't perform Add User Action for shadow '{}', oid '{}'.", (Throwable)ex, (Object[])new Object[]{shadowAfterChange.getName(), shadowAfterChange.getOid()});
                    subResult.recordFatalError("Couldn't perform Add User Action for shadow '" + shadowAfterChange.getName() + "', oid '" + shadowAfterChange.getOid() + "'.", (Throwable)ex);
                    throw new SynchronizationException(ex.getMessage(), ex);
                }
            }
            finally {
                subResult.recomputeStatus();
            }
        }
        try {
            this.synchronizeUser(context, subResult);
            this.executeChanges(context, subResult);
            userOid = context.getUserSecondaryDelta().getOid();
        }
        finally {
            subResult.recomputeStatus();
            result.recomputeStatus();
            auditRecord.clearTimestamp();
            auditRecord.setEventType(AuditEventType.ADD_OBJECT);
            auditRecord.setEventStage(AuditEventStage.EXECUTION);
            auditRecord.setResult(result);
            auditRecord.clearDeltas();
            auditRecord.addDeltas(context.getAllChanges());
            this.getAuditService().audit(auditRecord, task);
        }
        return userOid;
    }

    private UserTemplateType getUserTemplate(OperationResult result) throws ObjectNotFoundException, SchemaException {
        Element templateRef = this.getParameterElement(new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "userTemplateRef"));
        if (templateRef == null) {
            return null;
        }
        String oid = templateRef.getAttribute("oid");
        if (StringUtils.isEmpty((String)oid)) {
            return null;
        }
        return this.getModel().getObjectResolver().getObject(UserTemplateType.class, oid, result);
    }
}

