/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.controller;

import com.evolveum.midpoint.common.Utils;
import com.evolveum.midpoint.common.crypto.EncryptionException;
import com.evolveum.midpoint.common.crypto.Protector;
import com.evolveum.midpoint.util.RandomString;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ActivationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordType;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ModelUtils {
    private static final Trace LOGGER = TraceManager.getTrace(ModelUtils.class);

    public static void validatePaging(PagingType paging) {
        if (paging == null) {
            return;
        }
        if (paging.getMaxSize() != null && paging.getMaxSize().longValue() < 0L) {
            throw new IllegalArgumentException("Paging max size must be more than 0.");
        }
        if (paging.getOffset() != null && paging.getOffset().longValue() < 0L) {
            throw new IllegalArgumentException("Paging offset index must be more than 0.");
        }
    }

    public static void generatePassword(AccountShadowType account, int length, Protector protector) throws EncryptionException {
        Validate.notNull((Object)account, (String)"Account shadow must not be null.");
        Validate.isTrue((length > 0 ? 1 : 0) != 0, (String)"Password length must be more than zero.");
        Validate.notNull((Object)protector, (String)"Protector instance must not be null.");
        String pwd = "";
        if (length > 0) {
            pwd = new RandomString(length).nextString();
        }
        PasswordType password = ModelUtils.getPassword(account);
        password.setProtectedString(protector.encryptString(pwd));
    }

    public static PasswordType getPassword(AccountShadowType account) {
        PasswordType password;
        Validate.notNull((Object)account, (String)"Account shadow must not be null.");
        CredentialsType credentials = account.getCredentials();
        ObjectFactory of = new ObjectFactory();
        if (credentials == null) {
            credentials = of.createCredentialsType();
            account.setCredentials(credentials);
        }
        if ((password = credentials.getPassword()) == null) {
            password = of.createPasswordType();
            credentials.setPassword(password);
        }
        return password;
    }

    public static PropertyReferenceListType createPropertyReferenceListType(String ... properties) {
        PropertyReferenceListType list = new PropertyReferenceListType();
        if (properties == null) {
            return list;
        }
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (StringUtils.isEmpty((String)property)) {
                LOGGER.warn("Trying to add empty or null property to PropertyReferenceListType, skipping.");
            } else {
                list.getProperty().add(Utils.fillPropertyReference((String)property));
            }
            ++n2;
        }
        return list;
    }

    public static boolean isActivationEnabled(ActivationType activation) {
        GregorianCalendar calendar;
        if (activation == null) {
            return true;
        }
        if (activation.isEnabled() != null) {
            return activation.isEnabled();
        }
        Calendar actual = Calendar.getInstance();
        if (activation.getValidFrom() != null && actual.before(calendar = activation.getValidFrom().toGregorianCalendar())) {
            return false;
        }
        return activation.getValidTo() == null || !actual.after(calendar = activation.getValidTo().toGregorianCalendar());
    }
}

