/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.xml;

import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.repo.api.RepositoryServiceFactory;
import com.evolveum.midpoint.repo.api.RepositoryServiceFactoryException;
import com.evolveum.midpoint.repo.xml.XmlRepositoryService;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.basex.BaseXServer;
import org.basex.core.BaseXException;
import org.basex.server.ClientQuery;
import org.basex.server.ClientSession;

public class XmlRepositoryServiceFactory
implements RepositoryServiceFactory {
    private static final Trace LOGGER = TraceManager.getTrace(XmlRepositoryServiceFactory.class);
    private boolean dropDatabase = false;
    private boolean runServer = true;
    private boolean embedded = true;
    private boolean shutdown = false;
    private boolean debug = false;
    private String initialDataPath = "";
    private String host = "localhost";
    private int port = 1984;
    private int eventPort = 1985;
    private String username = "admin";
    private String password = "admin";
    private String databaseName = "midPoint";
    private String serverPath;
    private BaseXServer server;

    public void init(Configuration config) throws RepositoryServiceFactoryException {
        this.applyConfiguration(config);
        this.startServer();
        this.recreateDatabase();
    }

    private void startServer() throws RepositoryServiceFactoryException {
        if (this.runServer) {
            LOGGER.trace("Starting BaseX Server on {}:{}", (Object)this.host, (Object)this.port);
            if (StringUtils.isNotEmpty((String)this.serverPath)) {
                LOGGER.debug("BaseX Server base path: {}", (Object)this.serverPath);
            } else {
                LOGGER.debug("BaseX Server base not set, using default value");
            }
            StringBuffer commands = new StringBuffer();
            if (StringUtils.isNotEmpty((String)this.serverPath)) {
                if (StringUtils.equals((String)"memory", (String)this.serverPath)) {
                    commands.append("-cset mainmem true;info");
                } else {
                    commands.append("-cset dbpath ").append(this.serverPath).append(";info");
                }
            }
            String debugging = "";
            if (this.debug) {
                debugging = "-d";
            }
            if (this.embedded) {
                this.checkPort(this.port);
                this.checkPort(this.eventPort);
                this.server = new BaseXServer(new String[]{"-p" + this.port, "-e" + this.eventPort, "-D", "-s", debugging, commands.toString()});
            } else {
                this.server = new BaseXServer(new String[]{"-p" + this.port, "-e" + this.eventPort, "-s", debugging, commands.toString()});
            }
            LOGGER.trace("BaseX Server started");
        }
    }

    private void recreateDatabase() throws RepositoryServiceFactoryException {
        boolean newDb = false;
        ClientSession session = null;
        try {
            try {
                block16: {
                    LOGGER.trace("Creating BaseX client Session");
                    session = new ClientSession(this.host, this.port, this.username, this.password);
                    LOGGER.trace("BaseX client Session created");
                    if (this.dropDatabase) {
                        session.execute("DROP DATABASE " + this.databaseName);
                    }
                    try {
                        session.execute("OPEN " + this.databaseName);
                    }
                    catch (BaseXException ex) {
                        if (!("Database '" + this.databaseName + "' was not found.").equals(ex.getMessage())) break block16;
                        newDb = true;
                    }
                }
                if (newDb) {
                    session.execute("CREATE DB " + this.databaseName + " " + this.initialDataPath);
                    if (StringUtils.isEmpty((String)this.initialDataPath)) {
                        String serializedObject = "<c:objects xmlns:c=\"http://midpoint.evolveum.com/xml/ns/public/common/common-2\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"/>";
                        StringBuilder query = new StringBuilder().append("declare namespace c='http://midpoint.evolveum.com/xml/ns/public/common/common-2';\n").append("let $x := ").append(serializedObject).append("\n").append("return insert node $x into doc(\"").append(this.databaseName).append("\")");
                        ClientQuery cq = session.query(query.toString());
                        cq.execute();
                    }
                }
            }
            catch (BaseXException e) {
                throw new RepositoryServiceFactoryException("XML DB Exception during DB initialization", (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryServiceFactoryException("XML DB IO Exception during DB initialization", (Throwable)e);
            }
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IOException e) {
                    throw new RepositoryServiceFactoryException("BaseX Client Session IO Exception during DB initialization", (Throwable)e);
                }
            }
        }
    }

    private void applyConfiguration(Configuration config) {
        if (config == null) {
            throw new IllegalStateException("Configuration has to be injected prior the initialization.");
        }
        this.setDatabaseName(config.getString("databaseName", this.databaseName));
        this.setDropDatabase(config.getBoolean("dropDatabase", this.dropDatabase));
        this.setEmbedded(config.getBoolean("embedded", this.embedded));
        this.setHost(config.getString("host", this.host));
        this.setInitialDataPath(config.getString("initialDataPath", this.initialDataPath));
        this.setPassword(config.getString("password", this.password));
        this.setPort(config.getInt("port", this.port));
        this.setEventPort(config.getInt("eventPort", this.eventPort));
        this.setRunServer(config.getBoolean("runServer", this.runServer));
        this.setServerPath(config.getString("serverPath", this.serverPath));
        this.setShutdown(config.getBoolean("shutdown", this.shutdown));
        this.setUsername(config.getString("username", this.username));
        this.setDebug(config.getBoolean("debug", this.debug));
    }

    public void destroy() {
        if (this.shutdown && this.server != null) {
            LOGGER.info("Basex server committing to shutdown.");
            this.server.stop();
            LOGGER.info("Basex server is down.");
        }
        LOGGER.info("Destroying BaseX server service.");
    }

    public void destroyService(RepositoryService service) throws RepositoryServiceFactoryException {
        if (!(service instanceof XmlRepositoryService)) {
            throw new RepositoryServiceFactoryException("Service '" + service.getClass().getName() + "' is not instance of '" + XmlRepositoryService.class.getName() + "'.");
        }
        XmlRepositoryService xmlService = (XmlRepositoryService)service;
        xmlService.close();
    }

    public RepositoryService getRepositoryService() throws RepositoryServiceFactoryException {
        XmlRepositoryService service = new XmlRepositoryService(this.host, this.port, this.username, this.password, this.databaseName);
        service.init();
        return service;
    }

    public boolean isRunServer() {
        return this.runServer;
    }

    public void setRunServer(boolean runServer) {
        this.runServer = runServer;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public String getInitialDataPath() {
        return this.initialDataPath;
    }

    public void setInitialDataPath(String initialDataPath) {
        this.initialDataPath = initialDataPath;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getEventPort() {
        return this.eventPort;
    }

    public void setEventPort(int eventPort) {
        this.eventPort = eventPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean isDropDatabase() {
        return this.dropDatabase;
    }

    public void setDropDatabase(boolean dropDatabase) {
        this.dropDatabase = dropDatabase;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void checkPort(int port) throws RepositoryServiceFactoryException {
        ServerSocket ss = null;
        try {
            try {
                ss = new ServerSocket();
                ss.setReuseAddress(true);
                InetSocketAddress endpoint = new InetSocketAddress(port);
                ss.bind(endpoint);
            }
            catch (IOException e) {
                throw new RepositoryServiceFactoryException("BaseX port (" + port + ") already in use.", (Throwable)e);
            }
        }
        finally {
            try {
                if (ss != null) {
                    ss.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Reported IO error, while closing ServerSocket used to test availability of port for BaseX Server", (Throwable)e);
            }
        }
    }
}

