if (!window.ice) {
    window.ice = new Object;
}
if (!window.ice.icefaces) {
    (function(namespace) {
        namespace.icefaces = true;
        namespace.configuration = new Object();
        namespace.disableDefaultErrorPopups = false;
        var sessionExpiryListeners = [];
        namespace.onSessionExpiry = function(callback) {
            append(sessionExpiryListeners, callback);
        };
        var networkErrorListeners = [];
        namespace.onNetworkError = function(callback) {
            append(networkErrorListeners, callback);
        };
        var serverErrorListeners = [];
        namespace.onServerError = function(callback) {
            append(serverErrorListeners, callback);
        };
        var viewDisposedListeners = [];
        namespace.onViewDisposal = function(callback) {
            append(viewDisposedListeners, callback);
        };
        var beforeSubmitListeners = [];
        namespace.onBeforeSubmit = function(callback) {
            append(beforeSubmitListeners, callback);
        };
        var beforeUpdateListeners = [];
        namespace.onBeforeUpdate = function(callback) {
            append(beforeUpdateListeners, callback);
        };
        var afterUpdateListeners = [];
        namespace.onAfterUpdate = function(callback) {
            append(afterUpdateListeners, callback);
        };
        var elementRemoveListeners = [];
        namespace.onElementRemove = function(id, callback) {
            append(elementRemoveListeners, Cell(id, callback));
        };
        function configurationOf(element) {
            return detect(parents(element),
                    function(e) {
                        return e.configuration;
                    }).configuration;
        }
        function deltaSubmit(element) {
            return configurationOf(element).deltaSubmit;
        }
        function viewIDOf(element) {
            return configurationOf(element).viewID;
        }
        function formOf(element) {
            return toLowerCase(element.nodeName) == 'form' ? element : enclosingForm(element);
        }
        function lookupElementById(id) {
            var e;
            if (id == 'javax.faces.ViewRoot') {
                e = document.documentElement;
            } else if (id == 'javax.faces.ViewBody') {
                e = document.body;
            } else {
                try {
                    e = document.getElementById(id);
                } catch (e) {
                }
            }
            return e;
        }
function apply(fun, arguments) {
    return fun.apply(fun, arguments);
}
function withArguments() {
    var args = arguments;
    return function(fun) {
        apply(fun, args);
    };
}
function let(definition) {
    return function() {
        return apply(definition, arguments);
    };
}
function curry() {
    var args = arguments;
    return function() {
        var curriedArguments = [];
        var fun = args[0];
        for (var i = 1; i < args.length; i++) curriedArguments.push(args[i]);
        for (var j = 0; j < arguments.length; j++) curriedArguments.push(arguments[j]);
        return apply(fun, curriedArguments);
    };
}
function $witch(tests, defaultRun) {
    return function(val) {
        var args = arguments;
        var conditions = [];
        var runs = [];
        tests(function(condition, run) {
            conditions.push(condition);
            runs.push(run);
        });
        var size = conditions.length;
        for (var i = 0; i < size; i++) {
            if (apply(conditions[i], args)) {
                return apply(runs[i], args);
            }
        }
        if (defaultRun) apply(defaultRun, args);
    };
}
function identity(arg) {
    return arg;
}
function negate(b) {
    return !b;
}
function greater(a, b) {
    return a > b;
}
function less(a, b) {
    return a < b;
}
function not(a) {
    return !a;
}
function multiply(a, b) {
    return a * b;
}
function plus(a, b) {
    return a + b;
}
function max(a, b) {
    return a > b ? a : b;
}
function increment(value, step) {
    return value + (step ? step : 1);
}
function decrement(value, step) {
    return value - (step ? step : 1);
}
function any() {
    return true;
}
function none() {
    return false;
}
function noop() {
}
function isArray(a) {
    return a && !!a.push;
}
function isString(s) {
    return typeof s == 'string';
}
function isNumber(s) {
    return typeof s == 'number';
}
function isBoolean(s) {
    return typeof s == 'boolean';
}
function isIndexed(s) {
    return typeof s.length == 'number';
}
function isObject(o) {
    return o.instanceTag == o;
}
var uid = (function() {
    var id = 0;
    return function() {
        return id++;
    };
})();
function operationNotSupported() {
    throw 'operation not supported';
}
function operator(defaultOperation) {
    return function() {
        var args = arguments;
        var instance = arguments[0];
        if (instance.instanceTag && instance.instanceTag == instance) {
            var method = instance(arguments.callee);
            if (method) {
                return method.apply(method, args);
            } else {
                operationNotSupported();
            }
        } else {
            return defaultOperation ? defaultOperation.apply(defaultOperation, args) : operationNotSupported();
        }
    };
}
var asString = operator(String);
var asNumber = operator(Number);
var hash = operator(function(o) {
    var s;
    if (isString(o)) {
        s = o;
    } else if (isNumber(o)) {
        return Math.abs(Math.round(o));
    } else {
        s = o.toString();
    }
    var h = 0;
    for (var i = 0, l = s.length; i < l; i++) {
        var c = parseInt(s[i], 36);
        if (!isNaN(c)) {
            h = c + (h << 6) + (h << 16) - h;
        }
    }
    return Math.abs(h);
});
var equal = operator(function(a, b) {
    return a == b;
});
function object(definition) {
    var operators = [];
    var methods = [];
    var unknown = null;
    var id = uid();
    operators.push(hash);
    methods.push(function(self) {
        return id;
    });
    operators.push(equal);
    methods.push(function(self, other) {
        return self == other;
    });
    operators.push(asString);
    methods.push(function(self) {
        return 'Object:' + id.toString(16);
    });
    definition(function(operator, method) {
        var size = operators.length;
        for (var i = 0; i < size; i++) {
            if (operators[i] == operator) {
                methods[i] = method;
                return;
            }
        }
        operators.push(operator);
        methods.push(method);
    }, function(method) {
        unknown = method;
    });
    function self(operator) {
        var size = operators.length;
        for (var i = 0; i < size; i++) {
            if (operators[i] == operator) {
                return methods[i];
            }
        }
        return unknown;
    }
    return self.instanceTag = self;
}
function objectWithAncestors() {
    var definition = arguments[0];
    var args = arguments;
    var o = object(definition);
    function self(operator) {
        var method = o(operator);
        if (method) {
            return method;
        } else {
            var size = args.length;
            for (var i = 1; i < size; i++) {
                var ancestor = args[i];
                var overriddenMethod = ancestor(operator);
                if (overriddenMethod) {
                    return overriddenMethod;
                }
            }
            return null;
        }
    }
    return self.instanceTag = self;
}
var indexOf = operator($witch(function(condition) {
    condition(isString, function(items, item) {
        return items.indexOf(item);
    });
    condition(isArray, function(items, item) {
        for (var i = 0, size = items.length; i < size; i++) {
            if (items[i] == item) {
                return i;
            }
        }
        return -1;
    });
    condition(any, operationNotSupported);
}));
var concatenate = operator(function(items, other) {
    return items.concat(other);
});
var append = operator($witch(function(condition) {
    condition(isArray, function(items, item) {
        items.push(item);
        return items;
    });
    condition(any, operationNotSupported);
}));
var insert = operator($witch(function(condition) {
    condition(isArray, function(items, item) {
        items.unshift(item);
        return items;
    });
    condition(any, operationNotSupported);
}));
var each = operator(function(items, iterator) {
    var size = items.length;
    for (var i = 0; i < size; i++) iterator(items[i], i);
});
var inject = operator(function(items, initialValue, injector) {
    var tally = initialValue;
    var size = items.length;
    for (var i = 0; i < size; i++) {
        tally = injector(tally, items[i]);
    }
    return tally;
});
var select = operator($witch(function(condition) {
    condition(isArray, function(items, selector) {
        return inject(items, [], function(tally, item) {
            return selector(item) ? append(tally, item) : tally;
        });
    });
    condition(isString, function(items, selector) {
        return inject(items, '', function(tally, item) {
            return selector(item) ? concatenate(tally, item) : tally;
        });
    });
    condition(isIndexed, function(items, selector) {
        return Stream(function(cellConstructor) {
            function selectingStream(start, end) {
                if (start > end) return null;
                var item = items[start];
                return selector(item) ?
                       function() {
                           return cellConstructor(item, selectingStream(start + 1, end));
                       } : selectingStream(start + 1, end);
            }
            return selectingStream(0, items.length - 1);
        });
    });
}));
var detect = operator(function(items, iterator, notDetectedThunk) {
    var size = items.length;
    for (var i = 0; i < size; i++) {
        var element = items[i];
        if (iterator(element, i)) {
            return element;
        }
    }
    return notDetectedThunk ? notDetectedThunk(items) : null;
});
var contains = operator($witch(function(condition) {
    condition(isString, function(items, item) {
        return items.indexOf(item) > -1;
    });
    condition(isArray, function(items, item) {
        var size = items.length;
        for (var i = 0; i < size; i++) {
            if (items[i] == item) {
                return true;
            }
        }
        return false;
    });
    condition(any, operationNotSupported);
}));
var size = operator(function(items) {
    return items.length;
});
var isEmpty = operator(function(items) {
    return items.length == 0;
});
var notEmpty = function(items) {
    return !isEmpty(items);
};
var collect = operator($witch(function(condition) {
    condition(isString, function(items, collector) {
        return inject(items, '', function(tally, item) {
            return concatenate(tally, collector(item));
        });
    });
    condition(isArray, function(items, collector) {
        return inject(items, [], function(tally, item) {
            return append(tally, collector(item));
        });
    });
    condition(isIndexed, function(items, collector) {
        return Stream(function(cellConstructor) {
            function collectingStream(start, end) {
                if (start > end) return null;
                return function() {
                    return cellConstructor(collector(items[start], start), collectingStream(start + 1, end));
                };
            }
            return collectingStream(0, items.length - 1);
        });
    });
}));
var sort = operator(function(items, sorter) {
    return copy(items).sort(function(a, b) {
        return sorter(a, b) ? -1 : 1;
    });
});
var reverse = operator(function(items) {
    return copy(items).reverse();
});
var copy = operator(function(items) {
    return inject(items, [], curry(append));
});
var join = operator(function(items, separator) {
    return items.join(separator);
});
var inspect = operator();
var reject = function(items, rejector) {
    return select(items, function(i) {
        return !rejector(i);
    });
};
var intersect = operator(function(items, other) {
    return select(items, curry(contains, other));
});
var complement = operator(function(items, other) {
    return reject(items, curry(contains, other));
});
var broadcast = function(items, args) {
    args = args || [];
    each(items, function(i) {
        apply(i, args);
    });
};
var broadcaster = function(items) {
    return function() {
        var args = arguments;
        each(items, function(i) {
            apply(i, args);
        });
    };
};
var asArray = function(items) {
    return inject(items, [], append);
};
var asSet = function(items) {
    return inject(items, [], function(set, item) {
        if (not(contains(set, item))) {
            append(set, item);
        }
        return set;
    });
};
var key = operator();
var value = operator();
function Cell(k, v) {
    return object(function(method) {
        method(key, function(self) {
            return k;
        });
        method(value, function(self) {
            return v;
        });
        method(asString, function(self) {
            return 'Cell[' + asString(k) + ': ' + asString(v) + ']';
        });
    });
}
function Stream(streamDefinition) {
    var stream = streamDefinition(Cell);
    return object(function(method) {
        method(each, function(self, iterator) {
            var cursor = stream;
            while (cursor != null) {
                var cell = cursor();
                iterator(key(cell));
                cursor = value(cell);
            }
        });
        method(inject, function(self, initialValue, injector) {
            var tally = initialValue;
            var cursor = stream;
            while (cursor != null) {
                var cell = cursor();
                tally = injector(tally, key(cell));
                cursor = value(cell);
            }
            return tally;
        });
        method(join, function(self, separator) {
            var tally;
            var cursor = stream;
            while (cursor != null) {
                var cell = cursor();
                var itemAsString = asString(key(cell));
                tally = tally ? tally + separator + itemAsString : itemAsString;
                cursor = value(cell);
            }
            return tally;
        });
        method(collect, function(self, collector) {
            return Stream(function(cellConstructor) {
                function collectingStream(stream) {
                    if (!stream) return null;
                    var cell = stream();
                    return function() {
                        return cellConstructor(collector(key(cell)), collectingStream(value(cell)));
                    };
                }
                return collectingStream(stream);
            });
        });
        method(contains, function(self, item) {
            var cursor = stream;
            while (cursor != null) {
                var cell = cursor();
                if (item == key(cell)) return true;
                cursor = value(cell);
            }
            return false;
        });
        method(size, function(self) {
            var cursor = stream;
            var i = 0;
            while (cursor != null) {
                i++;
                cursor = value(cursor());
            }
            return i;
        });
        method(select, function(self, selector) {
            return Stream(function(cellConstructor) {
                function select(stream) {
                    if (!stream) return null;
                    var cell = stream();
                    var k = key(cell);
                    var v = value(cell);
                    return selector(k) ? function() {
                        return cellConstructor(k, select(v));
                    } : select(v);
                }
                return select(stream);
            });
        });
        method(detect, function(self, detector, notDetectedThunk) {
            var cursor = stream;
            var result;
            while (cursor != null) {
                var cell = cursor();
                var k = key(cell);
                if (detector(k)) {
                    result = k;
                    break;
                }
                cursor = value(cell);
            }
            if (result) {
                return result;
            } else {
                return notDetectedThunk ? notDetectedThunk(self) : null;
            }
        });
        method(isEmpty, function(self) {
            return stream == null;
        });
        method(copy, function(self) {
            return Stream(streamDefinition);
        });
        method(asString, function(self) {
            return 'Stream[' + join(self, ', ') + ']';
        });
    });
}
var at = operator();
var putAt = operator();
var removeAt = operator();
var HashTable;
var HashSet;
(function() {
    var removeInArray = Array.prototype.splice ? function(array, index) {
        array.splice(index, 1);
    } : function(array, index) {
        if (index == array.length - 1) {
            array.length = index;
        } else {
            var rightSlice = array.slice(index + 1);
            array.length = index;
            for (var i = 0, l = rightSlice.length; i < l; ++i) {
                array[index + i] = rightSlice[i];
            }
        }
    };
    function atPrimitive(buckets, bucketCount, k, notFoundThunk) {
        var index = hash(k) % bucketCount;
        var bucket = buckets[index];
        if (bucket) {
            for (var i = 0, l = bucket.length; i < l; i++) {
                var entry = bucket[i];
                if (equal(entry.key, k)) {
                    return entry.value;
                }
            }
            if (notFoundThunk) notFoundThunk();
            return null;
        } else {
            if (notFoundThunk) notFoundThunk();
            return null;
        }
    }
    function putAtPrimitive(buckets, bucketCount, k, v) {
        var index = hash(k) % bucketCount;
        var bucket = buckets[index];
        if (bucket) {
            for (var i = 0, l = bucket.length; i < l; i++) {
                var entry = bucket[i];
                if (equal(entry.key, k)) {
                    var oldValue = entry.value;
                    entry.value = v;
                    return oldValue;
                }
            }
            bucket.push({ key:k, value: v });
            return null;
        } else {
            bucket = [
                {
                    key:k,
                    value: v
                }
            ];
            buckets[index] = bucket;
            return null;
        }
    }
    function removeAtPrimitive(buckets, bucketCount, k) {
        var index = hash(k) % bucketCount;
        var bucket = buckets[index];
        if (bucket) {
            for (var i = 0, l = bucket.length; i < l; i++) {
                var entry = bucket[i];
                if (equal(entry.key, k)) {
                    removeInArray(bucket, i);
                    if (bucket.length == 0) {
                        removeInArray(buckets, index);
                    }
                    return entry.value;
                }
            }
            return null;
        } else {
            return null;
        }
    }
    function injectPrimitive(buckets, initialValue, iterator) {
        var tally = initialValue;
        for (var i = 0, lbs = buckets.length; i < lbs; i++) {
            var bucket = buckets[i];
            if (bucket) {
                for (var j = 0, lb = bucket.length; j < lb; j++) {
                    var entry = bucket[j];
                    if (entry) {
                        tally = iterator(tally, entry.key, entry.value);
                    }
                }
            }
        }
        return tally;
    }
    var internalBuckets = operator();
    var internalBucketCount = operator();
    HashTable = function() {
        var buckets = [];
        var bucketCount = 5000;
        return object(function(method) {
            method(at, function(self, k, notFoundThunk) {
                return atPrimitive(buckets, bucketCount, k, notFoundThunk);
            });
            method(putAt, function(self, k, v) {
                return putAtPrimitive(buckets, bucketCount, k, v);
            });
            method(removeAt, function(self, k) {
                return removeAtPrimitive(buckets, bucketCount, k);
            });
            method(each, function(iterator) {
                injectPrimitive(buckets, null, function(tally, k, v) {
                    iterator(k, v);
                });
            });
        });
    };
    HashSet = function(list) {
        var buckets = [];
        var bucketCount = 5000;
        var present = new Object;
        if (list) {
            each(list, function(k) {
                putAtPrimitive(buckets, bucketCount, k, present);
            });
        }
        return object(function(method) {
            method(append, function(self, k) {
                putAtPrimitive(buckets, bucketCount, k, present);
            });
            method(each, function(self, iterator) {
                injectPrimitive(buckets, null, function(t, k, v) {
                    iterator(k);
                });
            });
            method(contains, function(self, k) {
                return !!atPrimitive(buckets, bucketCount, k);
            });
            method(complement, function(self, other) {
                var result = [];
                var c;
                try {
                    var othersInternalBuckets = internalBuckets(other);
                    var othersInternalBucketCount = internalBucketCount(other);
                    c = function(items, k) {
                        return !!atPrimitive(othersInternalBuckets, othersInternalBucketCount, k);
                    };
                } catch (e) {
                    c = contains;
                }
                return injectPrimitive(buckets, result, function(tally, k, v) {
                    if (!c(other, k)) {
                        result.push(k);
                    }
                    return tally;
                });
            });
            method(asString, function(self) {
                return 'HashSet[' + join(injectPrimitive(buckets, [], function(tally, k, v) {
                    tally.push(k);
                    return tally;
                }), ',') + ']';
            });
            method(internalBuckets, function(self) {
                return buckets;
            });
            method(internalBucketCount, function(self) {
                return bucketCount;
            });
        });
    };
})();
var indexOf = function(s, substring) {
    var index = s.indexOf(substring);
    if (index >= 0) {
        return index;
    } else {
        throw '"' + s + '" does not contain "' + substring + '"';
    }
};
var lastIndexOf = function(s, substring) {
    var index = s.lastIndexOf(substring);
    if (index >= 0) {
        return index;
    } else {
        throw 'string "' + s + '" does not contain "' + substring + '"';
    }
};
var startsWith = function(s, pattern) {
    return s.indexOf(pattern) == 0;
};
var endsWith = function(s, pattern) {
    return s.lastIndexOf(pattern) == s.length - pattern.length;
};
var containsSubstring = function(s, substring) {
    return s.indexOf(substring) >= 0;
};
var blank = function(s) {
    return /^\s*$/.test(s);
};
var split = function(s, separator) {
    return s.length == 0 ? [] : s.split(separator);
};
var replace = function(s, regex, replace) {
    return s.replace(regex, replace);
};
var toLowerCase = function(s) {
    return s.toLowerCase();
};
var toUpperCase = function(s) {
    return s.toUpperCase();
};
var substring = function(s, from, to) {
    return s.substring(from, to);
};
var trim = function(s) {
    s = s.replace(/^\s+/, '');
    for (var i = s.length - 1; i >= 0; i--) {
        if (/\S/.test(s.charAt(i))) {
            s = s.substring(0, i + 1);
            break;
        }
    }
    return s;
};
var asNumber = Number;
var asBoolean = function(s) {
    return 'true' == s || 'any' == s;
};
var asRegexp = function(s) {
    return new RegExp(s);
};
var run = operator();
var runOnce = operator();
var stop = operator();
function Delay(f, milliseconds) {
    return object(function(method) {
        var id = null;
        var canceled = false;
        method(run, function(self, times) {
            if (id || canceled) return;
            var call = times ? function() {
                try {
                    f();
                } finally {
                    if (--times < 1) stop(self);
                }
            } : f;
            id = setInterval(call, milliseconds);
            return self;
        });
        method(runOnce, function(self) {
            return run(self, 1);
        });
        method(stop, function(self) {
            if (id) {
                clearInterval(id);
                id = null;
            } else {
                canceled = true;
            }
        });
    });
}
function registerListener(eventType, obj, listener) {
    var previousListener = obj[eventType];
    if (previousListener) {
        obj[eventType] = function() {
            apply(previousListener, arguments);
            apply(listener, arguments);
        };
    } else {
        obj[eventType] = listener;
    }
}
var onLoad = curry(registerListener, 'onload');
var onUnload = curry(registerListener, 'onunload');
var onBeforeUnload = curry(registerListener, 'onbeforeunload');
var onResize = curry(registerListener, 'onresize');
var onKeyPress = curry(registerListener, 'onkeypress');
var onKeyUp = curry(registerListener, 'onkeyup');
window.width = function() {
    return window.innerWidth ? window.innerWidth : (document.documentElement && document.documentElement.clientWidth) ? document.documentElement.clientWidth : document.body.clientWidth;
};
window.height = function() {
    return window.innerHeight ? window.innerHeight : (document.documentElement && document.documentElement.clientHeight) ? document.documentElement.clientHeight : document.body.clientHeight;
};
        namespace.onLoad = curry(onLoad, window);
        namespace.onUnload = curry(onUnload, window);
var cancel = operator();
var cancelBubbling = operator();
var cancelDefaultAction = operator();
var isKeyEvent = operator();
var isMouseEvent = operator();
var capturedBy = operator();
var triggeredBy = operator();
var serializeEventOn = operator();
var serializePositionOn = operator();
var type = operator();
var yes = any;
var no = none;
function isIEEvent(event) {
    return event.srcElement && !event.preventDefault;
}
function Event(event, capturingElement) {
    return object(function(method) {
        method(cancel, function(self) {
            cancelBubbling(self);
            cancelDefaultAction(self);
        });
        method(isKeyEvent, no);
        method(isMouseEvent, no);
        method(type, function(self) {
            return event.type;
        });
        method(triggeredBy, function(self) {
            return capturingElement;
        });
        method(capturedBy, function(self) {
            return capturingElement;
        });
        method(serializeEventOn, function(self, query) {
            serializeElementOn(capturingElement, query);
            addNameValue(query, 'ice.event.target', identifier(triggeredBy(self)));
            addNameValue(query, 'ice.event.captured', identifier(capturedBy(self)));
            addNameValue(query, 'ice.event.type', 'on' + type(self));
        });
        method(serializeOn, curry(serializeEventOn));
    });
}
function IEEvent(event, capturingElement) {
    return objectWithAncestors(function(method) {
        method(triggeredBy, function(self) {
            return event.srcElement ? event.srcElement : null;
        });
        method(cancelBubbling, function(self) {
            event.cancelBubble = true;
        });
        method(cancelDefaultAction, function(self) {
            event.returnValue = false;
        });
        method(asString, function(self) {
            return 'IEEvent[' + type(self) + ']';
        });
    }, Event(event, capturingElement));
}
function NetscapeEvent(event, capturingElement) {
    return objectWithAncestors(function(method) {
        method(triggeredBy, function(self) {
            return event.target ? event.target : null;
        });
        method(cancelBubbling, function(self) {
            try {
                event.stopPropagation();
            } catch (e) {
            }
        });
        method(cancelDefaultAction, function(self) {
            try {
                event.preventDefault();
            } catch (e) {
            }
        });
        method(asString, function(self) {
            return 'NetscapeEvent[' + type(self) + ']';
        });
    }, Event(event, capturingElement));
}
var isAltPressed = operator();
var isCtrlPressed = operator();
var isShiftPressed = operator();
var isMetaPressed = operator();
var serializeKeyOrMouseEventOn = operator();
function KeyOrMouseEvent(event) {
    return object(function(method) {
        method(isAltPressed, function(self) {
            return event.altKey;
        });
        method(isCtrlPressed, function(self) {
            return event.ctrlKey;
        });
        method(isShiftPressed, function(self) {
            return event.shiftKey;
        });
        method(isMetaPressed, function(self) {
            return event.metaKey;
        });
        method(serializeKeyOrMouseEventOn, function(self, query) {
            addNameValue(query, 'ice.event.alt', isAltPressed(self));
            addNameValue(query, 'ice.event.ctrl', isCtrlPressed(self));
            addNameValue(query, 'ice.event.shift', isShiftPressed(self));
            addNameValue(query, 'ice.event.meta', isMetaPressed(self));
        });
    });
}
var isLeftButton = operator();
var isRightButton = operator();
var positionX = operator();
var positionY = operator();
var serializeMouseEventOn = operator();
function MouseEvent(event) {
    return objectWithAncestors(function(method) {
        method(isMouseEvent, yes);
        method(serializeMouseEventOn, function(self, query) {
            serializeKeyOrMouseEventOn(self, query);
            addNameValue(query, 'ice.event.x', positionX(self));
            addNameValue(query, 'ice.event.y', positionY(self));
            addNameValue(query, 'ice.event.left', isLeftButton(self));
            addNameValue(query, 'ice.event.right', isRightButton(self));
        });
    }, KeyOrMouseEvent(event));
}
function MouseEventTrait(method) {
    method(serializeOn, function(self, query) {
        serializeEventOn(self, query);
        serializeMouseEventOn(self, query);
    });
}
function IEMouseEvent(event, capturingElement) {
    return objectWithAncestors(function(method) {
        MouseEventTrait(method);
        method(positionX, function(self) {
            return event.clientX + (document.documentElement.scrollLeft || document.body.scrollLeft);
        });
        method(positionY, function(self) {
            return event.clientY + (document.documentElement.scrollTop || document.body.scrollTop);
        });
        method(isLeftButton, function(self) {
            return event.button == 1;
        });
        method(isRightButton, function(self) {
            return event.button == 2;
        });
        method(asString, function(self) {
            return 'IEMouseEvent[' + type(self) + ']';
        });
    }, MouseEvent(event), IEEvent(event, capturingElement));
}
function NetscapeMouseEvent(event, capturingElement) {
    return objectWithAncestors(function(method) {
        MouseEventTrait(method);
        method(positionX, function(self) {
            return event.pageX;
        });
        method(positionY, function(self) {
            return event.pageY;
        });
        method(isLeftButton, function(self) {
            return event.which == 1;
        });
        method(isRightButton, function(self) {
            return event.which == 2;
        });
        method(asString, function(self) {
            return 'NetscapeMouseEvent[' + type(self) + ']';
        });
    }, MouseEvent(event), NetscapeEvent(event, capturingElement));
}
var keyCharacter = operator();
var keyCode = operator();
var serializeKeyEventOn = operator();
function KeyEvent(event) {
    return objectWithAncestors(function(method) {
        method(isKeyEvent, yes);
        method(keyCharacter, function(self) {
            return String.fromCharCode(keyCode(self));
        });
        method(serializeKeyEventOn, function(self, query) {
            serializeKeyOrMouseEventOn(self, query);
            addNameValue(query, 'ice.event.keycode', keyCode(self));
        });
    }, KeyOrMouseEvent(event));
}
function KeyEventTrait(method) {
    method(serializeOn, function(self, query) {
        serializeEventOn(self, query);
        serializeKeyEventOn(self, query);
    });
}
function IEKeyEvent(event, capturingElement) {
    return objectWithAncestors(function(method) {
        KeyEventTrait(method);
        method(keyCode, function(self) {
            return event.keyCode;
        });
        method(asString, function(self) {
            return 'IEKeyEvent[' + type(self) + ']';
        });
    }, KeyEvent(event), IEEvent(event, capturingElement));
}
function NetscapeKeyEvent(event, capturingElement) {
    return objectWithAncestors(function(method) {
        KeyEventTrait(method);
        method(keyCode, function(self) {
            return event.which == 0 ? event.keyCode : event.which;
        });
        method(asString, function(self) {
            return 'NetscapeKeyEvent[' + type(self) + ']';
        });
    }, KeyEvent(event), NetscapeEvent(event, capturingElement));
}
function isEnterKey(event) {
    return keyCode(event) == 13;
}
function isEscKey(event) {
    return keyCode(event) == 27;
}
function UnknownEvent(capturingElement) {
    return objectWithAncestors(function(method) {
        method(cancelBubbling, noop);
        method(cancelDefaultAction, noop);
        method(type, function(self) {
            return 'unknown';
        });
        method(asString, function(self) {
            return 'UnkownEvent[]';
        });
    }, Event(null, capturingElement));
}
var MouseListenerNames = [ 'onclick', 'ondblclick', 'onmousedown', 'onmousemove', 'onmouseout', 'onmouseover', 'onmouseup' ];
var KeyListenerNames = [ 'onkeydown', 'onkeypress', 'onkeyup', 'onhelp' ];
function $event(e, element) {
    var capturedEvent = window.event || e;
    if (capturedEvent && capturedEvent.type) {
        var eventType = 'on' + capturedEvent.type;
        if (contains(KeyListenerNames, eventType)) {
            return isIEEvent(capturedEvent) ? IEKeyEvent(capturedEvent, element) : NetscapeKeyEvent(capturedEvent, element);
        } else if (contains(MouseListenerNames, eventType)) {
            return isIEEvent(capturedEvent) ? IEMouseEvent(capturedEvent, element) : NetscapeMouseEvent(capturedEvent, element);
        } else {
            return isIEEvent(capturedEvent) ? IEEvent(capturedEvent, element) : NetscapeEvent(capturedEvent, element);
        }
    } else {
        return UnknownEvent(element);
    }
}
function identifier(element) {
    return element.id;
}
function tag(element) {
    return toLowerCase(element.tagName);
}
function property(element, name) {
    return element[name];
}
function parents(element) {
    return Stream(function(cellConstructor) {
        function parentStream(e) {
            if (e == null || e == document) return null;
            return function() {
                return cellConstructor(e, parentStream(e.parentNode));
            };
        }
        return parentStream(element.parentNode);
    });
}
function enclosingForm(element) {
    return element.form || detect(parents(element), function(e) {
        return tag(e) == 'form';
    }, function() {
        throw 'cannot find enclosing form';
    });
}
function enclosingBridge(element) {
    return property(detect(parents(element), function(e) {
        return property(e, 'bridge') != null;
    }, function() {
        throw 'cannot find enclosing bridge';
    }), 'bridge');
}
function serializeElementOn(element, query) {
    var tagName = tag(element);
    switch (tagName) {
        case 'a':
            var name = element.name || element.id;
            if (name) addNameValue(query, name, name);
            break;
        case 'input':
            switch (element.type) {
                case 'image':
                case 'submit':
                case 'button': addNameValue(query, element.name, element.value); break;
            }
            break;
        case 'button':
            if (element.type == 'submit') addNameValue(query, element.name, element.value);
            break;
        default:
    }
}
function $elementWithID(id) {
    return document.getElementById(id);
}
var debug = operator();
var info = operator();
var warn = operator();
var error = operator();
var childLogger = operator();
var log = operator();
var threshold = operator();
var enable = operator();
var disable = operator();
var toggle = operator();
function Logger(category, handler) {
    return object(function(method) {
        each([debug, info, warn, error], function(priorityOperator) {
            method(priorityOperator, function(self, message, exception) {
                log(handler, priorityOperator, category, message, exception);
            });
        });
        method(childLogger, function(self, categoryName, newHandler) {
            return Logger(append(copy(category), categoryName), newHandler || handler);
        });
        method(asString, function(self) {
            return 'Logger[' + join(category, '.') + ']';
        });
    });
}
function ConsoleLogHandler(priority) {
    function formatOutput(category, message) {
        return join(['[', join(category, '.'), '] ', message], '');
    }
    var ieConsole = !window.console.debug;
    var debugPrimitive = ieConsole ?
            function(self, category, message, exception) {
                exception ? console.log(formatOutput(category, message), '\n', exception) : console.log(formatOutput(category, message));
            } :
            function(self, category, message, exception) {
                exception ? console.debug(formatOutput(category, message), exception) : console.debug(formatOutput(category, message));
            };
    var infoPrimitive = ieConsole ?
            function(self, category, message, exception) {
                exception ? console.info(formatOutput(category, message), '\n', exception) : console.info(formatOutput(category, message));
            } :
            function(self, category, message, exception) {
                exception ? console.info(formatOutput(category, message), exception) : console.info(formatOutput(category, message));
            };
    var warnPrimitive = ieConsole ?
            function(self, category, message, exception) {
                exception ? console.warn(formatOutput(category, message), '\n', exception) : console.warn(formatOutput(category, message));
            } :
            function(self, category, message, exception) {
                exception ? console.warn(formatOutput(category, message), exception) : console.warn(formatOutput(category, message));
            };
    var errorPrimitive = ieConsole ?
            function(self, category, message, exception) {
                exception ? console.error(formatOutput(category, message), '\n', exception) : console.error(formatOutput(category, message));
            } :
            function(self, category, message, exception) {
                exception ? console.error(formatOutput(category, message), exception) : console.error(formatOutput(category, message));
            };
    var handlers = [
        Cell(debug, object(function(method) {
            method(debug, debugPrimitive);
            method(info, infoPrimitive);
            method(warn, warnPrimitive);
            method(error, errorPrimitive);
        })),
        Cell(info, object(function(method) {
            method(debug, noop);
            method(info, infoPrimitive);
            method(warn, warnPrimitive);
            method(error, errorPrimitive);
        })),
        Cell(warn, object(function(method) {
            method(debug, noop);
            method(info, noop);
            method(warn, warnPrimitive);
            method(error, errorPrimitive);
        })),
        Cell(error, object(function(method) {
            method(debug, noop);
            method(info, noop);
            method(warn, noop);
            method(error, errorPrimitive);
        }))
    ];
    var handler;
    function selectHandler(p) {
        handler = value(detect(handlers, function(cell) {
            return key(cell) == p;
        }));
    }
    selectHandler(priority || debug);
    return object(function (method) {
        method(threshold, function(self, priority) {
            selectHandler(priority);
        });
        method(log, function(self, operation, category, message, exception) {
            operation(handler, category, message, exception);
        });
    });
}
var FirebugLogHandler = ConsoleLogHandler;
function WindowLogHandler(thresholdPriority, name) {
    var lineOptions = [25, 50, 100, 200, 400];
    var numberOfLines = lineOptions[3];
    var categoryMatcher = /.*/;
    var closeOnExit = true;
    var logContainer;
    var logEntry = noop;
    function trimLines() {
        var nodes = logContainer.childNodes;
        var trim = size(nodes) - numberOfLines;
        if (trim > 0) {
            each(copy(nodes), function(node, index) {
                if (index < trim) logContainer.removeChild(node);
            });
        }
    }
    function trimAllLines() {
        each(copy(logContainer.childNodes), function(node) {
            logContainer.removeChild(node);
        });
    }
    function toggle() {
        var disabled = logEntry == noop;
        logEntry = disabled ? displayEntry : noop;
        return !disabled;
    }
    function displayEntry(priorityName, colorName, category, message, exception) {
        var categoryName = join(category, '.');
        if (categoryMatcher.test(categoryName)) {
            var elementDocument = logContainer.ownerDocument;
            var timestamp = new Date();
            var completeMessage = join(['[', categoryName, '] : ', message, (exception ? join(['\n', exception.name, ' <', exception.message, '>'], '') : '')], '');
            each(split(completeMessage, '\n'), function(line) {
                if (/(\w+)/.test(line)) {
                    var eventNode = elementDocument.createElement('div');
                    eventNode.style.padding = '3px';
                    eventNode.style.color = colorName;
                    eventNode.setAttribute("title", timestamp + ' | ' + priorityName)
                    logContainer.appendChild(eventNode).appendChild(elementDocument.createTextNode(line));
                }
            });
            logContainer.scrollTop = logContainer.scrollHeight;
        }
        trimLines();
    }
    function showWindow() {
        var logWindow = window.open('', '_blank', 'scrollbars=1,width=800,height=680');
        try {
            var windowDocument = logWindow.document;
            var documentBody = windowDocument.body;
            each(copy(documentBody.childNodes), function(e) {
                windowDocument.body.removeChild(e);
            });
            documentBody.appendChild(windowDocument.createTextNode(' Close on exit '));
            var closeOnExitCheckbox = windowDocument.createElement('input');
            closeOnExitCheckbox.style.margin = '2px';
            closeOnExitCheckbox.setAttribute('type', 'checkbox');
            closeOnExitCheckbox.defaultChecked = true;
            closeOnExitCheckbox.checked = true;
            closeOnExitCheckbox.onclick = function() {
                closeOnExit = closeOnExitCheckbox.checked;
            };
            documentBody.appendChild(closeOnExitCheckbox);
            documentBody.appendChild(windowDocument.createTextNode(' Lines '));
            var lineCountDropDown = windowDocument.createElement('select');
            lineCountDropDown.style.margin = '2px';
            each(lineOptions, function(count, index) {
                var option = lineCountDropDown.appendChild(windowDocument.createElement('option'));
                if (numberOfLines == count) lineCountDropDown.selectedIndex = index;
                option.appendChild(windowDocument.createTextNode(asString(count)));
            });
            documentBody.appendChild(lineCountDropDown);
            documentBody.appendChild(windowDocument.createTextNode(' Category '));
            var categoryInputText = windowDocument.createElement('input');
            categoryInputText.style.margin = '2px';
            categoryInputText.setAttribute('type', 'text');
            categoryInputText.setAttribute('value', categoryMatcher.source);
            categoryInputText.onchange = function() {
                categoryMatcher = new RegExp(categoryInputText.value);
            };
            documentBody.appendChild(categoryInputText);
            documentBody.appendChild(windowDocument.createTextNode(' Level '));
            var levelDropDown = windowDocument.createElement('select');
            levelDropDown.style.margin = '2px';
            var levels = [Cell('debug', debug), Cell('info', info), Cell('warn', warn), Cell('error', error)];
            each(levels, function(priority, index) {
                var option = levelDropDown.appendChild(windowDocument.createElement('option'));
                if (thresholdPriority == value(priority)) levelDropDown.selectedIndex = index;
                option.appendChild(windowDocument.createTextNode(key(priority)));
            });
            levelDropDown.onchange = function(event) {
                thresholdPriority = value(levels[levelDropDown.selectedIndex]);
            };
            documentBody.appendChild(levelDropDown);
            var startStopButton = windowDocument.createElement('input');
            startStopButton.style.margin = '2px';
            startStopButton.setAttribute('type', 'button');
            startStopButton.setAttribute('value', 'Stop');
            startStopButton.onclick = function() {
                startStopButton.setAttribute('value', toggle() ? 'Stop' : 'Start');
            };
            documentBody.appendChild(startStopButton);
            var clearButton = windowDocument.createElement('input');
            clearButton.style.margin = '2px';
            clearButton.setAttribute('type', 'button');
            clearButton.setAttribute('value', 'Clear');
            documentBody.appendChild(clearButton);
            logContainer = documentBody.appendChild(windowDocument.createElement('pre'));
            logContainer.id = 'log-window';
            var logContainerStyle = logContainer.style;
            logContainerStyle.width = '100%';
            logContainerStyle.minHeight = '0';
            logContainerStyle.maxHeight = '550px';
            logContainerStyle.borderWidth = '1px';
            logContainerStyle.borderStyle = 'solid';
            logContainerStyle.borderColor = '#999';
            logContainerStyle.backgroundColor = '#ddd';
            logContainerStyle.overflow = 'scroll';
            lineCountDropDown.onchange = function(event) {
                numberOfLines = lineOptions[lineCountDropDown.selectedIndex];
                trimLines();
            };
            clearButton.onclick = trimAllLines;
            onUnload(window, function() {
                if (closeOnExit) {
                    logEntry = noop;
                    logWindow.close();
                }
            });
        } catch (e) {
            logWindow.close();
        }
    }
    onKeyUp(document, function(evt) {
        var event = $event(evt, document.documentElement);
        if (keyCode(event) == 84 && isCtrlPressed(event) && isShiftPressed(event)) {
            showWindow();
            logEntry = displayEntry;
        }
    });
    return object(function(method) {
        method(threshold, function(self, priority) {
            thresholdPriority = priority;
        });
        method(log, function(self, operation, category, message, exception) {
            operation(self, category, message, exception);
        });
        method(debug, function(self, category, message, exception) {
            logEntry('debug', '#333', category, message, exception);
        });
        method(info, function(self, category, message, exception) {
            logEntry('info', 'green', category, message, exception);
        });
        method(warn, function(self, category, message, exception) {
            logEntry('warn', 'orange', category, message, exception);
        });
        method(error, function(self, category, message, exception) {
            logEntry('error', 'red', category, message, exception);
        });
    });
}
        var handler = window.console && window.console.log ? ConsoleLogHandler(debug) : WindowLogHandler(debug, window.location.href);
        var logger = Logger([ 'window' ], handler);
        namespace.log = logger;
        namespace.log.debug = debug;
        namespace.log.info = info;
        namespace.log.warn = warn;
        namespace.log.error = error;
        namespace.log.childLogger = childLogger;
var setFocus;
var applyFocus;
var currentFocus = '';
(function() {
    setFocus = function(id) {
        currentFocus = id ? id : '';
        debug(logger, 'persisted focus for element "' + id + '"');
    };
    function isValidID(id) {
        return /^\w[\w\-\:]*$/.test(id);
    }
    var isIE = /MSIE/.test(navigator.userAgent);
    var focusOn = function(id) {
        runOnce(Delay(function() {
            if (id && isValidID(id)) {
                var e = document.getElementById(id);
                if (e) {
                    setFocus(id);
                    if (e.focus) {
                        try {
                            e.focus();
                        } catch (ex) {
                        } finally {
                            if (isIE) {
                                try {
                                    e.focus();
                                } catch (ex2) {
                                }
                            }
                            debug(logger, 'focused element "' + id + '"');
                        }
                    }
                }
            }
        }, 100));
    };
    var focusStrategy = focusOn;
    applyFocus = function(id) {
        focusStrategy(id);
    };
    if (isIE) {
        var activeElement;
        onLoad(window, function() {
            activeElement = document.activeElement;
        });
        var onBlur = function(callback) {
            registerElementListener(document, 'onfocusout', function() {
                if (activeElement == document.activeElement) {
                    callback();
                } else {
                    activeElement = document.activeElement;
                }
            });
        };
        var onFocus = function(callback) {
            registerElementListener(window, 'onfocus', callback);
        };
        onBlur(function() {
            focusStrategy = setFocus;
        });
        onFocus(function() {
            focusStrategy = focusOn;
        });
    }
    function registerElementListener(element, eventType, listener) {
        var previousListener = element[eventType];
        if (previousListener) {
            element[eventType] = function(e) {
                var args = [e];
                previousListener.apply(element, args);
                listener.apply(element, args);
            };
        } else {
            element[eventType] = listener;
        }
    }
    function setFocusListener(e) {
        var evt = e || window.event;
        var element = evt.srcElement || evt.target;
        setFocus(element.id);
    }
    var focusableElements = ['select', 'input', 'button', 'a'];
    function captureFocusIn(root) {
        if (contains(focusableElements, root.nodeName)) {
            registerElementListener(root, 'onfocus', setFocusListener);
        }
        each(focusableElements, function(type) {
            each(root.getElementsByTagName(type), function(element) {
                registerElementListener(element, 'onfocus', setFocusListener);
            });
        });
    }
    namespace.onAfterUpdate(function(updates) {
        each(updates.getElementsByTagName('update'), function(update) {
            var id = update.getAttribute('id');
            var element = lookupElementById(id);
            if (id != 'javax.faces.ViewState' && element) captureFocusIn(element);
        });
    });
    onLoad(window, function() {
        captureFocusIn(document);
    });
})();
        namespace.setFocus = setFocus;
        namespace.sf = setFocus;
        namespace.applyFocus = applyFocus;
        namespace.af = applyFocus;
var asURIEncodedString = operator();
var serializeOn = operator();
var Parameter = function(name, value) {
    return objectWithAncestors(function(method) {
        method(asURIEncodedString, function(self) {
            return encodeURIComponent(name) + '=' + encodeURIComponent(value);
        });
        method(serializeOn, function(self, query) {
            addParameter(query, self);
        });
    }, Cell(name, value));
};
var addParameter = operator();
var addNameValue = operator();
var queryParameters = operator();
var addQuery = operator();
var appendToURI = operator();
var Query = function() {
    var parameters = [];
    return object(function(method) {
        method(queryParameters, function(self) {
            return parameters;
        });
        method(addParameter, function(self, parameter) {
            append(parameters, parameter);
            return self;
        });
        method(addNameValue, function(self, name, value) {
            append(parameters, Parameter(name, value));
            return self;
        });
        method(addQuery, function(self, appended) {
            serializeOn(appended, self);
            return self;
        });
        method(serializeOn, function(self, query) {
            each(parameters, curry(addParameter, query));
        });
        method(asURIEncodedString, function(self) {
            return join(collect(parameters, asURIEncodedString), '&');
        });
        method(appendToURI, function(self, uri) {
            if (not(isEmpty(parameters))) {
                return uri + (contains(uri, '?') ? '&' : '?') + asURIEncodedString(self);
            } else {
                return uri;
            }
        });
        method(asString, function(self) {
            return inject(parameters, '', function(tally, p) {
                return tally + '|' + key(p) + '=' + value(p) + '|\n';
            });
        });
    });
};
var getSynchronously = operator();
var getAsynchronously = operator();
var postSynchronously = operator();
var postAsynchronously = operator();
var Client = function(autoclose) {
    var newNativeRequest;
    if (window.XMLHttpRequest) {
        newNativeRequest = function() {
            return new XMLHttpRequest();
        };
    } else if (window.ActiveXObject) {
        newNativeRequest = function() {
            return new window.ActiveXObject('Microsoft.XMLHTTP');
        };
    } else {
        throw 'cannot create XMLHttpRequest';
    }
    function withNewQuery(setup) {
        var query = Query();
        setup(query);
        return query;
    }
    var autoClose = autoclose ? close : noop;
    return object(function(method) {
        method(getAsynchronously, function(self, uri, setupQuery, setupRequest, onResponse) {
            var nativeRequestResponse = newNativeRequest();
            var request = RequestProxy(nativeRequestResponse);
            var response = ResponseProxy(nativeRequestResponse);
            nativeRequestResponse.open('GET', appendToURI(withNewQuery(setupQuery), uri), true);
            setupRequest(request);
            nativeRequestResponse.onreadystatechange = function() {
                if (nativeRequestResponse.readyState == 4) {
                    onResponse(response, request);
                    autoClose(request);
                }
            };
            nativeRequestResponse.send('');
            return request;
        });
        method(getSynchronously, function(self, uri, setupQuery, setupRequest, onResponse) {
            var nativeRequestResponse = newNativeRequest();
            var request = RequestProxy(nativeRequestResponse);
            var response = ResponseProxy(nativeRequestResponse);
            nativeRequestResponse.open('GET', appendToURI(withNewQuery(setupQuery), uri), false);
            setupRequest(request);
            nativeRequestResponse.send('');
            onResponse(response, request);
            autoClose(request);
        });
        method(postAsynchronously, function(self, uri, setupQuery, setupRequest, onResponse) {
            var nativeRequestResponse = newNativeRequest();
            var request = RequestProxy(nativeRequestResponse);
            var response = ResponseProxy(nativeRequestResponse);
            nativeRequestResponse.open('POST', uri, true);
            setupRequest(request);
            nativeRequestResponse.onreadystatechange = function() {
                if (nativeRequestResponse.readyState == 4) {
                    onResponse(response, request);
                    autoClose(request);
                }
            };
            nativeRequestResponse.send(asURIEncodedString(withNewQuery(setupQuery)));
            return request;
        });
        method(postSynchronously, function(self, uri, setupQuery, setupRequest, onResponse) {
            var nativeRequestResponse = newNativeRequest();
            var request = RequestProxy(nativeRequestResponse);
            var response = ResponseProxy(nativeRequestResponse);
            nativeRequestResponse.open('POST', uri, false);
            setupRequest(request);
            nativeRequestResponse.send(asURIEncodedString(withNewQuery(setupQuery)));
            onResponse(response, request);
            autoClose(request);
        });
    });
};
var close = operator();
var abort = operator();
var setHeader = operator();
var onResponse = operator();
var RequestProxy = function(nativeRequestResponse) {
    return object(function(method) {
        method(setHeader, function(self, name, value) {
            nativeRequestResponse.setRequestHeader(name, value);
        });
        method(close, function(self) {
            nativeRequestResponse.onreadystatechange = noop;
        });
        method(abort, function(self) {
            nativeRequestResponse.onreadystatechange = noop;
            nativeRequestResponse.abort();
            method(abort, noop);
        });
    });
};
var statusCode = operator();
var statusText = operator();
var getHeader = operator();
var getAllHeaders = operator();
var hasHeader = operator();
var contentAsText = operator();
var contentAsDOM = operator();
var ResponseProxy = function(nativeRequestResponse) {
    return object(function(method) {
        method(statusCode, function() {
            try {
                return nativeRequestResponse.status;
            } catch (e) {
                return 0;
            }
        });
        method(statusText, function(self) {
            try {
                return nativeRequestResponse.statusText;
            } catch (e) {
                return '';
            }
        });
        method(hasHeader, function(self, name) {
            try {
                var header = nativeRequestResponse.getResponseHeader(name);
                return header && header != '';
            } catch (e) {
                return false;
            }
        });
        method(getHeader, function(self, name) {
            try {
                return nativeRequestResponse.getResponseHeader(name);
            } catch (e) {
                return null;
            }
        });
        method(getAllHeaders, function(self, name) {
            try {
                return collect(reject(split(nativeRequestResponse.getAllResponseHeaders(), '\n'), isEmpty), function(pair) {
                    var nameValue = split(pair, ': ')
                    return Cell(nameValue[0], nameValue[1]);
                });
            } catch (e) {
                return [];
            }
        });
        method(contentAsText, function(self) {
            try {
                return nativeRequestResponse.responseText;
            } catch (e) {
                return '';
            }
        });
        method(contentAsDOM, function(self) {
            return nativeRequestResponse.responseXML;
        });
        method(asString, function(self) {
            return inject(getAllHeaders(self), 'HTTP Response\n', function(result, header) {
                return result + key(header) + ': ' + value(header) + '\n';
            }) + contentAsText(self);
        });
    });
};
function OK(response) {
    return statusCode(response) == 200;
}
function NotFound(response) {
    return statusCode(response) == 404;
}
function ServerInternalError(response) {
    var code = statusCode(response);
    return code >= 500 && code < 600;
}
function FormPost(request) {
    setHeader(request, 'Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
}
var singleSubmitExecuteThis;
var singleSubmitExecuteThisRenderThis;
var submit;
(function() {
    function idOrElement(e) {
        return isString(e) ? document.getElementById(e) : e;
    }
    function formOf(element) {
        return toLowerCase(element.nodeName) == 'form' ? element : enclosingForm(element);
    }
    function isAjaxDisabled(element) {
        var elementID = element.id;
        var formID = formOf(element).id;
        var disablingMarker = document.getElementById(formID + ":ajaxDisabled");
        return disablingMarker && contains(split(trim(disablingMarker.value), ' '), elementID);
    }
    function standardFormSerialization(element) {
        return configurationOf(element).standardFormSerialization;
    }
    function serializeEventToOptions(event, options) {
        var collectingQuery = object(function(method) {
            method(addNameValue, function(self, name, value) {
                options[name] = value;
            });
        });
        serializeOn(event, collectingQuery);
    }
    function encodedURLOf(form) {
        return form['javax.faces.encodedURL'] ? form['javax.faces.encodedURL'].value : form.action;
    }
    function serializeAdditionalParameters(additionalParameters, options) {
        if (additionalParameters) {
            additionalParameters(function(name, value) {
                options[name] = value;
            });
        }
    }
    var submitSendListeners = [];
    namespace.onSubmitSend = function(callback) {
        append(submitSendListeners, callback);
    };
    var submitResponseListeners = [];
    namespace.onSubmitResponse = function(callback) {
        append(submitResponseListeners, callback);
    };
    function requestCallback(e) {
        switch (e.status) {
            case 'begin':
                broadcast(submitSendListeners);
                break;
            case 'complete':
                broadcast(submitResponseListeners, [ e.responseCode, e.responseText, e.responseXML ]);
                break;
        }
    }
    function singleSubmit(execute, render, event, element, additionalParameters) {
        var viewID = viewIDOf(element);
        var form = document.getElementById(viewID);
        var clonedElements = [];
        try {
            var clonedElement = form.appendChild(element.cloneNode(true));
            append(clonedElements, clonedElement);
            var tagName = toLowerCase(element.nodeName);
            if (tagName == 'input') {
                if (element.type == 'radio') {
                    clonedElement.checked = element.checked;
                }
                if (element.type == 'checkbox') {
                    clonedElement.checked = element.checked;
                    var name = element.name;
                    each(element.form.elements, function(checkbox) {
                        if (checkbox.name == name && checkbox != element) {
                            var checkboxClone = form.appendChild(checkbox.cloneNode(true));
                            append(clonedElements, checkboxClone);
                            checkboxClone.checked = checkbox.checked;
                        }
                    });
                }
            } else if (tagName == 'select') {
                var clonedOptions = clonedElement.options;
                each(element.options, function(option, i) {
                    clonedOptions[i].selected = option.selected;
                });
            }
            event = event || null;
            var options = {execute: execute, render: render, onevent: requestCallback, 'ice.window': namespace.window, 'ice.view': viewID, 'ice.focus': currentFocus};
            var decoratedEvent = $event(event, element);
            if (isKeyEvent(decoratedEvent) && isEnterKey(decoratedEvent)) {
                cancelBubbling(decoratedEvent);
                cancelDefaultAction(decoratedEvent);
            }
            serializeEventToOptions(decoratedEvent, options);
            serializeAdditionalParameters(additionalParameters, options);
            debug(logger, join([
                'partial submit to ' + encodedURLOf(form),
                'javax.faces.execute: ' + execute,
                'javax.faces.render: ' + render,
                'javax.faces.source: ' + element.id,
                'view ID: ' + viewID,
                'event type: ' + type(decoratedEvent)
            ], '\n'));
            jsf.ajax.request(clonedElement, event, options);
        } finally {
            each(clonedElements, function(c) {
                form.removeChild(c);
            });
        }
    }
    singleSubmitExecuteThis = function(event, idorelement, additionalParameters) {
        var element = idOrElement(idorelement);
        if (standardFormSerialization(element)) {
            return fullSubmit('@this', '@all', event, element, function(p) {
                p('ice.submit.type', 'ice.se');
                p('ice.submit.serialization', 'form');
                if (additionalParameters) additionalParameters(p);
            });
        } else {
            return singleSubmit('@this', '@all', event, element, function(p) {
                p('ice.submit.type', 'ice.se');
                p('ice.submit.serialization', 'element');
                if (additionalParameters) additionalParameters(p);
            });
        }
    };
    singleSubmitExecuteThisRenderThis = function(event, idorelement, additionalParameters) {
        var element = idOrElement(idorelement);
        if (standardFormSerialization(element)) {
            return fullSubmit('@this', '@this', event, element, function(p) {
                p('ice.submit.type', 'ice.ser');
                p('ice.submit.serialization', 'form');
                if (additionalParameters) additionalParameters(p);
            });
        } else {
            return singleSubmit('@this', '@this', event, element, function(p) {
                p('ice.submit.type', 'ice.ser');
                p('ice.submit.serialization', 'element');
                if (additionalParameters) additionalParameters(p);
            });
        }
    };
    var addPrefix = 'patch+';
    var removePrefix = 'patch-';
    function fullSubmit(execute, render, event, element, additionalParameters) {
        if (isAjaxDisabled(element)) {
            var f = formOf(element);
            if (f && f.nativeSubmit) f.nativeSubmit();
        } else {
            event = event || null;
            var viewID = viewIDOf(element);
            var options = {execute: execute, render: render, onevent: requestCallback, 'ice.window': namespace.window, 'ice.view': viewID, 'ice.focus': currentFocus};
            var decoratedEvent = $event(event, element);
            if (isKeyEvent(decoratedEvent) && isEnterKey(decoratedEvent)) {
                cancelBubbling(decoratedEvent);
                cancelDefaultAction(decoratedEvent);
            }
            serializeEventToOptions(decoratedEvent, options);
            serializeAdditionalParameters(additionalParameters, options);
            var form = formOf(element);
            var isDeltaSubmit = deltaSubmit(element);
            debug(logger, join([
                (isDeltaSubmit ? 'delta ' : '') + 'full submit to ' + encodedURLOf(form),
                'javax.faces.execute: ' + execute,
                'javax.faces.render: ' + render,
                'javax.faces.source: ' + element.id,
                'view ID: ' + viewID,
                'event type: ' + type(decoratedEvent)
            ], '\n'));
            if (isDeltaSubmit) {
                var previousParameters = form.previousParameters || HashSet();
                var currentParameters = HashSet(jsf.getViewState(form).split('&'));
                var addedParameters = complement(currentParameters, previousParameters);
                var removedParameters = complement(previousParameters, currentParameters);
                form.previousParameters = currentParameters;
                function splitStringParameter(f) {
                    return function(p) {
                        var parameter = split(p, '=');
                        f(decodeURIComponent(parameter[0]), decodeURIComponent(parameter[1]));
                    };
                }
                var deltaSubmitForm = document.getElementById(viewID);
                var clonedElement = element.cloneNode(true);
                var appendedElements = [];
                function createHiddenInputInDeltaSubmitForm(name, value) {
                    append(appendedElements, appendHiddenInputElement(deltaSubmitForm, name, value));
                }
                try {
                    createHiddenInputInDeltaSubmitForm('ice.deltasubmit.form', form.id);
                    createHiddenInputInDeltaSubmitForm(form.id, form.id);
                    each(addedParameters, splitStringParameter(function(name, value) {
                        createHiddenInputInDeltaSubmitForm(addPrefix + name, value);
                    }));
                    each(removedParameters, splitStringParameter(function(name, value) {
                        createHiddenInputInDeltaSubmitForm(removePrefix + name, value);
                    }));
                    jsf.ajax.request(deltaSubmitForm, event, options);
                } finally {
                    each(appendedElements, function(element) {
                        deltaSubmitForm.removeChild(element);
                    });
                }
            } else {
                jsf.ajax.request(element, event, options);
            }
        }
    }
    submit = function(event, element, additionalParameters) {
        return fullSubmit('@all', '@all', event, idOrElement(element), function(p) {
            p('ice.submit.type', 'ice.s');
            p('ice.submit.serialization', 'form');
            if (additionalParameters) additionalParameters(p);
        });
    };
})();
        namespace.se = singleSubmitExecuteThis;
        namespace.ser = singleSubmitExecuteThisRenderThis;
        namespace.submit = submit;
        namespace.s = submit;
        function appendHiddenInputElement(form, name, value, defaultValue) {
            var hiddenInput = document.createElement('input');
            hiddenInput.setAttribute('name', name);
            hiddenInput.setAttribute('value', value);
            hiddenInput.setAttribute('type', 'hidden');
            if (defaultValue) {
                hiddenInput.defaultValue = defaultValue;
            }
            form.appendChild(hiddenInput);
            return hiddenInput;
        }
        var viewIDs = [];
        function retrieveUpdate(viewID) {
            append(viewIDs, viewID);
            return function() {
                var form = document.getElementById(viewID);
                try {
                    debug(logger, 'picking updates for view ' + viewID);
                    jsf.ajax.request(form, null, {'ice.submit.type': 'ice.push', render: '@all', 'ice.view': viewID, 'ice.window': namespace.window});
                } catch (e) {
                    warn(logger, 'failed to pick updates', e);
                }
            };
        }
        var client = Client();
        function disposeWindow(viewID) {
            return function() {
                var form = document.getElementById(viewID);
                try {
                    var encodedURLElement = form['javax.faces.encodedURL'];
                    var url = encodedURLElement ? encodedURLElement.value : form.action;
                    form.action = url.replace(/(\?|&)cid=[0-9]+/, "$1");
                    debug(logger, 'dispose window and associated views ' + viewIDs);
                    postSynchronously(client, form.action, function(query) {
                        addNameValue(query, 'ice.submit.type', 'ice.dispose.window');
                        addNameValue(query, 'ice.window', namespace.window);
                        addNameValue(query, 'javax.faces.ViewState', form['javax.faces.ViewState'].value);
                        each(viewIDs, curry(addNameValue, query, 'ice.view'));
                    }, FormPost, noop);
                } catch (e) {
                    warn(logger, 'failed to notify window disposal', e);
                }
            };
        }
        function sessionExpired() {
            retrieveUpdate = noop;
            each(viewIDs, namespace.push.deregister);
            broadcast(sessionExpiryListeners);
        }
        function containsXMLData(doc) {
            return doc && doc.documentElement;
        }
        jsf.ajax.addOnEvent(function(e) {
            switch (e.status) {
                case 'begin':
                    broadcast(beforeSubmitListeners, [ e.source ]);
                    break;
                case 'complete':
                    var xmlContent = e.responseXML;
                    if (containsXMLData(xmlContent)) {
                        broadcast(beforeUpdateListeners, [ xmlContent ]);
                    } else {
                        warn(logger, 'the response does not contain XML data');
                    }
                    break;
                case 'success':
                    var xmlContent = e.responseXML;
                    broadcast(afterUpdateListeners, [ xmlContent ]);
                    var updates = xmlContent.documentElement.firstChild.childNodes;
                    var updateDescriptions = collect(updates, function(update) {
                        var id = update.getAttribute('id');
                        return update.nodeName + (id ? '["' + id + '"]' : '') +
                                ': ' + substring(update.firstChild.data, 0, 40) + '....';
                    });
                    debug(logger, 'applied updates >>\n' + join(updateDescriptions, '\n'));
                    break;
            }
        });
        jsf.ajax.addOnError(function(e) {
            if (e.status == 'serverError') {
                var xmlContent = e.responseXML;
                if (containsXMLData(xmlContent)) {
                    var errorName = xmlContent.getElementsByTagName("error-name")[0].firstChild.nodeValue;
                    if (errorName && contains(errorName, 'org.icefaces.application.SessionExpiredException')) {
                        info(logger, 'received session expired message');
                        sessionExpired();
                        return;
                    }
                }
                info(logger, 'received error message [code: ' + e.responseCode + ']: ' + e.responseText);
                broadcast(serverErrorListeners, [ e.responseCode, e.responseText, containsXMLData(xmlContent) ? xmlContent : null]);
            } else if (e.status == 'httpError') {
                warn(logger, 'HTTP error [code: ' + e.responseCode + ']: ' + e.description);
                broadcast(networkErrorListeners, [ e.responseCode, e.description]);
            } else {
                error(logger, 'Error [status: ' + e.status + ' code: ' + e.responseCode + ']: ' + e.description);
            }
        });
        namespace.setupBridge = function(setupID, viewID, windowID, configuration) {
            var container = document.getElementById(setupID).parentNode;
            container.configuration = configuration;
            container.configuration.viewID = viewID;
            namespace.window = windowID;
            if (configuration.sendDisposeWindow) {
                onBeforeUnload(window, disposeWindow(viewID));
            }
            setupDefaultIndicators(container, configuration);
        };
        namespace.setupPush = function(viewID) {
            ice.push.register([viewID], retrieveUpdate(viewID));
        };
        namespace.captureEnterKey = function(id) {
            var f = document.getElementById(id);
            f.onkeypress = function(ev) {
                var e = $event(ev, f);
                var element = triggeredBy(e);
                var type = toLowerCase(element.nodeName);
                if (isEnterKey(e) && (type != 'textarea' && type != 'a')) {
                    submit(ev || window.event, element);
                    return false;
                } else {
                    return true;
                }
            };
        };
        namespace.captureSubmit = function(id) {
            var f = document.getElementById(id);
            f.nativeSubmit = f.submit;
            f.submit = function() {
                submit(null, f);
            };
            each(['onkeydown', 'onkeypress', 'onkeyup', 'onclick', 'ondblclick', 'onchange'], function(name) {
                f[name] = function(e) {
                    var event = e || window.event;
                    var element = event.target || event.srcElement;
                    var disabled = document.getElementById(id + ":ajaxDisabled");
                    if ((disabled) &&
                            (disabled.value.indexOf(" " + element.id + " ") >= 0)) {
                        return true;
                    }
                    f.onsubmit = function() {
                        submit(event, element);
                        f.onsubmit = none;
                        return false;
                    };
                };
            });
        };
        namespace.enableSingleSubmit = function(id) {
            var f = document.getElementById(id);
            function submitForm(ev) {
                var eType;
                if (window.event) {
                    eType = window.event.type;
                } else {
                    eType = ev.type;
                }
                if (0 == eType.indexOf("on")) {
                    eType = eType.substr(2);
                }
                var e = $event(ev, f);
                var element = triggeredBy(e);
                var elementType = element.type;
                if (!elementType) {
                    return;
                }
                elementType = toLowerCase(elementType);
                if (elementType == 'image') {
                    return;
                }
                if (elementType == 'submit') {
                    return;
                }
                if ((null == element.id) || ("" == element.id)) {
                    return;
                }
                var isText = ( (elementType == "text") ||
                        (elementType == "password") ||
                        (elementType == "textarea") );
                if (isText) {
                    if ((eType == "click") || (eType == "blur")) {
                        return;
                    }
                }
                if (0 == elementType.indexOf("select-")) {
                    if (element.selectedIndex == element.previousSelectedIndex) {
                        return;
                    } else {
                        element.previousSelectedIndex = element.selectedIndex;
                    }
                }
                ice.setFocus(null);
                ice.se(e, element);
            }
            if (f.addEventListener) {
                f.addEventListener('blur', submitForm, true);
                f.addEventListener('change', submitForm, true);
            } else {
                f.attachEvent('onfocusout', submitForm);
                f.attachEvent('onclick', submitForm);
            }
        };
        namespace.calculateInitialParameters = function(id) {
            var f = document.getElementById(id);
            f.previousParameters = HashSet(jsf.getViewState(f).split('&'));
        };
        function isComponentRendered(form) {
            return form['javax.faces.encodedURL'] ||
                    form['javax.faces.ViewState'] ||
                    form['ice.window'] ||
                    form['ice.view'] ||
                    (form.id && form[form.id] && form.id == form[form.id].value);
        }
        function findUpdatedForms(updates) {
            return inject(updates.getElementsByTagName('update'), [], function(result, update) {
                var id = update.getAttribute('id');
                var e = lookupElementById(id);
                if (e) {
                    if (toLowerCase(e.nodeName) == 'form') {
                        if (isComponentRendered(e)) {
                            append(result, e);
                        }
                    } else {
                        var updatedForms = asArray(select(e.getElementsByTagName('form'), isComponentRendered));
                        result = concatenate(result, updatedForms);
                    }
                }
                return result;
            });
        }
        var previousFormParameters = HashTable();
        namespace.onBeforeUpdate(function(updates) {
            each(findUpdatedForms(updates), function(form) {
                if (deltaSubmit(form)) {
                    putAt(previousFormParameters, form.id, form.previousParameters);
                }
            });
        });
        namespace.onAfterUpdate(function(updates) {
            var viewStateUpdate = detect(updates.getElementsByTagName('update'), function(update) {
                return update.getAttribute('id') == 'javax.faces.ViewState';
            });
            if (viewStateUpdate) {
                var viewState = viewStateUpdate.firstChild.data;
                var forms = findUpdatedForms(updates);
                each(forms, function(form) {
                    if (!form['javax.faces.ViewState']) {
                        appendHiddenInputElement(form, 'javax.faces.ViewState', viewState, viewState);
                        debug(logger, 'append missing "javax.faces.ViewState" input element to form["' + form.id + '"]');
                    }
                    if (deltaSubmit(form)) {
                        var previousParameters = at(previousFormParameters, form.id);
                        if (previousParameters) {
                            form.previousParameters = previousParameters;
                        } else {
                            debug(logger, 'recalculate initial parameters for updated form["' + form.id + '"]');
                            form.previousParameters = HashSet(jsf.getViewState(form).split('&'));
                        }
                    }
                });
                previousFormParameters = HashTable();
            }
        });
        namespace.onAfterUpdate(function(updates) {
            elementRemoveListeners = reject(elementRemoveListeners, function(idCallbackTuple) {
                var id = key(idCallbackTuple);
                var notFound = !document.getElementById(id);
                if (notFound) {
                    var callback = value(idCallbackTuple);
                    try {
                        callback();
                    } catch (e) {
                    }
                }
                return notFound;
            });
        });
        onKeyPress(document, function(ev) {
            var e = $event(ev);
            if (isEscKey(e)) cancelDefaultAction(e);
        });
var setupDefaultIndicators;
(function() {
    function PopupIndicator(message, description, panel) {
        panel();
        var messageContainer = document.body.appendChild(document.createElement('div'));
        var messageContainerStyle = messageContainer.style;
        messageContainerStyle.position = 'absolute';
        messageContainerStyle.textAlign = 'center';
        messageContainerStyle.zIndex = '28001';
        messageContainerStyle.color = 'black';
        messageContainerStyle.backgroundColor = 'white';
        messageContainerStyle.paddingLeft = '10px';
        messageContainerStyle.paddingRight = '10px';
        messageContainerStyle.paddingTop = '15px';
        messageContainerStyle.paddingBottom = '15px';
        messageContainerStyle.borderBottomColor = 'gray';
        messageContainerStyle.borderRightColor = 'gray';
        messageContainerStyle.borderTopColor = 'silver';
        messageContainerStyle.borderLeftColor = 'silver';
        messageContainerStyle.borderWidth = '2px';
        messageContainerStyle.borderStyle = 'solid';
        var messageElement = messageContainer.appendChild(document.createElement('div'));
        messageElement.appendChild(document.createTextNode(message));
        var messageElementStyle = messageElement.style;
        messageElementStyle.textAlign = 'left';
        messageElementStyle.fontSize = '14px';
        messageElementStyle.fontSize = '14px';
        messageElementStyle.fontWeight = 'bold';
        var descriptionElement = messageElement.appendChild(document.createElement('div'));
        descriptionElement.innerHTML = description;
        var descriptionElementStyle = descriptionElement.style;
        descriptionElementStyle.fontSize = '11px';
        descriptionElementStyle.marginTop = '7px';
        descriptionElementStyle.marginBottom = '7px';
        descriptionElementStyle.fontWeight = 'normal';
        var resize = function() {
            messageContainerStyle.left = ((window.width() - messageContainer.clientWidth) / 2) + 'px';
            messageContainerStyle.top = ((window.height() - messageContainer.clientHeight) / 2) + 'px';
        };
        resize();
        onResize(window, resize);
    }
    function BackgroundOverlay(container) {
        return function() {
            var overlay = container.ownerDocument.createElement('iframe');
            overlay.setAttribute('src', 'about:blank');
            overlay.setAttribute('frameborder', '0');
            var overlayStyle = overlay.style;
            overlayStyle.position = 'absolute';
            overlayStyle.display = 'block';
            overlayStyle.visibility = 'visible';
            overlayStyle.backgroundColor = 'white';
            overlayStyle.zIndex = '28000';
            overlayStyle.top = '0';
            overlayStyle.left = '0';
            overlayStyle.opacity = 0.22;
            overlayStyle.filter = 'alpha(opacity=22)';
            container.appendChild(overlay);
            var resize = container.tagName.toLowerCase() == 'body' ?
                    function() {
                        overlayStyle.width = Math.max(document.documentElement.scrollWidth, document.body.scrollWidth) + 'px';
                        overlayStyle.height = Math.max(document.documentElement.scrollHeight, document.body.scrollHeight) + 'px';
                    } :
                    function() {
                        overlayStyle.width = container.offsetWidth + 'px';
                        overlayStyle.height = container.offsetHeight + 'px';
                    };
            resize();
            onResize(window, resize);
        };
    }
    function extractTagContent(tag, html) {
        var start = new RegExp('\<' + tag + '[^\<]*\>', 'g').exec(html);
        var end = new RegExp('\<\/' + tag + '\>', 'g').exec(html);
        var tagWithContent = html.substring(start.index, end.index + end[0].length);
        return tagWithContent.substring(tagWithContent.indexOf('>') + 1, tagWithContent.lastIndexOf('<'));
    }
    setupDefaultIndicators = function(container, configuration) {
        var overlay = BackgroundOverlay(container);
        function showIndicators() {
            return !(namespace.disableDefaultErrorPopups || configuration.disableDefaultErrorPopups);
        }
        namespace.onServerError(function(code, html, xmlContent) {
            if (showIndicators()) {
                var message;
                var description;
                if (xmlContent) {
                    message = xmlContent.getElementsByTagName("error-message")[0].firstChild.nodeValue;
                    description = xmlContent.getElementsByTagName("error-name")[0].firstChild.nodeValue;
                } else {
                    message = extractTagContent('title', html);
                    description = extractTagContent('body', html);
                }
                PopupIndicator(message, description, overlay);
            }
        });
        namespace.onNetworkError(function() {
            if (showIndicators()) {
                PopupIndicator("Network Connection Interrupted", "Reload this page to try to reconnect.", overlay);
            }
        });
        namespace.onSessionExpiry(function() {
            if (showIndicators()) {
                PopupIndicator("User Session Expired", "Reload this page to start a new user session.", overlay);
            }
        });
    }
})();
(function() {
    var off = operator();
    function Overlay(element) {
        var container = element || document.body;
        var overlay = container.ownerDocument.createElement('iframe');
        overlay.setAttribute('src', 'about:blank');
        overlay.setAttribute('frameborder', '0');
        var overlayStyle = overlay.style;
        overlayStyle.position = 'absolute';
        overlayStyle.backgroundColor = 'white';
        overlayStyle.zIndex = '28000';
        overlayStyle.top = '0';
        overlayStyle.left = '0';
        overlayStyle.opacity = 0.22;
        overlayStyle.filter = 'alpha(opacity=22)';
        if (container.tagName.toLowerCase() == 'body') {
            overlayStyle.width = Math.max(document.documentElement.scrollWidth, document.body.scrollWidth) + 'px';
            overlayStyle.height = Math.max(document.documentElement.scrollHeight, document.body.scrollHeight) + 'px';
        } else {
            overlayStyle.width = container.offsetWidth + 'px';
            overlayStyle.height = container.offsetHeight + 'px';
        }
        container.appendChild(overlay);
        return object(function(method) {
            method(off, function(self) {
                if (overlay) container.removeChild(overlay);
            });
        });
    }
    function isBlockUIEnabled(source) {
        return configurationOf(source).blockUIOnSubmit;
    }
    function eventSink(element) {
        return function(e) {
            var ev = $event(e, element);
            var evenType = type(ev);
            var triggeringElement = triggeredBy(ev);
            var capturingElement = capturedBy(ev);
            debug(logger, 'event [type: ' + evenType +
                    ', triggered by: ' + identifier(triggeringElement) || triggeringElement +
                    ', captured in: ' + identifier(capturingElement) || capturingElement + '] was discarded.');
        }
    }
    var stopBlockingUI = noop;
    namespace.onBeforeSubmit(function(source) {
        if (viewIDOf(source) != source.id && isBlockUIEnabled(source)) {
            debug(logger, 'blocking UI');
            var blockUIOverlay = Overlay();
            var rollbacks = inject(['input', 'select', 'textarea', 'button', 'a'], [], function(result, type) {
                return concatenate(result, asArray(collect(document.body.getElementsByTagName(type), function(e) {
                    var sink = eventSink(e);
                    var onkeypress = e.onkeypress;
                    var onkeyup = e.onkeyup;
                    var onkeydown = e.onkeydown;
                    var onclick = e.onclick;
                    e.onkeypress = sink;
                    e.onkeyup = sink;
                    e.onkeydown = sink;
                    e.onclick = sink;
                    return function() {
                        try {
                            e.onkeypress = onkeypress;
                            e.onkeyup = onkeyup;
                            e.onkeydown = onkeydown;
                            e.onclick = onclick;
                        } catch (ex) {
                        }
                    };
                })));
            });
            stopBlockingUI = function() {
                broadcast(rollbacks);
                off(blockUIOverlay);
                debug(logger, 'unblocked UI');
            };
        } else {
            stopBlockingUI = noop;
        }
    });
    namespace.onAfterUpdate(function() {
        stopBlockingUI();
    });
})();
(function() {
    function extractTagContent(tag, html) {
        var start = new RegExp('\<' + tag + '[^\<]*\>', 'g').exec(html);
        var end = new RegExp('\<\/' + tag + '\>', 'g').exec(html);
        var tagWithContent = html.substring(start.index, end.index + end[0].length);
        return tagWithContent.substring(tagWithContent.indexOf('>') + 1, tagWithContent.lastIndexOf('<'));
    }
    function extractSrcAttribute(html) {
        var result = html.match(/src="([\S]*?)"/im);
        return result ? result[1] : null;
    }
    function unescapeHtml(text) {
        var temp = document.createElement("div");
        temp.innerHTML = text;
        var result = temp.firstChild.data;
        temp.removeChild(temp.firstChild);
        return result;
    }
    var scriptElementMatcher = /<script[^>]*>([\S\s]*?)<\/script>/igm;
    var client = Client();
    document.scriptRefs = document.scriptRefs ? document.scriptRefs : [];
    onLoad(window, function() {
        var scriptElements = document.documentElement.getElementsByTagName('script');
        inject(scriptElements, document.scriptRefs, function(result, s) {
            var src = s.getAttribute('src');
            if (src) {
                append(result, src);
            }
            return result;
        });
    });
    function findViewRootUpdate(content) {
        return detect(content.getElementsByTagName('update'), function(update) {
            return update.getAttribute('id') == 'javax.faces.ViewRoot';
        });
    }
    onLoad(window, function() {
        document.documentElement.isHeadUpdateSuccessful = null;
    });
    namespace.onAfterUpdate(function(content) {
        var rootUpdate = findViewRootUpdate(content);
        if (rootUpdate && !document.documentElement.isHeadUpdateSuccessful) {
            var headContent = extractTagContent('head', rootUpdate.firstChild.data);
            var scriptTags = headContent.match(scriptElementMatcher);
            var scripts = collect(scriptTags, function(script) {
                var src = extractSrcAttribute(script);
                var code;
                if (src) {
                    if (contains(document.scriptRefs, unescapeHtml(src))) {
                        code = '';
                    } else {
                        getSynchronously(client, src, noop, noop, function(response) {
                            code = contentAsText(response);
                        });
                        append(document.scriptRefs, src);
                    }
                } else {
                    code = unescapeHtml(extractTagContent('script', script));
                }
                return code;
            });
            each(scripts, eval);
        } else {
            document.documentElement.isHeadUpdateSuccessful = null;
        }
    });
    if (!/MSIE/.test(navigator.userAgent)) {
        namespace.onBeforeUpdate(function(content) {
            var rootUpdate = findViewRootUpdate(content);
            if (rootUpdate) {
                var configuration = document.body.configuration;
                if (configuration) {
                    document.documentElement.configuration = configuration;
                }
            }
        });
    }
})();
    })(window.ice);
}
