/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.mysqluser;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.dbcommon.DatabaseConnection;
import org.identityconnectors.dbcommon.DatabaseQueryBuilder;
import org.identityconnectors.dbcommon.FilterWhereBuilder;
import org.identityconnectors.dbcommon.SQLParam;
import org.identityconnectors.dbcommon.SQLUtil;
import org.identityconnectors.framework.common.exceptions.AlreadyExistsException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributeInfos;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;
import org.identityconnectors.mysqluser.MySQLUserConfiguration;
import org.identityconnectors.mysqluser.MySQLUserConnection;
import org.identityconnectors.mysqluser.MySQLUserFilterTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConnectorClass(displayNameKey="MYSQL_CONNECTOR_DISPLAY", configurationClass=MySQLUserConfiguration.class)
public class MySQLUserConnector
implements PoolableConnector,
CreateOp,
SearchOp<FilterWhereBuilder>,
DeleteOp,
UpdateOp,
SchemaOp,
TestOp,
AuthenticateOp {
    private static final Log log = Log.getLog(MySQLUserConnector.class);
    private MySQLUserConfiguration config;
    private MySQLUserConnection conn;

    public Configuration getConfiguration() {
        return this.config;
    }

    public void init(Configuration cfg) {
        this.config = (MySQLUserConfiguration)cfg;
        this.conn = MySQLUserConnection.getConnection(this.config);
    }

    public void checkAlive() {
        if (StringUtil.isNotBlank((String)this.config.getDatasource())) {
            try {
                this.conn.openConnection();
            }
            catch (SQLException e) {
                log.error((Throwable)e, "error in checkAlive", new Object[0]);
                throw ConnectorException.wrap((Throwable)e);
            }
        } else {
            this.conn.test();
            this.conn.commit();
        }
        log.ok("checkAlive", new Object[0]);
    }

    MySQLUserConnection getConnection() {
        return this.conn;
    }

    public void dispose() {
        if (this.conn != null) {
            this.conn.dispose();
            this.conn = null;
        }
        this.config = null;
        log.ok("dispose", new Object[0]);
    }

    public Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        this.checkAttributes(oclass, attrs);
        Name user = AttributeUtil.getNameFromAttributes(attrs);
        if (user == null || StringUtil.isBlank((String)user.getNameValue())) {
            throw new IllegalArgumentException(this.config.getMessage("name.blank"));
        }
        GuardedString password = AttributeUtil.getPasswordValue(attrs);
        if (password == null) {
            throw new IllegalArgumentException(this.config.getMessage("pwd.blank"));
        }
        try {
            log.info("Creating user: {0}", new Object[]{user.getNameValue()});
            this.conn.openConnection();
            this.createUser(user.getNameValue(), password);
            Uid uid = this.newUid(user.getNameValue());
            String modelUserName = this.config.getUsermodel();
            log.info("Reading the modeluser: {0}", new Object[]{modelUserName});
            List<String> grants = this.readGrantsForModelUser(modelUserName);
            List<String> newGrants = this.replaceModelUserInGrants(user.getNameValue(), modelUserName, grants);
            log.info("Granting rights for user: {0}", new Object[]{user.getNameValue()});
            this.grantingRights(newGrants, user.getNameValue(), password);
            this.conn.commit();
            log.ok("Created user: {0}", new Object[]{user.getNameValue()});
            Uid uid2 = uid;
            return uid2;
        }
        catch (SQLException ex) {
            log.error((Throwable)ex, "error in create", new Object[0]);
            throw ConnectorException.wrap((Throwable)ex);
        }
        finally {
            this.conn.closeConnection();
        }
    }

    public void delete(ObjectClass oclass, Uid uid, OperationOptions options) {
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        if (uid == null || uid.getUidValue() == null) {
            throw new IllegalArgumentException(this.config.getMessage("uid.blank"));
        }
        try {
            log.info("Delete user uid: {0}", new Object[]{uid.getName()});
            this.conn.openConnection();
            this.deleteUser(uid);
            this.conn.commit();
            log.ok("Deleted user uid: {0}", new Object[]{uid.getName()});
        }
        catch (SQLException ex) {
            log.error((Throwable)ex, "error in delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)ex);
        }
        finally {
            this.conn.closeConnection();
        }
    }

    public Uid update(ObjectClass oclass, Uid oldUid, Set<Attribute> attrs, OperationOptions options) {
        GuardedString password;
        String SQL_UPDATE = "UPDATE mysql.user SET {0} WHERE user=?";
        String SQL_SET_USER = "user = ?";
        String SQL_SET_PASSWORD = "password = password(?)";
        this.checkAttributes(oclass, attrs);
        Uid ret = oldUid;
        String updateSet = "";
        ArrayList<SQLParam> values = new ArrayList<SQLParam>();
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        if (name != null && !oldUid.getUidValue().equals(name.getNameValue())) {
            log.info("Update user {0} to (1)", new Object[]{oldUid.getUidValue(), name.getNameValue()});
            updateSet = "user = ?";
            values.add(new SQLParam("user", (Object)name.getNameValue(), 12));
            ret = this.newUid(name.getNameValue());
        }
        if ((password = AttributeUtil.getPasswordValue(attrs)) != null) {
            if (updateSet.length() != 0) {
                updateSet = updateSet + ", ";
            }
            updateSet = updateSet + "password = password(?)";
            values.add(new SQLParam("password", (Object)password));
        }
        String sql = MessageFormat.format("UPDATE mysql.user SET {0} WHERE user=?", updateSet);
        values.add(new SQLParam("user", (Object)oldUid.getUidValue(), 1));
        try {
            this.conn.openConnection();
            this.updateUser(sql, values);
            this.conn.commit();
        }
        catch (SQLException ex) {
            log.error((Throwable)ex, "error in update", new Object[0]);
            throw ConnectorException.wrap((Throwable)ex);
        }
        finally {
            this.conn.closeConnection();
        }
        log.ok("User name: {0} updated", new Object[]{name});
        return ret;
    }

    public FilterTranslator<FilterWhereBuilder> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        return new MySQLUserFilterTranslator(oclass, options);
    }

    public void executeQuery(ObjectClass oclass, FilterWhereBuilder where, ResultsHandler handler, OperationOptions options) {
        String ALL_USER_QUERY = "SELECT DISTINCT User FROM mysql.user";
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        DatabaseQueryBuilder query = new DatabaseQueryBuilder("SELECT DISTINCT User FROM mysql.user");
        query.setWhere(where);
        ResultSet result = null;
        PreparedStatement statement = null;
        try {
            this.conn.openConnection();
            statement = this.conn.prepareStatement(query);
            result = statement.executeQuery();
            while (result.next()) {
                ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
                String userName = result.getString(1);
                if (userName == null || userName.length() == 0) continue;
                bld.setUid(this.newUid(userName));
                bld.setName(userName);
                bld.setObjectClass(ObjectClass.ACCOUNT);
                ConnectorObject ret = bld.build();
                if (handler.handle(ret)) continue;
                break;
            }
            this.conn.commit();
        }
        catch (SQLException e) {
            try {
                SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
                throw ConnectorException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(result);
                SQLUtil.closeQuietly(statement);
                this.conn.closeConnection();
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)statement);
        this.conn.closeConnection();
        log.ok("executeQuery", new Object[0]);
    }

    public Schema schema() {
        HashSet<AttributeInfo> attrInfoSet = new HashSet<AttributeInfo>();
        attrInfoSet.add(Name.INFO);
        attrInfoSet.add(OperationalAttributeInfos.PASSWORD);
        SchemaBuilder schemaBld = new SchemaBuilder(this.getClass());
        schemaBld.defineObjectClass(ObjectClass.ACCOUNT_NAME, attrInfoSet);
        log.ok("schema", new Object[0]);
        return schemaBld.build();
    }

    public void test() {
        try {
            this.conn.openConnection();
            this.conn.test();
            if (!this.findUser(this.config.getUsermodel())) {
                SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
                throw new IllegalArgumentException(this.config.getMessage("user.model.not.found", this.config.getUsermodel()));
            }
            this.conn.commit();
        }
        catch (SQLException e) {
            log.error((Throwable)e, "Error in test", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        finally {
            this.conn.closeConnection();
        }
        log.ok("test", new Object[0]);
    }

    public Uid authenticate(ObjectClass oclass, String user, GuardedString password, OperationOptions options) {
        Uid uid;
        String AUTH_SELECT = "SELECT DISTINCT user FROM mysql.user WHERE user = ? AND password = password(?)";
        log.info("authenticate user: {0}", new Object[]{user});
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        if (user == null || StringUtil.isBlank((String)user)) {
            throw new IllegalArgumentException(this.config.getMessage("name.blank"));
        }
        if (password == null) {
            throw new IllegalArgumentException(this.config.getMessage("pwd.blank"));
        }
        ArrayList<SQLParam> values = new ArrayList<SQLParam>();
        values.add(new SQLParam("user", (Object)user, 12));
        values.add(new SQLParam("password", (Object)password));
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            this.conn.openConnection();
            stmt = this.conn.prepareStatement("SELECT DISTINCT user FROM mysql.user WHERE user = ? AND password = password(?)", values);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw new InvalidCredentialException(this.config.getMessage("auth.op.failed", user));
            }
            Uid uid2 = new Uid(result.getString(1));
            this.conn.commit();
            log.info("user: {0} authenticated ", new Object[]{user});
            uid = uid2;
        }
        catch (SQLException e) {
            try {
                log.error((Throwable)e, "user: {0} authentication failed ", new Object[]{user});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
                throw ConnectorException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(result);
                SQLUtil.closeQuietly(stmt);
                this.conn.closeConnection();
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)stmt);
        this.conn.closeConnection();
        return uid;
    }

    private void checkAttributes(ObjectClass oclass, Set<Attribute> attrs) {
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        if (attrs == null || attrs.size() == 0) {
            throw new IllegalArgumentException(this.config.getMessage("invalid.attribute.set"));
        }
        for (Attribute attribute : attrs) {
            if (attribute == null) {
                throw new IllegalArgumentException(this.config.getMessage("invalid.attribute.set"));
            }
            if (attribute.is(Name.NAME) || attribute.is(Uid.NAME) || attribute.is(OperationalAttributes.PASSWORD_NAME)) continue;
            throw new IllegalArgumentException(this.config.getMessage("invalid.attribute.set"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createUser(String name, GuardedString password) {
        String SQL_CREATE_TEMPLATE = "CREATE USER ? IDENTIFIED BY ?";
        PreparedStatement c1 = null;
        try {
            ArrayList<SQLParam> values = new ArrayList<SQLParam>();
            values.add(new SQLParam("name", (Object)name, 12));
            values.add(new SQLParam("password", (Object)password));
            c1 = this.conn.prepareStatement("CREATE USER ? IDENTIFIED BY ?", values);
            c1.execute();
            log.ok("User {0} created", new Object[]{name});
            SQLUtil.closeQuietly((Statement)c1);
        }
        catch (SQLException e) {
            if (this.findUser(name)) {
                log.error((Throwable)e, "Already Exists user {0}", new Object[]{name});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
                throw new AlreadyExistsException((Throwable)e);
            }
            this.grantUssage(name, password);
        }
        finally {
            SQLUtil.closeQuietly(c1);
        }
    }

    private void grantUssage(String name, GuardedString password) {
        String SQL_GRANT_TEMPLATE = "GRANT USAGE ON *.* TO ?@'localhost' IDENTIFIED BY ?";
        PreparedStatement c1 = null;
        try {
            ArrayList<SQLParam> values = new ArrayList<SQLParam>();
            values.add(new SQLParam("name", (Object)name, 12));
            values.add(new SQLParam("password", (Object)password));
            c1 = this.conn.prepareStatement("GRANT USAGE ON *.* TO ?@'localhost' IDENTIFIED BY ?", values);
            c1.execute();
        }
        catch (SQLException e) {
            try {
                log.error((Throwable)e, "Grant user {0} exception", new Object[]{name});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(c1);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((Statement)c1);
    }

    private boolean findUser(String userName) {
        ResultSet result;
        PreparedStatement ps;
        block4: {
            boolean bl;
            ps = null;
            result = null;
            ArrayList<SQLParam> values = new ArrayList<SQLParam>();
            values.add(new SQLParam("user", (Object)userName, 12));
            String SQL_SELECT = "SELECT DISTINCT user FROM mysql.user WHERE user = ?";
            log.info("findt User {0}", new Object[]{userName});
            try {
                ps = this.conn.prepareStatement("SELECT DISTINCT user FROM mysql.user WHERE user = ?", values);
                result = ps.executeQuery();
                if (!result.next()) break block4;
                bl = true;
            }
            catch (SQLException ex) {
                try {
                    log.error((Throwable)ex, "find User {0} ", new Object[]{userName});
                    SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
                    throw new IllegalStateException(ex);
                }
                catch (Throwable throwable) {
                    SQLUtil.closeQuietly(result);
                    SQLUtil.closeQuietly((Statement)ps);
                    throw throwable;
                }
            }
            SQLUtil.closeQuietly((ResultSet)result);
            SQLUtil.closeQuietly((Statement)ps);
            return bl;
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)ps);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readGrantsForModelUser(String modelUser) {
        String SQL_SHOW_MODEL_USERS = "SELECT host FROM mysql.user WHERE user = ?";
        String SQL_SHOW_GRANTS = "SHOW GRANTS FOR ?";
        PreparedStatement c1 = null;
        PreparedStatement c2 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ArrayList<String> grants = new ArrayList<String>();
        try {
            c1 = this.conn.getConnection().prepareStatement("SELECT host FROM mysql.user WHERE user = ?");
            c1.setString(1, modelUser);
            rs1 = c1.executeQuery();
            while (rs1.next()) {
                StringBuilder query = new StringBuilder("SHOW GRANTS FOR ?");
                String host = rs1.getString(1);
                log.ok("readGrantsFor host:{0}, user:{1}", new Object[]{host, modelUser});
                if (host != null && !host.equals("") && !host.equals("%")) {
                    query.append("@" + host);
                }
                c2 = this.conn.getConnection().prepareStatement(query.toString());
                c2.setString(1, modelUser);
                rs2 = c2.executeQuery();
                while (rs2.next()) {
                    String grant = rs2.getString(1);
                    grants.add(grant);
                }
            }
        }
        catch (SQLException e) {
            try {
                log.error((Throwable)e, "Error read GRANTS for model user {0}", new Object[]{modelUser});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(rs1);
                SQLUtil.closeQuietly(rs2);
                SQLUtil.closeQuietly((Statement)c1);
                SQLUtil.closeQuietly(c2);
                throw throwable;
            }
            SQLUtil.closeQuietly((ResultSet)rs1);
            SQLUtil.closeQuietly(rs2);
            SQLUtil.closeQuietly((Statement)c1);
            SQLUtil.closeQuietly(c2);
        }
        SQLUtil.closeQuietly((ResultSet)rs1);
        SQLUtil.closeQuietly(rs2);
        SQLUtil.closeQuietly((Statement)c1);
        SQLUtil.closeQuietly(c2);
        return grants;
    }

    private List<String> replaceModelUserInGrants(String userName, String modelUser, List<String> grants) {
        ArrayList<String> newGrants = new ArrayList<String>();
        for (String grant : grants) {
            String newGrant = grant.replaceAll("'" + modelUser + "'", "'" + userName + "'");
            newGrant = newGrant.replaceAll("IDENTIFIED BY PASSWORD '.*'", "IDENTIFIED BY ?");
            newGrants.add(newGrant);
        }
        return newGrants;
    }

    private void grantingRights(List<String> grants, String userName, GuardedString password) {
        for (String grant : grants) {
            final PreparedStatement[] psa = new PreparedStatement[1];
            try {
                psa[0] = this.conn.getConnection().prepareStatement(grant);
                log.info("Granting rights {0} for user: {1}", new Object[]{userName, grant});
                if (grant.indexOf("IDENTIFIED BY ?") > 0) {
                    password.access(new GuardedString.Accessor(){

                        public void access(char[] clearChars) {
                            try {
                                psa[0].setObject(1, new String(clearChars));
                            }
                            catch (SQLException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                psa[0].execute();
            }
            catch (SQLException e) {
                log.error((Throwable)e, "Error granting rights {0} for user: {1}", new Object[]{userName, grant});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
                throw ConnectorException.wrap((Throwable)e);
            }
            finally {
                SQLUtil.closeQuietly((Statement)psa[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUser(Uid uid) {
        block8: {
            String SQL_SHOW_MODEL_USERS = "SELECT host FROM mysql.user WHERE user = ?";
            String SQL_DELETE_TEMPLATE = "DROP USER ?";
            PreparedStatement ps1 = null;
            PreparedStatement ps2 = null;
            ResultSet rs1 = null;
            try {
                ps1 = this.conn.getConnection().prepareStatement("SELECT host FROM mysql.user WHERE user = ?");
                ps1.setString(1, uid.getUidValue());
                rs1 = ps1.executeQuery();
                boolean unknown = true;
                while (rs1.next()) {
                    unknown = false;
                    StringBuilder query = new StringBuilder("DROP USER ?");
                    String host = rs1.getString(1);
                    if (host != null && !host.equals("") && !host.equals("%")) {
                        query.append("@" + host);
                    }
                    ps2 = this.conn.getConnection().prepareStatement(query.toString());
                    ps2.setString(1, uid.getUidValue());
                    log.info("Deleting Uid: {0}, host:{1}", new Object[]{uid.getUidValue(), host});
                    ps2.execute();
                }
                if (unknown) {
                    throw new UnknownUidException(uid, ObjectClass.ACCOUNT);
                }
                SQLUtil.closeQuietly((ResultSet)rs1);
            }
            catch (SQLException e) {
                this.deleteUser41(uid);
                break block8;
            }
            finally {
                SQLUtil.closeQuietly(rs1);
                SQLUtil.closeQuietly((Statement)ps1);
                SQLUtil.closeQuietly(ps2);
            }
            SQLUtil.closeQuietly((Statement)ps1);
            SQLUtil.closeQuietly(ps2);
        }
        log.ok("Deleted Uid: {0}", new Object[]{uid.getUidValue()});
    }

    private void deleteUser41(Uid uid) {
        String SQL_DELETE_USERS = "DELETE FROM user WHERE User=?";
        String SQL_DELETE_DB = "DELETE FROM db WHERE User=?";
        String SQL_DELETE_TABLES = "DELETE FROM tables_priv WHERE User=?";
        String SQL_DELETE_COLUMNS = "DELETE FROM columns_priv WHERE User=?";
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        PreparedStatement ps3 = null;
        PreparedStatement ps4 = null;
        try {
            ps1 = this.conn.getConnection().prepareStatement("DELETE FROM user WHERE User=?");
            ps1.setString(1, uid.getUidValue());
            ps1.execute();
            ps2 = this.conn.getConnection().prepareStatement("DELETE FROM db WHERE User=?");
            ps2.setString(1, uid.getUidValue());
            ps2.execute();
            ps3 = this.conn.getConnection().prepareStatement("DELETE FROM tables_priv WHERE User=?");
            ps3.setString(1, uid.getUidValue());
            ps3.execute();
            ps4 = this.conn.getConnection().prepareStatement("DELETE FROM columns_priv WHERE User=?");
            ps4.setString(1, uid.getUidValue());
            ps4.execute();
            this.flushPriviledges();
        }
        catch (SQLException e) {
            try {
                SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
                log.error((Throwable)e, "delete user 41", new Object[0]);
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(ps1);
                SQLUtil.closeQuietly(ps2);
                SQLUtil.closeQuietly(ps3);
                SQLUtil.closeQuietly(ps4);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((Statement)ps1);
        SQLUtil.closeQuietly((Statement)ps2);
        SQLUtil.closeQuietly((Statement)ps3);
        SQLUtil.closeQuietly((Statement)ps4);
        log.ok("Deleted Uid: {0}", new Object[]{uid.getUidValue()});
    }

    private void updateUser(String updstr, List<SQLParam> values) {
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.getConnection().prepareStatement(updstr);
            SQLUtil.setParams((PreparedStatement)stmt, values);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
                log.error((Throwable)e, "SQL: " + updstr, new Object[0]);
                throw ConnectorException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(stmt);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((Statement)stmt);
        this.flushPriviledges();
    }

    private void flushPriviledges() {
        String FLUSH_PRIVILEGES = "FLUSH PRIVILEGES";
        PreparedStatement cstmt = null;
        try {
            cstmt = this.conn.getConnection().prepareStatement("FLUSH PRIVILEGES");
            cstmt.execute();
        }
        catch (SQLException e) {
            try {
                SQLUtil.rollbackQuietly((DatabaseConnection)this.conn);
                log.error((Throwable)e, "SQL: FLUSH PRIVILEGES", new Object[0]);
                throw ConnectorException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(cstmt);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((Statement)cstmt);
    }

    private Uid newUid(String userName) {
        return new Uid(userName);
    }
}

