/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.mysqluser;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.dbcommon.DatabaseConnection;
import org.identityconnectors.dbcommon.JNDIUtil;
import org.identityconnectors.dbcommon.SQLUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.mysqluser.MySQLUserConfiguration;

public class MySQLUserConnection
extends DatabaseConnection {
    private static final Log log = Log.getLog(MySQLUserConnection.class);
    private MySQLUserConfiguration config;

    private MySQLUserConnection(MySQLUserConfiguration config, Connection conn) {
        super(conn);
        this.config = config;
    }

    public void test() {
        String VALIDATE_CONNECTION = "FLUSH STATUS";
        PreparedStatement stmt = null;
        try {
            log.info("Test connection using {0}", new Object[]{"FLUSH STATUS"});
            stmt = this.getConnection().prepareStatement("FLUSH STATUS");
            stmt.execute();
        }
        catch (Exception ex) {
            try {
                log.error("Test connection fail with {0}", new Object[]{ex.getMessage()});
                SQLUtil.rollbackQuietly((Connection)this.getConnection());
                throw ConnectorException.wrap((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(stmt);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((Statement)stmt);
    }

    static MySQLUserConnection getConnection(MySQLUserConfiguration config) {
        Connection connection = MySQLUserConnection.getNativeConnection(config);
        return new MySQLUserConnection(config, connection);
    }

    private static Connection getNativeConnection(MySQLUserConfiguration config) {
        Connection connection;
        String user = config.getUser();
        GuardedString password = config.getPassword();
        String datasource = config.getDatasource();
        if (StringUtil.isNotBlank((String)datasource)) {
            String[] jndiProperties = config.getJndiProperties();
            ConnectorMessages connectorMessages = config.getConnectorMessages();
            Hashtable prop = JNDIUtil.arrayToHashtable((String[])jndiProperties, (ConnectorMessages)connectorMessages);
            connection = StringUtil.isNotBlank((String)user) && password != null ? SQLUtil.getDatasourceConnection((String)datasource, (String)user, (GuardedString)password, (Hashtable)prop) : SQLUtil.getDatasourceConnection((String)datasource, (Hashtable)prop);
        } else {
            connection = SQLUtil.getDriverMangerConnection((String)config.getDriver(), (String)MySQLUserConfiguration.getUrlString(config.getHost(), config.getPort()), (String)config.getUser(), (GuardedString)config.getPassword());
        }
        try {
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
        }
        catch (SQLException expected) {
            log.error((Throwable)expected, "Could not disable auto-commit mode", new Object[0]);
        }
        return connection;
    }

    void closeConnection() {
        if (this.getConnection() != null && StringUtil.isNotBlank((String)this.config.getDatasource())) {
            log.info("Close the connection", new Object[0]);
            this.dispose();
        }
    }

    void openConnection() throws SQLException {
        if (this.getConnection() == null || this.getConnection().isClosed()) {
            log.info("Get new connection, it is closed", new Object[0]);
            this.setConnection(MySQLUserConnection.getNativeConnection(this.config));
        }
    }
}

