/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.mysqluser;

import java.text.MessageFormat;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.dbcommon.JNDIUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public class MySQLUserConfiguration
extends AbstractConfiguration {
    private String datasource = "";
    private String[] jndiProperties;
    private String driver = "com.mysql.jdbc.Driver";
    private String host = "";
    private String user = "";
    private GuardedString password;
    private String port = "3306";
    private String usermodel = "idm";

    @ConfigurationProperty(order=1, helpMessageKey="MYSQL_DATASOURCE_HELP", displayMessageKey="MYSQL_DATASOURCE_DISLPAY")
    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    @ConfigurationProperty(order=2, helpMessageKey="MYSQL_JNDI_PROPERTIES_HELP", displayMessageKey="MYSQL_JNDI_PROPERTIES_DISPLAY")
    public String[] getJndiProperties() {
        return this.jndiProperties;
    }

    public void setJndiProperties(String[] jndiProperties) {
        this.jndiProperties = jndiProperties;
    }

    @ConfigurationProperty(order=4, helpMessageKey="MYSQL_DRIVER_HELP", displayMessageKey="MYSQL_DRIVER_DISPLAY")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @ConfigurationProperty(order=5, helpMessageKey="MYSQL_HOST_HELP", displayMessageKey="MYSQL_HOST_DISPLAY")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @ConfigurationProperty(order=6, helpMessageKey="MYSQL_USER_HELP", displayMessageKey="MYSQL_USER_DISPLAY")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @ConfigurationProperty(order=7, helpMessageKey="MYSQL_PWD_HELP", displayMessageKey="MYSQL_PWD_DISPLAY", confidential=true)
    public GuardedString getPassword() {
        return this.password;
    }

    public void setPassword(GuardedString password) {
        this.password = password;
    }

    @ConfigurationProperty(order=8, helpMessageKey="MYSQL_PORT_HELP", displayMessageKey="MYSQL_PORT_DISPLAY")
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @ConfigurationProperty(order=9, required=true, helpMessageKey="MYSQL_USERMODEL_HELP", displayMessageKey="MYSQL_USERMODEL_DISPLAY")
    public String getUsermodel() {
        return this.usermodel;
    }

    public void setUsermodel(String usermodel) {
        this.usermodel = usermodel;
    }

    public void validate() {
        Assertions.blankCheck((String)this.getUsermodel(), (String)"usermodel");
        if (StringUtil.isBlank((String)this.getUsermodel())) {
            throw new IllegalArgumentException(this.getMessage("user.model.blank"));
        }
        if (StringUtil.isBlank((String)this.getDatasource())) {
            if (StringUtil.isBlank((String)this.getUser())) {
                throw new IllegalArgumentException(this.getMessage("user.blank"));
            }
            if (this.getPassword() == null) {
                throw new IllegalArgumentException(this.getMessage("password.blank"));
            }
            if (StringUtil.isBlank((String)this.getHost())) {
                throw new IllegalArgumentException(this.getMessage("host.blank"));
            }
            if (StringUtil.isBlank((String)this.getPort())) {
                throw new IllegalArgumentException(this.getMessage("port.blank"));
            }
            if (StringUtil.isBlank((String)this.getDriver())) {
                throw new IllegalArgumentException(this.getMessage("jdbc.driver.blank"));
            }
            try {
                Class.forName(this.getDriver());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(this.getMessage("jdbc.driver.not.found"));
            }
        } else {
            JNDIUtil.arrayToHashtable((String[])this.getJndiProperties(), (ConnectorMessages)this.getConnectorMessages());
        }
    }

    public String getMessage(String key) {
        return this.getConnectorMessages().format(key, key, new Object[0]);
    }

    public String getMessage(String key, Object ... objects) {
        return this.getConnectorMessages().format(key, key, objects);
    }

    public static String getUrlString(String host, String port) {
        String URL_TEMPLATE = "jdbc:mysql://{0}:{1}/mysql";
        String url = null;
        try {
            url = MessageFormat.format("jdbc:mysql://{0}:{1}/mysql", host, port);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
        return url;
    }
}

