/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.Account;
import com.evolveum.midpoint.model.GenericEntityBase;
import com.evolveum.midpoint.model.Property;
import com.evolveum.midpoint.model.Resource;
import com.evolveum.midpoint.model.ResourceAccessConfiguration;
import com.evolveum.midpoint.model.ResourceObjectShadow;
import com.evolveum.midpoint.model.ResourceState;
import com.evolveum.midpoint.model.SimpleDomainObject;
import com.evolveum.midpoint.model.StringProperty;
import com.evolveum.midpoint.model.User;
import com.evolveum.midpoint.model.UserTemplate;
import com.evolveum.midpoint.repo.PagingRepositoryType;
import com.evolveum.midpoint.repo.spring.GenericDao;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.Utils;
import com.evolveum.midpoint.util.jaxb.JAXBUtil;
import com.evolveum.midpoint.util.patch.PatchException;
import com.evolveum.midpoint.util.patch.PatchXml;
import com.evolveum.midpoint.util.patch.PatchingListener;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.Configuration;
import com.evolveum.midpoint.xml.ns._public.common.common_1.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ExtensibleObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.Extension;
import com.evolveum.midpoint.xml.ns._public.common.common_1.FaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.GenericObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.IllegalArgumentFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectAlreadyExistsFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectNotFoundFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyAvailableValuesListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.QueryType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ReferentialIntegrityFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceAccessConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceStateType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SchemaHandlingType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ScriptsType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UnsupportedObjectTypeFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserTemplateType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage;
import com.evolveum.midpoint.xml.ns._public.repository.repository_1.RepositoryPortType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
@Transactional
public class RepositoryService
implements RepositoryPortType {
    Trace logger = TraceManager.getTrace(RepositoryService.class);
    @Autowired(required=true)
    private GenericDao genericDao;
    ObjectFactory objectFactory = new ObjectFactory();

    private void addExtensionProperty(ExtensibleObjectType objectType, Property property) throws DOMException {
        Extension extension = objectType.getExtension();
        if (null == extension) {
            extension = new Extension();
            objectType.setExtension(extension);
        }
        Document doc = DOMUtil.parseDocument((String)((String)property.getPropertyValue()));
        extension.getAny().add((Element)doc.getFirstChild());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void storeOrImport(SimpleDomainObject entity) throws FaultMessage {
        if (null != entity.getOid()) {
            if (null != this.genericDao.findById(entity.getOid())) throw new FaultMessage("Could not import, because object with oid '" + entity.getOid() + "' already exists in store", (FaultType)new ObjectAlreadyExistsFaultType());
            this.genericDao.persist(entity);
            return;
        } else {
            this.genericDao.persist(entity);
        }
    }

    private void copyExtensionToProperties(List<Element> extension, List<Property> properties) {
        for (Element element : extension) {
            StringProperty property = new StringProperty();
            property.setPropertyName(element.getNamespaceURI() + ":" + element.getLocalName());
            property.setPropertyValue(DOMUtil.serializeDOMToString((Node)element));
            this.addOrReplaceProperty(properties, property);
        }
    }

    private void copyGenericEntityToGenericOjectType(GenericEntityBase genericEntity, GenericObjectType genericObjectType) {
        Utils.copyPropertiesSilent((Object)genericObjectType, (Object)genericEntity);
        for (Property property : genericEntity.getProperties()) {
            this.addExtensionProperty((ExtensibleObjectType)genericObjectType, property);
        }
    }

    private void copyGenericObjectTypeToGenericEntity(GenericObjectType genericObjectType, GenericEntityBase genericEntity) {
        List<Property> properties;
        String oid = genericObjectType.getOid();
        genericObjectType.setOid(null);
        Utils.copyPropertiesSilent((Object)genericEntity, (Object)genericObjectType);
        if (null != oid) {
            genericEntity.setOid(UUID.fromString(oid));
        }
        genericObjectType.setOid(oid);
        if (null == genericEntity.getProperties()) {
            properties = new LinkedList<Property>();
            genericEntity.setProperties(properties);
        } else {
            properties = genericEntity.getProperties();
        }
        if (null != genericObjectType.getExtension()) {
            List extension = genericObjectType.getExtension().getAny();
            this.copyExtensionToProperties(extension, properties);
        }
    }

    private void copyUserToUserType(User user, UserType userType) throws FaultMessage {
        Utils.copyPropertiesSilent((Object)userType, (Object)user);
        Set<Account> accounts = user.getAccounts();
        ArrayList<AccountShadowType> accountShadowTypeList = new ArrayList<AccountShadowType>();
        ArrayList<ObjectReferenceType> accountsRef = new ArrayList<ObjectReferenceType>();
        for (Account account : accounts) {
            AccountShadowType accountType = new AccountShadowType();
            this.copyAccountToAccountShadowType(account, accountType);
            accountShadowTypeList.add(accountType);
            ObjectReferenceType objectReferenceType = new ObjectReferenceType();
            objectReferenceType.setOid(String.valueOf(account.getOid()));
            objectReferenceType.setType(SchemaConstants.I_ACCOUNT_REF);
            accountsRef.add(objectReferenceType);
        }
        userType.getAccountRef().addAll(accountsRef);
        for (Property property : user.getProperties()) {
            if ("credentials".equals(property.getPropertyName())) {
                CredentialsType credentials;
                try {
                    credentials = (CredentialsType)((JAXBElement)JAXBUtil.unmarshal((String)((String)property.getPropertyValue()))).getValue();
                }
                catch (JAXBException ex) {
                    this.logger.error("Failed to unmarshal", (Throwable)ex);
                    throw new FaultMessage("Failed to unmarshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
                }
                userType.setCredentials(credentials);
                continue;
            }
            this.addExtensionProperty((ExtensibleObjectType)userType, property);
        }
    }

    private void copyUserTypeToUser(UserType userType, User user) throws FaultMessage {
        List<Property> properties;
        String oid = userType.getOid();
        userType.setOid(null);
        Utils.copyPropertiesSilent((Object)user, (Object)userType);
        if (null != oid) {
            user.setOid(UUID.fromString(oid));
        }
        userType.setOid(oid);
        if (null == user.getProperties()) {
            properties = new LinkedList<Property>();
            user.setProperties(properties);
        } else {
            properties = user.getProperties();
        }
        if (null != userType.getExtension()) {
            List extension = userType.getExtension().getAny();
            this.copyExtensionToProperties(extension, properties);
        }
        try {
            CredentialsType credentials = userType.getCredentials();
            if (null != credentials) {
                StringProperty credentialsProperty = new StringProperty();
                credentialsProperty.setPropertyName("credentials");
                credentialsProperty.setPropertyValue(JAXBUtil.marshalWrap((Object)credentials, (QName)SchemaConstants.I_CREDENTIALS));
                this.addOrReplaceProperty(properties, credentialsProperty);
            }
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshal", (Throwable)ex);
            throw new FaultMessage("Failed to marshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
        }
    }

    private void copyAccountToAccountShadowType(Account account, AccountShadowType accountShadowType) throws FaultMessage {
        Resource resource = account.getResource();
        Map<String, String> attributes = account.getAttributes();
        String objectClass = account.getObjectClass();
        account.setResource(null);
        account.setAttributes(null);
        account.setObjectClass(null);
        Utils.copyPropertiesSilent((Object)accountShadowType, (Object)account);
        account.setResource(resource);
        account.setAttributes(attributes);
        account.setObjectClass(objectClass);
        ObjectReferenceType objectReferenceType = new ObjectReferenceType();
        objectReferenceType.setOid(String.valueOf(resource.getOid()));
        accountShadowType.setResourceRef(objectReferenceType);
        ArrayList<Element> attributesType = new ArrayList<Element>();
        for (String attributeName : attributes.keySet()) {
            String attributeValue = attributes.get(attributeName);
            String attributeNamespace = attributeName.substring(0, attributeName.lastIndexOf(":"));
            attributeName = attributeName.substring(attributeName.lastIndexOf(":") + 1);
            Document doc = DOMUtil.getDocument();
            doc.setDocumentURI(attributeNamespace);
            Element node = doc.createElementNS(attributeNamespace, "ns66:" + attributeName);
            node.setTextContent(attributeValue);
            doc.appendChild(node);
            attributesType.add(doc.getDocumentElement());
        }
        ResourceObjectShadowType.Attributes rost = new ResourceObjectShadowType.Attributes();
        rost.getAny().addAll(attributesType);
        accountShadowType.setAttributes(rost);
        objectClass = account.getObjectClass();
        String objectClassNamespace = StringUtils.substring((String)objectClass, (int)0, (int)StringUtils.lastIndexOf((String)objectClass, (String)":"));
        String objectClassName = StringUtils.substring((String)objectClass, (int)(StringUtils.lastIndexOf((String)objectClass, (String)":") + 1));
        accountShadowType.setObjectClass(new QName(objectClassNamespace, objectClassName));
        for (Property property : account.getProperties()) {
            CredentialsType credentials;
            if (!"credentials".equals(property.getPropertyName())) continue;
            try {
                credentials = (CredentialsType)((JAXBElement)JAXBUtil.unmarshal((String)((String)property.getPropertyValue()))).getValue();
            }
            catch (JAXBException ex) {
                this.logger.error("Failed to unmarshal", (Throwable)ex);
                throw new FaultMessage("Failed to unmarshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
            }
            accountShadowType.setCredentials(credentials);
        }
    }

    private void copyResourceObjectShadowToResourceObjectShadowType(ResourceObjectShadow account, ResourceObjectShadowType accountShadowType) throws FaultMessage {
        Resource resource = account.getResource();
        Map<String, String> attributes = account.getAttributes();
        String objectClass = account.getObjectClass();
        account.setResource(null);
        account.setAttributes(null);
        account.setObjectClass(null);
        Utils.copyPropertiesSilent((Object)accountShadowType, (Object)account);
        account.setResource(resource);
        account.setAttributes(attributes);
        account.setObjectClass(objectClass);
        ObjectReferenceType objectReferenceType = new ObjectReferenceType();
        objectReferenceType.setOid(String.valueOf(resource.getOid()));
        accountShadowType.setResourceRef(objectReferenceType);
        ArrayList<Element> attributesType = new ArrayList<Element>();
        for (String attributeName : attributes.keySet()) {
            String attributeValue = attributes.get(attributeName);
            String attributeNamespace = attributeName.substring(0, attributeName.lastIndexOf(":"));
            attributeName = attributeName.substring(attributeName.lastIndexOf(":") + 1);
            Document doc = DOMUtil.getDocument();
            doc.setDocumentURI(attributeNamespace);
            Element node = doc.createElementNS(attributeNamespace, "ns66:" + attributeName);
            node.setTextContent(attributeValue);
            doc.appendChild(node);
            attributesType.add(doc.getDocumentElement());
        }
        ResourceObjectShadowType.Attributes rost = new ResourceObjectShadowType.Attributes();
        rost.getAny().addAll(attributesType);
        accountShadowType.setAttributes(rost);
        objectClass = account.getObjectClass();
        String objectClassNamespace = StringUtils.substring((String)objectClass, (int)0, (int)StringUtils.lastIndexOf((String)objectClass, (String)":"));
        String objectClassName = StringUtils.substring((String)objectClass, (int)(StringUtils.lastIndexOf((String)objectClass, (String)":") + 1));
        accountShadowType.setObjectClass(new QName(objectClassNamespace, objectClassName));
    }

    private void copyAccountShadowTypeToAccount(AccountShadowType accountShadowType, Account account) throws FaultMessage {
        List<Property> properties;
        ResourceObjectShadowType.Attributes attributesType = accountShadowType.getAttributes();
        accountShadowType.setAttributes(null);
        String oid = accountShadowType.getOid();
        accountShadowType.setOid(null);
        QName objectClass = accountShadowType.getObjectClass();
        Utils.copyPropertiesSilent((Object)account, (Object)accountShadowType);
        if (null != oid) {
            account.setOid(UUID.fromString(oid));
        }
        accountShadowType.setAttributes(attributesType);
        accountShadowType.setOid(oid);
        accountShadowType.setObjectClass(objectClass);
        if (null != accountShadowType.getExtension()) {
            List extension = accountShadowType.getExtension().getAny();
            LinkedList<Property> properties2 = new LinkedList<Property>();
            this.copyExtensionToProperties(extension, properties2);
            account.setProperties(properties2);
        }
        HashMap<String, String> attributes = new HashMap<String, String>(0);
        if (null != attributesType) {
            for (Element object : attributesType.getAny()) {
                Element element = object;
                if (null != element.getNamespaceURI()) {
                    attributes.put(element.getNamespaceURI() + ":" + element.getLocalName(), element.getTextContent());
                    continue;
                }
                attributes.put(element.getLocalName(), element.getTextContent());
            }
        }
        account.setAttributes(attributes);
        ObjectReferenceType resourceRef = accountShadowType.getResourceRef();
        SimpleDomainObject resource = this.genericDao.findById(UUID.fromString(resourceRef.getOid()));
        account.setResource((Resource)resource);
        String objectClassString = objectClass.getNamespaceURI() + ":" + objectClass.getLocalPart();
        account.setObjectClass(objectClassString);
        if (null == account.getProperties()) {
            properties = new LinkedList<Property>();
            account.setProperties(properties);
        } else {
            properties = account.getProperties();
        }
        try {
            CredentialsType credentials = accountShadowType.getCredentials();
            if (null != credentials) {
                StringProperty credentialsProperty = new StringProperty();
                credentialsProperty.setPropertyName("credentials");
                credentialsProperty.setPropertyValue(JAXBUtil.marshalWrap((Object)credentials, (QName)SchemaConstants.I_CREDENTIALS));
                this.addOrReplaceProperty(properties, credentialsProperty);
            }
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshal", (Throwable)ex);
            throw new FaultMessage("Failed to marshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
        }
    }

    private void copyResourceObjectShadowTypeToResourceObjectShadow(ResourceObjectShadowType accountShadowType, ResourceObjectShadow account) {
        ResourceObjectShadowType.Attributes attributesType = accountShadowType.getAttributes();
        accountShadowType.setAttributes(null);
        String oid = accountShadowType.getOid();
        if (null != oid) {
            account.setOid(UUID.fromString(oid));
        }
        accountShadowType.setOid(null);
        QName objectClass = accountShadowType.getObjectClass();
        Utils.copyPropertiesSilent((Object)account, (Object)accountShadowType);
        accountShadowType.setAttributes(attributesType);
        accountShadowType.setOid(oid);
        accountShadowType.setObjectClass(objectClass);
        if (null != accountShadowType.getExtension()) {
            List extension = accountShadowType.getExtension().getAny();
            LinkedList<Property> properties = new LinkedList<Property>();
            this.copyExtensionToProperties(extension, properties);
            account.setProperties(properties);
        }
        HashMap<String, String> attributes = new HashMap<String, String>(0);
        if (null != attributesType) {
            for (Element object : attributesType.getAny()) {
                Element element = object;
                if (null != element.getNamespaceURI()) {
                    attributes.put(element.getNamespaceURI() + ":" + element.getLocalName(), element.getTextContent());
                    continue;
                }
                attributes.put(element.getLocalName(), element.getTextContent());
            }
        }
        account.setAttributes(attributes);
        ObjectReferenceType resourceRef = accountShadowType.getResourceRef();
        SimpleDomainObject resource = this.genericDao.findById(UUID.fromString(resourceRef.getOid()));
        account.setResource((Resource)resource);
        String objectClassString = objectClass.getNamespaceURI() + ":" + objectClass.getLocalPart();
        account.setObjectClass(objectClassString);
    }

    private void copyResourceToResourceType(Resource resource, ResourceType resourceType) throws FaultMessage {
        Utils.copyPropertiesSilent((Object)resourceType, (Object)resource);
        for (Property property : resource.getProperties()) {
            this.logger.trace("(String) property.getPropertyValue() = {}", (Object)((String)property.getPropertyValue()));
            if ("schema".equals(property.getPropertyName())) {
                if (!StringUtils.isNotEmpty((String)((String)property.getPropertyValue()))) continue;
                Document doc = DOMUtil.parseDocument((String)((String)property.getPropertyValue()));
                ResourceType.Schema schema = new ResourceType.Schema();
                ArrayList<Element> any = new ArrayList<Element>();
                any.add(doc.getDocumentElement());
                schema.getAny().addAll(any);
                resourceType.setSchema(schema);
                continue;
            }
            if ("schemaHandling".equals(property.getPropertyName())) {
                try {
                    JAXBElement rsht = (JAXBElement)JAXBUtil.unmarshal((String)((String)property.getPropertyValue()));
                    resourceType.setSchemaHandling((SchemaHandlingType)rsht.getValue());
                    continue;
                }
                catch (JAXBException ex) {
                    this.logger.error("Failed to unmarshal", (Throwable)ex);
                    throw new FaultMessage("Failed to unmarshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
                }
            }
            if ("configuration".equals(property.getPropertyName())) {
                try {
                    Configuration configuration = (Configuration)JAXBUtil.unmarshal((String)((String)property.getPropertyValue()));
                    resourceType.setConfiguration(configuration);
                    continue;
                }
                catch (JAXBException ex) {
                    this.logger.error("Failed to unmarshal", (Throwable)ex);
                    throw new FaultMessage("Failed to unmarshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
                }
            }
            if ("synchronization".equals(property.getPropertyName())) {
                try {
                    JAXBElement jaxbSynchronization = (JAXBElement)JAXBUtil.unmarshal((String)((String)property.getPropertyValue()));
                    if (null != jaxbSynchronization) {
                        resourceType.setSynchronization((SynchronizationType)jaxbSynchronization.getValue());
                        continue;
                    }
                    resourceType.setSynchronization(null);
                    continue;
                }
                catch (JAXBException ex) {
                    this.logger.error("Failed to unmarshal", (Throwable)ex);
                    throw new FaultMessage("Failed to unmarshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
                }
            }
            if ("scripts".equals(property.getPropertyName())) {
                try {
                    JAXBElement jaxbScripts = (JAXBElement)JAXBUtil.unmarshal((String)((String)property.getPropertyValue()));
                    if (null != jaxbScripts) {
                        resourceType.setScripts((ScriptsType)jaxbScripts.getValue());
                        continue;
                    }
                    resourceType.setScripts(null);
                    continue;
                }
                catch (JAXBException ex) {
                    this.logger.error("Failed to unmarshal", (Throwable)ex);
                    throw new FaultMessage("Failed to unmarshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
                }
            }
            if ("resourceAccessConfigurationRef".equals(property.getPropertyName())) continue;
            this.addExtensionProperty((ExtensibleObjectType)resourceType, property);
        }
    }

    private void copyResourceAccessConfigurationToResourceAccessConfiguration(ResourceAccessConfiguration resource, ResourceAccessConfigurationType resourceType) throws FaultMessage {
        Utils.copyPropertiesSilent((Object)resourceType, (Object)resource);
        for (Property property : resource.getProperties()) {
            this.logger.trace("(String) property.getPropertyValue() = {}", (Object)((String)property.getPropertyValue()));
            if ("schema".equals(property.getPropertyName())) {
                Document doc = DOMUtil.parseDocument((String)((String)property.getPropertyValue()));
                ResourceAccessConfigurationType.Schema schema = new ResourceAccessConfigurationType.Schema();
                ArrayList<Element> any = new ArrayList<Element>();
                any.add(doc.getDocumentElement());
                schema.getAny().addAll(any);
                resourceType.setSchema(schema);
                continue;
            }
            if ("schemaHandling".equals(property.getPropertyName())) {
                try {
                    SchemaHandlingType rsht = null;
                    Object o = JAXBUtil.unmarshal((String)((String)property.getPropertyValue()));
                    if (o instanceof SchemaHandlingType) {
                        rsht = (SchemaHandlingType)o;
                    } else if (o instanceof JAXBElement) {
                        rsht = (SchemaHandlingType)((JAXBElement)o).getValue();
                    } else {
                        throw new AssertionError((Object)("Unexpected type " + o.getClass()));
                    }
                    resourceType.setSchemaHandling(rsht);
                    continue;
                }
                catch (JAXBException ex) {
                    this.logger.error("Failed to unmarshal", (Throwable)ex);
                    throw new FaultMessage("Failed to unmarshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
                }
            }
            if ("configuration".equals(property.getPropertyName())) {
                try {
                    Configuration configuration = (Configuration)JAXBUtil.unmarshal((String)((String)property.getPropertyValue()));
                    resourceType.setConfiguration(configuration);
                    continue;
                }
                catch (JAXBException ex) {
                    this.logger.error("Failed to unmarshal", (Throwable)ex);
                    throw new FaultMessage("Failed to unmarshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
                }
            }
            if (!"namespace".equals(property.getPropertyName())) continue;
            resourceType.setNamespace((String)property.getPropertyValue());
        }
    }

    private void copyResourceAccessConfigurationTypeToResourceAccessConfiguration(ResourceAccessConfigurationType resourceType, ResourceAccessConfiguration resource) throws FaultMessage {
        ResourceAccessConfigurationType.Schema schema;
        String oid = resourceType.getOid();
        resourceType.setOid(null);
        Utils.copyPropertiesSilent((Object)resource, (Object)resourceType);
        if (null != oid) {
            resource.setOid(UUID.fromString(oid));
        }
        resourceType.setOid(oid);
        LinkedList<Property> properties = new LinkedList<Property>();
        resource.setProperties(properties);
        StringProperty namespaceProperty = new StringProperty();
        namespaceProperty.setPropertyName("namespace");
        namespaceProperty.setPropertyValue(resourceType.getNamespace());
        this.addOrReplaceProperty(properties, namespaceProperty);
        if (null != resourceType.getExtension()) {
            List extension = resourceType.getExtension().getAny();
            this.copyExtensionToProperties(extension, properties);
        }
        if ((schema = resourceType.getSchema()) != null && !schema.getAny().isEmpty()) {
            Document doc = DOMUtil.getDocument();
            Iterator i$ = schema.getAny().iterator();
            while (i$.hasNext()) {
                Element object;
                Element element = object = (Element)i$.next();
                Node node = doc.importNode(element, true);
                doc.appendChild(node);
            }
            StringProperty schemaProperty = new StringProperty();
            schemaProperty.setPropertyName("schema");
            schemaProperty.setPropertyValue(DOMUtil.serializeDOMToString((Node)doc));
            this.addOrReplaceProperty(properties, schemaProperty);
        }
        try {
            SchemaHandlingType rsht = resourceType.getSchemaHandling();
            StringProperty schemaHandlingProperty = new StringProperty();
            schemaHandlingProperty.setPropertyName("schemaHandling");
            schemaHandlingProperty.setPropertyValue(JAXBUtil.marshal((Object)rsht));
            this.addOrReplaceProperty(properties, schemaHandlingProperty);
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshal", (Throwable)ex);
            throw new FaultMessage("Failed to marshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
        }
        try {
            Configuration configuration = resourceType.getConfiguration();
            StringProperty configurationProperty = new StringProperty();
            configurationProperty.setPropertyName("configuration");
            configurationProperty.setPropertyValue(JAXBUtil.marshal((Object)configuration));
            this.addOrReplaceProperty(properties, configurationProperty);
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshal", (Throwable)ex);
            throw new FaultMessage("Failed to marshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
        }
        this.logger.trace("properties.size() = " + properties.size());
        for (Property property : properties) {
            this.logger.trace("Property name {}, value {}", (Object)property.getPropertyName(), property.getPropertyValue());
        }
    }

    private void copyResourceTypeToResource(ResourceType resourceType, Resource resource) throws FaultMessage {
        ResourceType.Schema schema;
        List<Property> properties;
        String oid = resourceType.getOid();
        resourceType.setOid(null);
        Utils.copyPropertiesSilent((Object)resource, (Object)resourceType);
        if (null != oid) {
            resource.setOid(UUID.fromString(oid));
        }
        resourceType.setOid(oid);
        if (null == resource.getProperties()) {
            properties = new LinkedList<Property>();
            resource.setProperties(properties);
        } else {
            properties = resource.getProperties();
        }
        if (null != resourceType.getExtension()) {
            List extension = resourceType.getExtension().getAny();
            this.copyExtensionToProperties(extension, properties);
        }
        if ((schema = resourceType.getSchema()) != null && !schema.getAny().isEmpty()) {
            Document doc = DOMUtil.getDocument();
            Iterator i$ = schema.getAny().iterator();
            while (i$.hasNext()) {
                Element object;
                Element element = object = (Element)i$.next();
                Node node = doc.importNode(element, true);
                doc.appendChild(node);
            }
            StringProperty schemaProperty = new StringProperty();
            schemaProperty.setPropertyName("schema");
            schemaProperty.setPropertyValue(DOMUtil.serializeDOMToString((Node)doc));
            this.addOrReplaceProperty(properties, schemaProperty);
        } else {
            StringProperty schemaProperty = new StringProperty();
            schemaProperty.setPropertyName("schema");
            schemaProperty.setPropertyValue(null);
            this.addOrReplaceProperty(properties, schemaProperty);
        }
        try {
            SchemaHandlingType rsht = resourceType.getSchemaHandling();
            StringProperty schemaHandlingProperty = new StringProperty();
            schemaHandlingProperty.setPropertyName("schemaHandling");
            schemaHandlingProperty.setPropertyValue(JAXBUtil.marshal((Object)this.objectFactory.createSchemaHandling(rsht)));
            this.addOrReplaceProperty(properties, schemaHandlingProperty);
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshal", (Throwable)ex);
            throw new FaultMessage("Failed to marshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
        }
        try {
            Configuration configuration = resourceType.getConfiguration();
            StringProperty configurationProperty = new StringProperty();
            configurationProperty.setPropertyName("configuration");
            configurationProperty.setPropertyValue(JAXBUtil.marshal((Object)configuration));
            this.addOrReplaceProperty(properties, configurationProperty);
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshal", (Throwable)ex);
            throw new FaultMessage("Failed to marshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
        }
        try {
            StringProperty synchronizationProperty;
            SynchronizationType synchronization = resourceType.getSynchronization();
            if (null != synchronization) {
                synchronizationProperty = new StringProperty();
                synchronizationProperty.setPropertyName("synchronization");
                synchronizationProperty.setPropertyValue(JAXBUtil.marshalWrap((Object)synchronization, (QName)SchemaConstants.I_SYNCHRONIZATION));
                this.addOrReplaceProperty(properties, synchronizationProperty);
            } else {
                synchronizationProperty = new StringProperty();
                synchronizationProperty.setPropertyName("synchronization");
                synchronizationProperty.setPropertyValue(null);
                this.addOrReplaceProperty(properties, synchronizationProperty);
            }
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshal", (Throwable)ex);
            throw new FaultMessage("Failed to marshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
        }
        try {
            StringProperty scriptsProperty;
            ScriptsType scripts = resourceType.getScripts();
            if (null != scripts) {
                scriptsProperty = new StringProperty();
                scriptsProperty.setPropertyName("scripts");
                scriptsProperty.setPropertyValue(JAXBUtil.marshalWrap((Object)scripts, (QName)SchemaConstants.I_SCRIPTS));
                this.addOrReplaceProperty(properties, scriptsProperty);
            } else {
                scriptsProperty = new StringProperty();
                scriptsProperty.setPropertyName("scripts");
                scriptsProperty.setPropertyValue(null);
                this.addOrReplaceProperty(properties, scriptsProperty);
            }
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshal", (Throwable)ex);
            throw new FaultMessage("Failed to marshal", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
        }
        this.logger.trace("properties.size() = " + properties.size());
        for (Property property : properties) {
            this.logger.trace("Property name {}, value {}", (Object)property.getPropertyName(), property.getPropertyValue());
        }
    }

    private void copyResourceStateTypeToResourceState(ResourceStateType resourceStateType, ResourceState resourceState) {
        ResourceStateType.SynchronizationState state = resourceStateType.getSynchronizationState();
        resourceStateType.setSynchronizationState(null);
        String oid = resourceStateType.getOid();
        resourceStateType.setOid(null);
        ObjectReferenceType resourceRef = resourceStateType.getResourceRef();
        Validate.notNull((Object)resourceRef, (String)("ResourceStateType object with oid = " + oid + " does not contain resource reference"));
        Utils.copyPropertiesSilent((Object)resourceState, (Object)resourceStateType);
        if (null != oid) {
            resourceState.setOid(UUID.fromString(oid));
        }
        resourceStateType.setSynchronizationState(state);
        resourceStateType.setOid(oid);
        resourceStateType.setResourceRef(resourceRef);
        String serializedState = DOMUtil.serializeDOMToString((Node)((Node)state.getAny().get(0)));
        resourceState.setState(serializedState);
        Resource resource = (Resource)this.genericDao.findById(UUID.fromString(resourceRef.getOid()));
        Validate.notNull((Object)resource, (String)("ResourceStateType object instance with oid = " + oid + " references not existing resource wit oid = " + resourceRef.getOid()));
        resourceState.setResource(resource);
    }

    private void copyResourceStateToResourceStateType(ResourceState resourceState, ResourceStateType resourceStateType) {
        Resource resource = resourceState.getResource();
        String state = resourceState.getState();
        resourceState.setResource(null);
        resourceState.setState(null);
        Utils.copyPropertiesSilent((Object)resourceStateType, (Object)resourceState);
        resourceState.setResource(resource);
        resourceState.setState(state);
        ObjectReferenceType objectReferenceType = new ObjectReferenceType();
        objectReferenceType.setOid(String.valueOf(resource.getOid()));
        resourceStateType.setResourceRef(objectReferenceType);
        ResourceStateType.SynchronizationState deserializedState = new ResourceStateType.SynchronizationState();
        deserializedState.getAny().add(DOMUtil.parseDocument((String)state).getDocumentElement());
        resourceStateType.setSynchronizationState(deserializedState);
    }

    private void copyUserTemplateTypeToUserTemplate(UserTemplateType userTemplateType, UserTemplate userTemplate) {
        userTemplate.setOid(UUID.fromString(userTemplateType.getOid()));
        userTemplate.setName(userTemplateType.getName());
        String serializedUserTemplateType = JAXBUtil.silentMarshalWrap((Object)userTemplateType, (QName)SchemaConstants.I_USER_TEMPLATE);
        userTemplate.setTemplate(serializedUserTemplateType);
    }

    private void copyUserTemplateToUserTemplateType(UserTemplate userTemplate, UserTemplateType userTemplateType) {
        try {
            UserTemplateType localUserTemplateType = (UserTemplateType)((JAXBElement)JAXBUtil.unmarshal((String)userTemplate.getTemplate())).getValue();
            userTemplateType.setName(localUserTemplateType.getName());
            userTemplateType.setExtension(localUserTemplateType.getExtension());
            userTemplateType.setOid(localUserTemplateType.getOid());
            userTemplateType.setVersion(localUserTemplateType.getVersion());
            userTemplateType.getAccountConstruction().addAll(localUserTemplateType.getAccountConstruction());
            userTemplateType.getPropertyConstruction().addAll(localUserTemplateType.getPropertyConstruction());
        }
        catch (JAXBException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void addOrReplaceProperty(List<Property> properties, Property newProperty) {
        for (Property existingProperty : properties) {
            if (!StringUtils.equals((String)existingProperty.getPropertyName(), (String)newProperty.getPropertyName())) continue;
            existingProperty.setPropertyValue(newProperty.getPropertyValue());
            return;
        }
        properties.add(newProperty);
    }

    public GenericDao getGenericDao() {
        return this.genericDao;
    }

    public void setGenericDao(GenericDao genericDao) {
        this.genericDao = genericDao;
    }

    private void modifyUser(ObjectModificationType objectChange) throws FaultMessage {
        try {
            this.logger.trace("[Repository] modifyUser begin");
            Validate.notNull((Object)objectChange);
            SimpleDomainObject user = this.genericDao.findById(UUID.fromString(objectChange.getOid()));
            UserType userType = new UserType();
            this.copyUserToUserType((User)user, userType);
            PatchXml xmlPatchTool = new PatchXml();
            RepositoryPatchingListener listener = new RepositoryPatchingListener((User)user);
            xmlPatchTool.setPatchingListener((PatchingListener)listener);
            String xmlObject = xmlPatchTool.applyDifferences(objectChange, (ObjectType)userType);
            JAXBElement jaxb = (JAXBElement)JAXBUtil.unmarshal((String)xmlObject);
            this.copyUserTypeToUser((UserType)jaxb.getValue(), (User)user);
            this.logger.trace("[Repository] modifyUser end");
        }
        catch (PatchException ex) {
            this.logger.error("Failed to patch user", (Throwable)ex);
            throw new FaultMessage(ex.getMessage(), (FaultType)new ReferentialIntegrityFaultType());
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshall user", (Throwable)ex);
            throw new FaultMessage(ex.getMessage(), (FaultType)new ReferentialIntegrityFaultType());
        }
    }

    private void modifyAccount(ObjectModificationType objectChange) throws FaultMessage {
        try {
            this.logger.trace("[Repository] modifyAccount begin");
            Validate.notNull((Object)objectChange);
            SimpleDomainObject account = this.genericDao.findById(UUID.fromString(objectChange.getOid()));
            AccountShadowType accountShadowType = new AccountShadowType();
            this.copyAccountToAccountShadowType((Account)account, accountShadowType);
            PatchXml xmlPatchTool = new PatchXml();
            String xmlObject = xmlPatchTool.applyDifferences(objectChange, (ObjectType)accountShadowType);
            JAXBElement jaxb = (JAXBElement)JAXBUtil.unmarshal((String)xmlObject);
            this.copyAccountShadowTypeToAccount((AccountShadowType)jaxb.getValue(), (Account)account);
            this.logger.trace("[Repository] modifyAccount end");
        }
        catch (PatchException ex) {
            this.logger.error("Failed to patch account", (Throwable)ex);
            throw new FaultMessage(ex.getMessage(), (FaultType)new ReferentialIntegrityFaultType());
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshall account", (Throwable)ex);
            throw new FaultMessage(ex.getMessage(), (FaultType)new ReferentialIntegrityFaultType());
        }
    }

    private void modifyResource(ObjectModificationType objectChange) throws FaultMessage {
        try {
            this.logger.trace("[Repository] modifyResource begin");
            Validate.notNull((Object)objectChange);
            SimpleDomainObject resource = this.genericDao.findById(UUID.fromString(objectChange.getOid()));
            ResourceType resourceType = new ResourceType();
            this.copyResourceToResourceType((Resource)resource, resourceType);
            PatchXml xmlPatchTool = new PatchXml();
            String xmlObject = xmlPatchTool.applyDifferences(objectChange, (ObjectType)resourceType);
            JAXBElement jaxb = (JAXBElement)JAXBUtil.unmarshal((String)xmlObject);
            this.copyResourceTypeToResource((ResourceType)jaxb.getValue(), (Resource)resource);
            this.logger.trace("[Repository] modifyResource end");
        }
        catch (PatchException ex) {
            this.logger.error("Failed to patch resource", (Throwable)ex);
            throw new FaultMessage(ex.getMessage(), (FaultType)new ReferentialIntegrityFaultType());
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshall resource", (Throwable)ex);
            throw new FaultMessage(ex.getMessage(), (FaultType)new ReferentialIntegrityFaultType());
        }
    }

    private void modifyResourceState(ObjectModificationType objectChange) throws FaultMessage {
        try {
            this.logger.trace("[Repository] modifyResourceState begin");
            Validate.notNull((Object)objectChange);
            SimpleDomainObject resourceState = this.genericDao.findById(UUID.fromString(objectChange.getOid()));
            ResourceStateType resourceStateType = new ResourceStateType();
            this.copyResourceStateToResourceStateType((ResourceState)resourceState, resourceStateType);
            PatchXml xmlPatchTool = new PatchXml();
            String xmlObject = xmlPatchTool.applyDifferences(objectChange, (ObjectType)resourceStateType);
            JAXBElement jaxb = (JAXBElement)JAXBUtil.unmarshal((String)xmlObject);
            this.copyResourceStateTypeToResourceState((ResourceStateType)jaxb.getValue(), (ResourceState)resourceState);
            this.logger.trace("[Repository] modifyResourceState end");
        }
        catch (PatchException ex) {
            this.logger.error("Failed to patch resourceState", (Throwable)ex);
            throw new FaultMessage(ex.getMessage(), (FaultType)new ReferentialIntegrityFaultType());
        }
        catch (JAXBException ex) {
            this.logger.error("Failed to marshall resourceState", (Throwable)ex);
            throw new FaultMessage(ex.getMessage(), (FaultType)new ReferentialIntegrityFaultType());
        }
    }

    public String addObject(ObjectContainerType objectContainer) throws FaultMessage {
        this.logger.info("### REPOSITORY # Enter addObject({})", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainer));
        Validate.notNull((Object)objectContainer);
        if (objectContainer.getObject().getName() == null || objectContainer.getObject().getName().isEmpty()) {
            this.logger.error("### REPOSITORY # Fault addObject(..): Attempt to add object without name (OID:{})", (Object)objectContainer.getObject().getOid());
            IllegalArgumentFaultType ft = new IllegalArgumentFaultType();
            ft.setMessage("Attempt to add object without name");
            throw new FaultMessage("Attempt to add object without name", (FaultType)ft);
        }
        if (objectContainer.getObject() instanceof UserType) {
            this.logger.trace("[Repository] addUser begin");
            UserType userType = (UserType)objectContainer.getObject();
            User user = new User();
            this.copyUserTypeToUser(userType, user);
            this.storeOrImport(user);
            for (ObjectReferenceType ort : userType.getAccountRef()) {
                Account acc = (Account)this.genericDao.findById(UUID.fromString(ort.getOid()));
                if (null == acc) {
                    throw new FaultMessage("Account with oid = " + ort.getOid() + " referenced in accountRef does not exist.", (FaultType)new ObjectNotFoundFaultType());
                }
                acc.setUser(user);
            }
            userType.setOid(user.getOid().toString());
            this.logger.trace("[Repository] addUser end");
            this.logger.info("### REPOSITORY # Exit addObject(..) : {}", (Object)user.getOid().toString());
            return user.getOid().toString();
        }
        if (objectContainer.getObject() instanceof AccountShadowType) {
            this.logger.trace("[Repository] addAccount begin");
            AccountShadowType accountShadowType = (AccountShadowType)objectContainer.getObject();
            Account account = new Account();
            this.copyAccountShadowTypeToAccount(accountShadowType, account);
            this.storeOrImport(account);
            accountShadowType.setOid(account.getOid().toString());
            this.logger.trace("[Repository] addAccount end");
            this.logger.info("### REPOSITORY # Exit addObject(..) : {}", (Object)account.getOid().toString());
            return account.getOid().toString();
        }
        if (objectContainer.getObject() instanceof ResourceObjectShadowType) {
            this.logger.trace("[Repository] addResourceObjectShadow begin");
            ResourceObjectShadowType accountShadowType = (ResourceObjectShadowType)objectContainer.getObject();
            ResourceObjectShadow account = new ResourceObjectShadow();
            this.copyResourceObjectShadowTypeToResourceObjectShadow(accountShadowType, account);
            this.storeOrImport(account);
            accountShadowType.setOid(account.getOid().toString());
            this.logger.trace("[Repository] addResourceObjectShadow end");
            this.logger.info("### REPOSITORY # Exit addObject(..) : {}", (Object)account.getOid().toString());
            return account.getOid().toString();
        }
        if (objectContainer.getObject() instanceof ResourceType) {
            this.logger.trace("[Repository] addResource begin");
            ResourceType resourceType = (ResourceType)objectContainer.getObject();
            Resource resource = new Resource();
            this.copyResourceTypeToResource(resourceType, resource);
            this.storeOrImport(resource);
            resourceType.setOid(resource.getOid().toString());
            this.logger.trace("[Repository] addResource end");
            this.logger.info("### REPOSITORY # Exit addObject(..) : {}", (Object)resource.getOid().toString());
            return resource.getOid().toString();
        }
        if (objectContainer.getObject() instanceof ResourceAccessConfigurationType) {
            this.logger.trace("[Repository] addResourceAccessConfiguration begin");
            ResourceAccessConfigurationType resourceAccessConfigurationType = (ResourceAccessConfigurationType)objectContainer.getObject();
            ResourceAccessConfiguration resource = new ResourceAccessConfiguration();
            this.copyResourceAccessConfigurationTypeToResourceAccessConfiguration(resourceAccessConfigurationType, resource);
            this.storeOrImport(resource);
            resourceAccessConfigurationType.setOid(resource.getOid().toString());
            this.logger.trace("[Repository] addResourceAccessConfiguration end");
            this.logger.info("### REPOSITORY # Exit addObject(..) : {}", (Object)resource.getOid().toString());
            return resource.getOid().toString();
        }
        if (objectContainer.getObject() instanceof ResourceStateType) {
            this.logger.trace("[Repository] addResourceState begin");
            ResourceStateType resourceStateType = (ResourceStateType)objectContainer.getObject();
            ResourceState resourceState = new ResourceState();
            this.copyResourceStateTypeToResourceState(resourceStateType, resourceState);
            this.storeOrImport(resourceState);
            resourceStateType.setOid(resourceState.getOid().toString());
            this.logger.trace("[Repository] addResourceState end");
            this.logger.info("### REPOSITORY # Exit addObject(..) : {}", (Object)resourceState.getOid().toString());
            return resourceState.getOid().toString();
        }
        if (objectContainer.getObject() instanceof UserTemplateType) {
            this.logger.trace("[Repository] addUserTemplate begin");
            UserTemplateType userTemplateType = (UserTemplateType)objectContainer.getObject();
            UserTemplate userTemplate = new UserTemplate();
            this.copyUserTemplateTypeToUserTemplate(userTemplateType, userTemplate);
            this.storeOrImport(userTemplate);
            userTemplateType.setOid(userTemplate.getOid().toString());
            this.logger.trace("[Repository] addUserTemplate end");
            this.logger.info("### REPOSITORY # Exit addObject(..) : {}", (Object)userTemplate.getOid().toString());
            return userTemplate.getOid().toString();
        }
        if (objectContainer.getObject() instanceof GenericObjectType) {
            this.logger.trace("[Repository] addGenericObject begin");
            GenericObjectType genericObjectType = (GenericObjectType)objectContainer.getObject();
            GenericEntityBase genericEntity = new GenericEntityBase();
            this.copyGenericObjectTypeToGenericEntity(genericObjectType, genericEntity);
            this.storeOrImport(genericEntity);
            genericObjectType.setOid(genericEntity.getOid().toString());
            this.logger.trace("[Repository] addGenericObject end");
            this.logger.info("### REPOSITORY # Exit addObject(..) : {}", (Object)genericEntity.getOid().toString());
            return genericEntity.getOid().toString();
        }
        throw new FaultMessage("Object of type " + objectContainer.getObject() + " is not supported", (FaultType)new UnsupportedObjectTypeFaultType());
    }

    public ObjectContainerType getObject(String oid, PropertyReferenceListType resolve) throws FaultMessage {
        this.logger.info("### REPOSITORY # Enter getObject({})", (Object)oid);
        this.logger.trace("[Repository] getObject begin");
        Validate.notNull((Object)oid);
        ObjectContainerType objectContainerType = new ObjectContainerType();
        SimpleDomainObject object = this.genericDao.findById(UUID.fromString(oid));
        if (null == object) {
            throw new FaultMessage("Object with oid = " + oid + " not found", (FaultType)new ObjectNotFoundFaultType());
        }
        if (object instanceof User) {
            User user = (User)object;
            UserType userType = new UserType();
            this.copyUserToUserType(user, userType);
            objectContainerType.setObject((ObjectType)userType);
            this.logger.info("### REPOSITORY # Exit getObject(..): {}", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainerType));
            return objectContainerType;
        }
        if (object instanceof Account) {
            Account account = (Account)object;
            AccountShadowType accountShadowType = new AccountShadowType();
            this.copyAccountToAccountShadowType(account, accountShadowType);
            objectContainerType.setObject((ObjectType)accountShadowType);
            this.logger.info("### REPOSITORY # Exit getObject(..): {}", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainerType));
            return objectContainerType;
        }
        if (object instanceof ResourceObjectShadow) {
            ResourceObjectShadow account = (ResourceObjectShadow)object;
            ResourceObjectShadowType accountShadowType = new ResourceObjectShadowType();
            this.copyResourceObjectShadowToResourceObjectShadowType(account, accountShadowType);
            objectContainerType.setObject((ObjectType)accountShadowType);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("### REPOSITORY # Exit getObject(..): {}", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainerType));
            }
            return objectContainerType;
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            ResourceType resourceType = new ResourceType();
            this.copyResourceToResourceType(resource, resourceType);
            objectContainerType.setObject((ObjectType)resourceType);
            this.logger.trace("Returning object: {}", (Object)JAXBUtil.silentMarshalWrap((Object)resourceType, (QName)SchemaConstants.I_RESOURCE_TYPE));
            this.logger.info("### REPOSITORY # Exit getObject(..): {}", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainerType));
            return objectContainerType;
        }
        if (object instanceof ResourceAccessConfiguration) {
            ResourceAccessConfiguration resource = (ResourceAccessConfiguration)object;
            ResourceAccessConfigurationType resourceType = new ResourceAccessConfigurationType();
            this.copyResourceAccessConfigurationToResourceAccessConfiguration(resource, resourceType);
            objectContainerType.setObject((ObjectType)resourceType);
            this.logger.info("### REPOSITORY # Exit getObject(..): {}", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainerType));
            return objectContainerType;
        }
        if (object instanceof ResourceState) {
            ResourceState resourceState = (ResourceState)object;
            ResourceStateType resourceStateType = new ResourceStateType();
            this.copyResourceStateToResourceStateType(resourceState, resourceStateType);
            objectContainerType.setObject((ObjectType)resourceStateType);
            this.logger.info("### REPOSITORY # Exit getObject(..): {}", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainerType));
            return objectContainerType;
        }
        if (object instanceof UserTemplate) {
            UserTemplate userTemplate = (UserTemplate)object;
            UserTemplateType userTemplateType = new UserTemplateType();
            this.copyUserTemplateToUserTemplateType(userTemplate, userTemplateType);
            objectContainerType.setObject((ObjectType)userTemplateType);
            this.logger.info("### REPOSITORY # Exit getObject(..): {}", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainerType));
            return objectContainerType;
        }
        if (object instanceof GenericEntityBase) {
            GenericEntityBase genericEntity = (GenericEntityBase)object;
            GenericObjectType genericObjectType = new GenericObjectType();
            this.copyGenericEntityToGenericOjectType(genericEntity, genericObjectType);
            objectContainerType.setObject((ObjectType)genericObjectType);
            this.logger.info("### REPOSITORY # Exit getObject(..): {}", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainerType));
            return objectContainerType;
        }
        this.logger.error("### REPOSITORY # Fault getObject(..): Object with oid {} is not supported", (Object)oid);
        throw new FaultMessage("Object with oid " + oid + " is not supported", (FaultType)new UnsupportedObjectTypeFaultType());
    }

    private <T, U extends ObjectType> ObjectListType convertListOfObjects(List<T> objects, Class clazz) throws FaultMessage {
        this.logger.trace("[Repository] convertListOfObjects begin");
        ObjectListType olt = new ObjectListType();
        for (T object : objects) {
            ObjectType objectType = null;
            try {
                objectType = (ObjectType)clazz.newInstance();
            }
            catch (InstantiationException ex) {
                this.logger.warn("Failed to copy properties for instances {}, {}. Error message was {}", new Object[]{object, objectType, ex.getMessage()});
            }
            catch (IllegalAccessException ex) {
                this.logger.warn("Failed to copy properties for instances {}, {}. Error message was {}", new Object[]{object, objectType, ex.getMessage()});
            }
            if (clazz.getSimpleName().equals("UserType")) {
                this.copyUserToUserType((User)object, (UserType)objectType);
            }
            if (clazz.getSimpleName().equals("AccountShadowType")) {
                this.copyAccountToAccountShadowType((Account)object, (AccountShadowType)objectType);
            }
            if (clazz.getSimpleName().equals("ResourceType")) {
                this.copyResourceToResourceType((Resource)object, (ResourceType)objectType);
            }
            if (clazz.getSimpleName().equals("ResourceStateType")) {
                this.copyResourceStateToResourceStateType((ResourceState)object, (ResourceStateType)objectType);
            }
            if (clazz.getSimpleName().equals("UserTemplateType")) {
                this.copyUserTemplateToUserTemplateType((UserTemplate)object, (UserTemplateType)objectType);
            }
            if (clazz.getSimpleName().equals("GenericObjectType")) {
                this.copyGenericEntityToGenericOjectType((GenericEntityBase)object, (GenericObjectType)objectType);
            }
            olt.getObject().add(objectType);
        }
        this.logger.trace("[Repository] convertListOfObjects end");
        return olt;
    }

    public ObjectListType listObjects(String objectType, PagingType paging) throws FaultMessage {
        this.logger.info("### REPOSITORY # Enter listObjects({})", (Object)objectType);
        try {
            if (Utils.getObjectType((String)"UserType").equals(objectType)) {
                PagingRepositoryType pagingType = new PagingRepositoryType();
                pagingType.fillPagingProperties(paging);
                List<SimpleDomainObject> users = this.genericDao.findRangeUsers("User", pagingType);
                ObjectListType listOfObjects = this.convertListOfObjects(users, UserType.class);
                for (ObjectType objType : listOfObjects.getObject()) {
                    this.logger.debug(objType.getName());
                }
                this.logger.info("### REPOSITORY # Exit listObjects(..) : {}", (Object)DebugUtil.prettyPrint((ObjectListType)listOfObjects));
                return listOfObjects;
            }
            if (Utils.getObjectType((String)"AccountType").equals(objectType)) {
                List<SimpleDomainObject> accounts = this.genericDao.findAllOfType("Account");
                ObjectListType listOfObjects = this.convertListOfObjects(accounts, AccountShadowType.class);
                this.logger.info("### REPOSITORY # Exit listObjects(..) : {}", (Object)DebugUtil.prettyPrint((ObjectListType)listOfObjects));
                return listOfObjects;
            }
            if (Utils.getObjectType((String)"ResourceType").equals(objectType)) {
                List<SimpleDomainObject> resources = this.genericDao.findAllOfType("Resource");
                ObjectListType listOfObjects = this.convertListOfObjects(resources, ResourceType.class);
                this.logger.info("### REPOSITORY # Exit listObjects(..) : {}", (Object)DebugUtil.prettyPrint((ObjectListType)listOfObjects));
                return listOfObjects;
            }
            if (Utils.getObjectType((String)"ResourceStateType").equals(objectType)) {
                List<SimpleDomainObject> resourceStates = this.genericDao.findAllOfType("ResourceState");
                ObjectListType listOfObjects = this.convertListOfObjects(resourceStates, ResourceStateType.class);
                this.logger.info("### REPOSITORY # Exit listObjects(..) : {}", (Object)DebugUtil.prettyPrint((ObjectListType)listOfObjects));
                return listOfObjects;
            }
            if (Utils.getObjectType((String)"UserTemplateType").equals(objectType)) {
                List<SimpleDomainObject> userTemplates = this.genericDao.findAllOfType("UserTemplate");
                ObjectListType listOfObjects = this.convertListOfObjects(userTemplates, UserTemplateType.class);
                this.logger.info("### REPOSITORY # Exit listObjects(..) : {}", (Object)DebugUtil.prettyPrint((ObjectListType)listOfObjects));
                return listOfObjects;
            }
            if (Utils.getObjectType((String)"GenericObjectType").equals(objectType)) {
                List<SimpleDomainObject> genericEntities = this.genericDao.findAllOfType("GenericEntityBase");
                ObjectListType listOfObjects = this.convertListOfObjects(genericEntities, GenericObjectType.class);
                this.logger.info("### REPOSITORY # Exit listObjects(..) : {}", (Object)DebugUtil.prettyPrint((ObjectListType)listOfObjects));
                return listOfObjects;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new FaultMessage("Unsupported object type", (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
        }
        this.logger.error("### REPOSITORY # Fault getObject(..): Unsupported object type");
        throw new FaultMessage("Unsupported object type", (FaultType)new IllegalArgumentFaultType());
    }

    public static String convertFilterToQuery(Element filter) {
        String query;
        NodeList children = filter.getChildNodes();
        String path = null;
        String criteriaName = null;
        String criteriaValue = null;
        String objectType = null;
        String resourceRef = null;
        for (int index = 0; index < children.getLength(); ++index) {
            Node child = children.item(index);
            if (child.getNodeType() != 1) continue;
            String nodeLocalName = child.getLocalName();
            if ("type".equals(nodeLocalName)) {
                objectType = child.getAttributes().getNamedItem("uri").getTextContent();
                continue;
            }
            if ("equal".equals(nodeLocalName)) {
                if (StringUtils.isNotEmpty(criteriaName) && StringUtils.isNotEmpty(resourceRef) && QNameUtil.qNameToUri((QName)SchemaConstants.I_ACCOUNT_SHADOW_TYPE).equals(objectType) || StringUtils.isNotEmpty(criteriaName) && (QNameUtil.qNameToUri((QName)SchemaConstants.I_RESOURCE_STATE_TYPE).equals(objectType) || QNameUtil.qNameToUri((QName)SchemaConstants.I_USER_TYPE).equals(objectType)) || !QNameUtil.qNameToUri((QName)SchemaConstants.I_ACCOUNT_SHADOW_TYPE).equals(objectType) && QNameUtil.qNameToUri((QName)SchemaConstants.I_RESOURCE_STATE_TYPE).equals(objectType) && QNameUtil.qNameToUri((QName)SchemaConstants.I_USER_TYPE).equals(objectType)) {
                    throw new IllegalArgumentException("Provided unsupported filter in search query: " + DOMUtil.serializeDOMToString((Node)filter));
                }
                Node criteria = DOMUtil.getFirstChildElement((Node)child);
                if ("path".equals(criteria.getLocalName())) {
                    path = StringUtils.contains((String)criteria.getTextContent(), (String)":") ? StringUtils.substringAfter((String)criteria.getTextContent(), (String)":") : criteria.getTextContent();
                    if (null == (criteria = DOMUtil.getNextSiblingElement((Node)criteria))) {
                        throw new IllegalArgumentException("Query filter does not contain any values to search by");
                    }
                    Node firstChild = DOMUtil.getFirstChildElement((Node)criteria);
                    if (null == firstChild) {
                        throw new IllegalArgumentException("Query filter contains empty list of values to search by");
                    }
                    criteriaName = firstChild.getNamespaceURI() + ":" + firstChild.getLocalName();
                    criteriaValue = criteria.getTextContent();
                    continue;
                }
                criteria = DOMUtil.getFirstChildElement((Node)DOMUtil.getFirstChildElement((Node)child));
                if ("resourceRef".equals(criteria.getLocalName())) {
                    resourceRef = criteria.getAttributes().getNamedItem("oid").getNodeValue();
                    continue;
                }
                criteriaName = criteria.getLocalName();
                criteriaValue = criteria.getTextContent();
                continue;
            }
            throw new IllegalArgumentException("Unsupported element " + nodeLocalName + " in filter");
        }
        if (StringUtils.isEmpty(objectType)) {
            throw new IllegalArgumentException("Element type is required in filter");
        }
        if (criteriaValue != null) {
            criteriaValue = criteriaValue.trim();
        }
        String dbObject = StringUtils.substringBefore((String)StringUtils.substringAfter(objectType, (String)"#"), (String)"Type");
        if (StringUtils.isEmpty(path)) {
            query = StringUtils.isNotEmpty(resourceRef) ? "from " + dbObject + " where resource_uuid = '" + resourceRef + "'" : "from " + dbObject + " where " + criteriaName + " = '" + criteriaValue + "'";
        } else if ("User".equals(dbObject)) {
            query = "from " + dbObject + " where " + path + " = '" + criteriaValue + "' ";
        } else {
            dbObject = "Account";
            query = "from " + dbObject + " where " + path + "['" + criteriaName + "'] = '" + criteriaValue + "' ";
            if (StringUtils.isNotEmpty(resourceRef)) {
                query = query + "and resource_uuid = '" + resourceRef + "'";
            }
        }
        return query;
    }

    public ObjectListType searchObjects(QueryType queryType, PagingType paging) throws FaultMessage {
        this.logger.info("### REPOSITORY # Enter searchObjects({})", (Object)DebugUtil.prettyPrint((QueryType)queryType));
        String query = RepositoryService.convertFilterToQuery(queryType.getFilter());
        ObjectListType result = new ObjectListType();
        List returnedObjects = (List)this.genericDao.execute(query);
        for (SimpleDomainObject dbObject : returnedObjects) {
            if (dbObject instanceof User) {
                UserType user = new UserType();
                this.copyUserToUserType((User)dbObject, user);
                result.getObject().add(user);
                continue;
            }
            if (dbObject instanceof Account) {
                AccountShadowType accountShadow = new AccountShadowType();
                this.copyAccountToAccountShadowType((Account)dbObject, accountShadow);
                result.getObject().add(accountShadow);
                continue;
            }
            if (dbObject instanceof Resource) {
                ResourceType resource = new ResourceType();
                this.copyResourceToResourceType((Resource)dbObject, resource);
                result.getObject().add(resource);
                continue;
            }
            if (dbObject instanceof ResourceState) {
                ResourceStateType resourceState = new ResourceStateType();
                this.copyResourceStateToResourceStateType((ResourceState)dbObject, resourceState);
                result.getObject().add(resourceState);
                continue;
            }
            throw new FaultMessage("Object of type " + dbObject.getClass() + " is not supported", (FaultType)new UnsupportedObjectTypeFaultType());
        }
        this.logger.info("### REPOSITORY # Exit searchObjects({})", (Object)DebugUtil.prettyPrint((ObjectListType)result));
        return result;
    }

    public void modifyObject(ObjectModificationType objectChange) throws FaultMessage {
        this.logger.info("### REPOSITORY # Enter modifyObject({})", (Object)DebugUtil.prettyPrint((ObjectModificationType)objectChange));
        if (StringUtils.isEmpty((String)objectChange.getOid()) && objectChange.getPropertyModification().isEmpty()) {
            this.logger.warn("### REPOSITORY # Method modifyObject({}) was called with empty changes, Note: XMLUtil returns immediately if there are no results", (Object)DebugUtil.prettyPrint((ObjectModificationType)objectChange));
            return;
        }
        String oid = objectChange.getOid();
        SimpleDomainObject object = this.genericDao.findById(UUID.fromString(oid));
        if (object != null) {
            if (object instanceof User) {
                this.modifyUser(objectChange);
            } else if (object instanceof Account) {
                this.modifyAccount(objectChange);
            } else if (object instanceof Resource) {
                this.modifyResource(objectChange);
            } else if (object instanceof ResourceState) {
                this.modifyResourceState(objectChange);
            } else {
                throw new UnsupportedOperationException("Operation modifyObject() is unsupported (or not implemented yet) for object of class" + object.getClass());
            }
            this.logger.info("### REPOSITORY # Exit modifyObject(..)");
            return;
        }
        this.logger.error("### REPOSITORY # Fault modifyObject(..) : Object not modified");
        throw new FaultMessage("Object not modified", (FaultType)new ObjectNotFoundFaultType());
    }

    public void deleteObject(String oid) throws FaultMessage {
        this.logger.info("### REPOSITORY # Enter deleteObject({})", (Object)oid);
        this.logger.trace("[Repository] deleteObject begin");
        Validate.notNull((Object)oid);
        SimpleDomainObject object = this.genericDao.findById(UUID.fromString(oid));
        if (object != null) {
            this.genericDao.remove(object);
            this.logger.trace("[Repository] deleteObject end");
            this.logger.info("### REPOSITORY # Exit deleteObject(..)");
            return;
        }
        this.logger.error("### REPOSITORY # Fault deleteObject(..) : Oid not found : {}", (Object)oid);
        throw new FaultMessage("Oid '" + oid + "' not found", (FaultType)new ObjectNotFoundFaultType());
    }

    public PropertyAvailableValuesListType getPropertyAvailableValues(String oid, PropertyReferenceListType properties) throws FaultMessage {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public UserContainerType listAccountShadowOwner(String accountOid) throws FaultMessage {
        this.logger.info("### REPOSITORY # Enter listAccountShadowOwner({})", (Object)accountOid);
        Validate.notNull((Object)accountOid, (String)"provided accountShadow oid was null");
        UserContainerType userContainerType = new UserContainerType();
        String query = "from User as user inner join user.accounts as account where account.oid = '" + accountOid + "' ";
        List returnedObjects = (List)this.genericDao.execute(query);
        if (null == returnedObjects || returnedObjects.isEmpty()) {
            this.logger.warn("### REPOSITORY # Fault listAccountShadowOwner(..) : Owner of account with oid {} does not exist", (Object)accountOid);
            return userContainerType;
        }
        if (returnedObjects.size() > 1) {
            this.logger.error("### REPOSITORY # Fault listAccountShadowOwner(..) : Integrity problem: more than one owner found for account with oid {}", (Object)accountOid);
            throw new FaultMessage("Integrity problem: more than one owner found for account with oid " + accountOid, (FaultType)new ReferentialIntegrityFaultType());
        }
        UserType userType = new UserType();
        User user = (User)((Object[])returnedObjects.get(0))[0];
        this.copyUserToUserType(user, userType);
        userContainerType.setUser(userType);
        this.logger.info("### REPOSITORY # Exit listAccountShadowOwner(..): {}", (Object)DebugUtil.prettyPrint((UserContainerType)userContainerType));
        return userContainerType;
    }

    public ResourceObjectShadowListType listResourceObjectShadows(String resourceOid, String resourceObjectShadowType) throws FaultMessage {
        this.logger.trace("[Repository] listResourceObjectShadows begin");
        Validate.notNull((Object)resourceOid);
        Validate.notNull((Object)resourceObjectShadowType);
        ResourceObjectShadowListType result = new ResourceObjectShadowListType();
        if (this.genericDao.findById(UUID.fromString(resourceOid)) != null) {
            if (Utils.getObjectType((String)"AccountType").equals(resourceObjectShadowType)) {
                List<SimpleDomainObject> accounts = this.genericDao.findAllOfType(Account.class.getSimpleName());
                ArrayList<AccountShadowType> accountTypeList = new ArrayList<AccountShadowType>();
                for (SimpleDomainObject account : accounts) {
                    if (!((Account)account).getResource().getOid().equals(UUID.fromString(resourceOid))) continue;
                    AccountShadowType accountShadowType = new AccountShadowType();
                    this.copyAccountToAccountShadowType((Account)account, accountShadowType);
                    accountTypeList.add(accountShadowType);
                }
                result.getObject().addAll(accountTypeList);
            }
        } else {
            throw new FaultMessage("Resource with oid " + resourceOid + " not found", (FaultType)new ObjectNotFoundFaultType());
        }
        return result;
    }

    private class RepositoryPatchingListener
    implements PatchingListener {
        private User user;

        public RepositoryPatchingListener(User user) {
            this.user = user;
        }

        public boolean isApplicable(PropertyModificationType change) {
            Node node = (Node)change.getValue().getAny().get(0);
            String newValue = DOMUtil.serializeDOMToString((Node)node);
            if (StringUtils.contains((String)newValue, (String)"accountRef")) {
                if (PropertyModificationTypeType.add.equals((Object)change.getModificationType())) {
                    Node oidNode = node.getAttributes().getNamedItem("oid");
                    if (null == oidNode) {
                        return false;
                    }
                    String oid = oidNode.getNodeValue();
                    Account account = (Account)RepositoryService.this.genericDao.findById(UUID.fromString(oid));
                    if (account == null) {
                        return false;
                    }
                    account.setUser(this.user);
                    return false;
                }
                if (PropertyModificationTypeType.delete.equals((Object)change.getModificationType())) {
                    Node oidNode = node.getAttributes().getNamedItem("oid");
                    if (null == oidNode) {
                        return false;
                    }
                    String oid = oidNode.getNodeValue();
                    Account account = (Account)RepositoryService.this.genericDao.findById(UUID.fromString(oid));
                    if (account == null) {
                        return true;
                    }
                    account.setUser(null);
                    return true;
                }
            }
            return true;
        }

        public void applied(PropertyModificationType change) {
        }
    }
}

