/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.model.Account;
import com.evolveum.midpoint.model.Domain;
import com.evolveum.midpoint.model.SimpleDomainObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;

@Entity
@SecondaryTable(catalog="midPoint", name="Users", pkJoinColumns={@PrimaryKeyJoinColumn(name="uuid", referencedColumnName="uuid")}, uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
@NamedQueries(value={@NamedQuery(name="User.findAll", query="SELECT m FROM User m"), @NamedQuery(name="User.findByUname", query="SELECT m FROM User m WHERE m.name = ?0")})
public class User
extends SimpleDomainObject {
    public static final String code_id = "$Id$";
    public static final String DDL_TABLE_USER = "Users";
    public static final String QUERY_USER_FIND_BY_NAME = "User.findByUname";
    public static final String QUERY_USER_FIND_ALL = "User.findAll";
    private static final long serialVersionUID = -6219139356897428716L;
    private String givenName;
    private String familyName;
    private String fullName;
    private List<String> additionalNames;
    private String honorificPrefix;
    private String honorificSuffix;
    private List<String> eMailAddress;
    private List<String> telephoneNumber;
    private String employeeNumber;
    private List<String> employeeType;
    private List<String> organizationalUnit;
    private String locality;
    private Set<Account> accounts = new HashSet<Account>(0);
    private static final int PRIME = 31;

    public User() {
    }

    public User(Domain domain, String username) {
        this.name = username;
    }

    @Column(table="Users", name="name", unique=true, nullable=false, length=128)
    public String getName() {
        return this.name;
    }

    @Column(table="Users", name="familyName", length=128)
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Column(table="Users", name="fullName", length=128)
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Column(table="Users", name="givenName", length=128)
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="user", cascade={CascadeType.REMOVE})
    public Set<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Set<Account> accounts) {
        this.accounts = accounts;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @IndexColumn(name="index_position", base=1)
    public List<String> getAdditionalNames() {
        return this.additionalNames;
    }

    public void setAdditionalNames(List<String> additionalNames) {
        this.additionalNames = additionalNames;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @IndexColumn(name="index_position", base=1)
    public List<String> getEMailAddress() {
        return this.eMailAddress;
    }

    public void setEMailAddress(List<String> eMailAddress) {
        this.eMailAddress = eMailAddress;
    }

    @Column(table="Users", name="employeeNumber", length=128)
    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @IndexColumn(name="index_position", base=1)
    public List<String> getEmployeeType() {
        return this.employeeType;
    }

    public void setEmployeeType(List<String> employeeType) {
        this.employeeType = employeeType;
    }

    @Column(table="Users", name="honorificPrefix", length=128)
    public String getHonorificPrefix() {
        return this.honorificPrefix;
    }

    public void setHonorificPrefix(String honorificPrefix) {
        this.honorificPrefix = honorificPrefix;
    }

    @Column(table="Users", name="honorificSuffix", length=128)
    public String getHonorificSuffix() {
        return this.honorificSuffix;
    }

    public void setHonorificSuffix(String honorificSuffix) {
        this.honorificSuffix = honorificSuffix;
    }

    @Column(table="Users", name="locality", length=128)
    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @IndexColumn(name="index_position", base=1)
    public List<String> getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public void setOrganizationalUnit(List<String> organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @IndexColumn(name="index_position", base=1)
    public List<String> getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(List<String> telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.givenName == null ? other.givenName != null : !this.givenName.equals(other.givenName)) {
            return false;
        }
        return !(this.familyName == null ? other.familyName != null : !this.familyName.equals(other.familyName));
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.givenName != null ? this.givenName.hashCode() : 0);
        hash = 89 * hash + (this.familyName != null ? this.familyName.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("User [");
        builder.append("accounts.size=");
        builder.append(this.accounts.size());
        builder.append(", additionalNames=");
        builder.append(this.additionalNames);
        builder.append(", eMailAddress=");
        builder.append(this.eMailAddress);
        builder.append(", employeeNumber=");
        builder.append(this.employeeNumber);
        builder.append(", employeeType=");
        builder.append(this.employeeType);
        builder.append(", familyName=");
        builder.append(this.familyName);
        builder.append(", fullName=");
        builder.append(this.fullName);
        builder.append(", givenName=");
        builder.append(this.givenName);
        builder.append(", honorificPrefix=");
        builder.append(this.honorificPrefix);
        builder.append(", honorificSuffix=");
        builder.append(this.honorificSuffix);
        builder.append(", locality=");
        builder.append(this.locality);
        builder.append(", organizationalUnit=");
        builder.append(this.organizationalUnit);
        builder.append(", telephoneNumber=");
        builder.append(this.telephoneNumber);
        builder.append("]");
        return builder.toString();
    }
}

