/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.model.DomainRuntime;
import com.evolveum.midpoint.model.SimpleDomainObject;
import java.net.URL;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;

@SecondaryTable(catalog="midPoint", name="Domains", pkJoinColumns={@PrimaryKeyJoinColumn(name="uuid", referencedColumnName="uuid")}, uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
@NamedQueries(value={@NamedQuery(name="Domain.findAll", query="SELECT p FROM Domain p")})
public class Domain
extends SimpleDomainObject {
    public static final String code_id = "$Id$";
    public static final String DDL_TABLE_DOMAIN = "Domains";
    private static final long serialVersionUID = 7341781651134648946L;
    private static final int PRIME = 31;
    private String regex;
    private String reservedRegex;
    private String unallowableRegex;
    private Pattern pattern;
    private Pattern reservedPattern;
    private Pattern unallowablePattern;
    private DomainRuntime runtime = new DomainRuntime();

    public Domain() {
        String re = "[a-z]{1,16}";
        this.setRegex(re);
        re = "root|toor|wheel|staff|admin|administrator";
        this.setReservedRegex(re);
        re = "w+|home|server|approve.*|approving|register|login|logout|email.*|password.*|persona.*|site.*|attribute.*|hl|member|news|jos|mail|smtp|pop3|pop|.*fuck.*";
        this.setUnallowableRegex(re);
    }

    @Column(name="name", unique=true, nullable=false, length=128)
    public String getName() {
        return this.name;
    }

    @Transient
    public DomainRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(DomainRuntime runtime) {
        this.runtime = runtime;
    }

    @Transient
    public String getIdentifierPrefix() {
        StringBuilder sb = new StringBuilder();
        URL baseUrl = this.getRuntime().getServerBaseUrl();
        sb.append(baseUrl.getProtocol()).append("://");
        sb.append(this.getName());
        sb.append(baseUrl.getPath());
        return sb.toString();
    }

    @Column(name="regex", nullable=false, length=500)
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
        this.pattern = regex != null ? Pattern.compile(regex) : null;
    }

    @Column(name="reserved_regex", nullable=false, length=500)
    public String getReservedRegex() {
        return this.reservedRegex;
    }

    public void setReservedRegex(String reservedRegex) {
        this.reservedRegex = reservedRegex;
        this.reservedPattern = reservedRegex != null ? Pattern.compile(reservedRegex, 2) : null;
    }

    @Column(name="unallowable_regex", nullable=false, length=500)
    public String getUnallowableRegex() {
        return this.unallowableRegex;
    }

    public void setUnallowableRegex(String unallowableRegex) {
        this.unallowableRegex = unallowableRegex;
        this.unallowablePattern = unallowableRegex != null ? Pattern.compile(unallowableRegex, 2) : null;
    }

    @Transient
    public Pattern getPattern() {
        return this.pattern;
    }

    @Transient
    public Pattern getReservedPattern() {
        return this.reservedPattern;
    }

    @Transient
    public Pattern getUnallowablePattern() {
        return this.unallowablePattern;
    }

    public boolean isResourcename(String resourcename) {
        return this.getPattern() != null ? this.getPattern().matcher(resourcename).matches() : false;
    }

    public boolean isReserved(String resourcename) {
        return this.getReservedPattern() != null ? this.getReservedPattern().matcher(resourcename).matches() : false;
    }

    public boolean isUnallowable(String resourcename) {
        return this.getUnallowablePattern() != null ? this.getUnallowablePattern().matcher(resourcename).matches() : false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Domain)) {
            return false;
        }
        Domain other = (Domain)obj;
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

