/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.hibernate.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class UUIDType
implements UserType {
    public static final String code_id = "$Id$";
    private static final String CAST_EXCEPTION_TEXT = " cannot be cast to a java.util.UUID.";

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (!String.class.isAssignableFrom(cached.getClass())) {
            return null;
        }
        return UUID.fromString((String)((Object)cached));
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (!UUID.class.isAssignableFrom(value.getClass())) {
            throw new HibernateException(value.getClass().toString() + CAST_EXCEPTION_TEXT);
        }
        UUID other = (UUID)value;
        return UUID.fromString(other.toString());
    }

    public Serializable disassemble(Object value) throws HibernateException {
        System.out.println(value.toString());
        return value.toString();
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (null == x && null != y) {
            return false;
        }
        if (null == y && null != x) {
            return false;
        }
        if (!UUID.class.isAssignableFrom(x.getClass())) {
            throw new HibernateException(x.getClass().toString() + CAST_EXCEPTION_TEXT);
        }
        if (!UUID.class.isAssignableFrom(y.getClass())) {
            throw new HibernateException(y.getClass().toString() + CAST_EXCEPTION_TEXT);
        }
        UUID a = (UUID)x;
        UUID b = (UUID)y;
        return a.equals(b);
    }

    public int hashCode(Object x) throws HibernateException {
        if (!UUID.class.isAssignableFrom(x.getClass())) {
            throw new HibernateException(x.getClass().toString() + CAST_EXCEPTION_TEXT);
        }
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (value == null) {
            return null;
        }
        return UUID.fromString(value);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
            return;
        }
        if (!UUID.class.isAssignableFrom(value.getClass())) {
            throw new HibernateException(value.getClass().toString() + CAST_EXCEPTION_TEXT);
        }
        st.setString(index, value.toString());
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        if (!UUID.class.isAssignableFrom(original.getClass())) {
            throw new HibernateException(original.getClass().toString() + CAST_EXCEPTION_TEXT);
        }
        return UUID.fromString(original.toString());
    }

    public Class returnedClass() {
        return UUID.class;
    }

    public int[] sqlTypes() {
        return new int[]{1};
    }
}

