/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.ldap.search;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.ldap.search.LdapSearchStrategy;
import org.identityconnectors.ldap.search.SearchResultsHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePagedSearchStrategy
extends LdapSearchStrategy {
    private static final Log log = Log.getLog(SimplePagedSearchStrategy.class);
    private final int pageSize;

    public SimplePagedSearchStrategy(int pageSize) {
        this.pageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSearch(LdapContext initCtx, List<String> baseDNs, String query, SearchControls searchControls, SearchResultsHandler handler) throws IOException, NamingException {
        log.ok("Searching in {0} with filter {1} and {2}", new Object[]{baseDNs, query, SimplePagedSearchStrategy.searchControlsToString(searchControls)});
        LdapContext ctx = initCtx.newInstance(null);
        try {
            Iterator<String> baseDNIter = baseDNs.iterator();
            boolean proceed = true;
            while (baseDNIter.hasNext() && proceed) {
                String baseDN = baseDNIter.next();
                byte[] cookie = null;
                do {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(this.pageSize, cookie, true)});
                    NamingEnumeration<SearchResult> results = ctx.search(baseDN, query, searchControls);
                    try {
                        while (proceed && results.hasMore()) {
                            proceed = handler.handle(baseDN, results.next());
                        }
                    }
                    finally {
                        results.close();
                    }
                } while ((cookie = this.getResponseCookie(ctx.getResponseControls())) != null);
            }
        }
        finally {
            ctx.close();
        }
    }

    private byte[] getResponseCookie(Control[] controls) {
        if (controls != null) {
            for (Control control : controls) {
                if (!(control instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl pagedControl = (PagedResultsResponseControl)control;
                return pagedControl.getCookie();
            }
        }
        return null;
    }
}

