/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.synchronization;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.objects.ResourceObject;
import com.evolveum.midpoint.provisioning.schema.ResourceObjectDefinition;
import com.evolveum.midpoint.provisioning.service.ResourceAccessInterface;
import com.evolveum.midpoint.provisioning.service.ResourceObjectShadowCache;
import com.evolveum.midpoint.provisioning.service.ResultHandler;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeAdditionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.OperationalResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage;
import com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.ResourceObjectChangeListenerPortType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import javax.xml.namespace.QName;

public class ImportFromResourceTask
extends Thread
implements ResultHandler {
    private static final Trace logger = TraceManager.getTrace(ImportFromResourceTask.class);
    private ResourceType resource;
    private ResourceAccessInterface rai;
    private ResourceObjectDefinition objectDefinition;
    private long progress;
    private ResourceObjectChangeListenerPortType objectChangeListener;
    private ResourceObjectShadowCache shadowCache;
    private boolean stopOnError;
    private Long finishTime;
    private Long launchTime;
    private Exception lastError;
    private long lastErrorTime;
    private long numberOfErrors;

    public ImportFromResourceTask(ResourceType resource, ResourceAccessInterface rai, ResourceObjectDefinition objectDefinition) {
        this.resource = resource;
        this.rai = rai;
        this.objectDefinition = objectDefinition;
        this.progress = 0L;
        this.objectChangeListener = null;
        this.finishTime = null;
        this.launchTime = null;
        this.stopOnError = false;
        this.lastError = null;
        this.numberOfErrors = 0L;
    }

    public long getProgress() {
        return this.progress;
    }

    public ResourceObjectChangeListenerPortType getObjectChangeListener() {
        return this.objectChangeListener;
    }

    public void setObjectChangeListener(ResourceObjectChangeListenerPortType objectChangeListener) {
        this.objectChangeListener = objectChangeListener;
    }

    public ResourceObjectShadowCache getResourceObjectShadowCache() {
        return this.shadowCache;
    }

    public void setResourceObjectShadowCache(ResourceObjectShadowCache shadowCache) {
        this.shadowCache = shadowCache;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public Long getLaunchTime() {
        return this.launchTime;
    }

    public void setLaunchTime(Long launchTime) {
        this.launchTime = launchTime;
    }

    public Long getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Long finishTime) {
        this.finishTime = finishTime;
    }

    public Exception getLastError() {
        return this.lastError;
    }

    public void setLastError(Exception lastError) {
        this.lastError = lastError;
    }

    private void recordError(Exception error) {
        this.lastError = error;
        this.lastErrorTime = System.currentTimeMillis();
        ++this.numberOfErrors;
    }

    public long getLastErrorTime() {
        return this.lastErrorTime;
    }

    public void setLastErrorTime(long lastErrorTime) {
        this.lastErrorTime = lastErrorTime;
    }

    public long getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public void setNumberOfErrors(long numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
    }

    @Override
    public void run() {
        logger.debug("Import from resource {} starting", (Object)this.resource.getName());
        this.setLaunchTime(System.currentTimeMillis());
        OperationalResultType operationalResult = new OperationalResultType();
        try {
            this.rai.iterativeSearch(operationalResult, this.objectDefinition, this);
        }
        catch (Exception ex) {
            this.recordError(ex);
            logger.error("The import from resource {} failed in a spectacular way: {}", new Object[]{this.resource.getOid(), ex.getMessage(), ex});
        }
        this.setFinishTime(System.currentTimeMillis());
        logger.debug("Import from resource {} finishing", (Object)this.resource.getName());
    }

    @Override
    public boolean handle(ResourceObject resourceObject) {
        ResourceObjectShadowType newShadow;
        ++this.progress;
        logger.debug("Import from resource {} processing object {}, progress {}", new Object[]{this.resource.getName(), resourceObject, this.progress});
        if (this.objectChangeListener == null) {
            logger.warn("No object change listener set for import task, ending the task");
            return false;
        }
        ResourceObjectShadowChangeDescriptionType change = new ResourceObjectShadowChangeDescriptionType();
        change.setSourceChannel(QNameUtil.qNameToUri((QName)SchemaConstants.CHANGE_CHANNEL_IMPORT));
        change.setResource(this.resource);
        ResourceObjectShadowType oldShadow = null;
        try {
            oldShadow = this.shadowCache.getCurrentShadow(resourceObject, this.resource);
            logger.debug("Got old state: {}", (Object)DebugUtil.prettyPrint((ObjectType)oldShadow));
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            this.recordError((Exception)((Object)ex));
            logger.error("Unexpected repository error: " + ex.getFaultInfo());
            return !this.isStopOnError();
        }
        try {
            newShadow = this.shadowCache.update(resourceObject, this.resource);
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            this.recordError((Exception)((Object)ex));
            logger.error("Unexpected repository error: " + ex.getFaultInfo());
            return !this.isStopOnError();
        }
        if (newShadow == null) {
            IllegalArgumentException ex = new IllegalArgumentException("The shadow from shadow cache is null");
            this.recordError(ex);
            logger.error("The shadow from shadow cache is null. Resource {}", (Object)ex, (Object)this.resource.getName());
            logger.debug("resource object: {}", (Object)resourceObject);
            return !this.isStopOnError();
        }
        ObjectChangeAdditionType addChange = new ObjectChangeAdditionType();
        addChange.setObject((ObjectType)newShadow);
        change.setObjectChange((ObjectChangeType)addChange);
        if (oldShadow != null) {
            change.setShadow(oldShadow);
        } else {
            change.setShadow(newShadow);
        }
        logger.debug("Going to call notification with new object: " + DebugUtil.prettyPrint((ObjectType)newShadow));
        try {
            this.objectChangeListener.notifyChange(change);
        }
        catch (FaultMessage ex) {
            this.recordError((Exception)((Object)ex));
            logger.error("Change notication listener failed for import of object {}: {}", new Object[]{resourceObject, DebugUtil.prettyPrint((FaultMessage)ex), ex});
            return !this.isStopOnError();
        }
        catch (RuntimeException ex) {
            this.recordError(ex);
            logger.error("Change notication listener failed for import of object {}: {}: ", new Object[]{resourceObject, ex.getClass().getSimpleName(), ex.getMessage(), ex});
            return !this.isStopOnError();
        }
        return true;
    }
}

