/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.service;

import com.evolveum.midpoint.provisioning.objects.ResourceAttribute;
import com.evolveum.midpoint.provisioning.objects.ResourceObject;
import com.evolveum.midpoint.provisioning.schema.util.ObjectValueWriter;
import com.evolveum.midpoint.provisioning.util.ShadowUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.QueryUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.QueryType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage;
import com.evolveum.midpoint.xml.ns._public.repository.repository_1.RepositoryPortType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.schema.XPathSegment;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceObjectShadowCache {
    private RepositoryPortType repositoryService = null;

    public RepositoryPortType getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryPortType repositoryService) {
        this.repositoryService = repositoryService;
    }

    public ResourceObjectShadowType update(ResourceObject resourceObject, ResourceType resource) throws FaultMessage {
        ResourceObjectShadowType shadow = this.getCurrentShadow(resourceObject, resource);
        ObjectValueWriter objectValueWriter = new ObjectValueWriter();
        if (shadow == null) {
            ObjectContainerType oct = new ObjectContainerType();
            shadow = new AccountShadowType();
            ObjectReferenceType resourceRef = new ObjectReferenceType();
            resourceRef.setOid(resource.getOid());
            shadow.setResourceRef(resourceRef);
            shadow.setAttributes(new ResourceObjectShadowType.Attributes());
            objectValueWriter.merge(resourceObject.getIdentifier(), (List<Element>)shadow.getAttributes().getAny(), false);
            shadow.setObjectClass(resourceObject.getDefinition().getQName());
            shadow.setName((String)resourceObject.getIdentifier().getSingleJavaValue());
            oct.setObject((ObjectType)shadow);
            String oid = this.getRepositoryService().addObject(oct);
            shadow.setOid(oid);
        }
        objectValueWriter.merge(resourceObject, (List<Element>)shadow.getAttributes().getAny(), false);
        shadow.setResource(resource);
        shadow.setResourceRef(null);
        return shadow;
    }

    public ResourceObjectShadowType getCurrentShadow(ResourceObject resourceObject, ResourceType resource) throws FaultMessage {
        QueryType query = this.createSearchShadowQuery(resourceObject);
        PagingType paging = new PagingType();
        ObjectListType results = this.getRepositoryService().searchObjects(query, paging);
        if (results.getObject().size() == 0) {
            return null;
        }
        if (results.getObject().size() > 1) {
            throw new IllegalStateException("More than one shadows found for " + resourceObject);
        }
        return (ResourceObjectShadowType)results.getObject().get(0);
    }

    protected QueryType createSearchShadowQuery(ResourceObject resourceObject) {
        XPathSegment xpathSegment = new XPathSegment(SchemaConstants.I_ATTRIBUTES);
        ArrayList<XPathSegment> xpathSegments = new ArrayList<XPathSegment>();
        xpathSegments.add(xpathSegment);
        XPathType xpath = new XPathType(xpathSegments);
        ResourceAttribute identifier = resourceObject.getIdentifier();
        List<Node> idNodes = identifier.getValues();
        if (idNodes.size() > 1) {
            throw new IllegalArgumentException("More than one identifier value is not supported");
        }
        if (idNodes.size() < 1) {
            throw new IllegalArgumentException("The identifier has no value");
        }
        Element idElement = (Element)idNodes.get(0);
        Document doc = ShadowUtil.getXmlDocument();
        Element filter = QueryUtil.createAndFilter((Document)doc, (Element)QueryUtil.createTypeFilter((Document)doc, (String)QNameUtil.qNameToUri((QName)SchemaConstants.I_ACCOUNT_TYPE)), (Element)QueryUtil.createEqualFilter((Document)doc, (XPathType)xpath, (Element)idElement));
        QueryType query = new QueryType();
        query.setFilter(filter);
        return query;
    }
}

