/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.service;

import com.evolveum.midpoint.api.exceptions.MidPointException;
import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.exception.IllegalRequestException;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.aop.ResourceAccessAspect;
import com.evolveum.midpoint.provisioning.exceptions.InitialisationException;
import com.evolveum.midpoint.provisioning.exceptions.ValidationException;
import com.evolveum.midpoint.provisioning.objects.ResourceAttribute;
import com.evolveum.midpoint.provisioning.objects.ResourceObject;
import com.evolveum.midpoint.provisioning.schema.ResourceAttributeDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceObjectDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceSchema;
import com.evolveum.midpoint.provisioning.schema.util.ObjectValueWriter;
import com.evolveum.midpoint.provisioning.service.AttributeChange;
import com.evolveum.midpoint.provisioning.service.BaseResourceIntegration;
import com.evolveum.midpoint.provisioning.service.DefaultResourceFactory;
import com.evolveum.midpoint.provisioning.service.ResourceAccessInterface;
import com.evolveum.midpoint.provisioning.service.ResourceConnector;
import com.evolveum.midpoint.provisioning.service.ResourceFactory;
import com.evolveum.midpoint.provisioning.service.ResourceObjectShadowCache;
import com.evolveum.midpoint.provisioning.service.SynchronizationResult;
import com.evolveum.midpoint.provisioning.synchronization.ImportFromResourceTask;
import com.evolveum.midpoint.provisioning.util.ShadowUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.QueryUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.DiagnosticsMessageType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.EmptyType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.FaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.IllegalArgumentFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeAdditionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeDeletionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.OperationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.OperationalResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyAvailableValuesListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.QueryType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceAccessConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectIdentificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceStateType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceTestResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SchemaViolationFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ScriptOrderType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ScriptType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ScriptsType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SystemFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.TaskStatusType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.TestResultType;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.FaultMessage;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.ProvisioningPortType;
import com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.ResourceObjectChangeListenerPortType;
import com.evolveum.midpoint.xml.ns._public.repository.repository_1.RepositoryPortType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.schema.XPathSegment;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.commons.codec.binary.Base64;
import org.identityconnectors.common.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service(value="provisioningService")
public class ProvisioningService
implements ProvisioningPortType {
    @Autowired(required=false)
    private ResourceObjectChangeListenerPortType objectChangeListener;
    private ResourceFactory connectorFactory = new DefaultResourceFactory();
    private static final Trace logger = TraceManager.getTrace(ProvisioningService.class);
    private ObjectValueWriter valueWriter = ObjectValueWriter.getInstance();
    @Autowired
    private RepositoryPortType repositoryService;
    private ResourceObjectShadowCache shadowCache;
    private static final String IMPORT_TASK_NAME_PREFIX = "import-from-resource-";
    private Map<String, ImportFromResourceTask> importTasks = new HashMap<String, ImportFromResourceTask>();
    public static final String SEARCH_SHADOW_BY_UUID = "<c:query  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'    xmlns:c='http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd'    xmlns:dj=\"http://midpoint.evolveum.com/xml/ns/samples/localhostOpenDJ\"    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"    xsi:schemaLocation='http://www.w3.org/2001/XMLSchema ../standard/XMLSchema.xsd    http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd ../../../main/resources/META-INF/wsdl/xml/ns/public/common/common-1.xsd'     xmlns:foo=\"http://foo.com/\">     <c:and>         <c:type uri=\"http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd#AccountShadowType\"/>          <c:equal>             <c:path>c:attributes</c:path>             <c:value>                 <dj:__UID__>cn=foobar,uo=people,dc=nlight,dc=eu</dj:__UID__>             </c:value>          </c:equal>     </c:and> </c:query>";
    public static final String SEARCH_BY_UUID = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>          <c:query  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'   xmlns:c='http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd'   xmlns:i='http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd'   xmlns:dj=\"http://midpoint.evolveum.com/xml/ns/samples/localhostOpenDJ\"   xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"   xsi:schemaLocation='http://www.w3.org/2001/XMLSchema ../standard/XMLSchema.xsd   http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd ../../../main/resources/META-INF/wsdl/xml/ns/public/common/common-1.xsd'   xmlns:foo=\"http://foo.com/\">    <c:and>        <c:type uri=\"http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd#ResourceStateType\"/>        <c:equal>            <c:value>                <i:resourceRef oid=\"1234\"/>            </c:value>        </c:equal>    </c:and> </c:query>";

    private RepositoryPortType getRepository() {
        return this.repositoryService;
    }

    public void setRepositotyService(RepositoryPortType service) {
        this.repositoryService = service;
    }

    public void setRepositoryPort(RepositoryPortType newRepository) {
        this.repositoryService = newRepository;
    }

    public void setConnectorFactory(ResourceFactory connectorFactory) {
        this.connectorFactory = connectorFactory;
    }

    protected synchronized ResourceObjectShadowCache getResourceObjectShadowCache() {
        if (this.shadowCache == null) {
            this.shadowCache = new ResourceObjectShadowCache();
            this.shadowCache.setRepositoryService(this.getRepository());
        }
        return this.shadowCache;
    }

    public String addObject(ObjectContainerType objectContainer, ScriptsType scripts, Holder<OperationalResultType> result) throws FaultMessage {
        ObjectType object;
        logger.info("### PROVISIONING # Enter addObject({})", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainer));
        if (logger.isDebugEnabled() && (object = objectContainer.getObject()) instanceof ResourceObjectShadowType) {
            ResourceObjectShadowType shadow = (ResourceObjectShadowType)object;
            ResourceObjectShadowType.Attributes attributes = shadow.getAttributes();
            List elements = attributes.getAny();
            for (Element el : elements) {
                logger.debug("A: " + DebugUtil.prettyPrint((Element)el));
            }
        }
        object = objectContainer.getObject();
        String newOid = null;
        if (object instanceof ResourceObjectShadowType) {
            try {
                AccountShadowType acctShadow;
                ResourceObjectShadowType shadow = (ResourceObjectShadowType)object;
                this.resolveResource(shadow);
                ResourceObject updatedObject = null;
                ResourceAccessInterface rai = this.getResourceAccessInterface(shadow);
                ResourceSchema schema = this.mergeSchema(rai, shadow);
                ResourceObject resourceObject = this.valueWriter.buildResourceObject(shadow, schema);
                if (shadow instanceof AccountShadowType && null != (acctShadow = (AccountShadowType)shadow).getCredentials()) {
                    this.processAccountCredentials(resourceObject, acctShadow);
                }
                if (this.valueWriter.validateBeforeCreate(resourceObject)) {
                    Object robj = null;
                    if (robj == null) {
                        this.processScripts((OperationalResultType)result.value, rai, scripts, ScriptOrderType.BEFORE, OperationTypeType.ADD);
                        updatedObject = rai.add((OperationalResultType)result.value, resourceObject, shadow);
                        this.processScripts((OperationalResultType)result.value, rai, scripts, ScriptOrderType.AFTER, OperationTypeType.ADD);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                }
                if (null == updatedObject) {
                    logger.error("### PROVISIONING # Fault addObject(..): Resource Object Creation Failed");
                    throw new FaultMessage("Resource Object Creation Failed", (FaultType)new IllegalArgumentFaultType());
                }
                this.valueWriter.postProcessShadow(updatedObject, shadow);
                this.unresolveResource(shadow);
                objectContainer.setObject((ObjectType)shadow);
                newOid = this.getRepository().addObject(objectContainer);
            }
            catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
                logger.error("### PROVISIONING # Fault addObject(..): Error on add object to the repository: {}", (Object)ex.getMessage());
                logger.debug("Error on add object to the repository", (Throwable)ex);
                throw this.createFaultMessage("Repository invocation failed (addObject)", ex.getFaultInfo(), (Exception)((Object)ex), (OperationalResultType)result.value);
            }
            catch (ValidationException ex) {
                logger.error("### PROVISIONING # Fault addObject(..): Object validation error: {}", (Object)ex.getMessage());
                throw this.createFaultMessage("Object validation error: " + ex.getMessage(), SchemaViolationFaultType.class, false, ex, (OperationalResultType)result.value);
            }
            catch (Exception ex) {
                logger.error("### PROVISIONING # Fault addObject(..): General error in the provisioning (addObject): {}", (Object)ex.getMessage());
                logger.debug("General error in the provisioning (addObject).", (Throwable)ex);
                throw this.createFaultMessage("General error in the provisioning (addObject): " + ex.getMessage(), SystemFaultType.class, false, ex, (OperationalResultType)result.value);
            }
        } else {
            logger.error("### PROVISIONING # Fault addObject(..): Unsupported object type : {}", (Object)object.getClass().getName());
            throw new FaultMessage("Unsupported object type " + object.getClass().getName(), (FaultType)new IllegalArgumentFaultType());
        }
        logger.info("### PROVISIONING # Exit addObject(..) : ", (Object)newOid);
        return newOid;
    }

    public ObjectContainerType getObject(String oid, PropertyReferenceListType resolve, Holder<OperationalResultType> result) throws FaultMessage {
        logger.info("### PROVISIONING # Enter getObject({},{})", (Object)oid, (Object)DebugUtil.prettyPrint((PropertyReferenceListType)resolve));
        this.testOid(oid);
        try {
            ObjectType object = this.getRepository().getObject(oid, resolve).getObject();
            if (object instanceof ResourceType) {
                ResourceType resource = (ResourceType)object;
                this.completeResource(resource);
                ObjectContainerType container = new ObjectContainerType();
                container.setObject((ObjectType)resource);
                return container;
            }
            if (object instanceof ResourceObjectShadowType) {
                ResourceObjectShadowType shadow = (ResourceObjectShadowType)object;
                this.completeResourceObjectShadow(shadow);
                ObjectContainerType container = new ObjectContainerType();
                container.setObject((ObjectType)shadow);
                logger.info("### PROVISIONING # Exit getObject(..) : ", (Object)DebugUtil.prettyPrint((ObjectContainerType)container));
                return container;
            }
            logger.error("### PROVISIONING # Fault getObject(..) : Unsupported object type : {}", (Object)object.getClass().getName());
            throw this.createFaultMessage("Unsupported object type " + object.getClass().getName() + " (OID: " + oid + ")", IllegalArgumentFaultType.class, false, null, (OperationalResultType)result.value);
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### PROVISIONING # Fault getObject(..) : Repository error : {}", (Object)ex.getMessage());
            throw this.createFaultMessage("Repository invocation failed (getObject)", ex.getFaultInfo(), (Exception)((Object)ex), (OperationalResultType)result.value);
        }
        catch (RuntimeException ex) {
            logger.error("### PROVISIONING # Fault getObject(..) : Unknown error : {}", (Object)ex.getMessage());
            throw this.createFaultMessage("Error on getting object", SystemFaultType.class, false, ex, (OperationalResultType)result.value);
        }
    }

    public ObjectListType listObjects(String objectType, PagingType paging, Holder<OperationalResultType> result) throws FaultMessage {
        logger.info("### PROVISIONING # Enter listObjects({})", (Object)objectType);
        if (objectType == null || objectType.isEmpty()) {
            logger.error("### PROVISIONING # Fault listObjects(..) : Object type can't be null or empty");
            throw new FaultMessage("Object type can't be null or empty.", (FaultType)new IllegalArgumentFaultType());
        }
        ObjectListType listType = null;
        try {
            listType = this.getRepository().listObjects(objectType, paging);
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### PROVISIONING # Fault listObjects(..) : Repository error : {}", (Object)ex.getMessage());
            logger.debug("Unknown repository error occured.", (Throwable)ex);
            throw new FaultMessage("Unknown repository error occured.", (FaultType)new SystemFaultType(), (Throwable)ex);
        }
        logger.info("### PROVISIONING # Exit listObjects(..) : ", (Object)listType);
        return listType;
    }

    public ObjectListType searchObjects(QueryType query, PagingType paging, Holder<OperationalResultType> result) throws FaultMessage {
        logger.info("### PROVISIONING # Enter searchObjects({})", (Object)query);
        if (query == null) {
            logger.error("### PROVISIONING # Fault searchObjects(..) : Query can't be null");
            throw new FaultMessage("Query can't be null", (FaultType)new IllegalArgumentFaultType());
        }
        ObjectListType listType = null;
        try {
            listType = this.getRepository().searchObjects(query, paging);
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### PROVISIONING # Fault searchObjects(..) : Repository error : {}", (Object)ex.getMessage());
            logger.debug("Unknown error occured.", (Throwable)ex);
            throw new FaultMessage("Unknown error occured.", (FaultType)new SystemFaultType(), (Throwable)ex);
        }
        logger.info("### PROVISIONING # Exit searchObjects(..) : ", (Object)listType);
        return listType;
    }

    public void modifyObject(ObjectModificationType objectChange, ScriptsType scripts, Holder<OperationalResultType> result) throws FaultMessage {
        logger.info("### PROVISIONING # Enter modifyObject({})", (Object)DebugUtil.prettyPrint((ObjectModificationType)objectChange));
        if (objectChange == null) {
            logger.error("### PROVISIONING # Fault modifyObject(..): Object to change must not be null");
            throw new FaultMessage("Object to change must not be null", (FaultType)new IllegalArgumentFaultType());
        }
        String oid = objectChange.getOid();
        try {
            this.testOid(oid);
            ObjectContainerType oc = this.getRepository().getObject(oid, new PropertyReferenceListType());
            ObjectType ot = oc.getObject();
            if (!(ot instanceof ResourceObjectShadowType)) {
                logger.error("### PROVISIONING # Fault modifyObject(..): Unsupported object type {} (OID: {})", (Object)ot.getClass().getName(), (Object)oid);
                throw new FaultMessage("Unsupported object type " + ot.getClass().getName() + " (OID: " + oid + ")", (FaultType)new IllegalArgumentFaultType());
            }
            ResourceObjectShadowType shadow = (ResourceObjectShadowType)ot;
            this.resolveResource(shadow);
            ResourceAccessInterface rai = this.getResourceAccessInterface(shadow);
            ResourceSchema schema = ((ResourceConnector)rai.getConnector()).getSchema();
            ResourceObject identification = this.valueWriter.buildResourceObject(shadow, schema);
            ResourceObjectDefinition objectDefinition = schema.getObjectDefinition(shadow.getObjectClass());
            Set<AttributeChange> changes = this.processObjectChanges(schema, objectDefinition, objectChange);
            this.processScripts((OperationalResultType)result.value, rai, scripts, ScriptOrderType.BEFORE, OperationTypeType.MODIFY);
            this.getResourceAccessInterface(shadow).modify((OperationalResultType)result.value, identification, objectDefinition, changes);
            this.processScripts((OperationalResultType)result.value, rai, scripts, ScriptOrderType.AFTER, OperationTypeType.MODIFY);
        }
        catch (IllegalRequestException ex) {
            logger.error("### PROVISIONING # Fault modifyObject(..): Illegal Request : {}", (Throwable)ex);
            throw new FaultMessage(ex.getMessage(), (FaultType)new IllegalArgumentFaultType(), (Throwable)ex);
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### PROVISIONING # Fault modifyObject(..): Unknown error : {}", (Object)ex.getMessage());
            logger.debug("Unknown error occured.", (Throwable)ex);
            throw new FaultMessage("Unknown error occured.", (FaultType)new SystemFaultType(), (Throwable)ex);
        }
        logger.info("### PROVISIONING # Exit modifyObject(..)");
    }

    public void deleteObject(String oid, ScriptsType scripts, Holder<OperationalResultType> result) throws FaultMessage {
        block6: {
            logger.info("### PROVISIONING # Enter deleteObject({})", (Object)oid);
            this.testOid(oid);
            try {
                ObjectContainerType oct = this.getRepository().getObject(oid, new PropertyReferenceListType());
                if (oct == null) {
                    logger.error("### PROVISIONING # Fault deleteObject(..): No object with oid {}", (Object)oid);
                    throw new FaultMessage("No object with oid " + oid, (FaultType)new IllegalArgumentFaultType());
                }
                ObjectType c = oct.getObject();
                if (c instanceof ResourceObjectShadowType) {
                    ResourceObjectShadowType shadow = (ResourceObjectShadowType)c;
                    this.resolveResource(shadow);
                    this.getRepository().deleteObject(oid);
                    try {
                        ResourceAccessInterface rai = this.getResourceAccessInterface(shadow);
                        ResourceObject resourceObject = this.valueWriter.buildResourceObject(shadow, ((ResourceConnector)rai.getConnector()).getSchema());
                        this.processScripts((OperationalResultType)result.value, rai, scripts, ScriptOrderType.BEFORE, OperationTypeType.DELETE);
                        rai.delete((OperationalResultType)result.value, resourceObject);
                        this.processScripts((OperationalResultType)result.value, rai, scripts, ScriptOrderType.AFTER, OperationTypeType.DELETE);
                        break block6;
                    }
                    catch (MidPointException ex) {
                        logger.error("### PROVISIONING # Fault deleteObject(..): Unknown error : {}", (Object)ex.getMessage());
                        logger.debug("Unknown error " + (Object)((Object)ex));
                        throw new FaultMessage("Unknown error occured.", (FaultType)new SystemFaultType(), (Throwable)ex);
                    }
                }
                logger.error("### PROVISIONING # Fault deleteObject(..): Unsupported object type {} (OID: {})", (Object)c.getClass().getName(), (Object)oid);
                throw new FaultMessage("Unsupported object type " + c.getClass().getName() + " (OID: " + oid + ")", (FaultType)new IllegalArgumentFaultType());
            }
            catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
                logger.error("### PROVISIONING # Fault deleteObject(..): Unknown error : {}", (Object)ex.getMessage());
                logger.debug("Unknown error occured.", (Throwable)ex);
                throw new FaultMessage("Unknown error occured.", (FaultType)new SystemFaultType(), (Throwable)ex);
            }
        }
        logger.info("### PROVISIONING # Exit deleteObject(..)");
    }

    public PropertyAvailableValuesListType getPropertyAvailableValues(String oid, PropertyReferenceListType properties, Holder<OperationalResultType> result) throws FaultMessage {
        logger.info("### PROVISIONING # Enter getPropertyAvailableValues({},{})", (Object)oid, (Object)properties);
        this.testOid(oid);
        PropertyAvailableValuesListType listType = null;
        try {
            listType = this.getRepository().getPropertyAvailableValues(oid, properties);
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### PROVISIONING # Fault getPropertyAvailableValues(..): Unknown error : {}", (Object)ex.getMessage());
            logger.debug("Unknown error occured.", (Throwable)ex);
            throw new FaultMessage("Unknown error occured.", (FaultType)new SystemFaultType(), (Throwable)ex);
        }
        logger.info("### PROVISIONING # Exit getPropertyAvailableValues(..) : {}", (Object)listType);
        return listType;
    }

    public ObjectContainerType addResourceObject(String resourceOid, ObjectContainerType objectContainer, Holder<OperationalResultType> result) throws FaultMessage {
        if (objectContainer == null || objectContainer.getObject() == null) {
            throw new FaultMessage("Resource object type can't be null.", (FaultType)new IllegalArgumentFaultType());
        }
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ObjectContainerType getResourceObject(String resourceOid, ResourceObjectIdentificationType identification, Holder<OperationalResultType> result) throws FaultMessage {
        ResourceType resource = null;
        try {
            resource = (ResourceType)this.getRepository().getObject(resourceOid, new PropertyReferenceListType()).getObject();
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("Error on getting resource (oid: " + resourceOid + ") from repository");
            throw new FaultMessage("Error on getting resource (oid: " + resourceOid + ") from repository", ex.getFaultInfo(), (Throwable)ex);
        }
        ObjectType shadow = null;
        ObjectContainerType container = new ObjectContainerType();
        container.setObject(shadow);
        return container;
    }

    public ObjectListType listResourceObjects(String resourceOid, String objectType, PagingType paging, Holder<OperationalResultType> result) throws FaultMessage {
        ObjectListType objectList = new ObjectListType();
        try {
            Collection<ResourceObject> a;
            ResourceAccessInterface rai = this.getResourceAccessInterface(resourceOid, null);
            ResourceSchema schema = ((ResourceConnector)rai.getConnector()).getSchema();
            ObjectReferenceType resourceRef = new ObjectReferenceType();
            resourceRef.setOid(resourceOid);
            ResourceObjectDefinition def = schema.getObjectDefinition(new QName(schema.getResourceNamespace(), objectType));
            if (null != def && null != (a = rai.search((OperationalResultType)result.value, def))) {
                for (ResourceObject ro : a) {
                    ResourceObjectShadowType shadow = new ResourceObjectShadowType();
                    shadow.setResourceRef(resourceRef);
                    shadow.setObjectClass(def.getQName());
                    shadow.setName(UUID.randomUUID().toString());
                    ResourceObjectShadowType.Attributes attrs = new ResourceObjectShadowType.Attributes();
                    this.valueWriter.merge(ro, (List<Element>)attrs.getAny(), false);
                    shadow.setAttributes(attrs);
                    objectList.getObject().add(shadow);
                }
            }
        }
        catch (MidPointException ex) {
            // empty catch block
        }
        return objectList;
    }

    public void modifyResourceObject(String resourceOid, ObjectModificationType objectChange, Holder<OperationalResultType> result) throws FaultMessage {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deleteResourceObject(String resourceOid, ResourceObjectIdentificationType identification, Holder<OperationalResultType> result) throws FaultMessage {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void processAccountCredentials(ResourceObject resourceObject, AccountShadowType shadow) throws DOMException {
        ResourceObjectDefinition objectDefinition = resourceObject.getDefinition();
        QName attrQName = new QName("http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/resource-schema-1.xsd", "__PASSWORD__");
        ResourceAttributeDefinition attributeDefinition = objectDefinition.getAttributeDefinition(attrQName);
        ResourceAttribute resourceAttribute = new ResourceAttribute(attributeDefinition);
        Document doc = ShadowUtil.getXmlDocument();
        Element pwd = doc.createElementNS(attrQName.getNamespaceURI(), attrQName.getLocalPart());
        pwd.setTextContent(new String(Base64.decodeBase64((String)((Element)shadow.getCredentials().getPassword().getAny()).getTextContent())));
        resourceAttribute.addValue(pwd);
        resourceObject.addValue(resourceAttribute);
    }

    private void testOid(String oid) throws FaultMessage {
        if (StringUtil.isBlank((String)oid)) {
            throw new FaultMessage("Oid can't be null or empty.", (FaultType)new IllegalArgumentFaultType());
        }
    }

    protected ResourceAccessInterface getResourceAccessInterface(String resourceOID, ResourceType inputResource) throws FaultMessage {
        BaseResourceIntegration connector = null;
        ResourceAccessConfigurationType resourceAccessConfiguration = null;
        try {
            ResourceType savedResource = (ResourceType)this.getRepository().getObject(resourceOID, new PropertyReferenceListType()).getObject();
            connector = this.mergerResourceTypes(inputResource, savedResource);
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("Error on resolve ObjectShadow.resourceRef from repository. resource=" + resourceOID);
            throw new FaultMessage("Error on resolve ObjectShadow.resourceRef from repository.", ex.getFaultInfo(), (Throwable)ex);
        }
        try {
            ResourceAccessAspect rif = this.connectorFactory.checkout(ResourceAccessAspect.class, connector, resourceAccessConfiguration);
            return rif;
        }
        catch (InitialisationException ex) {
            logger.error("Error on ResourceAccessInterface Initialisation");
            throw new FaultMessage("Error on ResourceAccessInterface Initialisation, reason: " + ex.getMessage(), null, (Throwable)((Object)ex));
        }
    }

    protected ResourceAccessInterface getResourceAccessInterface(ResourceObjectShadowType shadow) throws FaultMessage {
        if (shadow.getResource() == null) {
            if (shadow.getResourceRef() == null) {
                throw new FaultMessage("Resource and resourceRef are undefined at object(oid=" + shadow.getOid() + "). One of them should be set.", (FaultType)new SchemaViolationFaultType());
            }
            return this.getResourceAccessInterface(shadow.getResourceRef().getOid(), null);
        }
        return this.getResourceAccessInterface(shadow.getResource().getOid(), shadow.getResource());
    }

    private ResourceAccessConfigurationType getResourceAccessConfiguration(ResourceType resource) {
        String oid = null;
        try {
            oid = resource.getResourceAccessConfigurationRef().getOid();
            return (ResourceAccessConfigurationType)this.getRepository().getObject(oid, new PropertyReferenceListType()).getObject();
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("Error on resolve ResourceType.resourceAccessConfigurationRef from repository. ResourceType=" + resource.getOid() + " , ResourceAccessConfigurationType=" + oid, (Throwable)ex);
            return new ResourceAccessConfigurationType();
        }
    }

    private BaseResourceIntegration mergerResourceTypes(ResourceType inputResource, ResourceType savedResource) {
        return new BaseResourceIntegration(savedResource);
    }

    private void completeResource(ResourceType resource) throws FaultMessage {
    }

    private void completeResourceObjectShadow(ResourceObjectShadowType shadow) throws FaultMessage, MidPointException, com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage {
        if (shadow.getAttributes() == null) {
            shadow.setAttributes(new ResourceObjectShadowType.Attributes());
        }
        this.resolveResource(shadow);
        ResourceAccessInterface rai = this.getResourceAccessInterface(shadow);
        Object connector = rai.getConnector();
        ResourceSchema schema = ((ResourceConnector)connector).getSchema();
        ResourceObject id = this.valueWriter.buildResourceObject(shadow, schema);
        OperationalResultType result = new OperationalResultType();
        ResourceObject resultObject = rai.get(result, id);
        if (resultObject == null) {
            throw new FaultMessage("The object " + shadow.getOid() + " could not be found", (FaultType)new SystemFaultType());
        }
        new ObjectValueWriter().merge(resultObject, (List<Element>)shadow.getAttributes().getAny(), false);
        this.unresolveResource(shadow);
    }

    protected void unresolveResource(ResourceObjectShadowType shadow) {
        if (null != shadow.getResource()) {
            ObjectReferenceType ort = new ObjectReferenceType();
            ort.setOid(shadow.getResource().getOid());
            shadow.setResourceRef(ort);
            shadow.setResource(null);
        }
    }

    protected void resolveResource(ResourceObjectShadowType shadow) throws com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage {
        if (shadow.getResource() == null) {
            if (shadow.getResourceRef() == null) {
                throw new com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage("Resource and resourceRef are undefined at object(oid=" + shadow.getOid() + "). One of them should be set.", (FaultType)new SchemaViolationFaultType());
            }
            String resourceOid = shadow.getResourceRef().getOid();
            ObjectContainerType oc = this.getRepository().getObject(resourceOid, new PropertyReferenceListType());
            if (oc == null) {
                throw new MidPointException("Invalid resource in object (oid=" + shadow.getOid() + ")");
            }
            ResourceType resource = (ResourceType)oc.getObject();
            shadow.setResource(resource);
        }
    }

    public Set<AttributeChange> processObjectChanges(ResourceSchema schema, ResourceObjectDefinition objectDefinition, ObjectModificationType objectChange) throws IllegalRequestException {
        HashSet<AttributeChange> attrChanges = new HashSet<AttributeChange>();
        for (PropertyModificationType change : objectChange.getPropertyModification()) {
            XPathType xpath = new XPathType(change.getPath());
            List segments = xpath.toSegments();
            List any = change.getValue().getAny();
            if (any != null && !any.isEmpty()) {
                QName attrQName = null;
                Element firstElement = (Element)any.get(0);
                String localName = firstElement.getLocalName();
                String namespace = firstElement.getNamespaceURI();
                boolean credentials = false;
                if (segments.isEmpty()) {
                    if (SchemaConstants.I_CREDENTIALS.getLocalPart().equals(localName)) {
                        credentials = true;
                    }
                } else if (SchemaConstants.I_ATTRIBUTES.equals(((XPathSegment)segments.get(0)).getQName())) {
                    if (segments.size() > 1) {
                        throw new IllegalRequestException("Hierarchy in " + ((XPathSegment)segments.get(0)).getQName() + " is not supported (XPath)");
                    }
                } else if (SchemaConstants.I_CREDENTIALS.equals(((XPathSegment)segments.get(0)).getQName())) {
                    credentials = true;
                }
                attrQName = credentials ? new QName("http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/resource-schema-1.xsd", "__PASSWORD__") : new QName(namespace, localName);
                ResourceAttributeDefinition attributeDefinition = objectDefinition.getAttributeDefinition(attrQName);
                ResourceAttribute resourceAttribute = new ResourceAttribute(attributeDefinition);
                for (Element element : any) {
                    if (credentials) {
                        Node password = null;
                        if (segments.isEmpty()) {
                            NodeList l = element.getElementsByTagNameNS("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "password");
                            if (l.getLength() == 1) {
                                password = l.item(0).getFirstChild();
                            }
                        } else {
                            password = element.getFirstChild();
                        }
                        if (null != password) {
                            password.setTextContent(new String(Base64.decodeBase64((String)password.getTextContent())));
                            resourceAttribute.addJavaValue(password.getTextContent());
                            continue;
                        }
                        resourceAttribute.addJavaValue("");
                        continue;
                    }
                    resourceAttribute.addValue(element.getFirstChild());
                }
                AttributeChange attrChange = new AttributeChange();
                attrChange.setChangeType(change.getModificationType());
                attrChange.setAttribute(resourceAttribute);
                attrChanges.add(attrChange);
                continue;
            }
            logger.warn("modifyObject(): Received empty attribute value element for oid {}", (Object)objectChange.getOid());
        }
        return attrChanges;
    }

    private QName getAttrNameFromXPath(ResourceObjectDefinition definition, XPathType xpath) throws IllegalRequestException {
        List segments = xpath.toSegments();
        if (!SchemaConstants.I_ATTRIBUTES.equals(((XPathSegment)segments.get(0)).getQName())) {
            throw new IllegalRequestException("Expected XPath starting with " + SchemaConstants.I_ATTRIBUTES + ", got " + xpath);
        }
        QName attrQName = ((XPathSegment)segments.get(1)).getQName();
        for (ResourceAttributeDefinition rad : definition.getAttributesCopy()) {
            if (!rad.getQName().equals(attrQName)) continue;
            return attrQName;
        }
        throw new IllegalRequestException("Attribute definition not found for " + attrQName + " (xpath " + xpath + " )");
    }

    private ResourceSchema mergeSchema(ResourceAccessInterface rai, ResourceObjectShadowType shadow) {
        ResourceSchema schema = ((ResourceConnector)rai.getConnector()).getSchema();
        return schema;
    }

    private FaultMessage createFaultMessage(String message, FaultType faultType, Exception ex, OperationalResultType result) {
        if (faultType.getMessage() == null || faultType.getMessage().isEmpty()) {
            faultType.setMessage(message);
        } else {
            faultType.setMessage(message + " : " + faultType.getMessage());
        }
        return new FaultMessage(message, faultType, (Throwable)ex);
    }

    private FaultMessage createFaultMessage(String message, Class<? extends FaultType> faultTypeClass, boolean temporary, Exception exception, OperationalResultType result) {
        FaultType fault;
        try {
            fault = faultTypeClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot instantate " + faultTypeClass.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot instantate " + faultTypeClass.getName(), ex);
        }
        if (exception instanceof RuntimeException) {
            fault.setMessage(message + " : " + exception.getClass().getSimpleName() + " : " + exception.getMessage());
        } else {
            fault.setMessage(message);
        }
        fault.setTemporary(temporary);
        return new FaultMessage(message, fault, (Throwable)exception);
    }

    public OperationalResultType synchronize(String oid) throws FaultMessage {
        OperationalResultType result;
        block15: {
            logger.info("### PROVISIONING # Enter synchronize({})", (Object)oid);
            result = new OperationalResultType();
            this.testOid(oid);
            try {
                ObjectContainerType oct = this.getRepository().getObject(oid, new PropertyReferenceListType());
                if (oct == null) {
                    logger.error("### PROVISIONING # Fault synchronize(..): No object with oid {}", (Object)oid);
                    throw new FaultMessage("No object with oid " + oid, (FaultType)new IllegalArgumentFaultType());
                }
                ObjectType c = oct.getObject();
                if (c instanceof ResourceType) {
                    ResourceType resource = (ResourceType)c;
                    try {
                        ResourceAccessInterface rai = this.getResourceAccessInterface(resource.getOid(), resource);
                        ResourceStateType state = this.getResourceState(resource.getOid());
                        ResourceStateType.SynchronizationState syncToken = state == null ? null : state.getSynchronizationState();
                        ResourceSchema schema = ((ResourceConnector)rai.getConnector()).getSchema();
                        ResourceObjectDefinition rad = ((ResourceConnector)rai.getConnector()).getSchema().getObjectDefinition(new QName(schema.getResourceNamespace(), "Account"));
                        SynchronizationResult changeCollection = rai.synchronize(syncToken, result, rad);
                        if (changeCollection.getChanges().isEmpty()) {
                            logger.info("Synchronization (OID:{}) detected no changes", (Object)resource.getOid());
                        }
                        for (SynchronizationResult.Change changeWrapper : changeCollection.getChanges()) {
                            ObjectChangeType change = changeWrapper.getChange();
                            logger.info("Synchronization (OID:{}) detected change: {}", (Object)resource.getOid(), (Object)DebugUtil.prettyPrint((ObjectChangeType)change));
                            ObjectChangeAdditionType newChange = new ObjectChangeAdditionType();
                            ResourceObjectShadowChangeDescriptionType roscdt = new ResourceObjectShadowChangeDescriptionType();
                            roscdt.setSourceChannel(QNameUtil.qNameToUri((QName)SchemaConstants.CHANGE_CHANNEL_SYNC));
                            roscdt.setResource(resource);
                            ObjectType originalShadow = null;
                            if (changeWrapper.getChange() instanceof ObjectChangeDeletionType) {
                                ObjectChangeDeletionType ocd = (ObjectChangeDeletionType)changeWrapper.getChange();
                                originalShadow = this.findOrCreateShadow(null, ocd.getOid(), resource);
                                if (originalShadow == null) {
                                    logger.warn("Got delete sync message for already deleted shadow {}, resource {}. ignoring it", (Object)ocd.getOid(), (Object)resource.getName());
                                    state = this.refreshToken(state, oid, resource.getName(), changeWrapper.getToken());
                                    continue;
                                }
                                roscdt.setObjectChange(change);
                            } else {
                                originalShadow = this.findOrCreateShadow(changeWrapper.getIdentifier(), null, resource);
                                ((ObjectChangeModificationType)change).getObjectModification().setOid(originalShadow.getOid());
                                this.getRepository().modifyObject(((ObjectChangeModificationType)change).getObjectModification());
                                ObjectContainerType object = this.getRepository().getObject(((ObjectChangeModificationType)change).getObjectModification().getOid(), new PropertyReferenceListType());
                                ((AccountShadowType)object.getObject()).setResource(resource);
                                newChange.setObject(object.getObject());
                                roscdt.setObjectChange((ObjectChangeType)newChange);
                            }
                            if (!(originalShadow instanceof ResourceObjectShadowType)) {
                                logger.error("### PROVISIONING # Fault synchronize(..): Invalid change object. The changed object is not a resourceObject. OID={}", (Object)originalShadow.getOid());
                                throw new FaultMessage("Invalid change object. The changed object is not a resourceObject. OID=" + originalShadow.getOid(), (FaultType)new SystemFaultType());
                            }
                            ((ResourceObjectShadowType)originalShadow).setResource(resource);
                            roscdt.setShadow((ResourceObjectShadowType)originalShadow);
                            this.objectChangeListener.notifyChange(roscdt);
                            if (changeWrapper.getChange() instanceof ObjectChangeDeletionType) {
                                this.getRepository().deleteObject(originalShadow.getOid());
                            }
                            state = this.refreshToken(state, oid, resource.getName(), changeWrapper.getToken());
                        }
                        break block15;
                    }
                    catch (JAXBException ex) {
                        logger.error("### PROVISIONING # Fault synchronize(..): Unknown error : {}", (Object)ex.getMessage());
                        logger.debug("Unknown error " + (Object)((Object)ex));
                        throw new FaultMessage("Unknown error occured.", (FaultType)new SystemFaultType(), (Throwable)ex);
                    }
                    catch (com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage ex) {
                        logger.error("### PROVISIONING # Fault synchronize(..): Unknown error : {}", (Object)ex.getMessage());
                        logger.debug("Unknown error " + (Object)((Object)ex));
                        throw new FaultMessage("Unknown error occured.", (FaultType)new SystemFaultType(), (Throwable)ex);
                    }
                    catch (MidPointException ex) {
                        logger.error("### PROVISIONING # Fault synchronize(..): Unknown error : {}", (Object)ex.getMessage());
                        logger.debug("Unknown error " + (Object)((Object)ex));
                        throw new FaultMessage("Unknown error occured.", (FaultType)new SystemFaultType(), (Throwable)ex);
                    }
                }
                logger.error("### PROVISIONING # Fault syncronize(..): Unsupported object type {} (OID: {})", (Object)c.getClass().getName(), (Object)oid);
                throw new FaultMessage("Unsupported object type " + c.getClass().getName() + " (OID: " + oid + ")", (FaultType)new IllegalArgumentFaultType());
            }
            catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
                logger.error("### PROVISIONING # Fault deleteObject(..): Unknown error : {}", (Object)ex.getMessage());
                logger.debug("Unknown error occured.", (Throwable)ex);
                throw new FaultMessage("Unknown error occured.", (FaultType)new SystemFaultType(), (Throwable)ex);
            }
        }
        logger.info("### PROVISIONING # Exit synchronize(..): {}", (Object)result);
        return result;
    }

    public ResourceTestResultType testResource(String resourceOid) throws FaultMessage {
        logger.info("### PROVISIONING # Enter testResource({})", (Object)resourceOid);
        ResourceAccessInterface rai = null;
        TestResultType initTestResult = new TestResultType();
        try {
            rai = this.getResourceAccessInterface(resourceOid, null);
            initTestResult.setSuccess(true);
        }
        catch (RuntimeException ex) {
            initTestResult.setSuccess(false);
            List errorOrWarning = initTestResult.getErrorOrWarning();
            DiagnosticsMessageType message = new DiagnosticsMessageType();
            message.setMessage(ex.getClass().getName() + ": " + ex.getMessage());
            JAXBElement element = new JAXBElement(SchemaConstants.I_DIAGNOSTICS_MESSAGE_ERROR, DiagnosticsMessageType.class, (Object)message);
            errorOrWarning.add(element);
        }
        ResourceTestResultType result = rai.test();
        if (result.getConnectorInitialization() == null) {
            result.setConnectorInitialization(initTestResult);
        }
        logger.info("### PROVISIONING # Exit testResource(..): {}", (Object)result);
        return result;
    }

    public synchronized EmptyType launchImportFromResource(String resourceOid, String objectClass) throws FaultMessage {
        logger.info("### PROVISIONING # Enter launchImportFromResource({},{})", (Object)resourceOid, (Object)objectClass);
        ResourceType resource = null;
        try {
            resource = (ResourceType)this.getRepository().getObject(resourceOid, new PropertyReferenceListType()).getObject();
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### PROVISIONING # Fault launchImportFromResource(..) : Repository error : {}", (Object)ex.getMessage());
            throw this.createFaultMessage("Repository invocation failed (getObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
        catch (ClassCastException ex) {
            logger.error("### PROVISIONING # Fault launchImportFromResource(..): Object with OID {} is not a resource", (Object)resourceOid);
            throw new FaultMessage("Object with OID " + resourceOid + " is not a resource", (FaultType)new SystemFaultType());
        }
        ImportFromResourceTask task = this.importTasks.get(resourceOid);
        if (task != null && task.isAlive()) {
            logger.error("### PROVISIONING # Fault launchImportFromResource({},{}): An import task is already running", (Object)resourceOid, (Object)objectClass);
            throw new FaultMessage("An import task is already running", (FaultType)new SystemFaultType());
        }
        ResourceAccessInterface rai = this.getResourceAccessInterface(resourceOid, null);
        ResourceSchema schema = ((ResourceConnector)rai.getConnector()).getSchema();
        ResourceObjectDefinition objectDefinition = null;
        try {
            objectDefinition = schema.getObjectDefinition(new QName(schema.getResourceNamespace(), objectClass));
        }
        catch (MidPointException ex) {
            logger.error("### PROVISIONING # Fault launchImportFromResource(..): Definition of object class {} not found in resource schema", (Object)objectClass);
            throw new FaultMessage("Definition of object class " + objectClass + " not found in resource schema", (FaultType)new SystemFaultType());
        }
        task = new ImportFromResourceTask(resource, rai, objectDefinition);
        task.setName(IMPORT_TASK_NAME_PREFIX + resource.getOid());
        task.setResourceObjectShadowCache(this.getResourceObjectShadowCache());
        task.setObjectChangeListener(this.getObjectChangeListener());
        logger.info("Staring import task, importing from resource {} (OID: {})", (Object)resource.getName(), (Object)resource.getOid());
        task.start();
        this.importTasks.put(resourceOid, task);
        logger.info("### PROVISIONING # Exit launchImportFromResource({},{})", (Object)resourceOid, (Object)objectClass);
        return new EmptyType();
    }

    public TaskStatusType getImportStatus(String resourceOid) throws FaultMessage {
        logger.info("### PROVISIONING # Enter getImportStatus({})", (Object)resourceOid);
        ResourceType resource = null;
        try {
            resource = (ResourceType)this.getRepository().getObject(resourceOid, new PropertyReferenceListType()).getObject();
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### PROVISIONING # Fault getImportStatus(..) : Repository error : {}", (Object)ex.getMessage());
            throw this.createFaultMessage("Repository invocation failed (getObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
        catch (ClassCastException ex) {
            logger.error("### PROVISIONING # Fault getImportStatus(..): Object with OID {} is not a resource, reason: {}", new Object[]{resourceOid, ex.getMessage()});
            throw new FaultMessage("Object with OID " + resourceOid + " is not a resource, reason: " + ex.getMessage(), (FaultType)new SystemFaultType());
        }
        TaskStatusType status = new TaskStatusType();
        status.setName("Import from resource " + resource.getName() + " (OID: " + resourceOid + ")");
        ImportFromResourceTask task = this.importTasks.get(resourceOid);
        if (task == null) {
            status.setRunning(false);
            status.setLastStatus("none");
            logger.info("### PROVISIONING # Exit getImportStatus({}): {}", (Object)resourceOid, (Object)status);
            return status;
        }
        DatatypeFactory dtf = null;
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            Logger.getLogger(ProvisioningService.class.getName()).log(Level.SEVERE, null, ex);
        }
        status.setLastStatus("unknown");
        status.setRunning(task.isAlive());
        status.setProgress(Long.valueOf(task.getProgress()));
        Long launchTime = task.getLaunchTime();
        if (launchTime != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(launchTime);
            XMLGregorianCalendar xmlLaunchTime = dtf.newXMLGregorianCalendar(gregorianCalendar);
            status.setLaunchTime(xmlLaunchTime);
        } else {
            status.setLastStatus("starting");
        }
        if (task.isAlive()) {
            status.setLastStatus("running");
        }
        if (task.getLastError() != null) {
            status.setLastStatus("error");
        }
        if (task.getLastError() != null) {
            DiagnosticsMessageType diagMsg = new DiagnosticsMessageType();
            Exception lastError = task.getLastError();
            diagMsg.setMessage(lastError.getClass().getSimpleName() + ": " + lastError.getMessage());
            long errorTime = task.getLastErrorTime();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(errorTime);
            XMLGregorianCalendar xmlErrorTime = dtf.newXMLGregorianCalendar(gregorianCalendar);
            diagMsg.setTimestamp(xmlErrorTime);
            diagMsg.setDetails("");
            status.setLastError(diagMsg);
        }
        status.setNumberOfErrors(Long.valueOf(task.getNumberOfErrors()));
        Long finishTime = task.getFinishTime();
        if (finishTime != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(finishTime);
            XMLGregorianCalendar xmlLaunchTime = dtf.newXMLGregorianCalendar(gregorianCalendar);
            status.setFinishTime(xmlLaunchTime);
            status.setLastStatus("finished");
        }
        logger.info("### PROVISIONING # Exit getImportStatus({}): {}", (Object)resourceOid, (Object)status);
        return status;
    }

    public void setObjectChangeListener(ResourceObjectChangeListenerPortType objectChangeListener) {
        this.objectChangeListener = objectChangeListener;
    }

    public ResourceObjectChangeListenerPortType getObjectChangeListener() {
        return this.objectChangeListener;
    }

    public void setRepositoryService(RepositoryPortType repositoryService) {
        this.repositoryService = repositoryService;
    }

    private ResourceStateType getResourceState(String oid) throws com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage {
        QueryType query = this.createSearchStateQuery(oid);
        PagingType paging = new PagingType();
        ObjectListType results = this.getRepository().searchObjects(query, paging);
        if (results.getObject().size() == 0) {
            return null;
        }
        if (results.getObject().size() > 1) {
            logger.warn("Found more than one resource states for OID: {}", (Object)oid);
        }
        return (ResourceStateType)results.getObject().get(0);
    }

    private ResourceStateType refreshToken(ResourceStateType state, String oid, String resourceName, ResourceStateType.SynchronizationState syncToken) throws com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage {
        if (state == null) {
            ObjectContainerType oct = new ObjectContainerType();
            state = new ResourceStateType();
            ObjectReferenceType ort = new ObjectReferenceType();
            ort.setOid(oid);
            state.setResourceRef(ort);
            state.setSynchronizationState(syncToken);
            state.setName(resourceName);
            oct.setObject((ObjectType)state);
            String newOid = this.getRepository().addObject(oct);
            state.setOid(newOid);
            return state;
        }
        ObjectModificationType obj = new ObjectModificationType();
        obj.setOid(state.getOid());
        PropertyModificationType modification = new PropertyModificationType();
        modification.setValue(new PropertyModificationType.Value());
        modification.getValue().getAny().addAll(syncToken.getAny());
        modification.setModificationType(PropertyModificationTypeType.replace);
        ArrayList<XPathSegment> segments = new ArrayList<XPathSegment>();
        segments.add(new XPathSegment(new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "synchronizationState")));
        XPathType xpath = new XPathType(segments);
        modification.setPath(xpath.toElement("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "path"));
        obj.getPropertyModification().add(modification);
        this.getRepository().modifyObject(obj);
        return state;
    }

    private ObjectType findOrCreateShadow(ResourceObject identifier, String acctOid, ResourceType resource) throws JAXBException, com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage, FaultMessage {
        PagingType paging = new PagingType();
        QueryType query = this.createSearchShadowQuery(identifier, acctOid);
        ObjectListType results = this.getRepository().searchObjects(query, paging);
        if (results == null || results.getObject().size() != 1) {
            if (identifier == null) {
                logger.warn("Object with OID " + acctOid + " can not be found");
                return null;
            }
            Holder holder = new Holder((Object)new OperationalResultType());
            ObjectContainerType oct = new ObjectContainerType();
            AccountShadowType shadow = new AccountShadowType();
            ObjectReferenceType ort = new ObjectReferenceType();
            ort.setOid(resource.getOid());
            shadow.setResourceRef(ort);
            shadow.setAttributes(new ResourceObjectShadowType.Attributes());
            new ObjectValueWriter().merge(identifier, (List<Element>)shadow.getAttributes().getAny(), false);
            shadow.setObjectClass(new QName(resource.getNamespace(), "Account"));
            oct.setObject((ObjectType)shadow);
            ResourceAccessInterface rai = this.getResourceAccessInterface((ResourceObjectShadowType)shadow);
            ResourceSchema schema = ((ResourceConnector)rai.getConnector()).getSchema();
            ResourceObjectDefinition objectDefinition = schema.getObjectDefinition(shadow.getObjectClass());
            ResourceAttributeDefinition attributeDefinition = objectDefinition.getPrimaryIdentifier();
            shadow.setName((String)identifier.getValue(attributeDefinition.getQName()).getSingleJavaValue());
            String oid = this.getRepository().addObject(oct);
            return this.getObject(oid, new PropertyReferenceListType(), (Holder<OperationalResultType>)holder).getObject();
        }
        return (ObjectType)results.getObject().get(0);
    }

    protected QueryType createSearchStateQuery(String oid) {
        Document doc = ShadowUtil.getXmlDocument();
        Element resourceRef = doc.createElementNS(SchemaConstants.I_RESOURCE_REF.getNamespaceURI(), SchemaConstants.I_RESOURCE_REF.getLocalPart());
        resourceRef.setAttribute("oid", oid);
        Element filter = QueryUtil.createAndFilter((Document)doc, (Element)QueryUtil.createTypeFilter((Document)doc, (String)QNameUtil.qNameToUri((QName)SchemaConstants.I_RESOURCE_STATE_TYPE)), (Element)QueryUtil.createEqualFilter((Document)doc, null, (Element)resourceRef));
        QueryType query = new QueryType();
        query.setFilter(filter);
        return query;
    }

    protected QueryType createSearchShadowQuery(ResourceObject identifier, String oid) {
        XPathSegment xpathSegment = new XPathSegment(SchemaConstants.I_ATTRIBUTES);
        ArrayList<XPathSegment> xpathSegments = new ArrayList<XPathSegment>();
        xpathSegments.add(xpathSegment);
        XPathType xpath = new XPathType(xpathSegments);
        ArrayList<Element> values = new ArrayList<Element>();
        Document doc = ShadowUtil.getXmlDocument();
        Element uid = null;
        if (oid != null) {
            uid = doc.createElementNS("http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/resource-schema-1.xsd", "__UID__");
            uid.setTextContent(oid);
        } else {
            this.valueWriter.merge(identifier, values, false);
            for (Element element : values) {
                if (!"__UID__".equals(element.getLocalName())) continue;
                uid = element;
            }
        }
        Element filter = QueryUtil.createAndFilter((Document)doc, (Element)QueryUtil.createTypeFilter((Document)doc, (String)QNameUtil.qNameToUri((QName)SchemaConstants.I_ACCOUNT_TYPE)), (Element)QueryUtil.createEqualFilter((Document)doc, (XPathType)xpath, (Element)uid));
        QueryType query = new QueryType();
        query.setFilter(filter);
        return query;
    }

    private void processScripts(OperationalResultType result, ResourceAccessInterface rai, ScriptsType scripts, ScriptOrderType order, OperationTypeType type) {
        logger.trace("Enter processScripts({})");
        if (scripts != null) {
            for (ScriptType script : scripts.getScript()) {
                if (!order.equals((Object)script.getOrder()) || !script.getOperation().contains(type)) continue;
                logger.debug("Executing script: " + script.getCode());
                try {
                    rai.executeScript(result, script);
                }
                catch (MidPointException ex) {
                    logger.error("Script execution failed: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
    }
}

