/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.schema.util;

import com.evolveum.midpoint.provisioning.exceptions.ConversionException;
import com.evolveum.midpoint.provisioning.schema.AccountObjectClassDefinition;
import com.evolveum.midpoint.provisioning.schema.AttributeFlag;
import com.evolveum.midpoint.provisioning.schema.ResourceAttributeDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceObjectDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceSchema;
import com.evolveum.midpoint.provisioning.schema.util.SchemaDOMElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaToDOMParser {
    public static final String RESOURCE_OBJECT_CLASS = "ResourceObjectClass";
    private static final String MAX_OCCURS_UNBOUNDED = "unbounded";
    private Document document;
    private Map<String, String> defaultPrefixMap = new HashMap<String, String>();
    private Map<String, String> prefixMap = new HashMap<String, String>();
    private boolean attributeQualified = false;

    public SchemaToDOMParser() {
        this(null);
    }

    public SchemaToDOMParser(Map<String, String> defaultPrefixMap) {
        this.defaultPrefixMap = defaultPrefixMap;
    }

    public boolean isAttributeQualified() {
        return this.attributeQualified;
    }

    public void setAttributeQualified(boolean attributeQualified) {
        this.attributeQualified = attributeQualified;
    }

    private void init(ResourceSchema resSchema) {
        this.document = null;
        this.prefixMap.clear();
        if (this.defaultPrefixMap == null) {
            this.prefixMap.put("http://www.w3.org/2001/XMLSchema", "xsd");
            this.prefixMap.put("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "c");
            this.prefixMap.put("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd", "r");
        } else {
            this.prefixMap.putAll(this.defaultPrefixMap);
        }
        Set<String> imports = resSchema.getImportList();
        int i = 0;
        String generatedPrefix = "xns";
        this.prefixMap.put(resSchema.getResourceNamespace(), "xns" + i);
        for (String importNamespace : imports) {
            if (this.prefixMap.containsKey(importNamespace)) continue;
            this.prefixMap.put(importNamespace, "xns" + ++i);
        }
    }

    public Document getDomSchemaHandling(ResourceSchema resSchema) {
        return null;
    }

    public Document getDomSchema(ResourceSchema resSchema) {
        this.init(resSchema);
        try {
            this.document = this.createSchemaDocument(resSchema.getResourceNamespace());
        }
        catch (ParserConfigurationException ex) {
            throw new ConversionException("Can't create document for XSD schema: " + ex.getMessage(), ex);
        }
        Element schema = this.document.getDocumentElement();
        Set<String> imports = resSchema.getImportList();
        for (String importNamespace : imports) {
            schema.appendChild(this.createImport(importNamespace));
        }
        if (!imports.contains("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd")) {
            schema.appendChild(this.createImport("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd"));
        }
        if (!imports.contains("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd")) {
            schema.appendChild(this.createImport("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd"));
        }
        Iterator<ResourceObjectDefinition> it = resSchema.getObjectClassesIterator();
        while (it.hasNext()) {
            ResourceObjectDefinition objClass = it.next();
            schema.appendChild(this.createComplexType(objClass, resSchema.getResourceNamespace()));
        }
        Set<String> usedNamespaces = this.updatePrefixes(schema);
        this.addNamespaces(schema, usedNamespaces);
        return this.document;
    }

    private void addNamespaces(Element schema, Set<String> usedNamespaces) {
        Set<Map.Entry<String, String>> set = this.prefixMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (schema.hasAttribute("xmlns:" + entry.getValue()) || usedNamespaces.contains(entry.getKey())) continue;
            schema.setAttribute("xmlns:" + entry.getValue(), entry.getKey());
        }
    }

    private void setAttribute(Element element, String attrName, String attrValue) {
        this.setAttribute(element, new QName("http://www.w3.org/2001/XMLSchema", attrName), attrValue);
    }

    private void setAttribute(Element element, QName attr, String attrValue) {
        if (this.attributeQualified) {
            element.setAttributeNS(attr.getNamespaceURI(), attr.getLocalPart(), attrValue);
        } else {
            element.setAttribute(attr.getLocalPart(), attrValue);
        }
    }

    private Element createComplexType(ResourceObjectDefinition objClass, String resourceNamespace) {
        Element complexType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.setAttribute(complexType, "name", objClass.getQName().getLocalPart());
        Element annotation = this.createObjectClassAnnotation(objClass);
        if (annotation != null) {
            complexType.appendChild(annotation);
        }
        Element complexContent = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
        complexType.appendChild(complexContent);
        Element extension = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
        this.setAttribute(extension, "base", this.prefixMap.get("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd") + ":" + RESOURCE_OBJECT_CLASS);
        extension.setAttribute("xmlns:" + this.prefixMap.get("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd"), "http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd");
        complexContent.appendChild(extension);
        Element sequence = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        extension.appendChild(sequence);
        Collection<ResourceAttributeDefinition> resAttributeList = objClass.getAttributesCopy();
        for (ResourceAttributeDefinition attribute : resAttributeList) {
            Element element = this.createElement(attribute, resourceNamespace);
            sequence.appendChild(element);
        }
        return complexType;
    }

    private String createPrefixedValue(QName name) {
        StringBuilder builder = new StringBuilder();
        String prefix = this.prefixMap.get(name.getNamespaceURI());
        if (prefix != null) {
            builder.append(prefix);
            builder.append(":");
        }
        builder.append(name.getLocalPart());
        return builder.toString();
    }

    private Element createObjectClassAnnotation(ResourceObjectDefinition objClass) {
        Element annotation = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
        Element appinfo = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
        annotation.appendChild(appinfo);
        ResourceAttributeDefinition identifier = null;
        ResourceAttributeDefinition displayName = null;
        ResourceAttributeDefinition secondaryIdentifier = null;
        ResourceAttributeDefinition compositeIdentifier = null;
        ResourceAttributeDefinition descriptionAttribute = null;
        Collection<ResourceAttributeDefinition> resAttributeList = objClass.getAttributesCopy();
        for (ResourceAttributeDefinition attr : resAttributeList) {
            if (attr.isIdentifier()) {
                identifier = attr;
            }
            if (attr.isDisplayName()) {
                displayName = attr;
            }
            if (attr.isSecondaryIdentifier()) {
                secondaryIdentifier = attr;
            }
            if (attr.isCompositeIdentifier()) {
                compositeIdentifier = attr;
            }
            if (attr.isDescriptionAttribute()) {
                descriptionAttribute = attr;
            }
            if (identifier == null || displayName == null || secondaryIdentifier == null || compositeIdentifier == null || descriptionAttribute == null) continue;
            break;
        }
        if (identifier != null) {
            appinfo.appendChild(this.createRefAnnotation(SchemaDOMElement.A_IDENTIFIER, this.createPrefixedValue(identifier.getQName())));
        }
        if (secondaryIdentifier != null) {
            appinfo.appendChild(this.createRefAnnotation(SchemaDOMElement.A_SECONDARY_IDENTIFIER, this.createPrefixedValue(secondaryIdentifier.getQName())));
        }
        if (compositeIdentifier != null) {
            appinfo.appendChild(this.createRefAnnotation(SchemaDOMElement.A_COMPOSITE_IDENTIFIER, this.createPrefixedValue(compositeIdentifier.getQName())));
        }
        if (displayName != null) {
            appinfo.appendChild(this.createRefAnnotation(SchemaDOMElement.A_DISPLAY_NAME, this.createPrefixedValue(displayName.getQName())));
        }
        if (descriptionAttribute != null) {
            appinfo.appendChild(this.createRefAnnotation(SchemaDOMElement.A_DESCRIPTION_ATTRIBUTE, this.createPrefixedValue(descriptionAttribute.getQName())));
        }
        appinfo.appendChild(this.createAnnotation(SchemaDOMElement.A_NATIVE_OBJECT_CLASS, objClass.getNativeObjectClass()));
        if (objClass.isContainer()) {
            appinfo.appendChild(this.createAnnotation(SchemaDOMElement.A_CONTAINER, null));
        }
        if (objClass instanceof AccountObjectClassDefinition) {
            AccountObjectClassDefinition accObjClass = (AccountObjectClassDefinition)objClass;
            Element accountTypeAnnotation = this.createAnnotation(SchemaDOMElement.A_ACCOUNT_TYPE, null);
            if (accObjClass.isDefault()) {
                this.setAttribute(accountTypeAnnotation, SchemaDOMElement.A_ATTR_DEFAULT, "true");
            }
            appinfo.appendChild(accountTypeAnnotation);
        }
        return annotation;
    }

    private Element createRefAnnotation(QName qname, String value) {
        Element access = this.document.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        this.setAttribute(access, new QName("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd", "ref"), value);
        return access;
    }

    private Element createElement(ResourceAttributeDefinition attribute, String resourceNamespace) {
        Element annotation;
        Element element = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        String attrNamespace = attribute.getQName().getNamespaceURI();
        if (attrNamespace != null && attrNamespace.equals(resourceNamespace)) {
            this.setAttribute(element, "name", attribute.getQName().getLocalPart());
            this.setAttribute(element, "type", this.createPrefixedValue(attribute.getType()));
        } else {
            this.setAttribute(element, "ref", this.createPrefixedValue(attribute.getQName()));
        }
        if (attribute.getMinOccurs() != 1) {
            this.setAttribute(element, "minOccurs", Integer.toString(attribute.getMinOccurs()));
        }
        if (attribute.getMaxOccurs() != 1) {
            String maxOccurs = attribute.getMaxOccurs() == -1 ? MAX_OCCURS_UNBOUNDED : Integer.toString(attribute.getMaxOccurs());
            this.setAttribute(element, "maxOccurs", maxOccurs);
        }
        if ((annotation = this.createAttributeAnnotation(attribute)) != null) {
            element.appendChild(annotation);
        }
        return element;
    }

    private Element createAttributeAnnotation(ResourceAttributeDefinition attribute) {
        boolean appinfoUsed = false;
        Element appinfo = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
        StringBuilder builder = new StringBuilder();
        List<AttributeFlag> flags = attribute.getAttributeFlag();
        for (AttributeFlag flag : flags) {
            builder.append((Object)flag);
            if (flags.indexOf((Object)flag) + 1 == flags.size()) continue;
            builder.append(" ");
        }
        if (builder.length() != 0) {
            appinfoUsed = true;
            appinfo.appendChild(this.createAnnotation(SchemaDOMElement.A_ATTRIBUTE_FLAG, builder.toString()));
        }
        ResourceAttributeDefinition.ClassifiedAttributeInfo classifiedInfo = attribute.getClassifiedAttributeInfo();
        if (attribute.isClassifiedAttribute() && classifiedInfo != null) {
            String classificationLevel;
            Element classifiedAttribute = this.document.createElementNS(SchemaDOMElement.A_CLASSIFIED_ATTRIBUTE.getNamespaceURI(), SchemaDOMElement.A_CLASSIFIED_ATTRIBUTE.getLocalPart());
            appinfo.appendChild(classifiedAttribute);
            ResourceAttributeDefinition.Encryption encryption = classifiedInfo.getEncryption();
            if (encryption != null && encryption != ResourceAttributeDefinition.Encryption.NONE) {
                classifiedAttribute.appendChild(this.createAnnotation(SchemaDOMElement.A_CA_ENCRYPTION, encryption.toString()));
            }
            if ((classificationLevel = classifiedInfo.getClassificationLevel()) != null && !classificationLevel.isEmpty()) {
                classifiedAttribute.appendChild(this.createAnnotation(SchemaDOMElement.A_CA_CLASSIFICATION_LEVEL, classificationLevel));
            }
        }
        if (attribute.getAttributeDisplayName() != null) {
            appinfo.appendChild(this.createAnnotation(SchemaDOMElement.A_ATTRIBUTE_DISPLAY_NAME, attribute.getAttributeDisplayName()));
            appinfoUsed = true;
        }
        if (attribute.getHelp() != null) {
            appinfo.appendChild(this.createAnnotation(SchemaDOMElement.A_HELP, attribute.getHelp()));
            appinfoUsed = true;
        }
        if (attribute.getNativeAttributeName() != null) {
            appinfo.appendChild(this.createAnnotation(SchemaDOMElement.A_NATIVE_ATTRIBUTE_NAME, attribute.getNativeAttributeName()));
            appinfoUsed = true;
        }
        if (!appinfoUsed) {
            return null;
        }
        Element annotation = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
        if (appinfoUsed) {
            annotation.appendChild(appinfo);
        }
        return annotation;
    }

    private Element createAnnotation(QName qname, String value) {
        Element annotation = this.document.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        annotation.setTextContent(value);
        return annotation;
    }

    private Element createImport(String namespace) {
        Element element = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
        this.setAttribute(element, "namespace", namespace);
        return element;
    }

    private Document createSchemaDocument(String targetNamespace) throws ParserConfigurationException {
        QName name = new QName("http://www.w3.org/2001/XMLSchema", "schema");
        Document doc = this.createDocument(name);
        Element root = doc.getDocumentElement();
        this.setAttribute(root, "targetNamespace", targetNamespace);
        this.setAttribute(root, "elementFormDefault", "qualified");
        if (this.attributeQualified) {
            this.setAttribute(root, "attributeFormDefault", "qualified");
        }
        return doc;
    }

    private Document createSchemaHandlingDocument() throws ParserConfigurationException {
        Document doc = this.createDocument(new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "schemaHandling"));
        return doc;
    }

    private Document createDocument(QName name) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        doc.appendChild(root);
        return doc;
    }

    private Set<String> updatePrefixes(Node parent) {
        HashSet<String> usedNamespaces = new HashSet<String>();
        if (parent.getNamespaceURI() != null) {
            usedNamespaces.add(parent.getNamespaceURI());
            parent.setPrefix(this.prefixMap.get(parent.getNamespaceURI()));
        }
        if (parent.hasChildNodes()) {
            NodeList children = parent.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                usedNamespaces.addAll(this.updatePrefixes(child));
            }
        }
        return usedNamespaces;
    }
}

