/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.schema.util;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import java.text.MessageFormat;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaErrorLog
implements ErrorHandler {
    private static final Trace logger = TraceManager.getTrace(SchemaErrorLog.class);

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.print("[Warning]", e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.print("[Error]", e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.print("[Fatal]", e);
    }

    private void print(String header, SAXParseException e) {
        String message = "Error occured during schema parsing: " + header + " " + MessageFormat.format("on line {0} at {1}", Integer.toString(e.getLineNumber()), e.getSystemId()) + ": " + e.getMessage();
        logger.error(message);
        logger.trace(message, (Throwable)e);
    }
}

