/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.schema.util;

import com.evolveum.midpoint.api.exceptions.MidPointException;
import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.exceptions.ValidationException;
import com.evolveum.midpoint.provisioning.objects.ResourceAttribute;
import com.evolveum.midpoint.provisioning.objects.ResourceObject;
import com.evolveum.midpoint.provisioning.schema.ResourceAttributeDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceObjectDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceSchema;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObjectValueWriter {
    public static final String code_id = "$Id$";
    private static final Trace logger = TraceManager.getTrace(ObjectValueWriter.class);
    private static ObjectValueWriter instance = new ObjectValueWriter();

    public static ObjectValueWriter getInstance() {
        return instance;
    }

    public void write(ResourceObject ro, Element destination) throws MidPointException {
        Document doc = destination.getOwnerDocument();
        for (ResourceAttribute attribute : ro.getValues()) {
            if (attribute.getDefinition() == null) {
                throw new IllegalArgumentException("Value present without type definition " + attribute);
            }
            for (Node value : attribute.getValues()) {
                destination.appendChild(doc.importNode(value, true));
            }
        }
    }

    public void merge(ResourceObject ro, List<Element> destination, boolean doFilter) throws MidPointException {
        destination.clear();
        for (ResourceAttribute attribute : ro.getValues()) {
            if (doFilter && !attribute.getDefinition().isStoredInRepository()) continue;
            QName qn = attribute.getDefinition().getQName();
            for (Node value : attribute.getValues()) {
                Document doc = value.getOwnerDocument();
                destination.add((Element)doc.importNode(value, true));
            }
        }
    }

    public void merge(ResourceAttribute attribute, List<Element> destination, boolean doFilter) throws MidPointException {
        if (doFilter && !attribute.getDefinition().isStoredInRepository()) {
            return;
        }
        for (Node value : attribute.getValues()) {
            Document doc = value.getOwnerDocument();
            destination.add((Element)doc.importNode(value, true));
        }
    }

    public void postProcessShadow(ResourceObject ro, ResourceObjectShadowType shadow) {
        this.merge(ro, (List<Element>)shadow.getAttributes().getAny(), true);
    }

    public ResourceObject readValues(ResourceObjectDefinition definition, List<Element> values) throws MidPointException {
        return this.readValues(definition, values, false);
    }

    public ResourceObject readValues(ResourceObjectDefinition definition, List<Element> values, boolean strict) throws MidPointException {
        ArrayList<ResourceAttribute> attributeValues = new ArrayList<ResourceAttribute>(0);
        ResourceObject obj = new ResourceObject(definition);
        for (Element e : values) {
            ArrayList<Node> value = new ArrayList<Node>(0);
            ResourceAttribute attribute = null;
            boolean found = false;
            for (ResourceAttributeDefinition attrDef : obj.getDefinition().getAttributesCopy()) {
                if (!e.getLocalName().equalsIgnoreCase(attrDef.getQName().getLocalPart()) || !e.getNamespaceURI().equalsIgnoreCase(attrDef.getQName().getNamespaceURI())) continue;
                if (null == attribute) {
                    attribute = new ResourceAttribute(attrDef, value);
                    attributeValues.add(attribute);
                    obj.addValue(attribute);
                }
                value.add(e);
                found = true;
            }
            if (!strict || found) continue;
            throw new MidPointException("No type for value in schema " + e.getNamespaceURI() + ":" + e.getTagName());
        }
        return obj;
    }

    public ResourceObject buildResourceObject(ResourceObjectShadowType shadow, ResourceSchema schema) throws MidPointException {
        return this.readValues(schema.getObjectDefinition(shadow.getObjectClass()), shadow.getAttributes().getAny());
    }

    public boolean validateBeforeCreate(ResourceObject object) throws ValidationException {
        for (ResourceAttributeDefinition def : object.getDefinition().getRequiredAttributsForCreate()) {
            if (null == def) continue;
            boolean contains = false;
            for (ResourceAttribute attr : object.getValues()) {
                if (!attr.getDefinition().is(def)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            logger.info("Missing required attribute: {}", (Object)def.getNativeAttributeName());
            ValidationException ex = new ValidationException("Missing required attribute " + def.getNativeAttributeName());
            ex.addFailedAttribute(def.getQName());
            throw ex;
        }
        return true;
    }
}

