/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.schema.util;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.exceptions.SchemaParserException;
import com.evolveum.midpoint.provisioning.schema.AccountObjectClassDefinition;
import com.evolveum.midpoint.provisioning.schema.AttributeFlag;
import com.evolveum.midpoint.provisioning.schema.ResourceAttributeDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceObjectDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceSchema;
import com.evolveum.midpoint.provisioning.schema.util.SchemaDOMElement;
import com.evolveum.midpoint.provisioning.schema.util.SchemaErrorLog;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AttributeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SchemaHandlingType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class DOMToSchemaParser {
    private static final Trace TRACE = TraceManager.getTrace(DOMToSchemaParser.class);
    private ResourceSchema schema;

    public ResourceSchema getSchema(Element resourceSchema) throws SchemaParserException {
        return this.getSchema(resourceSchema, null);
    }

    public ResourceSchema getSchema(Element resourceSchema, SchemaHandlingType schemaHandling) throws SchemaParserException {
        this.schema = this.initSchema(resourceSchema);
        XSSchemaSet set = this.parseSchema(resourceSchema);
        Iterator iterator = set.iterateComplexTypes();
        while (iterator.hasNext()) {
            XSComplexType complexType = (XSComplexType)iterator.next();
            if (!complexType.getTargetNamespace().equals(this.schema.getResourceNamespace())) continue;
            this.schema.addObjectClass(this.createResourceObjectDefinition(complexType, resourceSchema));
        }
        if (schemaHandling != null) {
            this.applySchemaHandling(this.schema, schemaHandling);
        }
        return this.schema;
    }

    private void applySchemaHandling(ResourceSchema schema, SchemaHandlingType schemaHandling) {
        List accountTypes = schemaHandling.getAccountType();
        for (SchemaHandlingType.AccountType accountType : accountTypes) {
            ResourceObjectDefinition definition = schema.getObjectDefinition(accountType.getObjectClass());
            if (definition == null) continue;
            List attributes = accountType.getAttribute();
            for (AttributeDescriptionType attribute : attributes) {
                ResourceAttributeDefinition attrDefinition = definition.getAttributeDefinition(attribute.getRef());
                if (attrDefinition == null || attribute.getOutbound() == null) continue;
                attrDefinition.setFilledWithExpression(true);
            }
        }
    }

    private ResourceObjectDefinition createResourceObjectDefinition(XSComplexType complexType, Element document) {
        XSTerm term;
        XSParticle particle;
        String nativeAttributeName;
        QName qname = new QName(complexType.getTargetNamespace(), complexType.getName());
        ResourceObjectDefinition definition = null;
        XSAnnotation annotation = complexType.getAnnotation();
        Element nativeAttrElement = this.getAnnotationElement(annotation, SchemaDOMElement.A_NATIVE_OBJECT_CLASS);
        String string = nativeAttributeName = nativeAttrElement == null ? qname.getLocalPart() : nativeAttrElement.getTextContent();
        if (this.isAccountObject(annotation)) {
            definition = new AccountObjectClassDefinition(qname, nativeAttributeName);
        } else {
            boolean container = false;
            if (this.getAnnotationElement(annotation, SchemaDOMElement.A_CONTAINER) != null) {
                container = true;
            }
            definition = new ResourceObjectDefinition(qname, nativeAttributeName, container);
        }
        List<ResourceAttributeDefinition> list = null;
        XSContentType content = complexType.getContentType();
        if (content != null && (particle = content.asParticle()) != null && (term = particle.getTerm()).isModelGroup()) {
            list = this.createResourceAttributeListFromGroup(term.asModelGroup());
        }
        if (list != null) {
            for (ResourceAttributeDefinition attribute : list) {
                definition.addAttribute(attribute);
            }
        }
        this.parseAnnotationForObjectClass(annotation, definition, document);
        return definition;
    }

    private List<ResourceAttributeDefinition> createResourceAttributeListFromGroup(XSModelGroup group) {
        XSParticle[] particles;
        ArrayList<ResourceAttributeDefinition> elementList = new ArrayList<ResourceAttributeDefinition>();
        for (XSParticle p : particles = group.getChildren()) {
            XSTerm pterm = p.getTerm();
            if (pterm.isModelGroup()) {
                elementList.addAll(this.createResourceAttributeListFromGroup(pterm.asModelGroup()));
            }
            if (!pterm.isElementDecl()) continue;
            XSAnnotation annotation = this.selectAnnotationToUse(p.getAnnotation(), pterm.getAnnotation());
            XSElementDecl element = pterm.asElementDecl();
            QName qname = new QName(element.getTargetNamespace(), element.getName());
            Element nativeAttrElement = this.getAnnotationElement(annotation, SchemaDOMElement.A_NATIVE_ATTRIBUTE_NAME);
            String nativeAttributeName = nativeAttrElement == null ? qname.getLocalPart() : nativeAttrElement.getTextContent();
            ResourceAttributeDefinition attribute = new ResourceAttributeDefinition(qname, nativeAttributeName);
            XSType type = element.getType();
            attribute.setType(new QName(type.getTargetNamespace(), type.getName()));
            attribute.setMinOccurs(p.getMinOccurs());
            attribute.setMaxOccurs(p.getMaxOccurs());
            this.parseAnnotationForAttribute(annotation, attribute);
            elementList.add(attribute);
        }
        return elementList;
    }

    private XSAnnotation selectAnnotationToUse(XSAnnotation particleAnnotation, XSAnnotation termAnnotation) {
        boolean useParticleAnnotation = false;
        if (particleAnnotation != null && particleAnnotation.getAnnotation() != null && this.testAnnotationAppinfo(particleAnnotation)) {
            useParticleAnnotation = true;
        }
        boolean useTermAnnotation = false;
        if (termAnnotation != null && termAnnotation.getAnnotation() != null && this.testAnnotationAppinfo(termAnnotation)) {
            useTermAnnotation = true;
        }
        if (useParticleAnnotation) {
            return particleAnnotation;
        }
        if (useTermAnnotation) {
            return termAnnotation;
        }
        return null;
    }

    private boolean testAnnotationAppinfo(XSAnnotation annotation) {
        Element appinfo = this.getAnnotationElement(annotation, new QName("http://www.w3.org/2001/XMLSchema", "appinfo"));
        return appinfo != null;
    }

    private QName getQNameForReference(String reference, Element element) {
        String[] array = reference.split(":");
        String namespace = element.lookupPrefix(array[0]);
        if (namespace == null) {
            namespace = element.getAttribute("xmlns:" + array[0]);
        }
        return new QName(namespace, array[1]);
    }

    private void parseAnnotationForObjectClass(XSAnnotation annotation, ResourceObjectDefinition objectClass, Element document) {
        ResourceAttributeDefinition compositeIdentifier;
        ResourceAttributeDefinition secondaryIdentifier;
        ResourceAttributeDefinition identifier;
        ResourceAttributeDefinition descriptionAttribute;
        if (annotation == null || annotation.getAnnotation() == null) {
            return;
        }
        ResourceAttributeDefinition displayName = this.getAnnotationReference(annotation, SchemaDOMElement.A_DISPLAY_NAME, document, objectClass);
        if (displayName != null) {
            displayName.setDisplayName(true);
        }
        if ((descriptionAttribute = this.getAnnotationReference(annotation, SchemaDOMElement.A_DESCRIPTION_ATTRIBUTE, document, objectClass)) != null) {
            descriptionAttribute.setDescriptionAttribute(true);
        }
        if ((identifier = this.getAnnotationReference(annotation, SchemaDOMElement.A_IDENTIFIER, document, objectClass)) != null) {
            identifier.setIdentifier(true);
        }
        if ((secondaryIdentifier = this.getAnnotationReference(annotation, SchemaDOMElement.A_SECONDARY_IDENTIFIER, document, objectClass)) != null) {
            secondaryIdentifier.setSecondaryIdentifier(true);
        }
        if ((compositeIdentifier = this.getAnnotationReference(annotation, SchemaDOMElement.A_COMPOSITE_IDENTIFIER, document, objectClass)) != null) {
            compositeIdentifier.setCompositeIdentifier(true);
        }
        if (objectClass instanceof AccountObjectClassDefinition) {
            String defaultValue;
            AccountObjectClassDefinition accObjectClass = (AccountObjectClassDefinition)objectClass;
            Element accountType = this.getAnnotationElement(annotation, SchemaDOMElement.A_ACCOUNT_TYPE);
            if (accountType != null && (defaultValue = accountType.getAttribute("default")) != null) {
                accObjectClass.setDefault(Boolean.parseBoolean(defaultValue));
            }
        }
    }

    private ResourceAttributeDefinition getAnnotationReference(XSAnnotation annotation, QName qname, Element document, ResourceObjectDefinition objectClass) {
        String reference;
        Element element = this.getAnnotationElement(annotation, qname);
        if (element != null && (reference = element.getAttribute("ref")) != null && !reference.isEmpty()) {
            return objectClass.getAttributeDefinition(this.getQNameForReference(reference, document));
        }
        return null;
    }

    private void parseAttributeInformation(NodeList nodes, ResourceAttributeDefinition attribute) {
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
        }
    }

    private void parseAnnotationForAttribute(XSAnnotation annotation, ResourceAttributeDefinition attribute) {
        Element encryption;
        Element help;
        Element attributeDisplayName;
        if (annotation == null || annotation.getAnnotation() == null) {
            return;
        }
        Element flagList = this.getAnnotationElement(annotation, SchemaDOMElement.A_ATTRIBUTE_FLAG);
        if (flagList != null && flagList.getTextContent() != null && !flagList.getTextContent().isEmpty()) {
            String[] array;
            String flags = flagList.getTextContent();
            for (String item : array = flags.split(" ")) {
                attribute.getAttributeFlag().add(AttributeFlag.valueOf(item));
            }
        }
        if ((attributeDisplayName = this.getAnnotationElement(annotation, SchemaDOMElement.A_ATTRIBUTE_DISPLAY_NAME)) != null) {
            attribute.setAttributeDisplayName(attributeDisplayName.getTextContent());
        }
        if ((help = this.getAnnotationElement(annotation, SchemaDOMElement.A_HELP)) != null) {
            attribute.setHelp(help.getTextContent());
        }
        if ((encryption = this.getAnnotationElement(annotation, SchemaDOMElement.A_CA_ENCRYPTION)) != null && encryption.getTextContent() != null) {
            Element classificationLevel = this.getAnnotationElement(annotation, SchemaDOMElement.A_CA_CLASSIFICATION_LEVEL);
            String classification = classificationLevel == null ? null : classificationLevel.getTextContent();
            attribute.makeClassified(ResourceAttributeDefinition.Encryption.valueOf(encryption.getTextContent()), classification);
        }
    }

    private boolean isAccountObject(XSAnnotation annotation) {
        if (annotation == null || annotation.getAnnotation() == null) {
            return false;
        }
        Element accountType = this.getAnnotationElement(annotation, SchemaDOMElement.A_ACCOUNT_TYPE);
        return accountType != null;
    }

    private Element getAnnotationElement(XSAnnotation annotation, QName qname) {
        if (annotation == null) {
            return null;
        }
        Element xsdAnnotation = (Element)annotation.getAnnotation();
        NodeList list = xsdAnnotation.getElementsByTagNameNS(qname.getNamespaceURI(), qname.getLocalPart());
        if (list != null && list.getLength() > 0) {
            return (Element)list.item(0);
        }
        return null;
    }

    private ResourceSchema initSchema(Element xsdSchema) {
        String targetNamespace = xsdSchema.getAttribute("targetNamespace");
        this.schema = new ResourceSchema(targetNamespace);
        List<Element> importList = this.createImportList(xsdSchema);
        for (Element element : importList) {
            String namespace = element.getAttribute("namespace");
            if (namespace == null || namespace.isEmpty() || namespace.equals("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd") || namespace.equals("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd")) continue;
            this.schema.getImportList().add(namespace);
        }
        return this.schema;
    }

    private List<Element> createImportList(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getLocalName().equals("import") || !"http://www.w3.org/2001/XMLSchema".equals(child.getNamespaceURI())) continue;
                list.add((Element)child);
            }
        }
        return list;
    }

    private XSOMParser createSchemaParser() {
        XSOMParser parser = new XSOMParser();
        parser.setErrorHandler((ErrorHandler)new SchemaErrorLog());
        parser.setAnnotationParser((AnnotationParserFactory)new DomAnnotationParserFactory());
        parser.setEntityResolver((EntityResolver)SchemaConstants.getEntityResolver());
        return parser;
    }

    private XSSchemaSet parseSchema(Element schema) throws SchemaParserException {
        XSSchemaSet xss = null;
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "no");
            trans.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(schema);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            trans.transform(source, result);
            XSOMParser parser = this.createSchemaParser();
            InputSource inSource = new InputSource(new ByteArrayInputStream(out.toByteArray()));
            inSource.setSystemId("SystemId");
            inSource.setEncoding("utf-8");
            parser.parse(inSource);
            xss = parser.getResult();
        }
        catch (Exception ex) {
            throw new SchemaParserException("Uknown error during resource xsd schema parsing: " + ex.getMessage(), ex);
        }
        return xss;
    }
}

