/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.schema;

import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSimpleType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class SimpleTypeRestriction
implements Serializable {
    private String[] enumeration = null;
    private String maxValue = null;
    private String minValue = null;
    private String length = null;
    private String maxLength = null;
    private String minLength = null;
    private String pattern = null;
    private String totalDigits = null;

    public String[] getEnumeration() {
        return this.enumeration;
    }

    public String getMaxLength() {
        return this.maxLength;
    }

    public String getMinLength() {
        return this.minLength;
    }

    public String getLength() {
        return this.length;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getTotalDigits() {
        return this.totalDigits;
    }

    public static SimpleTypeRestriction createTypeRestriction(XSSimpleType type) {
        SimpleTypeRestriction typeRestriction = new SimpleTypeRestriction();
        XSRestrictionSimpleType restriction = type.asRestriction();
        if (restriction != null) {
            ArrayList<String> enumeration = new ArrayList<String>();
            Collection i = restriction.getDeclaredFacets();
            for (XSFacet facet : i) {
                if (facet.getName().equals("enumeration")) {
                    enumeration.add(facet.getValue().value);
                }
                if (facet.getName().equals("maxInclusive")) {
                    typeRestriction.maxValue = facet.getValue().value;
                }
                if (facet.getName().equals("minInclusive")) {
                    typeRestriction.minValue = facet.getValue().value;
                }
                if (facet.getName().equals("maxExclusive")) {
                    typeRestriction.maxValue = String.valueOf(Integer.parseInt(facet.getValue().value) - 1);
                }
                if (facet.getName().equals("minExclusive")) {
                    typeRestriction.minValue = String.valueOf(Integer.parseInt(facet.getValue().value) + 1);
                }
                if (facet.getName().equals("length")) {
                    typeRestriction.length = facet.getValue().value;
                }
                if (facet.getName().equals("maxLength")) {
                    typeRestriction.maxLength = facet.getValue().value;
                }
                if (facet.getName().equals("minLength")) {
                    typeRestriction.minLength = facet.getValue().value;
                }
                if (facet.getName().equals("pattern")) {
                    typeRestriction.pattern = facet.getValue().value;
                }
                if (!facet.getName().equals("totalDigits")) continue;
                typeRestriction.totalDigits = facet.getValue().value;
            }
            if (enumeration.size() > 0) {
                typeRestriction.enumeration = enumeration.toArray(new String[0]);
            }
        }
        return typeRestriction;
    }
}

