/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.schema;

import com.evolveum.midpoint.provisioning.conversion.ConverterFactory;
import com.evolveum.midpoint.provisioning.schema.AttributeFlag;
import com.evolveum.midpoint.provisioning.schema.ResourceObjectDefinition;
import com.evolveum.midpoint.provisioning.schema.SimpleTypeRestriction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class ResourceAttributeDefinition {
    public static final int MAX_OCCURS_UNBOUNDED = -1;
    private final String nativeAttributeName;
    private boolean identifier = false;
    private boolean secondaryIdentifier = false;
    private boolean compositeIdentifier = false;
    private boolean displayName = false;
    private boolean descriptionAttribute = false;
    private List<AttributeFlag> attributeFlag;
    private ResourceObjectDefinition resourceObjectReference = null;
    private ClassifiedAttributeInfo classifiedAttributeInfo = null;
    private String help;
    private String attributeDisplayName;
    private boolean mandatory = false;
    private boolean filledWithExpression = false;
    private ResourceObjectDefinition parentDefinition;
    private final QName qname;
    private QName type;
    private SimpleTypeRestriction restriction;
    private int minOccurs = 1;
    private int maxOccurs = 1;

    public ResourceAttributeDefinition(QName qname) {
        this.qname = qname;
        this.nativeAttributeName = qname.getLocalPart();
    }

    public ResourceAttributeDefinition(QName qname, String nativeAttributeName) {
        this.qname = qname;
        this.nativeAttributeName = nativeAttributeName;
    }

    public String getAttributeDisplayName() {
        if (this.attributeDisplayName == null) {
            return this.qname.getLocalPart();
        }
        return this.attributeDisplayName;
    }

    public void setAttributeDisplayName(String attributeDisplayName) {
        this.attributeDisplayName = attributeDisplayName;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public QName getQName() {
        return this.qname;
    }

    public SimpleTypeRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(SimpleTypeRestriction restriction) {
        this.restriction = restriction;
    }

    public QName getType() {
        return this.type;
    }

    public ResourceAttributeDefinition setType(QName type) {
        this.type = type;
        return this;
    }

    public List<AttributeFlag> getAttributeFlag() {
        if (this.attributeFlag == null) {
            this.attributeFlag = new ArrayList<AttributeFlag>();
        }
        return this.attributeFlag;
    }

    public void setAttributeFlag(List<AttributeFlag> attributeFlag) {
        this.attributeFlag = attributeFlag;
    }

    public boolean isClassifiedAttribute() {
        return this.classifiedAttributeInfo != null;
    }

    public ClassifiedAttributeInfo getClassifiedAttributeInfo() {
        return this.classifiedAttributeInfo;
    }

    public boolean isCompositeIdentifier() {
        return this.compositeIdentifier;
    }

    public void setCompositeIdentifier(boolean compositeIdentifier) {
        this.compositeIdentifier = compositeIdentifier;
    }

    public boolean isDescriptionAttribute() {
        return this.descriptionAttribute;
    }

    public void setDescriptionAttribute(boolean descriptionAttribute) {
        this.descriptionAttribute = descriptionAttribute;
    }

    public boolean isDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(boolean displayName) {
        this.displayName = displayName;
    }

    public boolean isIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(boolean identifier) {
        this.identifier = identifier;
    }

    public ResourceObjectDefinition getResourceObjectReference() {
        return this.resourceObjectReference;
    }

    public void setResourceObjectReference(ResourceObjectDefinition resourceObjectReference) {
        this.resourceObjectReference = resourceObjectReference;
    }

    public boolean isSecondaryIdentifier() {
        return this.secondaryIdentifier;
    }

    public void setSecondaryIdentifier(boolean secondaryIdentifier) {
        this.secondaryIdentifier = secondaryIdentifier;
    }

    public boolean canRead() {
        return !this.getAttributeFlag().contains((Object)AttributeFlag.NOT_READABLE);
    }

    public boolean canUpdate() {
        return !this.getAttributeFlag().contains((Object)AttributeFlag.NOT_UPDATEABLE);
    }

    public boolean isPasswordAttribute() {
        return !this.getAttributeFlag().contains((Object)AttributeFlag.PASSWORD);
    }

    public boolean isStoredInRepository() {
        return this.isIdentifier() || this.isSecondaryIdentifier() || this.isCompositeIdentifier() || null != this.attributeFlag && this.attributeFlag.contains((Object)AttributeFlag.STORE_IN_REPOSITORY);
    }

    public String getNativeAttributeName() {
        return this.nativeAttributeName;
    }

    public ResourceObjectDefinition getParentDefinition() {
        return this.parentDefinition;
    }

    public void setParentDefinition(ResourceObjectDefinition parentDefinition) {
        this.parentDefinition = parentDefinition;
    }

    public boolean isRequired() {
        return this.minOccurs > 0;
    }

    public boolean isMultivalue() {
        return this.maxOccurs == -1 || this.maxOccurs > 1;
    }

    public boolean isMandatory() {
        if (this.minOccurs == 0) {
            return false;
        }
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isFilledWithExpression() {
        return this.filledWithExpression;
    }

    public void setFilledWithExpression(boolean filledWithExpression) {
        this.filledWithExpression = filledWithExpression;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            builder.append(":{");
            builder.append(this.type.getNamespaceURI());
            builder.append("}");
            builder.append(this.type.getLocalPart());
        } else {
            builder.append(": null");
        }
        return builder.toString();
    }

    public void makeClassified(Encryption encryption, String classificationLevel) {
        this.classifiedAttributeInfo = new ClassifiedAttributeInfo();
        this.classifiedAttributeInfo.encryption = encryption;
        this.classifiedAttributeInfo.classificationLevel = classificationLevel;
    }

    public boolean is(ResourceAttributeDefinition other) {
        return other != null && other.getQName().equals(this.getQName());
    }

    public ConverterFactory getConverterFactory() {
        if (this.getParentDefinition() == null) {
            throw new IllegalArgumentException("parent definition is null");
        }
        if (this.getParentDefinition().getParentSchema() == null) {
            throw new IllegalArgumentException("parent schema is null");
        }
        return this.getParentDefinition().getParentSchema().getConverterFactory();
    }

    public static class ClassifiedAttributeInfo {
        private Encryption encryption = Encryption.SYMMETRIC;
        private String classificationLevel = null;

        private ClassifiedAttributeInfo() {
        }

        public String getClassificationLevel() {
            return this.classificationLevel;
        }

        public Encryption getEncryption() {
            return this.encryption;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            boolean equal;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClassifiedAttributeInfo)) {
                return false;
            }
            ClassifiedAttributeInfo info = (ClassifiedAttributeInfo)obj;
            boolean bl = this.encryption == null ? info.getEncryption() == null : (equal = this.encryption.equals((Object)info.getEncryption()));
            if (!equal) {
                return false;
            }
            return this.classificationLevel == null ? info.getClassificationLevel() == null : this.classificationLevel.equals(info.getClassificationLevel());
        }
    }

    public static enum Encryption {
        HASH,
        NONE,
        SYMMETRIC;

    }
}

