/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.objects;

import com.evolveum.midpoint.provisioning.objects.ResourceAttribute;
import com.evolveum.midpoint.provisioning.schema.ResourceAttributeDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceObjectDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class ResourceObject {
    public static final String code_id = "$Id$";
    private final ResourceObjectDefinition definition;
    private final List<ResourceAttribute> values;

    public ResourceObject(ResourceObjectDefinition definition) {
        this.definition = definition;
        this.values = new ArrayList<ResourceAttribute>();
    }

    public ResourceObject(ResourceObjectDefinition definition, List<ResourceAttribute> values) {
        this.definition = definition;
        this.values = values;
    }

    public ResourceObjectDefinition getDefinition() {
        return this.definition;
    }

    public void addValue(ResourceAttribute attribute) {
        this.values.add(attribute);
    }

    public ResourceAttribute addValue(QName qname) {
        return this.addValue(qname, false);
    }

    public ResourceAttribute addValue(QName qname, boolean required) {
        ResourceAttributeDefinition rad = this.definition.getAttributeDefinition(qname);
        if (required && rad == null) {
            throw new IllegalArgumentException("Attribute definition is missing for " + qname);
        }
        ResourceAttribute ra = new ResourceAttribute(rad);
        this.values.add(ra);
        return ra;
    }

    public List<ResourceAttribute> getValues() {
        return this.values;
    }

    public ResourceAttribute getValue(QName attribute) {
        List<ResourceAttribute> result = this.getValues(attribute);
        if (result == null) {
            throw new IllegalArgumentException("No such vale " + attribute);
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException("More then one attribute is exists. Use getValues! " + attribute);
        }
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public List<ResourceAttribute> getValues(QName attribute) {
        ArrayList<ResourceAttribute> result = new ArrayList<ResourceAttribute>();
        for (ResourceAttribute value : this.values) {
            if (!value.getDefinition().getQName().equals(attribute)) continue;
            result.add(value);
        }
        return result;
    }

    public void removeValue(QName attribute) {
        Iterator<ResourceAttribute> it = this.values.iterator();
        while (it.hasNext()) {
            ResourceAttribute resourceAttribute = it.next();
            if (!resourceAttribute.getDefinition().getQName().equals(attribute)) continue;
            it.remove();
        }
    }

    public ResourceAttribute getIdentifier() {
        ResourceAttributeDefinition identifierDefinition = this.getDefinition().getPrimaryIdentifier();
        return this.getValue(identifierDefinition.getQName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getDefinition() + "," + this.getIdentifier();
    }
}

