/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.integration.identityconnector;

import com.evolveum.midpoint.api.exceptions.MidPointException;
import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.converter.ConverterFactory;
import com.evolveum.midpoint.provisioning.integration.identityconnector.IdentityConnector;
import com.evolveum.midpoint.provisioning.integration.identityconnector.converter.ICFConverterFactory;
import com.evolveum.midpoint.util.ClasspathUrlFinder;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.resource.idconnector.configuration_1.ConnectorRef;
import com.evolveum.midpoint.xml.ns._public.resource.idconnector.configuration_1.OperationTimeouts;
import com.evolveum.midpoint.xml.ns._public.resource.idconnector.configuration_1.OperationType;
import com.evolveum.midpoint.xml.ns._public.resource.idconnector.configuration_1.PoolConfigOption;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.xml.namespace.QName;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.api.operations.AuthenticationApiOp;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.SchemaApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnConnectorApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnResourceApiOp;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.api.operations.TestApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.api.operations.ValidateApiOp;
import org.w3c.dom.Element;

public class ConnectorUtil {
    private static ConverterFactory converters = ICFConverterFactory.getInstance();
    public static final String code_id = "$Id$";
    public static final String BUNDLES_REL_PATH = "";
    private static final Trace TRACE = TraceManager.getTrace(ConnectorUtil.class);
    private static ConnectorInfoManager localConnectorInfoManager = null;
    private static Map<OperationType, Class> opMap = new HashMap<OperationType, Class>();

    public static URL[] getBundleURLs() {
        HashSet<URL> bundleURLs = new HashSet<URL>();
        File icfFolder = null;
        try {
            icfFolder = new File(new File(ConnectorUtil.class.getClassLoader().getResource("com").toURI()), "../../lib/icf-connectors");
        }
        catch (URISyntaxException ex) {
            TRACE.debug("Couldn't find icf-connectors folder, reason: " + ex.getMessage());
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.exists() || file.isDirectory()) {
                    return false;
                }
                String fileName = file.getName();
                return fileName.startsWith("org.identityconnectors") && fileName.endsWith(".jar");
            }
        };
        if (icfFolder == null || !icfFolder.exists() || !icfFolder.isDirectory()) {
            URL[] resourceURLs = ClasspathUrlFinder.findClassPaths();
            for (int j = 0; j < resourceURLs.length; ++j) {
                File file;
                URL bundleUrl = resourceURLs[j];
                if (!"file".equals(bundleUrl.getProtocol()) || !fileFilter.accept(file = new File(bundleUrl.getFile()))) continue;
                bundleURLs.add(bundleUrl);
            }
        } else {
            File[] connectors;
            for (File file : connectors = icfFolder.listFiles(fileFilter)) {
                try {
                    bundleURLs.add(file.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    TRACE.debug("Couldn't transform file path " + file.getAbsolutePath() + " to URL, reason: " + ex.getMessage());
                }
            }
        }
        if (TRACE.isDebugEnabled()) {
            for (URL u : bundleURLs) {
                TRACE.debug("Bundle URL: {}", (Object)u);
            }
        }
        return bundleURLs.toArray(new URL[0]);
    }

    public static Vector<URL> getJarFileListing(URL jarLocation, String filter) {
        Vector<URL> files = new Vector<URL>();
        if (jarLocation == null) {
            return files;
        }
        String jarPath = jarLocation.getPath().substring(5, jarLocation.getPath().indexOf("!"));
        try {
            JarEntry jarEntry;
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarPath));
            do {
                if ((jarEntry = jarInputStream.getNextJarEntry()) == null) continue;
                String fileName = jarEntry.getName();
                if (filter != null && !fileName.matches(filter)) continue;
                files.add(new URL(jarLocation, fileName.replace(BUNDLES_REL_PATH, BUNDLES_REL_PATH)));
            } while (jarEntry != null);
            jarInputStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get Jar input stream from '" + jarLocation + "'", ioe);
        }
        return files;
    }

    public static void clearManagerCaches() {
        ConnectorInfoManagerFactory factory = ConnectorInfoManagerFactory.getInstance();
        factory.clearRemoteCache();
    }

    public static ConnectorFacade createConnectorFacade(IdentityConnector resource) throws MidPointException {
        return ConnectorUtil.createConnectorFacade(resource, null, null);
    }

    public static ConnectorFacade createConnectorFacade(IdentityConnector resource, CreateOptions options) throws MidPointException {
        return ConnectorUtil.createConnectorFacade(resource, null, options);
    }

    public static ConnectorFacade createConnectorFacade(IdentityConnector resourceConfig, Locale locale, CreateOptions options) {
        PoolConfigOption poolConfigOptions;
        ConnectorRef connRef;
        ConnectorInfo connectorInfo;
        ConnectorFacade connectorFacade = null;
        if (options == null) {
            options = new CreateOptions();
        }
        if (locale != null) {
            CurrentLocale.set((Locale)locale);
        }
        if ((connectorInfo = ConnectorUtil.getConnectorInfo(connRef = resourceConfig.getConfiguration().getConnectorRef())) == null) {
            Object[] args = new Object[]{connRef.getBundleName(), connRef.getBundleVersion(), connRef.getConnectorName()};
            TRACE.error("Identity connector bundle is not found {} / {} / {} ", args);
            throw new MidPointException("Identity connector bundle is not found " + connRef.getBundleName() + "/" + connRef.getBundleVersion() + "/" + connRef.getConnectorName());
        }
        TRACE.debug("Looking for connector {} / {} / {}, got {}", new Object[]{connRef.getBundleName(), connRef.getBundleVersion(), connRef.getConnectorName(), connectorInfo.getConnectorDisplayName()});
        APIConfiguration apiConfig = connectorInfo.createDefaultAPIConfiguration();
        OperationTimeouts opTimeouts = resourceConfig.getConfiguration().getOperationTimeouts();
        if (opTimeouts != null) {
            ConnectorUtil.setTimeouts(opTimeouts, apiConfig);
        }
        if ((poolConfigOptions = resourceConfig.getConfiguration().getPoolConfigOption()) != null) {
            ConnectorUtil.setPoolConfiguration(poolConfigOptions, apiConfig);
        }
        ConfigurationProperties configProps = apiConfig.getConfigurationProperties();
        ConnectorUtil.loadConfigurationProperties(resourceConfig, configProps);
        if (options.getDisableSearchBuffer()) {
            apiConfig.setProducerBufferSize(0);
            apiConfig.setTimeout(SearchApiOp.class, -1);
        }
        if (TRACE.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            for (String name : configProps.getPropertyNames()) {
                ConfigurationProperty property = configProps.getProperty(name);
                msg.append("  ").append(property.getName()).append(": ").append(property.getValue()).append("\n");
            }
            TRACE.debug("Connector {} configuration:\n{}", (Object)connectorInfo.getConnectorDisplayName(), (Object)msg.toString());
        }
        ConnectorFacadeFactory facadeFactory = ConnectorFacadeFactory.getInstance();
        connectorFacade = facadeFactory.newInstance(apiConfig);
        return connectorFacade;
    }

    public static void loadConfigurationProperties(IdentityConnector resource, ConfigurationProperties configProperties) {
        List configPropNames = configProperties.getPropertyNames();
        HashMap<QName, ArrayList<Element>> attrValues = new HashMap<QName, ArrayList<Element>>(configPropNames.size());
        for (Element element : resource.getConfiguration().getBundleProperties().getAny()) {
            String propertyName = element.getLocalName();
            if (!configPropNames.contains(propertyName)) {
                TRACE.warn("Ignoring unknown configuration property {} in resource {}", (Object)propertyName, (Object)resource.getOid());
                continue;
            }
            QName attrName = new QName(element.getNamespaceURI(), element.getLocalName());
            ArrayList<Element> value = (ArrayList<Element>)attrValues.get(attrName);
            if (null == value) {
                value = new ArrayList<Element>(1);
                attrValues.put(attrName, value);
            }
            value.add(element);
        }
        for (Map.Entry entry : attrValues.entrySet()) {
            Class<?> propBaseClass;
            ConfigurationProperty configProp = configProperties.getProperty(((QName)entry.getKey()).getLocalPart());
            Class propClass = configProp.getType();
            List attrValue = (List)entry.getValue();
            Object propertyValue = null;
            if (propClass.isArray()) {
                propBaseClass = propClass.getComponentType();
                Object propertyValues = Array.newInstance(propBaseClass, attrValue.size());
                for (int i = 0; i < attrValue.size(); ++i) {
                    Element prop = (Element)attrValue.get(i);
                    Object obj = ConnectorUtil.convertToConnectorPropertyObject(prop, propBaseClass);
                    Array.set(propertyValues, i, obj);
                }
                propertyValue = propertyValues;
            } else if (Collection.class.isAssignableFrom(propClass)) {
                propBaseClass = propClass.getComponentType();
            } else {
                propertyValue = ConnectorUtil.convertToConnectorPropertyObject((Element)attrValue.get(0), propClass);
            }
            configProperties.setPropertyValue(((QName)entry.getKey()).getLocalPart(), propertyValue);
        }
    }

    private static Object convertToConnectorPropertyObject(Element obj, Class configPropertyClass) throws MidPointException {
        if (!obj.hasChildNodes()) {
            return null;
        }
        Object result = null;
        try {
            String nodeValue = obj.getFirstChild().getNodeValue();
            result = converters.getConverter(configPropertyClass, nodeValue).convert((Object)nodeValue);
        }
        catch (NumberFormatException e) {
            String msg = "Invalid format for attribute " + obj.getLocalName() + ".  Cannot parse as type " + configPropertyClass.getCanonicalName();
            throw new MidPointException(msg);
        }
        catch (UnsupportedOperationException e) {
            String msg = "Conversion failed for  " + obj.getLocalName() + ".  No known coercion from type String to type " + configPropertyClass.getCanonicalName();
            throw new MidPointException(msg);
        }
        return result;
    }

    public static ConnectorInfo getConnectorInfo(ConnectorRef connectorRef) throws MidPointException {
        ConnectorInfo connectorInfo = null;
        if (connectorRef == null) {
            throw new MidPointException("Empty connector reference");
        }
        String bundleName = connectorRef.getBundleName();
        String bundleVersion = connectorRef.getBundleVersion();
        String connectorName = connectorRef.getConnectorName();
        connectorInfo = ConnectorUtil.getConnectorInfo(connectorRef, null, bundleName, bundleVersion, connectorName);
        return connectorInfo;
    }

    public static ConnectorInfo getConnectorInfo(ConnectorRef connectorRef, ObjectReferenceType connectorHostId, String bundleName, String bundleVersion, String connectorName) throws MidPointException {
        ConnectorInfo connectorInfo = null;
        try {
            ConnectorInfoManager mgr = null;
            if (connectorRef.getConnectorHost() != null) {
                RemoteFrameworkConnectionInfo connection = new RemoteFrameworkConnectionInfo(connectorRef.getConnectorHost(), connectorRef.getConnectorPort().intValue(), new GuardedString(connectorRef.getConnectorSecret().toCharArray()));
                mgr = ConnectorUtil.getRemoteConnectorInfoManager(connection);
            } else {
                mgr = ConnectorUtil.getLocalConnectorInfoManager();
            }
            ConnectorKey connKey = new ConnectorKey(bundleName, bundleVersion, connectorName);
            connectorInfo = mgr.findConnectorInfo(connKey);
        }
        catch (MidPointException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MidPointException((Throwable)e);
        }
        return connectorInfo;
    }

    public static ConnectorInfoManager getLocalConnectorInfoManager() throws MidPointException {
        if (null == localConnectorInfoManager) {
            URL[] bundleUrls = ConnectorUtil.getBundleURLs();
            ConnectorInfoManagerFactory factory = ConnectorInfoManagerFactory.getInstance();
            localConnectorInfoManager = factory.getLocalManager(bundleUrls);
        }
        return localConnectorInfoManager;
    }

    public static ConnectorInfoManager getRemoteConnectorInfoManager(String test) throws MidPointException {
        RemoteFrameworkConnectionInfo remBean = ConnectorUtil.getRFCI(test);
        return ConnectorUtil.getRemoteConnectorInfoManager(remBean);
    }

    public static ConnectorInfoManager getRemoteConnectorInfoManager(RemoteFrameworkConnectionInfo remBean) throws MidPointException {
        ConnectorInfoManager mgr = null;
        ConnectorInfoManagerFactory factory = ConnectorInfoManagerFactory.getInstance();
        try {
            mgr = factory.getRemoteManager(remBean);
        }
        catch (Exception e) {
            throw new MidPointException((Throwable)e);
        }
        return mgr;
    }

    private static RemoteFrameworkConnectionInfo getRFCI(String connectorHostType) {
        RemoteFrameworkConnectionInfo remBean = null;
        if (connectorHostType != null) {
            String host = "120.0.0.1";
            int port = 8759;
            int timeout = 0;
            boolean useSsl = false;
            String key = "xOS4IeeE6eb/AhMbhxZEC37PgtE\\=";
            GuardedString pwd = new GuardedString(key.toCharArray());
            remBean = new RemoteFrameworkConnectionInfo(host, port, pwd, useSsl, null, timeout);
        }
        return remBean;
    }

    private static void setTimeouts(OperationTimeouts opTimeouts, APIConfiguration apiConfig) throws MidPointException {
        if (opTimeouts != null) {
            for (OperationTimeouts.OperationTimeout opTimeout : opTimeouts.getOperationTimeout()) {
                if (opTimeout == null) continue;
                int timeout = opTimeout.getTimeout();
                Class api = opMap.get(opTimeout.getName());
                if (api != null) {
                    apiConfig.setTimeout(api, timeout);
                    continue;
                }
                throw new MidPointException("Unknown operation timeout label '" + opTimeout.getName() + "'");
            }
        }
    }

    private static void setPoolConfiguration(PoolConfigOption poolConfigOps, APIConfiguration apiConfig) throws MidPointException {
        ObjectPoolConfiguration connectorPoolConfig = apiConfig.getConnectorPoolConfiguration();
        if (poolConfigOps != null) {
            if (null != poolConfigOps.getMaxIdle()) {
                connectorPoolConfig.setMaxIdle(poolConfigOps.getMaxIdle().intValue());
            }
            if (null != poolConfigOps.getMinIdle()) {
                connectorPoolConfig.setMinIdle(poolConfigOps.getMinIdle().intValue());
            }
            if (null != poolConfigOps.getMaxObjects()) {
                connectorPoolConfig.setMaxObjects(poolConfigOps.getMaxObjects().intValue());
            }
            if (null != poolConfigOps.getMaxWait()) {
                connectorPoolConfig.setMaxWait(poolConfigOps.getMaxWait().longValue());
            }
            if (null != poolConfigOps.getMinEvictTimeMillis()) {
                connectorPoolConfig.setMinEvictableIdleTimeMillis(poolConfigOps.getMinEvictTimeMillis().longValue());
            }
        }
    }

    private static OperationTimeouts getTimeouts(APIConfiguration apiConfig) throws MidPointException {
        OperationTimeouts opTimeouts = new OperationTimeouts();
        if (apiConfig != null) {
            for (Map.Entry<OperationType, Class> e : opMap.entrySet()) {
                int timeout = apiConfig.getTimeout(e.getValue());
                OperationTimeouts.OperationTimeout opTimeout = new OperationTimeouts.OperationTimeout();
                opTimeout.setName(e.getKey());
                opTimeout.setTimeout(timeout);
                opTimeouts.getOperationTimeout().add(opTimeout);
            }
        }
        return opTimeouts;
    }

    public static PoolConfigOption getPoolConfigOptions(APIConfiguration apiConfig) throws MidPointException {
        PoolConfigOption poolConfigOptions = new PoolConfigOption();
        if (apiConfig != null && apiConfig.isConnectorPoolingSupported()) {
            ObjectPoolConfiguration poolConfig = apiConfig.getConnectorPoolConfiguration();
            int maxIdle = poolConfig.getMaxIdle();
            int minIdle = poolConfig.getMinIdle();
            int maxObjects = poolConfig.getMaxObjects();
            long evictTime = poolConfig.getMinEvictableIdleTimeMillis();
            long maxWait = poolConfig.getMaxWait();
            poolConfigOptions.setMaxIdle(Integer.valueOf(maxIdle));
            poolConfigOptions.setMinIdle(Integer.valueOf(minIdle));
            poolConfigOptions.setMaxObjects(Integer.valueOf(maxObjects));
            poolConfigOptions.setMinEvictTimeMillis(Long.valueOf(evictTime));
            poolConfigOptions.setMaxWait(Long.valueOf(maxWait));
        }
        return poolConfigOptions;
    }

    public static String normalizeConnectorName(String connectorName) {
        int lastDot;
        String name = null;
        if (connectorName != null && (lastDot = connectorName.lastIndexOf(46)) != -1) {
            name = connectorName.substring(lastDot + 1);
        }
        return name;
    }

    private static boolean supportsActiveSync(APIConfiguration apiConfig) {
        Set ops;
        boolean result = false;
        if (apiConfig != null && (ops = apiConfig.getSupportedOperations()).contains(SyncApiOp.class)) {
            result = true;
        }
        return result;
    }

    public static String getDefaultExecMode(ConnectorFacade facade) {
        boolean connector;
        boolean resource = facade.getOperation(ScriptOnResourceApiOp.class) != null;
        boolean bl = connector = facade.getOperation(ScriptOnConnectorApiOp.class) != null;
        if (resource && connector) {
            return null;
        }
        if (resource) {
            return "resource";
        }
        if (connector) {
            return "connector";
        }
        return null;
    }

    static {
        opMap.put(OperationType.CREATE, CreateApiOp.class);
        opMap.put(OperationType.UPDATE, UpdateApiOp.class);
        opMap.put(OperationType.DELETE, DeleteApiOp.class);
        opMap.put(OperationType.TEST, TestApiOp.class);
        opMap.put(OperationType.SCRIPT_ON_CONNECTOR, ScriptOnConnectorApiOp.class);
        opMap.put(OperationType.SCRIPT_ON_RESOURCE, ScriptOnResourceApiOp.class);
        opMap.put(OperationType.GET, GetApiOp.class);
        opMap.put(OperationType.AUTHENTICATE, AuthenticationApiOp.class);
        opMap.put(OperationType.SEARCH, SearchApiOp.class);
        opMap.put(OperationType.VALIDATE, ValidateApiOp.class);
        opMap.put(OperationType.SYNC, SyncApiOp.class);
        opMap.put(OperationType.SCHEMA, SchemaApiOp.class);
    }

    public static class CreateOptions {
        private boolean _disableSearchBuffer;
        private boolean _forTest;

        public boolean getDisableSearchBuffer() {
            return this._disableSearchBuffer;
        }

        public void setDisableSearchBuffer(boolean disableSearchBuffer) {
            this._disableSearchBuffer = disableSearchBuffer;
        }
    }
}

