/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.conversion;

import com.evolveum.midpoint.provisioning.conversion.ActivationConverter;
import com.evolveum.midpoint.provisioning.conversion.BooleanConverter;
import com.evolveum.midpoint.provisioning.conversion.Converter;
import com.evolveum.midpoint.provisioning.conversion.ConverterFactory;
import com.evolveum.midpoint.provisioning.conversion.IntegerConverter;
import com.evolveum.midpoint.provisioning.conversion.StringConverter;
import com.evolveum.midpoint.provisioning.conversion.SyncTokenConverter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class DefaultConverterFactory
implements ConverterFactory {
    private static DefaultConverterFactory conversion = new DefaultConverterFactory();
    private List<Converter> converters = new ArrayList<Converter>();

    public static DefaultConverterFactory getInstance() {
        return conversion;
    }

    public DefaultConverterFactory() {
        this.addConverter(new StringConverter());
        this.addConverter(new BooleanConverter());
        this.addConverter(new IntegerConverter());
        this.addConverter(new ActivationConverter());
        this.addConverter(new SyncTokenConverter());
    }

    @Override
    public Converter getConverter(QName xmlType) {
        for (Converter converter : this.converters) {
            if (!converter.getXmlType().equals(xmlType)) continue;
            return converter;
        }
        throw new IllegalArgumentException("Unsupported conversion type " + xmlType);
    }

    @Override
    public Converter getConverter(Class clazz) {
        for (Converter converter : this.converters) {
            if (!converter.getJavaTypes().contains(clazz)) continue;
            return converter;
        }
        throw new IllegalArgumentException("Unsupported conversion type " + clazz);
    }

    public void addConverter(Converter converter) {
        this.converters.add(converter);
    }

    public List<Converter> getConverters() {
        return this.converters;
    }
}

