/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.conversion;

import com.evolveum.midpoint.provisioning.conversion.Converter;
import com.evolveum.midpoint.provisioning.util.ShadowUtil;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BooleanConverter
implements Converter {
    private Collection<Class> supportedClasses = Arrays.asList(Boolean.class, Boolean.TYPE);

    @Override
    public QName getXmlType() {
        return new QName("http://www.w3.org/2001/XMLSchema", "boolean");
    }

    @Override
    public Collection<Class> getJavaTypes() {
        return this.supportedClasses;
    }

    @Override
    public Object convertToJava(Node node) {
        Boolean b = Boolean.FALSE;
        if ("true".equalsIgnoreCase(node.getTextContent())) {
            b = Boolean.TRUE;
        }
        return b;
    }

    @Override
    public Node convertToXML(QName qname, Object o) {
        String value = "false";
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            value = "true";
        } else if (Boolean.parseBoolean(o.toString())) {
            value = "true";
        }
        Document d = ShadowUtil.getXmlDocument();
        Element e = d.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        e.appendChild(d.createTextNode(value));
        return e;
    }
}

