/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.databasetable;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.databasetable.DatabaseTableConfiguration;
import org.identityconnectors.databasetable.DatabaseTableConnection;
import org.identityconnectors.databasetable.DatabaseTableFilterTranslator;
import org.identityconnectors.databasetable.DatabaseTableSQLUtil;
import org.identityconnectors.dbcommon.DatabaseConnection;
import org.identityconnectors.dbcommon.DatabaseQueryBuilder;
import org.identityconnectors.dbcommon.FilterWhereBuilder;
import org.identityconnectors.dbcommon.InsertIntoBuilder;
import org.identityconnectors.dbcommon.SQLParam;
import org.identityconnectors.dbcommon.SQLUtil;
import org.identityconnectors.dbcommon.UpdateSetBuilder;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributeInfos;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConnectorClass(displayNameKey="DBTABLE_CONNECTOR", configurationClass=DatabaseTableConfiguration.class)
public class DatabaseTableConnector
implements PoolableConnector,
CreateOp,
SearchOp<FilterWhereBuilder>,
DeleteOp,
UpdateOp,
SchemaOp,
TestOp,
AuthenticateOp,
SyncOp {
    static Log log = Log.getLog(DatabaseTableConnector.class);
    private DatabaseTableConnection conn;
    private DatabaseTableConfiguration config;
    private Schema schema;
    private Set<String> defaultAttributesToGet;
    private Map<String, Integer> columnSQLTypes;
    private Set<String> stringColumnRequired;

    public Configuration getConfiguration() {
        return this.config;
    }

    public void init(Configuration cfg) {
        log.info("init DatabaseTable connector", new Object[0]);
        this.config = (DatabaseTableConfiguration)cfg;
        this.conn = DatabaseTableConnection.createDBTableConnection(this.config);
        this.schema = null;
        this.defaultAttributesToGet = null;
        this.columnSQLTypes = null;
        log.ok("init DatabaseTable connector ok, connection is valid", new Object[0]);
    }

    public void checkAlive() {
        log.info("checkAlive DatabaseTable connector", new Object[0]);
        try {
            if (StringUtil.isNotBlank((String)this.config.getDatasource())) {
                this.openConnection();
            } else {
                this.getConn().test();
                this.commit();
            }
        }
        catch (SQLException e) {
            log.error((Throwable)e, "error in checkAlive", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        log.ok("checkAlive DatabaseTable connector ok", new Object[0]);
    }

    DatabaseTableConnection getConn() {
        return this.conn;
    }

    public void dispose() {
        log.info("dispose DatabaseTable connector", new Object[0]);
        if (this.conn != null) {
            this.conn.dispose();
            this.conn = null;
        }
        this.defaultAttributesToGet = null;
        this.schema = null;
        this.columnSQLTypes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        log.info("create account, check the ObjectClass", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        log.ok("Object class ok", new Object[0]);
        if (attrs == null || attrs.size() == 0) {
            throw new IllegalArgumentException(this.config.getMessage("invalid.attribute.set"));
        }
        log.ok("Attribute set is not empty", new Object[0]);
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        if (name == null) {
            throw new IllegalArgumentException(this.config.getMessage("name.blank"));
        }
        String accountName = name.getNameValue();
        log.ok("Required Name attribure value {0} for create", new Object[]{accountName});
        String tblname = this.config.getTable();
        InsertIntoBuilder bld = new InsertIntoBuilder();
        log.info("Creating account: {0}", new Object[]{accountName});
        SortedSet missingRequiredColumns = CollectionUtil.newCaseInsensitiveSet();
        if (this.config.isEnableEmptyString()) {
            Set<String> mrc = this.getStringColumnReguired();
            log.info("Empty String is enabled, add missing required columns {0}", new Object[]{mrc});
            missingRequiredColumns.addAll(mrc);
        }
        log.info("process and check the Attribute Set", new Object[0]);
        for (Attribute attr : attrs) {
            Object value;
            String columnName = this.getColumnName(attr.getName());
            if (this.isToBeEmpty(columnName, value = AttributeUtil.getSingleValue((Attribute)attr))) {
                log.info("create account, attribute for a column {0} is null and should be empty", new Object[]{columnName});
                value = "";
            }
            int sqlType = this.getColumnType(columnName);
            log.info("attribute {0} fit column {1} and sql type {2}", new Object[]{attr.getName(), columnName, sqlType});
            bld.addBind(new SQLParam(this.quoteName(columnName), value, sqlType));
            missingRequiredColumns.remove(columnName);
            log.ok("attribute {0} was added to insert", new Object[]{attr.getName()});
        }
        if (this.config.isEnableEmptyString()) {
            log.info("there are columns not matched in attribute set which should be empty", new Object[0]);
            for (String mCol : missingRequiredColumns) {
                bld.addBind(new SQLParam(this.quoteName(mCol), (Object)"", this.getColumnType(mCol)));
                log.ok("Required empty value to column {0} added", new Object[]{mCol});
            }
        }
        String SQL_INSERT = "INSERT INTO {0} ( {1} ) VALUES ( {2} )";
        String sql = MessageFormat.format("INSERT INTO {0} ( {1} ) VALUES ( {2} )", tblname, bld.getInto(), bld.getValues());
        PreparedStatement pstmt = null;
        try {
            this.openConnection();
            pstmt = this.getConn().prepareStatement(sql, bld.getParams());
            pstmt.execute();
            log.info("Create account {0} commit", new Object[]{accountName});
            this.commit();
        }
        catch (SQLException e) {
            block12: {
                try {
                    log.error((Throwable)e, "Create account ''{0}'' error", new Object[]{accountName});
                    if (!this.throwIt(e.getErrorCode())) break block12;
                    SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                    throw new ConnectorException(this.config.getMessage("can.not.create", accountName), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtil.closeQuietly(pstmt);
                    this.closeConnection();
                    throw throwable;
                }
            }
            SQLUtil.closeQuietly((Statement)pstmt);
            this.closeConnection();
        }
        SQLUtil.closeQuietly((Statement)pstmt);
        this.closeConnection();
        log.ok("Account {0} created", new Object[]{accountName});
        return new Uid(accountName);
    }

    private boolean throwIt(int errorCode) {
        return this.config.isRethrowAllSQLExceptions() || errorCode != 0;
    }

    private boolean isToBeEmpty(String columnName, Object value) {
        return this.config.isEnableEmptyString() && this.getStringColumnReguired().contains(columnName) && value == null;
    }

    public void delete(ObjectClass oclass, Uid uid, OperationOptions options) {
        log.info("delete account, check the ObjectClass", new Object[0]);
        String SQL_DELETE = "DELETE FROM {0} WHERE {1} = ?";
        PreparedStatement stmt = null;
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        log.ok("The ObjectClass is ok", new Object[0]);
        if (uid == null || uid.getUidValue() == null) {
            throw new IllegalArgumentException(this.config.getMessage("uid.blank"));
        }
        String accountUid = uid.getUidValue();
        log.ok("The Uid is present", new Object[0]);
        String tblname = this.config.getTable();
        String keycol = this.quoteName(this.config.getKeyColumn());
        String sql = MessageFormat.format("DELETE FROM {0} WHERE {1} = ?", tblname, keycol);
        try {
            log.info("delete account SQL {0}", new Object[]{sql});
            this.openConnection();
            stmt = this.getConn().getConnection().prepareStatement(sql);
            stmt.setString(1, accountUid);
            log.info("Deleting account Uid: {0}", new Object[]{accountUid});
            int dr = stmt.executeUpdate();
            if (dr < 1) {
                log.error("No account Uid: {0} found", new Object[]{accountUid});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new UnknownUidException();
            }
            if (dr > 1) {
                log.error("More then one account Uid: {0} found", new Object[]{accountUid});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new IllegalArgumentException(this.config.getMessage("more.users.deleted", accountUid));
            }
            log.info("Delete account {0} commit", new Object[]{accountUid});
            this.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Throwable)e, "Delete account ''{0}'' SQL error", new Object[]{accountUid});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new ConnectorException(this.config.getMessage("can.not.delete", accountUid), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(stmt);
                this.closeConnection();
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((Statement)stmt);
        this.closeConnection();
        log.ok("Account Uid {0} deleted", new Object[]{accountUid});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uid update(ObjectClass oclass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        log.info("update account, check the ObjectClass", new Object[0]);
        String SQL_TEMPLATE = "UPDATE {0} SET {1} WHERE {2} = ?";
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        log.ok("The ObjectClass is ok", new Object[0]);
        if (attrs == null || attrs.size() == 0) {
            throw new IllegalArgumentException(this.config.getMessage("invalid.attribute.set"));
        }
        log.ok("Attribute set is not empty", new Object[0]);
        String accountUid = uid.getUidValue();
        Assertions.nullCheck((Object)accountUid, (String)"accountUid");
        log.ok("Account uid {0} is present", new Object[]{accountUid});
        Uid ret = uid;
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        String accountName = accountUid;
        if (name != null && !accountUid.equals(name.getNameValue())) {
            accountName = name.getNameValue();
            Assertions.nullCheck((Object)accountName, (String)"accountName");
            log.info("Account name {0} is present and is not the same as uid", new Object[]{accountName});
            ret = new Uid(accountName);
            log.ok("Renaming account uid {0} to name {1}", new Object[]{accountUid, accountName});
        }
        log.info("process and check the Attribute Set", new Object[0]);
        UpdateSetBuilder updateSet = new UpdateSetBuilder();
        for (Attribute attribute : attrs) {
            Object value;
            if (attribute.is(Uid.NAME)) continue;
            String attributeName = attribute.getName();
            String columnName = this.getColumnName(attributeName);
            if (this.isToBeEmpty(columnName, value = AttributeUtil.getSingleValue((Attribute)attribute))) {
                log.info("Append empty attribute {0} for required columnName {1}", new Object[]{attributeName, columnName});
                value = "";
            }
            Integer sqlType = this.getColumnType(columnName);
            SQLParam param = new SQLParam(this.quoteName(columnName), value, sqlType.intValue());
            updateSet.addBind(param);
            log.ok("Appended to update statement the attribute {0} for columnName {1} and sqlType {2}", new Object[]{attributeName, columnName, sqlType});
        }
        log.info("Update account {1}", new Object[]{accountName});
        String tblname = this.config.getTable();
        String keycol = this.quoteName(this.config.getKeyColumn());
        updateSet.addValue(new SQLParam(keycol, (Object)accountUid, this.getColumnType(this.config.getKeyColumn())));
        String sql = MessageFormat.format("UPDATE {0} SET {1} WHERE {2} = ?", tblname, updateSet.getSQL(), keycol);
        PreparedStatement stmt = null;
        try {
            this.openConnection();
            stmt = this.getConn().prepareStatement(sql, updateSet.getParams());
            stmt.executeUpdate();
            log.info("Update account {0} commit", new Object[]{accountName});
            this.commit();
        }
        catch (SQLException e) {
            block9: {
                try {
                    log.error((Throwable)e, "Update account {0} error", new Object[]{accountName});
                    if (!this.throwIt(e.getErrorCode())) break block9;
                    SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                    throw new ConnectorException(this.config.getMessage("can.not.update", accountName), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtil.closeQuietly(stmt);
                    this.closeConnection();
                    throw throwable;
                }
            }
            SQLUtil.closeQuietly((Statement)stmt);
            this.closeConnection();
        }
        SQLUtil.closeQuietly((Statement)stmt);
        this.closeConnection();
        log.ok("Account {0} updated", new Object[]{accountName});
        return ret;
    }

    public FilterTranslator<FilterWhereBuilder> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        log.info("check the ObjectClass", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        log.ok("The ObjectClass is ok", new Object[0]);
        return new DatabaseTableFilterTranslator(this, oclass, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(ObjectClass oclass, FilterWhereBuilder where, ResultsHandler handler, OperationOptions options) {
        log.info("check the ObjectClass and result handler", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(this.config.getMessage("result.handler.null"));
        }
        log.ok("The ObjectClass and result handler is ok", new Object[0]);
        String tblname = this.config.getTable();
        Set<String> columnNamesToGet = this.resolveColumnNamesToGet(options);
        log.ok("Column Names {0} To Get", new Object[]{columnNamesToGet});
        DatabaseQueryBuilder query = new DatabaseQueryBuilder(tblname, columnNamesToGet);
        query.setWhere(where);
        ResultSet result = null;
        PreparedStatement statement = null;
        try {
            this.openConnection();
            statement = this.getConn().prepareStatement(query);
            result = statement.executeQuery();
            log.ok("executeQuery {0} on {1}", new Object[]{query.getSQL(), oclass});
            while (result.next()) {
                Map<String, SQLParam> columnValues = this.getConn().getColumnValues(result);
                log.ok("Column values {0} from result set ", new Object[]{columnValues});
                ConnectorObjectBuilder bld = this.buildConnectorObject(columnValues);
                if (handler.handle(bld.build())) continue;
                log.ok("Stop processing of the result set", new Object[0]);
                break;
            }
            log.info("commit executeQuery account", new Object[0]);
            this.commit();
        }
        catch (SQLException e) {
            block7: {
                try {
                    log.error((Throwable)e, "Query {0} on {1} error", new Object[]{query.getSQL(), oclass});
                    SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                    if (!this.throwIt(e.getErrorCode())) break block7;
                    throw new ConnectorException(this.config.getMessage("can.not.read", tblname), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtil.closeQuietly(result);
                    SQLUtil.closeQuietly(statement);
                    this.closeConnection();
                    throw throwable;
                }
            }
            SQLUtil.closeQuietly((ResultSet)result);
            SQLUtil.closeQuietly((Statement)statement);
            this.closeConnection();
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)statement);
        this.closeConnection();
        log.ok("Query Account commited", new Object[0]);
    }

    public void sync(ObjectClass oclass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        log.info("check the ObjectClass and result handler", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        log.ok("The object class is ok", new Object[0]);
        if (handler == null) {
            throw new IllegalArgumentException(this.config.getMessage("result.handler.null"));
        }
        log.ok("The result handles is not null", new Object[0]);
        if (StringUtil.isBlank((String)this.config.getChangeLogColumn())) {
            throw new IllegalArgumentException(this.config.getMessage("changelog.column.blank"));
        }
        log.ok("The change log column is ok", new Object[0]);
        String tblname = this.config.getTable();
        String changeLogColumnName = this.quoteName(this.config.getChangeLogColumn());
        log.ok("Change log attribute {0} map to column name {1}", new Object[]{this.config.getChangeLogColumn(), changeLogColumnName});
        Set<String> columnNames = this.resolveColumnNamesToGet(options);
        log.ok("Column Names {0} To Get", new Object[]{columnNames});
        ArrayList<DatabaseQueryBuilder.OrderBy> orderBy = new ArrayList<DatabaseQueryBuilder.OrderBy>();
        columnNames.add(changeLogColumnName);
        orderBy.add(new DatabaseQueryBuilder.OrderBy(changeLogColumnName, Boolean.valueOf(true)));
        log.ok("OrderBy {0}", new Object[]{orderBy});
        FilterWhereBuilder where = new FilterWhereBuilder();
        if (token != null && token.getValue() != null) {
            Object tokenVal = token.getValue();
            log.info("Sync token is {0}", new Object[]{tokenVal});
            Integer sqlType = this.getColumnType(this.config.getChangeLogColumn());
            where.addBind(new SQLParam(changeLogColumnName, tokenVal, sqlType.intValue()), ">");
        }
        DatabaseQueryBuilder query = new DatabaseQueryBuilder(tblname, columnNames);
        query.setWhere(where);
        query.setOrderBy(orderBy);
        ResultSet result = null;
        PreparedStatement statement = null;
        try {
            this.openConnection();
            statement = this.getConn().prepareStatement(query);
            result = statement.executeQuery();
            log.info("execute sync query {0} on {1}", new Object[]{query.getSQL(), oclass});
            while (result.next()) {
                Map<String, SQLParam> columnValues = this.getConn().getColumnValues(result);
                log.ok("Column values {0} from sync result set ", new Object[]{columnValues});
                SyncDeltaBuilder sdb = this.buildSyncDelta(columnValues);
                if (handler.handle(sdb.build())) continue;
                log.ok("Stop processing of the sync result set", new Object[0]);
                break;
            }
            log.info("commit sync account", new Object[0]);
            this.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Throwable)e, "sync {0} on {1} error", new Object[]{query.getSQL(), oclass});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new ConnectorException(this.config.getMessage("can.not.read", tblname), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(result);
                SQLUtil.closeQuietly(statement);
                this.closeConnection();
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)statement);
        this.closeConnection();
        log.ok("Sync Account commited", new Object[0]);
    }

    public SyncToken getLatestSyncToken(ObjectClass oclass) {
        log.info("check the ObjectClass", new Object[0]);
        String SQL_SELECT = "SELECT MAX( {0} ) FROM {1}";
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        log.ok("The object class is ok", new Object[0]);
        if (StringUtil.isBlank((String)this.config.getChangeLogColumn())) {
            throw new IllegalArgumentException(this.config.getMessage("changelog.column.blank"));
        }
        log.ok("The change log column is ok", new Object[0]);
        String tblname = this.config.getTable();
        String chlogName = this.quoteName(this.config.getChangeLogColumn());
        String sql = MessageFormat.format("SELECT MAX( {0} ) FROM {1}", chlogName, tblname);
        SyncToken ret = null;
        log.info("getLatestSyncToken on {0}", new Object[]{oclass});
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            Object value;
            this.openConnection();
            stmt = this.getConn().getConnection().prepareStatement(sql);
            rset = stmt.executeQuery();
            log.ok("The statement {0} executed", new Object[]{sql});
            if (rset.next() && (value = rset.getObject(1)) != null) {
                log.ok("New token value {0}", new Object[]{value});
                ret = new SyncToken(SQLUtil.jdbc2AttributeValue((Object)value));
            }
            log.ok("getLatestSyncToken", new Object[]{ret});
            log.info("commit getLatestSyncToken", new Object[0]);
            this.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Throwable)e, "getLatestSyncToken sql {0} on {1} error", new Object[]{sql, oclass});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new ConnectorException(this.config.getMessage("can.not.read", tblname), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(rset);
                SQLUtil.closeQuietly(stmt);
                this.closeConnection();
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)rset);
        SQLUtil.closeQuietly((Statement)stmt);
        this.closeConnection();
        log.ok("getLatestSyncToken commited", new Object[0]);
        return ret;
    }

    public Schema schema() {
        try {
            this.openConnection();
            if (this.schema == null) {
                log.info("cache schema", new Object[0]);
                this.cacheSchema();
            }
            assert (this.schema != null);
            this.commit();
        }
        catch (SQLException e) {
            log.error((Throwable)e, "error in schema", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        log.ok("schema", new Object[0]);
        return this.schema;
    }

    public void test() {
        log.info("test", new Object[0]);
        try {
            this.openConnection();
            this.getConn().test();
            this.commit();
        }
        catch (SQLException e) {
            log.error((Throwable)e, "error in test", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        log.ok("connector test ok", new Object[0]);
    }

    private void closeConnection() {
        this.getConn().closeConnection();
    }

    private void openConnection() throws SQLException {
        this.getConn().openConnection();
    }

    private void commit() throws SQLException {
        this.getConn().getConnection().commit();
    }

    public Uid authenticate(ObjectClass oclass, String username, GuardedString password, OperationOptions options) {
        String SQL_AUTH_QUERY = "SELECT {0} FROM {1} WHERE ( {0} = ? ) AND ( {2} = ? )";
        log.info("check the ObjectClass", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        log.ok("The object class is ok", new Object[0]);
        if (StringUtil.isBlank((String)this.config.getPasswordColumn())) {
            throw new UnsupportedOperationException(this.config.getMessage("auth.op.not.supported"));
        }
        log.ok("The Password Column is ok", new Object[0]);
        if (StringUtil.isBlank((String)username)) {
            throw new IllegalArgumentException(this.config.getMessage("admin.user.blank"));
        }
        log.ok("The username is ok", new Object[0]);
        if (password == null) {
            throw new IllegalArgumentException(this.config.getMessage("admin.password.blank"));
        }
        log.ok("The password is ok", new Object[0]);
        String keyColumnName = this.quoteName(this.config.getKeyColumn());
        String passwordColumnName = this.quoteName(this.config.getPasswordColumn());
        String sql = MessageFormat.format("SELECT {0} FROM {1} WHERE ( {0} = ? ) AND ( {2} = ? )", keyColumnName, this.config.getTable(), passwordColumnName);
        ArrayList<SQLParam> values = new ArrayList<SQLParam>();
        values.add(new SQLParam(keyColumnName, (Object)username, this.getColumnType(this.config.getKeyColumn())));
        values.add(new SQLParam(passwordColumnName, (Object)password));
        PreparedStatement stmt = null;
        ResultSet result = null;
        Uid uid = null;
        try {
            log.info("authenticate Account: {0}", new Object[]{username});
            this.openConnection();
            stmt = this.getConn().prepareStatement(sql, values);
            result = stmt.executeQuery();
            log.ok("authenticate query for account {0} executed ", new Object[]{username});
            if (!result.next()) {
                log.error("authenticate query for account {0} has no result ", new Object[]{username});
                throw new InvalidCredentialException(this.config.getMessage("auth.op.failed", username));
            }
            uid = new Uid(result.getString(1));
            log.info("commit authenticate", new Object[0]);
            this.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Throwable)e, "Account: {0} authentication failed ", new Object[]{username});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new ConnectorException(this.config.getMessage("can.not.read", this.config.getTable()), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(result);
                SQLUtil.closeQuietly(stmt);
                this.closeConnection();
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)stmt);
        this.closeConnection();
        log.info("Account: {0} authenticated ", new Object[]{username});
        return uid;
    }

    public String quoteName(String value) {
        return DatabaseTableSQLUtil.quoteName(this.config.getQuoting(), value);
    }

    public int getColumnType(String columnName) {
        if (this.columnSQLTypes == null) {
            this.cacheSchema();
        }
        assert (this.columnSQLTypes != null);
        Integer columnType = this.columnSQLTypes.get(columnName);
        if (columnType == null) {
            columnType = 0;
        }
        return columnType;
    }

    public String getColumnName(String attributeName) {
        if (Name.NAME.equalsIgnoreCase(attributeName)) {
            log.ok("attribute name {0} map to key column", new Object[]{attributeName});
            return this.config.getKeyColumn();
        }
        if (Uid.NAME.equalsIgnoreCase(attributeName)) {
            log.ok("attribute name {0} map to key column", new Object[]{attributeName});
            return this.config.getKeyColumn();
        }
        if (!StringUtil.isBlank((String)this.config.getPasswordColumn()) && OperationalAttributes.PASSWORD_NAME.equalsIgnoreCase(attributeName)) {
            log.ok("attribute name {0} map to password column", new Object[]{attributeName});
            return this.config.getPasswordColumn();
        }
        return attributeName;
    }

    private void cacheSchema() {
        Set<AttributeInfo> attrInfoSet = this.buildSelectBasedAttributeInfos();
        log.info("cacheSchema", new Object[0]);
        this.defaultAttributesToGet = new HashSet<String>();
        for (AttributeInfo info : attrInfoSet) {
            if (!info.isReturnedByDefault()) continue;
            this.defaultAttributesToGet.add(info.getName());
        }
        SchemaBuilder schemaBld = new SchemaBuilder(this.getClass());
        ObjectClassInfoBuilder ociB = new ObjectClassInfoBuilder();
        ociB.setType(ObjectClass.ACCOUNT_NAME);
        ociB.addAllAttributeInfo(attrInfoSet);
        ObjectClassInfo oci = ociB.build();
        schemaBld.defineObjectClass(oci);
        if (StringUtil.isBlank((String)this.config.getPasswordColumn())) {
            log.info("no password column, remove the AuthenticateOp", new Object[0]);
            schemaBld.removeSupportedObjectClass(AuthenticateOp.class, oci);
        }
        if (StringUtil.isBlank((String)this.config.getChangeLogColumn())) {
            log.info("no changeLog column, remove the SyncOp", new Object[0]);
            schemaBld.removeSupportedObjectClass(SyncOp.class, oci);
        }
        this.schema = schemaBld.build();
        log.ok("schema builded", new Object[0]);
    }

    private Set<AttributeInfo> buildSelectBasedAttributeInfos() {
        Set<AttributeInfo> attrInfo;
        String SCHEMA_QUERY = "SELECT * FROM {0} WHERE {1} IS NULL";
        log.info("get schema from the table", new Object[0]);
        String sql = MessageFormat.format("SELECT * FROM {0} WHERE {1} IS NULL", this.config.getTable(), this.quoteName(this.config.getKeyColumn()));
        ResultSet rset = null;
        Statement stmt = null;
        try {
            stmt = this.getConn().getConnection().createStatement();
            log.info("executeQuery ''{0}''", new Object[]{sql});
            rset = stmt.executeQuery(sql);
            log.ok("query executed", new Object[0]);
            attrInfo = this.buildAttributeInfoSet(rset);
            log.info("commit get schema", new Object[0]);
            this.commit();
        }
        catch (SQLException ex) {
            try {
                log.error((Throwable)ex, "buildSelectBasedAttributeInfo in SQL: ''{0}''", new Object[]{sql});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new ConnectorException(this.config.getMessage("can.not.read", this.config.getTable()), (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(rset);
                SQLUtil.closeQuietly((Statement)stmt);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)rset);
        SQLUtil.closeQuietly((Statement)stmt);
        log.ok("schema created", new Object[0]);
        return attrInfo;
    }

    private Set<AttributeInfo> buildAttributeInfoSet(ResultSet rset) throws SQLException {
        log.info("build AttributeInfoSet", new Object[0]);
        HashSet<AttributeInfo> attrInfo = new HashSet<AttributeInfo>();
        this.columnSQLTypes = CollectionUtil.newCaseInsensitiveMap();
        this.stringColumnRequired = CollectionUtil.newCaseInsensitiveSet();
        ResultSetMetaData meta = rset.getMetaData();
        int count = meta.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String name = meta.getColumnName(i);
            AttributeInfoBuilder attrBld = new AttributeInfoBuilder();
            Integer columnType = meta.getColumnType(i);
            log.ok("column name {0} has type {1}", new Object[]{name, columnType});
            this.columnSQLTypes.put(name, columnType);
            if (name.equalsIgnoreCase(this.config.getKeyColumn())) {
                attrBld.setName(Name.NAME);
                attrBld.setRequired(true);
                attrInfo.add(attrBld.build());
                log.ok("key column in name attribute in the schema", new Object[0]);
                continue;
            }
            if (name.equalsIgnoreCase(this.config.getPasswordColumn())) {
                attrInfo.add(OperationalAttributeInfos.PASSWORD);
                log.ok("password column in password attribute in the schema", new Object[0]);
                continue;
            }
            if (name.equalsIgnoreCase(this.config.getChangeLogColumn())) {
                log.ok("skip changelog column from the schema", new Object[0]);
                continue;
            }
            Class<String> dataType = this.getConn().getSms().getSQLAttributeType(columnType);
            attrBld.setType(dataType);
            attrBld.setName(name);
            boolean required = meta.isNullable(i) == 0;
            attrBld.setRequired(required);
            if (required && dataType.isAssignableFrom(String.class)) {
                log.ok("the column name {0} is string type and required", new Object[]{name});
                this.stringColumnRequired.add(name);
            }
            attrBld.setReturnedByDefault(this.isReturnedByDefault(dataType));
            attrInfo.add(attrBld.build());
            log.ok("the column name {0} has data type {1}", new Object[]{name, dataType});
        }
        log.ok("the Attribute InfoSet is done", new Object[0]);
        return attrInfo;
    }

    private boolean isReturnedByDefault(Class<?> dataType) {
        return !byte[].class.equals(dataType);
    }

    private ConnectorObjectBuilder buildConnectorObject(Map<String, SQLParam> columnValues) {
        log.info("build ConnectorObject", new Object[0]);
        String uidValue = null;
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        for (Map.Entry<String, SQLParam> colValue : columnValues.entrySet()) {
            String columnName = colValue.getKey();
            SQLParam param = colValue.getValue();
            if (columnName.equalsIgnoreCase(this.config.getKeyColumn())) {
                if (param == null || param.getValue() == null) {
                    log.error("Name cannot be null.", new Object[0]);
                    String msg = "Name cannot be null.";
                    throw new IllegalArgumentException(msg);
                }
                uidValue = param.getValue().toString();
                bld.setName(uidValue);
                continue;
            }
            if (columnName.equalsIgnoreCase(this.config.getPasswordColumn())) {
                log.ok("No Password in the result object", new Object[0]);
                continue;
            }
            if (columnName.equalsIgnoreCase(this.config.getChangeLogColumn())) {
                log.ok("changelogcolumn attribute in the result", new Object[0]);
                continue;
            }
            if (param != null && param.getValue() != null) {
                bld.addAttribute(new Attribute[]{AttributeBuilder.build((String)columnName, (Object[])new Object[]{param.getValue()})});
                continue;
            }
            bld.addAttribute(new Attribute[]{AttributeBuilder.build((String)columnName)});
        }
        if (uidValue == null) {
            String msg = "The uid value is missing in query.";
            log.error("The uid value is missing in query.", new Object[0]);
            throw new IllegalStateException("The uid value is missing in query.");
        }
        bld.setUid(new Uid(uidValue));
        bld.setObjectClass(ObjectClass.ACCOUNT);
        log.ok("ConnectorObject is builded", new Object[0]);
        return bld;
    }

    private SyncDeltaBuilder buildSyncDelta(Map<String, SQLParam> columnValues) {
        log.info("buildSyncDelta", new Object[0]);
        SyncDeltaBuilder bld = new SyncDeltaBuilder();
        SQLParam tokenParam = columnValues.get(this.config.getChangeLogColumn());
        if (tokenParam == null) {
            throw new IllegalArgumentException(this.config.getMessage("invalid.sync.token.value"));
        }
        Object token = tokenParam.getValue();
        if (token == null) {
            log.ok("token value is null, replacing to 0L", new Object[0]);
            token = 0L;
        }
        bld.setToken(new SyncToken(token));
        bld.setObject(this.buildConnectorObject(columnValues).build());
        bld.setDeltaType(SyncDeltaType.CREATE_OR_UPDATE);
        log.ok("SyncDeltaBuilder is ok", new Object[0]);
        return bld;
    }

    private Set<String> resolveColumnNamesToGet(OperationOptions options) {
        Set attributesToGet = this.getDefaultAttributesToGet();
        if (options != null && options.getAttributesToGet() != null) {
            attributesToGet = CollectionUtil.newSet((Object[])options.getAttributesToGet());
            attributesToGet.add(Uid.NAME);
        }
        HashSet<String> columnNamesToGet = new HashSet<String>();
        for (String attributeName : attributesToGet) {
            String columnName = this.getColumnName(attributeName);
            columnNamesToGet.add(this.quoteName(columnName));
        }
        return columnNamesToGet;
    }

    private Set<String> getDefaultAttributesToGet() {
        if (this.defaultAttributesToGet == null) {
            this.cacheSchema();
        }
        assert (this.defaultAttributesToGet != null);
        return this.defaultAttributesToGet;
    }

    private Set<String> getStringColumnReguired() {
        if (this.stringColumnRequired == null) {
            this.cacheSchema();
        }
        assert (this.stringColumnRequired != null);
        return this.stringColumnRequired;
    }
}

