/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.databasetable;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.databasetable.DatabaseTableConfiguration;
import org.identityconnectors.databasetable.DatabaseTableSQLUtil;
import org.identityconnectors.databasetable.mapping.AttributeConvertor;
import org.identityconnectors.databasetable.mapping.DefaultStrategy;
import org.identityconnectors.databasetable.mapping.JdbcConvertor;
import org.identityconnectors.databasetable.mapping.MappingStrategy;
import org.identityconnectors.databasetable.mapping.NativeTimestampsStrategy;
import org.identityconnectors.databasetable.mapping.StringStrategy;
import org.identityconnectors.dbcommon.DatabaseConnection;
import org.identityconnectors.dbcommon.JNDIUtil;
import org.identityconnectors.dbcommon.SQLParam;
import org.identityconnectors.dbcommon.SQLUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ConnectorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseTableConnection
extends DatabaseConnection {
    static Log log = Log.getLog(DatabaseTableConnection.class);
    private MappingStrategy sms = null;
    final DatabaseTableConfiguration config;

    static DatabaseTableConnection createDBTableConnection(DatabaseTableConfiguration config) {
        Connection connection = DatabaseTableConnection.getNativeConnection(config);
        return new DatabaseTableConnection(connection, config);
    }

    private static Connection getNativeConnection(DatabaseTableConfiguration config) {
        Connection connection;
        block10: {
            String login = config.getUser();
            GuardedString password = config.getPassword();
            String datasource = config.getDatasource();
            if (StringUtil.isNotBlank((String)datasource)) {
                log.info("Get a new connection using datasource {0}", new Object[]{datasource});
                String[] jndiProperties = config.getJndiProperties();
                ConnectorMessages connectorMessages = config.getConnectorMessages();
                Hashtable prop = JNDIUtil.arrayToHashtable((String[])jndiProperties, (ConnectorMessages)connectorMessages);
                connection = StringUtil.isNotBlank((String)login) && password != null ? SQLUtil.getDatasourceConnection((String)datasource, (String)login, (GuardedString)password, (Hashtable)prop) : SQLUtil.getDatasourceConnection((String)datasource, (Hashtable)prop);
                log.ok("The new connection using datasource {0} created", new Object[]{datasource});
            } else {
                String driver = config.getJdbcDriver();
                String connectionUrl = config.formatUrlTemplate();
                log.info("Get a new connection using connection url {0} and user {1}", new Object[]{connectionUrl, login});
                connection = SQLUtil.getDriverMangerConnection((String)driver, (String)connectionUrl, (String)login, (GuardedString)password);
                log.ok("The new connection using connection url {0} and user {1} created", new Object[]{connectionUrl, login});
            }
            try {
                Class<?> clazz = Class.forName("oracle.jdbc.OracleConnection");
                if (clazz == null || !clazz.isAssignableFrom(connection.getClass())) break block10;
                try {
                    Method getIncludeSynonyms = clazz.getMethod("getIncludeSynonyms", new Class[0]);
                    Object includeSynonyms = getIncludeSynonyms.invoke((Object)connection, new Object[0]);
                    log.info("getIncludeSynonyms on ORACLE : {0}", new Object[]{includeSynonyms});
                    if (Boolean.FALSE.equals(includeSynonyms)) {
                        Method setIncludeSynonyms = clazz.getMethod("setIncludeSynonyms", Boolean.TYPE);
                        setIncludeSynonyms.invoke((Object)connection, Boolean.TRUE);
                        log.ok("setIncludeSynonyms to true success", new Object[0]);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e, "setIncludeSynonyms on ORACLE exception", new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            if (connection.getAutoCommit()) {
                log.info("setAutoCommit(false)", new Object[0]);
                connection.setAutoCommit(false);
            }
        }
        catch (SQLException expected) {
            log.error((Throwable)expected, "setAutoCommit(false) exception", new Object[0]);
        }
        return connection;
    }

    private DatabaseTableConnection(Connection conn, DatabaseTableConfiguration config) {
        super(conn);
        this.config = config;
        this.sms = this.createMappingStrategy(conn, config);
        log.ok("New DatabaseTableConnection for : {0}", new Object[]{config.getUser()});
    }

    public MappingStrategy createMappingStrategy(Connection conn, DatabaseTableConfiguration config) {
        log.info("Create: DefaultStrategy", new Object[0]);
        log.info("Append: JdbcConvertor", new Object[0]);
        MappingStrategy tail = new JdbcConvertor(new DefaultStrategy());
        if (!config.isAllNative()) {
            log.info("Append: StringStrategy", new Object[0]);
            tail = new StringStrategy(tail);
            if (config.isNativeTimestamps()) {
                log.info("Append: NativeTimestampsStrategy", new Object[0]);
                tail = new NativeTimestampsStrategy(tail);
            }
        }
        log.info("Append: AttributeConvertor", new Object[0]);
        return new AttributeConvertor(tail);
    }

    public Map<String, SQLParam> getColumnValues(ResultSet result) throws SQLException {
        return DatabaseTableSQLUtil.getColumnValues(this.sms, result);
    }

    public MappingStrategy getSms() {
        return this.sms;
    }

    public CallableStatement prepareCall(String sql, List<SQLParam> params) throws SQLException {
        log.info("Prepare SQL Call : {0}", new Object[]{sql});
        CallableStatement prepareCall = this.getConnection().prepareCall(sql);
        DatabaseTableSQLUtil.setParams(this.sms, prepareCall, params);
        log.ok("SQL Call statement ok", new Object[0]);
        return prepareCall;
    }

    public PreparedStatement prepareStatement(String sql, List<SQLParam> params) throws SQLException {
        log.info("Prepare SQL Statement : {0}", new Object[]{sql});
        PreparedStatement prepareStatement = this.getConnection().prepareStatement(sql);
        DatabaseTableSQLUtil.setParams(this.sms, prepareStatement, params);
        log.ok("SQL Statement ok", new Object[0]);
        return prepareStatement;
    }

    public void test() {
        String sql = this.config.getValidConnectionQuery();
        if (StringUtil.isBlank((String)sql)) {
            log.info("valid connection query is empty, test connection using default", new Object[0]);
            super.test();
        } else {
            Statement stmt = null;
            try {
                stmt = this.getConnection().createStatement();
                log.info("test connection using {0}", new Object[]{sql});
                if (!stmt.execute(sql)) {
                    throw new ConnectorException(this.config.getMessage("query.invalid", sql));
                }
                log.ok("connection is valid", new Object[0]);
            }
            catch (Exception ex) {
                throw new ConnectorException(this.config.getMessage("can.not.read", sql), (Throwable)ex);
            }
            finally {
                SQLUtil.closeQuietly((Statement)stmt);
            }
        }
    }

    void setSms(MappingStrategy sms) {
        this.sms = sms;
    }

    void closeConnection() {
        if (this.getConnection() != null && StringUtil.isNotBlank((String)this.config.getDatasource())) {
            log.info("Close the pooled connection", new Object[0]);
            this.dispose();
        }
    }

    void openConnection() throws SQLException {
        if (this.getConnection() == null || this.getConnection().isClosed()) {
            log.info("Get new connection, it is closed", new Object[0]);
            this.setConnection(DatabaseTableConnection.getNativeConnection(this.config));
        }
    }
}

