/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.xml.schema;

import com.evolveum.midpoint.xml.schema.TrivialXPathParser;
import com.evolveum.midpoint.xml.schema.XPathSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XPathType {
    public static final String REPLACE_PREFIX_FOR_DEFAULT_NAMESPACE = "idmdn";
    private boolean absolute;
    private List<XPathSegment> segments;
    Map<String, String> explicitNamespaceDeclarations;
    static Random rnd = new Random();

    public XPathType() {
        this.absolute = false;
        this.segments = new ArrayList<XPathSegment>();
    }

    public XPathType(String xpath) {
        this.parse(xpath, null, null);
    }

    public XPathType(String xpath, Map<String, String> namespaceMap) {
        this.parse(xpath, null, namespaceMap);
    }

    public XPathType(List<XPathSegment> segments) {
        this(segments, false);
    }

    public XPathType(List<XPathSegment> segments, boolean absolute) {
        this.segments = new ArrayList<XPathSegment>();
        for (XPathSegment segment : segments) {
            if (StringUtils.isEmpty((String)segment.getQName().getPrefix())) {
                QName qname = segment.getQName();
                this.segments.add(new XPathSegment(new QName(qname.getNamespaceURI(), qname.getLocalPart(), REPLACE_PREFIX_FOR_DEFAULT_NAMESPACE)));
                continue;
            }
            this.segments.add(segment);
        }
        this.absolute = absolute;
    }

    public XPathType(Element domElement) {
        String xpath = ".";
        if (null != domElement) {
            xpath = domElement.getTextContent();
        }
        this.parse(xpath, domElement, null);
    }

    public XPathType(String xpath, Node domNode) {
        this.parse(xpath, domNode, null);
    }

    private void parse(String xpath, Node domNode, Map<String, String> namespaceMap) {
        this.segments = new ArrayList<XPathSegment>();
        this.absolute = false;
        if (".".equals(xpath)) {
            return;
        }
        TrivialXPathParser parser = TrivialXPathParser.parse(xpath);
        this.explicitNamespaceDeclarations = parser.getNamespaceMap();
        xpath = parser.getPureXPathString();
        String[] segArray = xpath.split("/");
        for (int i = 0; i < segArray.length; ++i) {
            QName qname;
            String namespace;
            String[] qnameArray;
            if (segArray[i] == null || segArray[i].isEmpty()) {
                if (i == 0) {
                    this.absolute = true;
                    continue;
                }
                throw new IllegalStateException("XPath " + xpath + " has an empty segment (number " + i + ")");
            }
            String segmentStr = segArray[i];
            boolean variable = false;
            if (segmentStr.startsWith("$")) {
                variable = true;
                segmentStr = segmentStr.substring(1);
            }
            if ((qnameArray = segmentStr.split(":")).length > 2) {
                throw new IllegalStateException("Unsupported format: more than one colon in XPath segment: " + segArray[i]);
            }
            if (qnameArray.length == 1 || qnameArray[1] == null || qnameArray[1].isEmpty()) {
                namespace = this.findNamespace(null, domNode, namespaceMap);
                qname = new QName(namespace, qnameArray[0], REPLACE_PREFIX_FOR_DEFAULT_NAMESPACE);
            } else {
                namespace = this.findNamespace(qnameArray[0], domNode, namespaceMap);
                qname = new QName(namespace, qnameArray[1], qnameArray[0]);
            }
            XPathSegment segment = new XPathSegment(qname, variable);
            this.segments.add(segment);
        }
    }

    private String findNamespace(String prefix, Node domNode, Map<String, String> namespaceMap) {
        String ns = null;
        if (this.explicitNamespaceDeclarations != null && (ns = prefix == null ? this.explicitNamespaceDeclarations.get("") : this.explicitNamespaceDeclarations.get(prefix)) != null) {
            return ns;
        }
        if (namespaceMap != null && (ns = prefix == null ? namespaceMap.get("") : namespaceMap.get(prefix)) != null) {
            return ns;
        }
        if (domNode != null && (ns = prefix == null || prefix.isEmpty() ? domNode.lookupNamespaceURI(null) : domNode.lookupNamespaceURI(prefix)) != null) {
            return ns;
        }
        if (ns == null && (REPLACE_PREFIX_FOR_DEFAULT_NAMESPACE.equals(prefix) || null == prefix)) {
            return "http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd";
        }
        return ns;
    }

    public String getXPath() {
        StringBuilder sb = new StringBuilder();
        this.addPureXpath(sb);
        return sb.toString();
    }

    public String getXPathWithDeclarations() {
        StringBuilder sb = new StringBuilder();
        this.addExplicitNsDeclarations(sb);
        this.addPureXpath(sb);
        return sb.toString();
    }

    private void addPureXpath(StringBuilder sb) {
        if (!this.absolute && this.segments.isEmpty()) {
            sb.append(".");
            return;
        }
        if (this.absolute) {
            sb.append("/");
        }
        Iterator<XPathSegment> iter = this.segments.iterator();
        while (iter.hasNext()) {
            QName qname;
            XPathSegment seg = iter.next();
            if (seg.isVariable()) {
                sb.append("$");
            }
            if ((qname = seg.getQName()).getPrefix() != null && !qname.getPrefix().isEmpty()) {
                sb.append(qname.getPrefix() + ":" + qname.getLocalPart());
            } else {
                sb.append("idmdn:" + qname.getLocalPart());
            }
            if (!iter.hasNext()) continue;
            sb.append("/");
        }
    }

    public Map<String, String> getNamespaceMap() {
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        for (XPathSegment seg : this.segments) {
            QName qname = seg.getQName();
            if (qname.getPrefix() != null) {
                namespaceMap.put(qname.getPrefix(), qname.getNamespaceURI());
                continue;
            }
            namespaceMap.put("", qname.getNamespaceURI());
        }
        return namespaceMap;
    }

    public Element toElement(String elementNamespace, String localElementName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder loader = factory.newDocumentBuilder();
            return this.toElement(elementNamespace, localElementName, loader.newDocument());
        }
        catch (ParserConfigurationException ex) {
            throw new AssertionError((Object)("Error on createing XML document " + ex.getMessage()));
        }
    }

    public Element toElement(QName elementQName, Document document) {
        return this.toElement(elementQName.getNamespaceURI(), elementQName.getLocalPart(), document);
    }

    public Element toElement(String elementNamespace, String localElementName, Document document) {
        Element e = document.createElementNS(elementNamespace, localElementName);
        e.setPrefix("xp" + rnd.nextInt(10000));
        e.setTextContent(this.getXPath());
        Map<String, String> namespaceMap = this.getNamespaceMap();
        if (namespaceMap != null) {
            NamedNodeMap attributes = e.getAttributes();
            for (Map.Entry<String, String> entry : namespaceMap.entrySet()) {
                Attr attr = entry.getKey() == null || entry.getKey().isEmpty() ? document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns") : document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + entry.getKey());
                attr.setValue(entry.getValue());
                attributes.setNamedItem(attr);
            }
        }
        return e;
    }

    public List<XPathSegment> toSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public String toString() {
        return this.getXPath();
    }

    private void addExplicitNsDeclarations(StringBuilder sb) {
        if (this.explicitNamespaceDeclarations == null || this.explicitNamespaceDeclarations.isEmpty()) {
            return;
        }
        for (String prefix : this.explicitNamespaceDeclarations.keySet()) {
            sb.append("declare ");
            if (prefix.equals("")) {
                sb.append("default namespace '");
                sb.append(this.explicitNamespaceDeclarations.get(prefix));
                sb.append("'; ");
                sb.append("declare namespace ");
                sb.append(REPLACE_PREFIX_FOR_DEFAULT_NAMESPACE);
                sb.append("='");
                sb.append(this.explicitNamespaceDeclarations.get(prefix));
                sb.append("'; ");
                continue;
            }
            sb.append("namespace ");
            sb.append(prefix);
            sb.append("='");
            sb.append(this.explicitNamespaceDeclarations.get(prefix));
            sb.append("'; ");
        }
    }
}

